/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.fatjar;

import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleGraph;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.JVMModuleUtil;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.tools.fatjar.CeylonFatJarMessages;
import com.redhat.ceylon.tools.moduleloading.ResourceRootTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@Summary(value="Generate a Ceylon executable jar for a given module")
@Description(value="Gerate an executable _fat jar_ which contains the given module and all its run-time dependencies, including the Ceylon run-time, which makes that jar self-sufficient and executable by `java` as if the Ceylon module was run by `ceylon run`.")
public class CeylonFatJarTool
extends ResourceRootTool {
    private List<ModuleSpec> modules;
    private boolean force;
    private File out;
    private final List<String> excludedModules = new ArrayList<String>();
    private String run;
    boolean foundRun;

    @Argument(order=1, argumentName="module", multiplicity="+")
    public void setModules(List<String> modules) {
        this.setModuleSpecs(ModuleSpec.parseEachList(modules, new ModuleSpec.Option[0]));
    }

    public void setModuleSpecs(List<ModuleSpec> modules) {
        this.modules = modules;
    }

    @OptionArgument(longName="run", argumentName="toplevel")
    @Description(value="Specifies the fully qualified name of a toplevel method or class with no parameters. The format is: `qualified.package.name::classOrMethodName` with `::` acting as separator between the package name and the toplevel class or method name (defaults to `{module}::run`).")
    public void setRun(String run) {
        this.run = run;
    }

    @Description(value="Target fat jar file (defaults to `{name}-{version}.jar`).")
    @OptionArgument(shortName=111, argumentName="file")
    public void setOut(File out) {
        this.out = out;
    }

    @OptionArgument(argumentName="moduleOrFile", shortName=120)
    @Description(value="Excludes modules from the resulting fat jar. Can be a module name or a file containing module names. Can be specified multiple times. Note that this excludes the module from the resulting fat jar, but if your modules require that module to be present at runtime it will still be required and may cause your application to fail to start if it is not provided at runtime.")
    public void setExcludeModule(List<String> exclusions) {
        for (String each : exclusions) {
            File xFile = new File(each);
            if (xFile.exists() && xFile.isFile()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(xFile));
                    Throwable throwable = null;
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            this.excludedModules.add(line);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        reader.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new ToolUsageError(CeylonFatJarMessages.msg("exclude.file.failure", each), e);
                }
            }
            this.excludedModules.add(each);
        }
    }

    @Option(longName="force")
    @Description(value="Force generation of mlib folder with multiple versions of the same module.")
    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    public void run() throws Exception {
        String firstModuleName = null;
        String firstModuleVersion = null;
        for (ModuleSpec module : this.modules) {
            String moduleName = module.getName();
            String version2 = this.checkModuleVersionsOrShowSuggestions(moduleName, module.isVersioned() ? module.getVersion() : null, ModuleQuery.Type.JVM, 8, 1, null, null, null);
            if (version2 == null) {
                return;
            }
            if (firstModuleName == null) {
                firstModuleName = moduleName;
                firstModuleVersion = version2;
            }
            this.loadModule(null, moduleName, version2);
            if (this.force) continue;
            this.errorOnConflictingModule(moduleName, version2);
        }
        this.loader.resolve();
        String versionSuffix = firstModuleVersion != null && !firstModuleVersion.isEmpty() ? "-" + firstModuleVersion : "";
        File outputJar = this.applyCwd(this.out != null ? this.out : new File(firstModuleName + versionSuffix + ".jar"));
        if (outputJar.getParentFile() != null && !outputJar.getParentFile().exists()) {
            FileUtil.mkdirs(outputJar.getParentFile());
        }
        if (outputJar.exists()) {
            FileUtil.delete(outputJar);
        }
        final HashSet<String> added = new HashSet<String>();
        if (firstModuleName != null && this.run != null && !this.run.contains("::") && !this.run.contains(".")) {
            this.run = firstModuleName + "::" + this.run;
        }
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        final String className = JVMModuleUtil.javaClassNameFromCeylon(firstModuleName, this.run);
        mainAttributes.putValue("Main-Class", className);
        mainAttributes.putValue("Manifest-Version", "1.0");
        mainAttributes.putValue("Created-By", "Ceylon fat-jar for module " + firstModuleName + "/" + firstModuleVersion);
        this.writeManifestEntries(mainAttributes);
        added.add("META-INF/");
        added.add("META-INF/MANIFEST.MF");
        this.addResources();
        try (final JarOutputStream zipFile = new JarOutputStream((OutputStream)new FileOutputStream(outputJar), manifest);){
            this.writeResources(zipFile);
            final ArrayList<ArtifactResult> staticMetamodelEntries = new ArrayList<ArtifactResult>();
            this.loader.visitModules(new ModuleGraph.Visitor(){
                String runClassPath;
                {
                    this.runClassPath = className.replace('.', '/') + ".class";
                }

                @Override
                public void visit(ModuleGraph.Module module) {
                    block19: {
                        if (module.artifact != null) {
                            File file = module.artifact.artifact();
                            try {
                                if (file == null) break block19;
                                if (CeylonFatJarTool.this.isVerbose()) {
                                    CeylonFatJarTool.this.append(file.getAbsolutePath());
                                    CeylonFatJarTool.this.newline();
                                }
                                staticMetamodelEntries.add(module.artifact);
                                try (ZipFile src = new ZipFile(file);){
                                    Enumeration<? extends ZipEntry> entries = src.entries();
                                    while (entries.hasMoreElements()) {
                                        ZipEntry srcEntry = entries.nextElement();
                                        if (srcEntry.getName().equals(this.runClassPath)) {
                                            CeylonFatJarTool.this.foundRun = true;
                                        }
                                        if (CeylonFatJarTool.this.skipEntry(srcEntry.getName())) continue;
                                        if (!added.add(srcEntry.getName())) {
                                            if (srcEntry.isDirectory()) continue;
                                            CeylonFatJarTool.this.append("Warning: skipping duplicate entry ").append(srcEntry.getName()).append(" from ").append(file).newline();
                                            continue;
                                        }
                                        srcEntry.setCompressedSize(-1L);
                                        zipFile.putNextEntry(srcEntry);
                                        if (srcEntry.isDirectory()) continue;
                                        IOUtils.copyStream(src.getInputStream(srcEntry), zipFile, true, false);
                                    }
                                }
                            }
                            catch (IOException x) {
                                throw new RuntimeException(x);
                            }
                        }
                    }
                }
            });
            JvmBackendUtil.writeStaticMetamodel(zipFile, added, staticMetamodelEntries, this.jdkProvider, Collections.emptySet());
            zipFile.flush();
        }
        this.flush();
        if (!this.foundRun) {
            this.append("Warning: missing run class ").append(className).newline();
        }
    }

    private boolean skipEntry(String name) {
        return name.equals("META-INF/MANIFEST.MF") || name.equals("META-INF/INDEX.LIST") || name.equals("META-INF/mapping.txt") || name.startsWith("META-INF/") && (name.endsWith(".DSA") || name.endsWith(".RSA") || name.endsWith(".SF"));
    }

    @Override
    protected boolean shouldExclude(String moduleName, String version2) {
        return super.shouldExclude(moduleName, version2) || this.excludedModules.contains(moduleName);
    }

    @Override
    protected void debug(String key, Object ... args) {
        if (this.verbose != null && !this.verbose.equals("loader")) {
            try {
                this.append("Debug: ").append(CeylonFatJarMessages.msg(key, args)).newline();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void usageError(String key, Object ... args) {
        throw new ToolUsageError(CeylonFatJarMessages.msg("resourceRoot.missing", args));
    }
}

