/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.maven.export;

import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleGraph;
import com.redhat.ceylon.cmr.impl.ShaSigner;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.RepositoryException;
import com.redhat.ceylon.tools.maven.export.CeylonMavenExportMessages;
import com.redhat.ceylon.tools.moduleloading.ModuleLoadingTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

@Summary(value="Generate a Maven repository for a given module")
@Description(value="Generate Maven repository which contains the given module and all its run-time dependencies, including the Ceylon runtime, which makes that repository usable by Maven as a regular Maven repository.\n\nAlternatively, running with `--for-import` creates a special repository set up suitable for importing the Ceylon distribution into Maven Central. This is mostly useful for the Ceylon team.")
public class CeylonMavenExportTool
extends ModuleLoadingTool {
    private final Comparator<? super ArtifactResult> ImportComparator = new ImportComparator();
    private List<ModuleSpec> modules;
    private File out;
    private final List<String> excludedModules = new ArrayList<String>();
    private boolean forImport;
    private boolean forSdkImport;
    private int indent = 0;

    @Argument(order=1, argumentName="module", multiplicity="+")
    public void setModules(List<String> modules) {
        this.setModuleSpecs(ModuleSpec.parseEachList(modules, new ModuleSpec.Option[0]));
    }

    public void setModuleSpecs(List<ModuleSpec> modules) {
        this.modules = modules;
    }

    @Description(value="Target Maven repository folder (defaults to `maven-repository`).")
    @OptionArgument(shortName=111, argumentName="file")
    public void setOut(File out) {
        this.out = out;
    }

    @Option(longName="for-import")
    @Description(value="Special set up to create a set of folders to import the distrib.")
    public void setForImport(boolean forImport) {
        this.forImport = forImport;
    }

    @Option(longName="for-sdk-import")
    @Description(value="Special set up to create a set of folders to import the Ceylon SDK.")
    public void setForSdkImport(boolean forSdkImport) {
        this.forSdkImport = forSdkImport;
    }

    @OptionArgument(argumentName="moduleOrFile", shortName=120)
    @Description(value="Excludes modules from the resulting Maven repository. Can be a module name or a file containing module names. Can be specified multiple times.")
    public void setExcludeModule(List<String> exclusions) {
        for (String each : exclusions) {
            File xFile = new File(each);
            if (xFile.exists() && xFile.isFile()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(xFile));
                    Throwable throwable = null;
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            this.excludedModules.add(line);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        reader.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new ToolUsageError(CeylonMavenExportMessages.msg("exclude.file.failure", each), e);
                }
            }
            this.excludedModules.add(each);
        }
    }

    @Override
    public void run() throws Exception {
        String firstModuleName = null;
        for (ModuleSpec module : this.modules) {
            String moduleName = module.getName();
            String version2 = this.checkModuleVersionsOrShowSuggestions(moduleName, module.isVersioned() ? module.getVersion() : null, ModuleQuery.Type.JVM, 8, 1, null, null, null);
            if (version2 == null) {
                return;
            }
            if (firstModuleName == null) {
                firstModuleName = moduleName;
            }
            System.err.println("Doing " + module);
            this.loadModule(null, moduleName, version2);
        }
        this.loader.resolve();
        final File outputFolder = this.applyCwd(this.out != null ? this.out : new File("maven-repository"));
        if (!outputFolder.exists()) {
            FileUtil.mkdirs(outputFolder);
        } else {
            FileUtil.delete(outputFolder);
        }
        final LinkedList<ArtifactResult> writtenModules = new LinkedList<ArtifactResult>();
        final LinkedList<ArtifactResult> externalDependencies = new LinkedList<ArtifactResult>();
        final HashSet<String> directImports = new HashSet<String>();
        this.loader.visitModules(new ModuleGraph.Visitor(){

            @Override
            public void visit(ModuleGraph.Module module) {
                if (module.artifact == null || module.artifact.artifact() == null) {
                    return;
                }
                if (CeylonMavenExportTool.this.forImport || CeylonMavenExportTool.this.forSdkImport) {
                    if (CeylonMavenExportTool.this.forImport && !module.artifact.groupId().equals("org.ceylon-lang")) {
                        externalDependencies.add(module.artifact);
                        return;
                    }
                    if (CeylonMavenExportTool.this.forSdkImport && !CeylonMavenExportTool.this.directlyListed(module.artifact.name())) {
                        if (!module.artifact.groupId().equals("org.ceylon-lang")) {
                            externalDependencies.add(module.artifact);
                        }
                        return;
                    }
                    CeylonMavenExportTool.this.makeMavenImportFolder(module, outputFolder, directImports);
                    writtenModules.add(module.artifact);
                } else {
                    CeylonMavenExportTool.this.makeMavenModule(module, outputFolder, directImports);
                }
            }
        });
        if (this.forImport || this.forSdkImport) {
            this.makeMavenImportSpecialFolders(writtenModules, externalDependencies, outputFolder, directImports);
        }
        this.flush();
    }

    private void makeMavenImportSpecialFolders(List<ArtifactResult> writtenModules, List<ArtifactResult> externalDependencies, File outputFolder, Set<String> directImports) {
        if (this.forImport) {
            File pomAllFile = this.makePomFile(outputFolder, "ceylon-all");
            this.generatePomForAll(pomAllFile, writtenModules, directImports);
            File pomSystemFile = this.makePomFile(outputFolder, "ceylon-system");
            this.generatePomForSystem(pomSystemFile, writtenModules, directImports);
            File pomCompleteFile = this.makePomFile(outputFolder, "ceylon-complete");
            this.generatePomForComplete(pomCompleteFile, writtenModules, externalDependencies);
            File pomPartsFile = new File(outputFolder, "pom-parts-distrib.xml");
            this.generatePomParts(pomPartsFile, writtenModules, externalDependencies, directImports);
        } else if (this.forSdkImport) {
            File pomSdkFile = this.makePomFile(outputFolder, "ceylon-sdk");
            this.generatePomForSdk(pomSdkFile, writtenModules, directImports);
            File pomPartsFile = new File(outputFolder, "pom-parts-sdk.xml");
            this.generatePomParts(pomPartsFile, writtenModules, externalDependencies, directImports);
        }
    }

    private File makePomFile(File outputFolder, String allArtifactId) {
        File folder = new File(outputFolder, allArtifactId);
        FileUtil.mkdirs(folder);
        return new File(folder, "pom.xml");
    }

    private void generatePomForAll(File pomFile, List<ArtifactResult> writtenModules, Set<String> directImports) {
        try (FileOutputStream os = new FileOutputStream(pomFile);){
            XMLStreamWriter out = XMLOutputFactory.newInstance().createXMLStreamWriter(new OutputStreamWriter((OutputStream)os, "utf-8"));
            this.writePomHeader(out);
            this.writePomParent(out, writtenModules.get(0));
            this.writeElement(out, "artifactId", "ceylon-all");
            this.writeNewline(out);
            this.writeElement(out, "name", "ceylon-all");
            this.writePomDependencies(out, writtenModules, directImports);
            this.writePomFooter(out);
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void generatePomForSdk(File pomFile, List<ArtifactResult> writtenModules, Set<String> directImports) {
        try (FileOutputStream os = new FileOutputStream(pomFile);){
            XMLStreamWriter out = XMLOutputFactory.newInstance().createXMLStreamWriter(new OutputStreamWriter((OutputStream)os, "utf-8"));
            this.writePomHeader(out);
            this.writePomParent(out, writtenModules.get(0));
            this.writeElement(out, "artifactId", "ceylon-sdk");
            this.writeNewline(out);
            this.writeElement(out, "name", "ceylon-sdk");
            this.writePomDependencies(out, writtenModules, directImports);
            this.writePomFooter(out);
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void generatePomForSystem(File pomFile, List<ArtifactResult> writtenModules, Set<String> directImports) {
        try (FileOutputStream os = new FileOutputStream(pomFile);){
            XMLStreamWriter out = XMLOutputFactory.newInstance().createXMLStreamWriter(new OutputStreamWriter((OutputStream)os, "utf-8"));
            this.writePomHeader(out);
            this.writePomParent(out, writtenModules.get(0));
            this.writeElement(out, "artifactId", "ceylon-system");
            this.writeNewline(out);
            this.writeElement(out, "name", "ceylon-system");
            this.writeNewline(out);
            this.writeElement(out, "packaging", "pom");
            this.writePomDependencies(out, writtenModules, directImports);
            this.writePomFooter(out);
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeNewline(XMLStreamWriter out) throws XMLStreamException {
        out.writeCharacters("\n");
    }

    private void writeIndent(XMLStreamWriter out) throws XMLStreamException {
        if (this.indent == 0) {
            return;
        }
        out.writeCharacters("\n");
        for (int i = 0; i < this.indent; ++i) {
            out.writeCharacters("  ");
        }
    }

    private void writeOpen(XMLStreamWriter out, String element) throws XMLStreamException {
        this.writeIndent(out);
        out.writeStartElement(element);
        ++this.indent;
    }

    private void writeClose(XMLStreamWriter out) throws XMLStreamException {
        --this.indent;
        this.writeIndent(out);
        out.writeEndElement();
    }

    private void writeElement(XMLStreamWriter out, String element, String text) throws XMLStreamException {
        this.writeIndent(out);
        out.writeStartElement(element);
        out.writeCharacters(text);
        out.writeEndElement();
    }

    private void generatePomForComplete(File pomFile, List<ArtifactResult> writtenModules, List<ArtifactResult> externalDependencies) {
        try (FileOutputStream os = new FileOutputStream(pomFile);){
            XMLStreamWriter out = XMLOutputFactory.newInstance().createXMLStreamWriter(new OutputStreamWriter((OutputStream)os, "utf-8"));
            this.writePomHeader(out);
            this.writePomParent(out, writtenModules.get(0));
            this.writeElement(out, "artifactId", "ceylon-complete");
            this.writeNewline(out);
            this.writeElement(out, "name", "ceylon-complete");
            this.writeNewline(out);
            this.writeOpen(out, "dependencies");
            this.writeOpen(out, "dependency");
            this.writeElement(out, "groupId", "org.ceylon-lang");
            this.writeElement(out, "artifactId", "ceylon-all");
            this.writeClose(out);
            this.writeClose(out);
            this.writeNewline(out);
            this.writeOpen(out, "build");
            this.writeOpen(out, "plugins");
            this.writeOpen(out, "plugin");
            this.writeElement(out, "artifactId", "maven-shade-plugin");
            this.writeElement(out, "version", "2.4.2");
            this.writeOpen(out, "executions");
            this.writeOpen(out, "execution");
            this.writeOpen(out, "goals");
            this.writeElement(out, "goal", "shade");
            this.writeClose(out);
            this.writeOpen(out, "configuration");
            this.writeElement(out, "createDependencyReducedPom", "true");
            this.writeElement(out, "createSourcesJar", "true");
            this.writeOpen(out, "artifactSet");
            this.writeOpen(out, "includes");
            this.writeElement(out, "include", "org.ceylon-lang:*");
            ArrayList<ArtifactResult> sortedImports = new ArrayList<ArtifactResult>(externalDependencies);
            Collections.sort(sortedImports, this.ImportComparator);
            for (ArtifactResult dep : sortedImports) {
                String dependencyName = dep.name();
                if (this.jdkProvider.isJDKModule(dependencyName)) continue;
                this.writeElement(out, "include", dep.groupId() + ":" + dep.artifactId());
            }
            this.writeClose(out);
            this.writeClose(out);
            this.writeClose(out);
            this.writeClose(out);
            this.writeClose(out);
            this.writeClose(out);
            this.writeClose(out);
            this.writeClose(out);
            this.writePomFooter(out);
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void generatePomParts(File pomFile, List<ArtifactResult> writtenModules, List<ArtifactResult> externalDependencies, Set<String> directImports) {
        try (FileOutputStream os = new FileOutputStream(pomFile);){
            XMLStreamWriter out = XMLOutputFactory.newInstance().createXMLStreamWriter(new OutputStreamWriter((OutputStream)os, "utf-8"));
            this.writePomHeader(out);
            this.writePomParent(out, writtenModules.get(0));
            this.writeElement(out, "artifactId", "ceylon-parts");
            this.writeNewline(out);
            this.writeElement(out, "name", "ceylon-parts");
            this.writeNewline(out);
            this.writeOpen(out, "properties");
            TreeMap<String, String> props = new TreeMap<String, String>();
            for (ArtifactResult artifactResult : externalDependencies) {
                String name = this.getDependencyPropertyName(artifactResult.name());
                if (!directImports.contains(name)) continue;
                props.put(name, artifactResult.version());
            }
            for (Map.Entry entry : props.entrySet()) {
                this.writeElement(out, (String)entry.getKey(), (String)entry.getValue());
            }
            this.writeClose(out);
            this.writeNewline(out);
            this.writeOpen(out, "modules");
            ArrayList<ArtifactResult> sortedImports = new ArrayList<ArtifactResult>(writtenModules);
            Collections.sort(sortedImports, this.ImportComparator);
            for (ArtifactResult artifactResult : sortedImports) {
                String dependencyName = artifactResult.name();
                this.writeElement(out, "module", dependencyName);
            }
            if (this.forImport) {
                this.writeElement(out, "module", "ceylon-all");
                this.writeElement(out, "module", "ceylon-complete");
                this.writeElement(out, "module", "ceylon-system");
            } else {
                this.writeElement(out, "module", "ceylon-sdk");
            }
            this.writeClose(out);
            this.writeNewline(out);
            this.writeOpen(out, "dependencyManagement");
            this.writePomDependencies(out, writtenModules, directImports, true);
            this.writeClose(out);
            this.writeNewline(out);
            this.writePomFooter(out);
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    protected void makeMavenImportFolder(ModuleGraph.Module module, File outputFolder, Set<String> directImports) {
        File pomFile = this.makePomFile(outputFolder, module.artifact.artifactId());
        this.generatePomFromModule(pomFile, module.artifact, directImports);
    }

    protected void makeMavenModule(ModuleGraph.Module module, File outputFolder, Set<String> directImports) {
        String groupId = module.artifact.groupId();
        String artifactId = module.artifact.artifactId();
        String path = groupId.replace('.', '/') + "/" + artifactId + "/" + module.version;
        File folder = new File(outputFolder, path);
        FileUtil.mkdirs(folder);
        String mavenFileName = artifactId + "-" + module.version;
        try {
            File pomFile;
            File jarFile;
            block27: {
                jarFile = new File(folder, mavenFileName + ".jar");
                pomFile = new File(folder, mavenFileName + ".pom");
                Files.copy(module.artifact.artifact().toPath(), jarFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                try (ZipFile zf = new ZipFile(module.artifact.artifact());){
                    ZipEntry pomEntry = zf.getEntry("META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml");
                    if (pomEntry != null) {
                        try (InputStream is = zf.getInputStream(pomEntry);){
                            Files.copy(is, pomFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            break block27;
                        }
                    }
                    this.generatePomFromModule(pomFile, module.artifact, directImports);
                }
            }
            ShaSigner.sign(jarFile, null, false);
            ShaSigner.sign(pomFile, null, false);
        }
        catch (RepositoryException | IOException e) {
            e.printStackTrace();
        }
    }

    private void generatePomFromModule(File pomFile, ArtifactResult artifact, Set<String> directImports) {
        try (FileOutputStream os = new FileOutputStream(pomFile);){
            XMLStreamWriter out = XMLOutputFactory.newInstance().createXMLStreamWriter(new OutputStreamWriter((OutputStream)os, "utf-8"));
            this.writePomHeader(out);
            if (this.forImport || this.forSdkImport) {
                this.writePomParent(out, artifact);
            } else {
                this.writeElement(out, "groupId", artifact.groupId());
            }
            this.writeElement(out, "artifactId", artifact.artifactId());
            this.writeNewline(out);
            this.writeElement(out, "name", artifact.name());
            if (this.forImport || this.forSdkImport) {
                this.writeElement(out, "packaging", "jar");
                this.writeNewline(out);
                this.writeOpen(out, "properties");
                String root = this.forImport ? "${ceylon.home}/repo/" : "${ceylon.sdk}/";
                this.writeElement(out, "jarFile", root + artifact.name().replace('.', '/') + "/${ceylon.version}/" + artifact.name() + "-${ceylon.version}." + (artifact.artifact().getName().endsWith(".jar") ? "jar" : "car"));
                this.writeElement(out, "sourcesFile", root + artifact.name().replace('.', '/') + "/${ceylon.version}/" + artifact.name() + "-${ceylon.version}.src");
                this.writeClose(out);
            } else {
                this.writeElement(out, "version", artifact.version());
            }
            List<ArtifactResult> imports = artifact.dependencies();
            this.writePomDependencies(out, imports, directImports);
            if (this.forImport || this.forSdkImport) {
                this.writeNewline(out);
                this.writeOpen(out, "build");
                this.writeOpen(out, "plugins");
                this.writeOpen(out, "plugin");
                this.writeElement(out, "groupId", "com.coderplus.maven.plugins");
                this.writeElement(out, "artifactId", "copy-rename-maven-plugin");
                this.writeClose(out);
                this.writeOpen(out, "plugin");
                this.writeElement(out, "groupId", "org.codehaus.mojo");
                this.writeElement(out, "artifactId", "build-helper-maven-plugin");
                this.writeClose(out);
                this.writeClose(out);
                this.writeClose(out);
            }
            this.writePomFooter(out);
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void writePomFooter(XMLStreamWriter out) throws XMLStreamException {
        this.writeNewline(out);
        this.writeClose(out);
        out.writeCharacters("\n");
        out.writeEndDocument();
        out.flush();
    }

    private boolean directlyListed(String name) {
        for (ModuleSpec spec : this.modules) {
            if (!spec.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void writePomDependencies(XMLStreamWriter out, List<ArtifactResult> imports, Set<String> directImports) throws XMLStreamException {
        this.writePomDependencies(out, imports, directImports, false);
    }

    private void writePomDependencies(XMLStreamWriter out, List<ArtifactResult> imports, Set<String> directImports, boolean forceVersion) throws XMLStreamException {
        if (!imports.isEmpty()) {
            this.writeNewline(out);
            this.writeOpen(out, "dependencies");
            ArrayList<ArtifactResult> sortedImports = new ArrayList<ArtifactResult>(imports);
            Collections.sort(sortedImports, this.ImportComparator);
            for (ArtifactResult dep : sortedImports) {
                String dependencyName = dep.name();
                ArtifactResult moduleArtifact = this.loader.getModuleArtifact(dependencyName);
                if (this.jdkProvider.isJDKModule(dependencyName)) continue;
                String[] mavenCoordinates = ModuleUtil.getMavenCoordinates(dependencyName);
                if (moduleArtifact != null) {
                    mavenCoordinates[0] = moduleArtifact.groupId();
                    mavenCoordinates[1] = moduleArtifact.artifactId();
                    mavenCoordinates[2] = moduleArtifact.classifier();
                }
                this.writeOpen(out, "dependency");
                this.writeElement(out, "groupId", mavenCoordinates[0]);
                this.writeElement(out, "artifactId", mavenCoordinates[1]);
                if (mavenCoordinates[2] != null) {
                    this.writeElement(out, "classifier", mavenCoordinates[2]);
                }
                if (forceVersion || !this.forImport && !this.forSdkImport || !mavenCoordinates[0].equals("org.ceylon-lang")) {
                    String version2;
                    if (forceVersion) {
                        version2 = "${ceylon.version}";
                    } else if (this.forImport || this.forSdkImport) {
                        version2 = "${";
                        String name = this.getDependencyPropertyName(dep.name());
                        directImports.add(name);
                        version2 = version2 + name;
                        version2 = version2 + "}";
                    } else {
                        version2 = dep.version();
                    }
                    this.writeElement(out, "version", version2);
                }
                if (dep.optional()) {
                    this.writeElement(out, "optional", "true");
                }
                this.writeClose(out);
            }
            this.writeClose(out);
        }
    }

    private String getDependencyPropertyName(String name) {
        if (name.startsWith("com.redhat.ceylon.aether.")) {
            return "com.redhat.ceylon.aether";
        }
        return name.replace(':', '.');
    }

    private void writePomParent(XMLStreamWriter out, ArtifactResult artifact) throws XMLStreamException {
        this.writeOpen(out, "parent");
        this.writeElement(out, "groupId", artifact.groupId());
        this.writeElement(out, "artifactId", "ceylon-parent");
        this.writeElement(out, "version", artifact.version());
        this.writeClose(out);
        this.writeNewline(out);
    }

    private void writePomHeader(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartDocument("UTF-8", "1.0");
        out.writeCharacters("\n");
        this.writeOpen(out, "project");
        out.writeAttribute("xmlns", "http://maven.apache.org/POM/4.0.0");
        out.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        out.writeAttribute("xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd");
        this.writeElement(out, "modelVersion", "4.0.0");
        this.writeNewline(out);
    }

    @Override
    protected boolean shouldExclude(String moduleName, String version2) {
        return super.shouldExclude(moduleName, version2) || this.excludedModules.contains(moduleName);
    }

    @Override
    public boolean includeOptionalDependencies() {
        return this.forImport;
    }

    @Override
    public void cycleDetected(List<ModuleGraph.Module> path) {
        try {
            this.errorAppend(CeylonMavenExportMessages.msg("module.cycle", path));
            this.errorNewline();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public class ImportComparator
    implements Comparator<ArtifactResult> {
        @Override
        public int compare(ArtifactResult o1, ArtifactResult o2) {
            ArtifactResult to1 = CeylonMavenExportTool.this.loader.getModuleArtifact(o1.name());
            ArtifactResult to2 = CeylonMavenExportTool.this.loader.getModuleArtifact(o2.name());
            if (to1 == null || to2 == null) {
                return o1.name().compareTo(o2.name());
            }
            int ret = to1.groupId().equals("org.ceylon-lang") ? (to2.groupId().equals("org.ceylon-lang") ? 0 : -1) : (to2.groupId().equals("org.ceylon-lang") ? 1 : to1.groupId().compareTo(to2.groupId()));
            if (ret != 0) {
                return ret;
            }
            return to1.artifactId().compareTo(to2.artifactId());
        }
    }
}

