/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.moduleloading;

import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleGraph;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleNotFoundException;
import com.redhat.ceylon.common.Messages;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.RepoUsingTool;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.cmr.ModuleScope;
import com.redhat.ceylon.model.loader.JdkProvider;
import com.redhat.ceylon.tools.moduleloading.ModuleLoadingMessages;
import com.redhat.ceylon.tools.moduleloading.ToolModuleLoader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public abstract class ModuleLoadingTool
extends RepoUsingTool {
    protected boolean upgradeDist = DefaultToolOptions.getLinkWithCurrentDistribution();
    protected JdkProvider jdkProvider = new JdkProvider();
    protected String jdkProviderModule;
    protected ToolModuleLoader loader;

    public ModuleLoadingTool() {
        super(ModuleLoadingMessages.RESOURCE_BUNDLE);
    }

    @Option
    @Description(value="Downgrade which were compiled with a more recent version of the distribution to the version of that module present in this distribution (1.3.3). This might fail with a linker error at runtime. For example if the module depended on an API present in the more recent version, but absent from 1.3.3. Allowed arguments are upgrade, downgrade or abort. Default: upgrade")
    public void setLinkWithCurrentDistribution(boolean downgradeDist) {
        this.upgradeDist = !downgradeDist;
    }

    @Description(value="Alternate JDK provider module (defaults to the current running JDK).")
    @OptionArgument(argumentName="module")
    public void setJdkProvider(String jdkProviderModule) {
        this.jdkProviderModule = jdkProviderModule;
    }

    @Override
    protected boolean shouldUpgradeDist() {
        return this.upgradeDist;
    }

    protected String moduleVersion(String moduleNameOptVersion) throws IOException {
        return this.checkModuleVersionsOrShowSuggestions(ModuleUtil.moduleName(moduleNameOptVersion), ModuleUtil.moduleVersion(moduleNameOptVersion), ModuleQuery.Type.JVM, 8, 1, null, null);
    }

    protected boolean loadModule(String namespace, String moduleName, String moduleVersion) throws IOException {
        if (moduleVersion != null) {
            return this.internalLoadModule(namespace, moduleName, moduleVersion);
        }
        return false;
    }

    protected boolean shouldExclude(String moduleName, String version2) {
        if (JDKUtils.jdk.providesVersion(JDKUtils.JDK.JDK9.version)) {
            moduleName = JDKUtils.getJava9ModuleName(moduleName, version2);
        }
        return this.jdkProvider.isJDKModule(moduleName);
    }

    protected boolean isProvided(String moduleName, String version2) {
        return false;
    }

    private boolean internalLoadModule(String namespace, String name, String version2) throws IOException {
        try {
            return this.loader.loadModuleForTool(name, version2, ModuleScope.RUNTIME);
        }
        catch (ModuleNotFoundException e) {
            String err = this.getModuleNotFoundErrorMessage(this.getRepositoryManager(), name, version2);
            this.errorAppend(err);
            this.errorNewline();
            return false;
        }
    }

    protected boolean skipDependency(ArtifactResult dep) {
        return false;
    }

    protected void errorOnConflictingModule(String module, String version2) throws IOException {
        boolean duplicate = false;
        for (Map.Entry<String, SortedSet<String>> entry : this.loader.getDuplicateModules().entrySet()) {
            duplicate = true;
            this.printDuplicateModuleErrorMessage(entry.getKey(), entry.getValue());
        }
        if (duplicate) {
            throw new ToolUsageError(Messages.msg(this.bundle, "module.conflict.error", module, version2));
        }
    }

    private void printDuplicateModuleErrorMessage(String name, SortedSet<String> versions) throws IOException {
        StringBuilder err = new StringBuilder();
        boolean first = true;
        for (String version2 : versions) {
            if (first) {
                first = false;
            } else {
                err.append(", ");
            }
            err.append(version2);
        }
        this.errorMsg("module.duplicate.error", name, err, versions.last());
    }

    protected String[] getLoaderSuffixes() {
        return new String[]{".car", ".jar"};
    }

    @Override
    public void initialize(CeylonTool mainTool) throws Exception {
        super.initialize(mainTool);
        this.loader = new ToolModuleLoader(this, this.getRepositoryManager(), this.getLoaderSuffixes());
        if (this.jdkProviderModule != null) {
            ModuleSpec moduleSpec = ModuleSpec.parse(this.jdkProviderModule, new ModuleSpec.Option[0]);
            if (!this.internalLoadModule(null, moduleSpec.getName(), moduleSpec.getVersion())) {
                throw new ToolUsageError(Messages.msg(this.bundle, "jdk.provider.not.found", this.jdkProviderModule));
            }
            ArtifactResult result = this.loader.getModuleArtifact(moduleSpec.getName());
            this.jdkProvider = new JdkProvider(moduleSpec.getName(), moduleSpec.getVersion(), null, result.artifact());
        }
    }

    public void handleMissingModuleError(String name, String version2) {
        try {
            String err = this.getModuleNotFoundErrorMessage(this.getRepositoryManager(), name, version2);
            this.errorAppend(err);
            this.errorNewline();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean includeOptionalDependencies() {
        return false;
    }

    public void cycleDetected(List<ModuleGraph.Module> path) {
    }
}

