/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.moduleloading;

import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.tools.moduleloading.ModuleLoadingTool;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public abstract class ResourceRootTool
extends ModuleLoadingTool {
    private String resourceRoot;
    private final List<EntrySpec> entrySpecs = new ArrayList<EntrySpec>();
    private List<String[]> manifestEntries = new ArrayList<String[]>();

    @OptionArgument(shortName=82, argumentName="directory")
    @Description(value="Sets the special resource directory whose files will end up in the root of the resulting WAR file (default: web-content).")
    public void setResourceRoot(String root) {
        this.resourceRoot = root;
    }

    @OptionArgument(argumentName="key:value", shortName=101)
    @Description(value="Specify a manifest entry for the resulting fat jar, of form <key>:<value>. Can be specified multiple times.")
    public void setManifestEntry(List<String> entries) {
        for (String entry : entries) {
            String[] keyValue = entry.split(":", 2);
            if (keyValue.length != 2) continue;
            this.manifestEntries.add(keyValue);
        }
    }

    protected void writeResources(JarOutputStream zipFile) throws IOException {
        for (EntrySpec entry : this.entrySpecs) {
            entry.write(zipFile);
        }
    }

    protected void writeManifestEntries(Attributes mainAttributes) {
        for (String[] keyValue : this.manifestEntries) {
            mainAttributes.putValue(keyValue[0], keyValue[1]);
        }
    }

    protected void addResources() throws MalformedURLException {
        File root;
        if (this.resourceRoot == null) {
            File defaultRoot = this.applyCwd(new File("web-content"));
            if (!defaultRoot.exists()) {
                return;
            }
            root = defaultRoot;
        } else {
            root = this.applyCwd(new File(this.resourceRoot));
        }
        if (!root.exists()) {
            this.usageError("resourceRoot.missing", root.getAbsolutePath());
        }
        if (!root.isDirectory()) {
            this.usageError("resourceRoot.nondir", root.getAbsolutePath());
        }
        this.debug("adding.resources", root.getAbsolutePath());
        this.addResources(root, "");
    }

    private void addResources(File root, String prefix) throws MalformedURLException {
        for (File f : root.listFiles()) {
            if (f.isDirectory()) {
                this.addResources(f, prefix + f.getName() + "/");
                continue;
            }
            this.addSpec(new URLEntrySpec(f.toURI().toURL(), prefix + f.getName()));
        }
    }

    protected void addSpec(EntrySpec spec) {
        this.debug("adding.entry", spec.name);
        this.entrySpecs.add(spec);
    }

    protected abstract void debug(String var1, Object ... var2);

    protected abstract void usageError(String var1, Object ... var2);

    protected class PropertiesEntrySpec
    extends EntrySpec {
        private final Properties properties;

        public PropertiesEntrySpec(Properties properties, String name) {
            super(name);
            this.properties = properties;
        }

        @Override
        public void write(JarOutputStream out) throws IOException {
            out.putNextEntry(new ZipEntry(this.name));
            this.properties.store(out, "");
        }

        @Override
        InputStream openStream() throws IOException {
            return null;
        }
    }

    protected class StringEntrySpec
    extends EntrySpec {
        private final String content;

        public StringEntrySpec(String content, String name) {
            super(name);
            this.content = content;
        }

        @Override
        InputStream openStream() throws IOException {
            return new ByteArrayInputStream(this.content.getBytes());
        }
    }

    protected class URLEntrySpec
    extends EntrySpec {
        private final URL url;

        public URLEntrySpec(URL url, String name) {
            super(name);
            this.url = url;
        }

        @Override
        InputStream openStream() throws IOException {
            return this.url.openStream();
        }
    }

    protected abstract class EntrySpec {
        final String name;

        EntrySpec(String name) {
            this.name = name;
        }

        public void write(JarOutputStream out) throws IOException {
            out.putNextEntry(new ZipEntry(this.name));
            IOUtils.copyStream(this.openStream(), out, true, false);
        }

        abstract InputStream openStream() throws IOException;
    }
}

