/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.new_;

import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.CeylonBaseTool;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Hidden;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.Rest;
import com.redhat.ceylon.common.tool.Subtool;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.ToolModel;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.tools.new_.Copy;
import com.redhat.ceylon.tools.new_.Environment;
import com.redhat.ceylon.tools.new_.GivenValue;
import com.redhat.ceylon.tools.new_.Messages;
import com.redhat.ceylon.tools.new_.NewSubTool;
import com.redhat.ceylon.tools.new_.Project;
import com.redhat.ceylon.tools.new_.PromptedValue;
import com.redhat.ceylon.tools.new_.Template;
import com.redhat.ceylon.tools.new_.Variable;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Summary(value="Generates a new Ceylon project")
@Description(value="Generates a new project, prompting for information as necessary")
public class CeylonNewTool
extends CeylonBaseTool {
    private ToolModel<CeylonNewTool> model;
    private NewSubTool project;
    private File from = new File(System.getProperty("ceylon.home"), "templates");
    private Map<String, String> rest = new HashMap<String, String>();

    public void setToolModel(ToolModel<CeylonNewTool> model) {
        this.model = model;
    }

    @Subtool(argumentName="name", classes={Simple.class, HelloWorld.class, JavaInterop.class, Module.class}, order=2)
    public void setProject(NewSubTool project) {
        this.project = project;
    }

    @Hidden
    @OptionArgument(argumentName="dir")
    public void setFrom(File from) {
        this.from = from;
    }

    @Rest
    public void setRest(List<String> rest) {
        for (String optionArg : rest) {
            String arg;
            String option;
            if (!optionArg.startsWith("--")) continue;
            int idx = optionArg.indexOf("=");
            if (idx == -1) {
                option = optionArg.substring(2);
                arg = "";
            } else {
                option = optionArg.substring(2, idx);
                arg = optionArg.substring(idx + 1);
            }
            this.rest.put(option, arg);
        }
    }

    @Override
    public void initialize(CeylonTool mainTool) {
    }

    @Override
    public void run() throws Exception {
        File fromDir = this.getFromDir();
        if (!fromDir.exists() || !fromDir.isDirectory()) {
            throw new IllegalArgumentException(Messages.msg("from.nonexistent.or.nondir", fromDir));
        }
        Environment env = this.buildPromptedEnv();
        List<Copy> resources = this.project.getResources(env);
        this.project.mkBaseDir(this.getCwd());
        for (Copy copy : resources) {
            copy.run(env);
        }
    }

    private String getProjectName() {
        String projectName = this.model.getSubtoolModel().getToolLoader().getToolName(this.project.getClass().getName());
        return projectName;
    }

    private File getFromDir() {
        return new File(this.applyCwd(this.from), this.getProjectName());
    }

    private Environment buildPromptedEnv() {
        Environment env = new Environment();
        if (this.project.getDirectory() != null) {
            env.put("base.dir", this.applyCwd(this.project.getDirectory()).getAbsolutePath());
        }
        env.put("ceylon.home", System.getProperty("ceylon.home"));
        env.put("ceylon.version.number", "1.3.3");
        env.put("ceylon.version.major", Integer.toString(1));
        env.put("ceylon.version.minor", Integer.toString(3));
        env.put("ceylon.version.release", Integer.toString(3));
        env.put("ceylon.version.name", "Contents May Differ");
        HashSet<String> seenKeys = new HashSet<String>();
        LinkedList<Variable> vars = new LinkedList<Variable>(this.project.getVariables());
        while (!vars.isEmpty()) {
            Variable var = (Variable)vars.remove(0);
            if (seenKeys.contains(var.getKey())) {
                throw new RuntimeException("Variables for project do not form a tree");
            }
            seenKeys.add(var.getKey());
            vars.addAll(0, var.initialize(this.getProjectName(), env));
        }
        String sourceFolder = "source";
        String baseDir = env.get("base.dir");
        if (this.project.getDirectory() == null) {
            this.project.setDirectory(new File(baseDir));
        }
        try {
            CeylonConfig config = CeylonConfig.createFromLocalDir(new File(baseDir));
            List<File> srcs = DefaultToolOptions.getCompilerSourceDirs(config);
            sourceFolder = !srcs.isEmpty() ? srcs.get(0).getPath() : "source";
        }
        catch (Exception exception) {
            // empty catch block
        }
        env.put("source.folder", sourceFolder);
        this.log(env);
        return env;
    }

    public Copy substituting(String cwd, final String src, String dst) {
        return this.substituting(cwd, new PathMatcher(){

            @Override
            public boolean matches(Path path) {
                return path.endsWith(src);
            }
        }, dst);
    }

    public Copy substituting(String cwd, PathMatcher pathMatcher, String dst) {
        return new Copy(new File(this.getFromDir(), cwd), this.applyCwd(this.project.getDirectory()), pathMatcher, dst, true);
    }

    private void log(Object msg) {
        if (this.verbose != null) {
            System.out.println(msg);
        }
    }

    public class Module
    extends NewSubTool {
        private final Variable moduleName = new Variable("module.name", Variable.moduleNameValidator, new GivenValue("dummy"));
        private final Variable moduleVersion = new Variable("module.version", Variable.moduleVersionValidator, new GivenValue("1.0.0"));

        @Argument(argumentName="module", multiplicity="1", order=1)
        public void setModuleName(String moduleName) {
            this.moduleName.setVariableValue(new GivenValue(moduleName));
        }

        @Argument(argumentName="version", multiplicity="?", order=2)
        public void setModuleVersion(String moduleVersion) {
            this.moduleVersion.setVariableValue(new GivenValue(moduleVersion));
        }

        @Override
        public List<Variable> getVariables() {
            ArrayList<Variable> result = new ArrayList<Variable>();
            result.add(new Variable("base.dir", null, new GivenValue(".")));
            result.add(this.moduleName);
            result.add(Variable.moduleQuotedName("module.quoted.name", "module.name"));
            result.add(Variable.moduleDir("module.dir", "module.name"));
            result.add(this.moduleVersion);
            return result;
        }

        @Override
        public List<Copy> getResources(Environment env) {
            FileSystem fs = FileSystems.getDefault();
            ArrayList<Copy> result = new ArrayList<Copy>();
            result.add(CeylonNewTool.this.substituting("source", fs.getPathMatcher("glob:**"), new Template("@[source.folder]/@[module.dir]").eval(env)));
            return result;
        }
    }

    @Description(value="Generates a project that is able to use Java legacy code\n\nTakes a `dir` argument to indicate in which directory the new project should be created.")
    public class JavaInterop
    extends BaseProject {
        public JavaInterop() {
            super("javainterop", "com.example.javainterop");
        }
    }

    @Description(value="Generates a very simple empty project\n\nTakes a `dir` argument to indicate in which directory the new project should be created.")
    public class Simple
    extends BaseProject {
        public Simple() {
            super("simple", "com.example.simple");
        }
    }

    @Description(value="Generates a 'Hello World' style project.\n\nTakes a `dir` argument to indicate in which directory the new project should be created.")
    public class HelloWorld
    extends BaseProject {
        public HelloWorld() {
            super("helloworld", "com.example.helloworld");
        }
    }

    public abstract class BaseProject
    extends Project {
        private final Variable baseDir;
        private final Variable moduleName;
        private final Variable moduleVersion;
        private final Variable eclipseProjectName;
        private final Variable eclipse;
        private final Variable ant;

        public BaseProject(String defBaseDir, String defModName) {
            this.baseDir = Variable.directory("base.dir", this.shouldCreateProject() ? defBaseDir : ".");
            this.moduleName = Variable.moduleName("module.name", defModName);
            this.moduleVersion = Variable.moduleVersion("module.version", "1.0.0");
            this.eclipseProjectName = new Variable("eclipse.project.name", null, new PromptedValue("eclipse.project.name", "@[module.name]"));
            this.eclipse = Variable.yesNo("eclipse", Messages.msg("mnemonic.yes", new Object[0]), this.eclipseProjectName);
            this.ant = Variable.yesNo("ant", Messages.msg("mnemonic.yes", new Object[0]), new Variable[0]);
        }

        @OptionArgument
        @Description(value="Specifies the name for the new module.")
        public void setModuleName(String moduleName) {
            this.moduleName.setVariableValue(new GivenValue(moduleName));
        }

        @OptionArgument
        @Description(value="Specifies the version for the new module.")
        public void setModuleVersion(String moduleVersion) {
            this.moduleVersion.setVariableValue(new GivenValue(moduleVersion));
        }

        @OptionArgument
        @Description(value="Indicates if an Eclipse project should be generated or not.")
        public void setEclipse(boolean eclipse) {
            this.eclipse.setVariableValue(new GivenValue(Boolean.toString(eclipse)));
        }

        @OptionArgument
        @Description(value="Specifies the name for the Eclipse project.")
        public void setEclipseProjectName(String eclipseProjectName) {
            this.eclipseProjectName.setVariableValue(new GivenValue(eclipseProjectName));
        }

        @OptionArgument
        @Description(value="Indicates if an Ant build file should be generated or not.")
        public void setAnt(boolean ant) {
            this.ant.setVariableValue(new GivenValue(Boolean.toString(ant)));
        }

        @Override
        public List<Variable> getVariables() {
            ArrayList<Variable> result = new ArrayList<Variable>();
            if (this.getDirectory() == null) {
                result.add(this.baseDir);
            }
            result.add(this.moduleName);
            result.add(Variable.moduleQuotedName("module.quoted.name", "module.name"));
            result.add(Variable.moduleDir("module.dir", "module.name"));
            result.add(this.moduleVersion);
            if (this.shouldCreateProject()) {
                result.add(this.eclipse);
                result.add(this.ant);
            }
            return result;
        }

        protected boolean shouldCreateProject() {
            File ceylonDir = new File(CeylonNewTool.this.applyCwd(this.getDirectory()), ".ceylon");
            if (ceylonDir.isDirectory()) {
                return false;
            }
            File sourcesDir = new File(CeylonNewTool.this.applyCwd(this.getDirectory()), "source");
            return !sourcesDir.isDirectory();
        }

        @Override
        public List<Copy> getResources(Environment env) {
            FileSystem fs = FileSystems.getDefault();
            ArrayList<Copy> result = new ArrayList<Copy>();
            result.add(CeylonNewTool.this.substituting("source", fs.getPathMatcher("glob:**"), new Template("@[source.folder]/@[module.dir]").eval(env)));
            if ("true".equals(env.get("ant"))) {
                result.add(CeylonNewTool.this.substituting("ant", "build.xml", "."));
            }
            if ("true".equals(env.get("eclipse"))) {
                result.add(CeylonNewTool.this.substituting("eclipse", fs.getPathMatcher("glob:**"), "."));
            }
            return result;
        }
    }
}

