/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.new_;

import com.redhat.ceylon.tools.new_.Environment;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Template {
    private static final Pattern placeholder = Pattern.compile("@\\[([a-zA-Z][_a-zA-Z0-9.]*)\\]");
    private final CharSequence source;

    public Template(CharSequence source) {
        this.source = source;
    }

    public String eval(Substitution subs) {
        Matcher matcher = placeholder.matcher(this.source);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String token = matcher.group(1);
            String replacement = Matcher.quoteReplacement(subs.getReplacement(token, matcher, this.source));
            matcher.appendReplacement(result, replacement);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public String eval(Environment env) {
        return this.eval(new SimpleSubstitution(env));
    }

    protected static void throwMissingReplacement(String token, Matcher matcher, CharSequence source) {
        throw new RuntimeException("No replacement for " + token + " at line " + Template.lineNumber(source, matcher.start()));
    }

    protected static int lineNumber(CharSequence source, int index) {
        int line = 1;
        for (int ii = 0; ii < source.length(); ++ii) {
            char ch = source.charAt(ii);
            if (ch != '\n' && ch != '\r') continue;
            ++line;
            if (ii >= source.length() - 1 || source.charAt(ii + 1) == ch || source.charAt(ii + 1) != '\n' && source.charAt(ii + 1) != '\r') continue;
            ++ii;
        }
        return line;
    }

    public static class SimpleSubstitution
    implements Substitution {
        private final Environment env;
        private final String missing;

        public SimpleSubstitution(Environment env, String missing) {
            this.env = env;
            this.missing = missing;
        }

        public SimpleSubstitution(Environment env) {
            this(env, null);
        }

        @Override
        public String getReplacement(String token, Matcher matcher, CharSequence source) {
            String replacement = this.env.get(token);
            if (replacement == null) {
                replacement = this.missing;
            }
            if (replacement == null) {
                Template.throwMissingReplacement(token, matcher, source);
            }
            return replacement;
        }
    }

    public static interface Substitution {
        public String getReplacement(String var1, Matcher var2, CharSequence var3);
    }
}

