/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.war;

import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleGraph;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Hidden;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ModuleScope;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.tools.moduleloading.ResourceRootTool;
import com.redhat.ceylon.tools.war.CeylonWarMessages;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

@Summary(value="Generates a WAR file from a compiled `.car` file")
@Description(value="Generates a WAR file from the `.car` file of the given `module-with-version`, suitable for deploying to a standard Servlet container.\n\nThe version number is required since, in general, there can be multiple versions available in the configured repositories.\n\nThe given module's `.car` file and those of its transitive dependencies will be copied to the `WEB-INF/lib` of the generated WAR file. Dependencies which are provided by the application container (and thus not required to be in `WEB-INF/lib`) can be excluded using `--provided-module`.")
public class CeylonWarTool
extends ResourceRootTool {
    private List<ModuleSpec> modules;
    private final List<String> excludedModules = new ArrayList<String>();
    private final List<String> providedModules = new ArrayList<String>();
    private String out = null;
    private String name = null;

    @Hidden
    @Option(longName="static-metamodel")
    @Description(value="Obsolete: Generate a static metamodel, skip the WarInitializer (always true).")
    public void setStaticMetamodel(boolean staticMetamodel) throws IOException {
        this.append("WARNING: --static-metamodel option no longer supported: enabled by default").newline();
    }

    @Argument(argumentName="module", multiplicity="+")
    public void setModules(List<String> modules) {
        this.setModuleSpecs(ModuleSpec.parseEachList(modules, new ModuleSpec.Option[0]));
    }

    public void setModuleSpecs(List<ModuleSpec> modules) {
        this.modules = modules;
    }

    @OptionArgument(shortName=111, argumentName="dir")
    @Description(value="Sets the output directory for the WAR file (default: .)")
    public void setOut(String out) {
        this.out = out;
    }

    @OptionArgument(shortName=110, argumentName="name")
    @Description(value="Sets name of the WAR file (default: moduleName-version.war)")
    public void setName(String name) {
        this.name = name;
    }

    @OptionArgument(argumentName="moduleOrFile", shortName=120)
    @Description(value="Excludes modules from the WAR file. Can be a module name or a file containing module names. Can be specified multiple times. Note that this excludes the module from the WAR file, but if your modules require that module to be present at runtime it will still be required and may cause your application to fail to start if it is not provided at runtime.")
    public void setExcludeModule(List<String> exclusions) {
        for (String each : exclusions) {
            File xFile = new File(each);
            if (xFile.exists() && xFile.isFile()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(xFile));
                    Throwable throwable = null;
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            this.excludedModules.add(line);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        reader.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new ToolUsageError(CeylonWarMessages.msg("exclude.file.failure", each), e);
                }
            }
            this.excludedModules.add(each);
        }
    }

    @OptionArgument(argumentName="moduleOrFile", shortName=112)
    @Description(value="Excludes modules from the WAR file by treating them as provided. Can be a module name or a file containing module names. Can be specified multiple times. Note that this excludes the module from the WAR file, but if your modules require that module to be present at runtime it will still be required and may cause your application to fail to start if it is not provided at runtime. The only difference between this and `--exclude-module` is that provided modules are listed in the metamodel.")
    public void setProvidedModule(List<String> exclusions) {
        for (String each : exclusions) {
            File xFile = new File(each);
            if (xFile.exists() && xFile.isFile()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(xFile));
                    Throwable throwable = null;
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            this.providedModules.add(line);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        reader.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new ToolUsageError(CeylonWarMessages.msg("exclude.file.failure", each), e);
                }
            }
            this.providedModules.add(each);
        }
    }

    @Override
    protected boolean skipDependency(ArtifactResult dep) {
        return dep.moduleScope() == ModuleScope.PROVIDED;
    }

    @Override
    public void run() throws Exception {
        String moduleName = null;
        String moduleVersion = null;
        for (ModuleSpec module : this.modules) {
            String name = module.getName();
            String version2 = this.checkModuleVersionsOrShowSuggestions(name, module.isVersioned() ? module.getVersion() : null, ModuleQuery.Type.JVM, 8, 1, null, null, null);
            if (version2 == null) continue;
            if (!this.loadModule(null, name, version2)) {
                throw new ToolUsageError(CeylonWarMessages.msg("abort.missing.modules", new Object[0]));
            }
            if (moduleName != null) continue;
            moduleName = name;
            moduleVersion = version2;
        }
        this.loader.resolve();
        ArrayList<ArtifactResult> staticMetamodelEntries = new ArrayList<ArtifactResult>();
        this.addLibEntries(staticMetamodelEntries);
        this.addResources();
        if (this.name == null) {
            this.name = moduleVersion != null && !moduleVersion.isEmpty() ? String.format("%s-%s.war", moduleName, moduleVersion) : String.format("%s.war", moduleName);
            this.debug("default.name", this.name);
        }
        File jarFile = this.getJarFile();
        this.writeJarFile(jarFile, staticMetamodelEntries);
        String descr = moduleVersion != null && !moduleVersion.isEmpty() ? moduleName + "/" + moduleVersion : moduleName;
        this.append(CeylonWarMessages.msg("archive.created", descr, jarFile.getAbsolutePath()));
        this.newline();
    }

    public File getJarFile() {
        return this.applyCwd(this.out == null ? new File(this.name) : new File(this.out, this.name));
    }

    @Override
    protected boolean shouldExclude(String moduleName, String version2) {
        return super.shouldExclude(moduleName, version2) || this.excludedModules.contains(moduleName);
    }

    @Override
    protected boolean isProvided(String moduleName, String version2) {
        return super.isProvided(moduleName, version2) || this.providedModules.contains(moduleName);
    }

    @Override
    protected void debug(String key, Object ... args) {
        if (this.verbose != null && !this.verbose.equals("loader")) {
            try {
                this.append("Debug: ").append(CeylonWarMessages.msg(key, args)).newline();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void usageError(String key, Object ... args) {
        throw new ToolUsageError(CeylonWarMessages.msg("resourceRoot.missing", args));
    }

    protected void addLibEntries(final List<ArtifactResult> staticMetamodelEntries) throws MalformedURLException {
        final ArrayList libs = new ArrayList();
        this.loader.visitModules(new ModuleGraph.Visitor(){

            @Override
            public void visit(ModuleGraph.Module module) {
                if (module.artifact != null) {
                    File artifact = module.artifact.artifact();
                    try {
                        if (artifact != null) {
                            staticMetamodelEntries.add(module.artifact);
                            if (CeylonWarTool.this.isProvided(module.name, module.version)) {
                                return;
                            }
                            String moduleName = module.name;
                            String version2 = module.version;
                            String versionSuffix = version2 != null && !version2.isEmpty() ? "-" + version2 : "";
                            String name = ModuleUtil.moduleName(moduleName).replace(":", ".") + versionSuffix + ".jar";
                            if (name.contains("/") || name.contains("\\") || name.length() == 0) {
                                throw new ToolUsageError(CeylonWarMessages.msg("module.name.illegal", name));
                            }
                            CeylonWarTool.this.addSpec(new ResourceRootTool.URLEntrySpec(artifact.toURI().toURL(), "WEB-INF/lib/" + name));
                            libs.add(name);
                        }
                    }
                    catch (IOException x) {
                        throw new RuntimeException(x);
                    }
                }
            }
        });
    }

    protected void writeJarFile(File jarFile, List<ArtifactResult> staticMetamodelEntries) throws IOException {
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        this.writeManifestEntries(mainAttributes);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(jarFile));
             JarOutputStream zipFile = mainAttributes.isEmpty() ? new JarOutputStream(out) : new JarOutputStream((OutputStream)out, manifest);){
            this.writeResources(zipFile);
            HashSet<String> added = new HashSet<String>();
            JvmBackendUtil.writeStaticMetamodel(zipFile, added, staticMetamodelEntries, this.jdkProvider, new HashSet<String>(this.providedModules));
        }
    }
}

