/*
 * Decompiled with CFR 0.152.
 */
package ceylon.decimal;

import ceylon.decimal.Decimal;
import ceylon.decimal.DividedWithRemainder;
import ceylon.decimal.Rounding;
import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Exponentiable;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.Number;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import ceylon.whole.Whole;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.metadata.CaseTypes;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A decimal floating point number. This class provides support \nfor fixed and arbitrary precision numbers. Values are immutable \nand represented as `unscaled * 10^(-scale)`. Methods without \nan explicit [[Rounding]] parameter use [[unlimitedPrecision]] \n(unless documented otherwise) except for `plus()`, `minus()`, \n`times()`, `divided()` and `power()` whose implicit rounding \nis subject to the rounding specified in [[implicitlyRounded]].")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::FimplicitlyRounded"}), @SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::CRounding"}), @SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::VunlimitedPrecision"})})
@SharedAnnotation$annotation$
@SatisfiedTypes(value={"ceylon.language::Number<ceylon.decimal::Decimal>", "ceylon.language::Exponentiable<ceylon.decimal::Decimal,ceylon.language::Integer>"})
@CaseTypes(value={"ceylon.decimal::DecimalImpl"})
public interface Decimal
extends Number<Decimal>,
Exponentiable<Decimal, Integer> {
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(Decimal.class, (TypeDescriptor[])new TypeDescriptor[0]);

    @Ignore
    public impl $ceylon$decimal$Decimal$impl();

    @DocAnnotation$annotation$(description="The platform-specific implementation object, if any. This \nis provided for interoperation with the runtime platform.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Object?")
    @Nullable
    public Object getImplementation();

    @DocAnnotation$annotation$(description="Determine whether two instances have equal value.`equals()` \nconsiders `1` and `1.0` to be the same, `strictlyEquals()` \nconsiders them to be different.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.FstrictlyEquals"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @ActualAnnotation$annotation$
    public boolean equals(@Name(value="that") @TypeInfo(value="ceylon.language::Object") @NonNull Object var1);

    @DocAnnotation$annotation$(description="Determine whether two instances have equal value _and \nscale_. `strictlyEquals()` considers `1` and `1.0` to\nbe different, `equals()` considers them to be the same.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.Fequals"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    public boolean strictlyEquals(@Name(value="that") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal var1);

    @DocAnnotation$annotation$(description="The hash value of this `Decimal`. Due to the definition \nof `equals()` trailing zeros do not contribute to the \nhash calculation so `1` and `1.0` have the same `hash.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @ActualAnnotation$annotation$
    public int hashCode();

    @DocAnnotation$annotation$(description="The quotient obtained by dividing this `Decimal` by the \ngiven `Decimal`. Unless invoked within `implicitlyRounded()`\nthe preferred scale of the result is the difference between \nthis `Decimal`'s scale and the given `Decimal`'s scale; it \nmay be larger if necessary; an exception is thrown if the \nresult would have a nonterminating decimal representation.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.FdividedRounded"}), @SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.FdividedTruncated"}), @SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::FimplicitlyRounded"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal", erased=true, untrusted=true)
    @NonNull
    public Decimal divided(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal var1);

    @Ignore
    public Decimal dividedRounded(Decimal var1);

    @Ignore
    public Rounding dividedRounded$rounding(Decimal var1);

    @DocAnnotation$annotation$(description="The quotient obtained by dividing this `Decimal` by the given \n`Decimal` with the given rounding.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.Fdivided"}), @SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.FdividedTruncated"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal")
    @NonNull
    public Decimal dividedRounded(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal var1, @Name(value="rounding") @Defaulted @TypeInfo(value="ceylon.decimal::Rounding?") @Nullable Rounding var2);

    @DocAnnotation$annotation$(description="The product of this `Decimal` and the given `Decimal`. Unless \ninvoked within `implicitlyRounded()` the scale of the result \nis the sum of the scales of the operands.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.FtimesRounded"}), @SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::FimplicitlyRounded"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal", erased=true, untrusted=true)
    @NonNull
    public Decimal times(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal var1);

    @Ignore
    public Decimal timesRounded(Decimal var1);

    @Ignore
    public Rounding timesRounded$rounding(Decimal var1);

    @DocAnnotation$annotation$(description="The product of this `Decimal` and the given `Decimal` with \nthe given rounding.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.Ftimes"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal")
    @NonNull
    public Decimal timesRounded(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal var1, @Name(value="rounding") @Defaulted @TypeInfo(value="ceylon.decimal::Rounding?") @Nullable Rounding var2);

    @DocAnnotation$annotation$(description="The sum of this `Decimal` and the given `Decimal`. Unless \ninvoked within `implicitlyRounded()` the scale of the result \nis the greater of the scales of the operands.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.FplusRounded"}), @SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::FimplicitlyRounded"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal", erased=true, untrusted=true)
    @NonNull
    public Decimal plus(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal var1);

    @Ignore
    public Decimal plusRounded(Decimal var1);

    @Ignore
    public Rounding plusRounded$rounding(Decimal var1);

    @DocAnnotation$annotation$(description="The sum of this `Decimal` and the given `Decimal` with the \ngiven rounding.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.Fplus"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal")
    @NonNull
    public Decimal plusRounded(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal var1, @Name(value="rounding") @Defaulted @TypeInfo(value="ceylon.decimal::Rounding?") @Nullable Rounding var2);

    @DocAnnotation$annotation$(description="The difference between this `Decimal` and the given `Decimal`.\nUnless invoked within `implicitlyRounded()` the scale of the \nresult is the greater of the scales of the operands.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.FminusRounded"}), @SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::FimplicitlyRounded"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal", erased=true, untrusted=true)
    @NonNull
    public Decimal minus(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal var1);

    @Ignore
    public Decimal minusRounded(Decimal var1);

    @Ignore
    public Rounding minusRounded$rounding(Decimal var1);

    @DocAnnotation$annotation$(description="The difference between this `Decimal` and the given `Decimal` \nwith the given rounding.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.Fminus"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal")
    @NonNull
    public Decimal minusRounded(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal var1, @Name(value="rounding") @Defaulted @TypeInfo(value="ceylon.decimal::Rounding?") @Nullable Rounding var2);

    @DocAnnotation$annotation$(description="The result of raising this number to the given power. \nUnless invoked within \n`implicitlyRounded()` the result is computed to unlimited \nprecision and negative powers are not supported.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.FpowerRounded"})})
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language::CException", when="The exponent has a non-zero fractional part"), @ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language::CException", when="The exponent is too large or too small"), @ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language::CException", when="The exponent was negative when attempting to \ncompute a result to unlimited precision")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal", erased=true, untrusted=true)
    @NonNull
    public Decimal power(@Name(value="other") @NonNull Integer var1);

    @Ignore
    public Decimal powerRounded(long var1);

    @Ignore
    public Rounding powerRounded$rounding(long var1);

    @DocAnnotation$annotation$(description="The result of raising this number to the given power with \nthe given rounding. Fractional powers are not supported.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.Fpower"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal")
    @NonNull
    public Decimal powerRounded(@Name(value="other") long var1, @Name(value="rounding") @Defaulted @TypeInfo(value="ceylon.decimal::Rounding?") @Nullable Rounding var3);

    @Ignore
    public Decimal dividedTruncated(Decimal var1);

    @Ignore
    public Rounding dividedTruncated$rounding(Decimal var1);

    @DocAnnotation$annotation$(description="The integer part of the quotient obtained by dividing this \n`Decimal` by the given `Decimal` and truncating the result. \nThe scale of the result is the difference of the scales of \nthe operands.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language::CException", when="The integer part of the quotient requires \nmore than the given precision."), @ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language::CException", when="The given divisor is zero")})
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.FdividedTruncated"}), @SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.Fdivided"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal")
    @NonNull
    public Decimal dividedTruncated(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal var1, @Name(value="rounding") @Defaulted @TypeInfo(value="ceylon.decimal::Rounding?") @Nullable Rounding var2);

    @Ignore
    public Decimal remainderRounded(Decimal var1);

    @Ignore
    public Rounding remainderRounded$rounding(Decimal var1);

    @DocAnnotation$annotation$(description="The Decimal remainder after the division of this `Decimal` \nby the given `Decimal`, that is:\n\n    `this - this.dividedTruncated(other, rounding) * other\n\n This is not equivalent to the `%` operator (`Decimal` does \n not satisfy `Integral`), and the result may be negative.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language::CException", when="The integer part of the quotient requires more \nthan the given precision."), @ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language::CException", when="The given divisor is zero")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal")
    @NonNull
    public Decimal remainderRounded(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal var1, @Name(value="rounding") @Defaulted @TypeInfo(value="ceylon.decimal::Rounding?") @Nullable Rounding var2);

    @Ignore
    public DividedWithRemainder dividedAndRemainder(Decimal var1);

    @Ignore
    public Rounding dividedAndRemainder$rounding(Decimal var1);

    @DocAnnotation$annotation$(description="A pair containing the same results as calling \n`dividedTruncated()` and `remainderRounded()` with the given \narguments, except the division is only performed once.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language::CException", when="The given divisor is zero")})
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.FdividedTruncated", "::1.3.3:ceylon.decimal::IDecimal.FremainderRounded"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::DividedWithRemainder")
    @NonNull
    public DividedWithRemainder dividedAndRemainder(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal var1, @Name(value="rounding") @Defaulted @TypeInfo(value="ceylon.decimal::Rounding?") @Nullable Rounding var2);

    @DocAnnotation$annotation$(description="The precision of this decimal. This is the number of digits \nin the unscaled value.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.Vscale"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    public long getPrecision();

    @DocAnnotation$annotation$(description="The scale of this decimal. This is the number of digits to \nthe right of the decimal point (for a positive scale) or \nthe power of ten by which the unscaled value is multiplied \n(for a negative scale).")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.Vunscaled"}), @SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.Vprecision"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    public long getScale();

    @DocAnnotation$annotation$(description="The unscaled value of this `Decimal`.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.Vscale"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.whole::Whole")
    @NonNull
    public Whole getUnscaled();

    @DocAnnotation$annotation$(description="This value rounded according to the given context.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal")
    @NonNull
    public Decimal round(@Name(value="rounding") @TypeInfo(value="ceylon.decimal::Rounding") @NonNull Rounding var1);

    @DocAnnotation$annotation$(description="The number, represented as a `Whole`, after truncation of \nany fractional part.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.whole::IWhole"}), @SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal.Vinteger"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.whole::Whole")
    @NonNull
    public Whole getWhole();

    @DocAnnotation$annotation$(description="The number, represented as an [[Integer]]. If the number is too \nbig to fit in an Integer then an Integer corresponding to the\nlower order bits is returned.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    public long getInteger();

    @DocAnnotation$annotation$(description="The number, represented as a [[Float]]. If the magnitude of this number \nis too large the result will be `infinity` or `-infinity`. If the result\nis finite, precision may still be lost.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    public double getFloat();
}

