/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk;

import com.alibaba.fastjson.JSON;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.stub.StreamObserver;
import java.security.cert.CertificateEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.chainmaker.pb.accesscontrol.MemberOuterClass;
import org.chainmaker.pb.accesscontrol.PolicyOuterClass;
import org.chainmaker.pb.common.ChainmakerBlock;
import org.chainmaker.pb.common.ChainmakerTransaction;
import org.chainmaker.pb.common.ContractOuterClass;
import org.chainmaker.pb.common.Request;
import org.chainmaker.pb.common.ResultOuterClass;
import org.chainmaker.pb.config.ChainConfigOuterClass;
import org.chainmaker.pb.config.ChainmakerServer;
import org.chainmaker.pb.config.LocalConfig;
import org.chainmaker.pb.discovery.Discovery;
import org.chainmaker.pb.store.Store;
import org.chainmaker.pb.syscontract.AccountManager;
import org.chainmaker.pb.syscontract.Archive;
import org.chainmaker.pb.syscontract.CertManage;
import org.chainmaker.pb.syscontract.ChainConfig;
import org.chainmaker.pb.syscontract.ChainQuery;
import org.chainmaker.pb.syscontract.ContractManage;
import org.chainmaker.pb.syscontract.MultiSign;
import org.chainmaker.pb.syscontract.PubkeyManage;
import org.chainmaker.pb.syscontract.Subscribe;
import org.chainmaker.pb.syscontract.SystemContractOuterClass;
import org.chainmaker.sdk.ChainClientException;
import org.chainmaker.sdk.ConnectionPool;
import org.chainmaker.sdk.RpcServiceClient;
import org.chainmaker.sdk.User;
import org.chainmaker.sdk.config.ArchiveConfig;
import org.chainmaker.sdk.config.AuthType;
import org.chainmaker.sdk.crypto.ChainMakerCryptoSuiteException;
import org.chainmaker.sdk.utils.Utils;
import org.chainmaker.sdk.utils.UtilsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainClient {
    private String chainId;
    private ConnectionPool connectionPool;
    private ArchiveConfig archiveConfig;
    private User clientUser;
    private boolean isEnabledCertHash;
    private boolean isEnabledAlias;
    private static final String TX_ID = "txId";
    private static final String ORG_ID = "org_id";
    private static final String MEMBER_INFO = "member_info";
    private static final String NODE_ID = "node_id";
    private static final String ROLE = "role";
    private static final String NODE_IDS = "node_ids";
    private static final String BLOCK_HEIGHT = "blockHeight";
    private static final String BLOCK_HASH = "blockHash";
    private static final String WITH_RW_SET = "withRWSet";
    private static final long DEFAULT_RPC_TIMEOUT = 10000L;
    private static final long DEFAULT_SYNC_RESULT_TIMEOUT = 10000L;
    private static final String DRIVER_NAME = "com.mysql.cj.jdbc.Driver";
    private static final String MYSQL_DBNAME_PREFIX = "cm_archived_chain";
    private static final String MYSQL_TABLENAME_PREFIX = "t_block_info";
    private static final long ROWS_PREBLOCKINFO_TABLE = 100000L;
    private static final long DEFAULT_SEQ = 0L;
    private static final int SUCCESS = 0;
    private static final String KEYCERTHASHS = "cert_hashes";
    private static final String KEYCERTS = "certs";
    private static final String KEYCERTCRL = "cert_crl";
    private static final String KEY_PUBKEY = "pubkey";
    private static final String KEY_PUBKEY_ROLE = "role";
    private static final String KEY_PUBKEY_ORG_ID = "org_id";
    private static final String KEY_ALIAS = "alias";
    private static final String KEY_ALIASES = "aliases";
    private static final String KEY_CERT = "cert";
    private static final Logger logger = LoggerFactory.getLogger(ChainClient.class);
    private static final String KEY_GASPUBLIC = "public_key";
    private static final String KEY_GASADDRESSKEY = "address_key";
    private static final String Key_GASBATCHRECHARGE = "batch_recharge";
    private static final String Key_GASBALANCEPUBLICKEY = "balance_public_key";
    private static final String Key_GASCHARGEPUBLICKEY = "charge_public_key";
    private static final String Key_GASCHARGEGASAMOUNT = "charge_gas_amount";
    private static final String Key_GASFROZENPUBLICKEY = "frozen_public_key";

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public void setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public ArchiveConfig getArchiveConfig() {
        return this.archiveConfig;
    }

    public void setArchiveConfig(ArchiveConfig archiveConfig) {
        this.archiveConfig = archiveConfig;
    }

    public User getClientUser() {
        return this.clientUser;
    }

    public void setClientUser(User clientUser) {
        this.clientUser = clientUser;
    }

    public synchronized boolean enableAlias() throws ChainMakerCryptoSuiteException, ChainClientException {
        if (this.isEnabledAlias) {
            return true;
        }
        if (!this.clientUser.getAuthType().equals(AuthType.PermissionedWithCert.getMsg())) {
            throw new ChainClientException("cert alias is not supported");
        }
        ResultOuterClass.TxResponse response = this.addAlias(10000L);
        this.checkProposalRequestResp(response, false);
        for (int i = 0; i < 10; ++i) {
            if (!this.getCheckAlias()) continue;
            this.isEnabledAlias = true;
            return true;
        }
        return false;
    }

    public synchronized boolean enableCertHash() throws ChainMakerCryptoSuiteException, ChainClientException {
        if (this.isEnabledAlias) {
            return true;
        }
        if (!this.clientUser.getAuthType().equals(AuthType.PermissionedWithCert.getMsg())) {
            throw new ChainClientException("cert hash is not supported");
        }
        if (this.isEnabledCertHash) {
            return true;
        }
        if (this.clientUser.getCertHash() == null || this.clientUser.getCertHash().length == 0) {
            ChainConfigOuterClass.ChainConfig chainConfig = this.getChainConfig(10000L);
            if (chainConfig == null) {
                throw new ChainClientException("get chain config from node failed, please try again later");
            }
            this.clientUser.setCertHash(this.getCertificateId(chainConfig.getCrypto().getHash()));
            if (this.clientUser.getCertHash() == null || this.clientUser.getCertHash().length == 0) {
                throw new ChainClientException("get certificate id failed");
            }
        }
        if (this.checkCertHashOnChain()) {
            this.isEnabledCertHash = true;
            return true;
        }
        ResultOuterClass.TxResponse responseInfo = this.addCert(10000L);
        if (responseInfo == null || responseInfo.getCode() != ResultOuterClass.TxStatusCode.SUCCESS || responseInfo.getContractResult().getCode() != 0) {
            throw new ChainClientException("add cert failed");
        }
        for (int i = 0; i < 10; ++i) {
            if (!this.checkCertHashOnChain()) continue;
            this.isEnabledCertHash = true;
            return true;
        }
        return false;
    }

    public synchronized void disableCertHash() {
        this.isEnabledCertHash = false;
    }

    private byte[] getCertHash() throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainConfigOuterClass.ChainConfig chainConfig = this.getChainConfig(10000L);
        return this.getCertificateId(chainConfig.getCrypto().getHash());
    }

    private byte[] getCertificateId(String hashType) throws ChainMakerCryptoSuiteException {
        byte[] encodedCert;
        if (this.clientUser.getCertBytes() == null || this.clientUser.getCertBytes().length == 0) {
            return new byte[0];
        }
        try {
            encodedCert = this.clientUser.getCertificate().getEncoded();
        }
        catch (CertificateEncodingException e) {
            logger.error("encoded cert err : ", (Throwable)e);
            throw new ChainMakerCryptoSuiteException("encoded cert err : " + e.getMessage());
        }
        if (encodedCert == null || encodedCert.length == 0) {
            return new byte[0];
        }
        Digest digest = this.getHashDigest(hashType);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.update(encodedCert, 0, encodedCert.length);
        digest.doFinal(hash, 0);
        return hash;
    }

    private Digest getHashDigest(String hashAlgorithm) {
        if ("SHA3".equals(hashAlgorithm)) {
            return new SHA3Digest();
        }
        if ("SM3".equals(hashAlgorithm)) {
            return new SM3Digest();
        }
        return new SHA256Digest();
    }

    private boolean checkCertHashOnChain() throws ChainClientException, ChainMakerCryptoSuiteException {
        byte[] certHash = this.clientUser.getCertHash();
        if (certHash == null || certHash.length == 0) {
            return false;
        }
        ResultOuterClass.CertInfos certInfos = this.queryCert(new String[]{ByteUtils.toHexString((byte[])certHash)}, 10000L);
        if (certInfos == null) {
            throw new ChainClientException("get cert infos failed");
        }
        if (certInfos.getCertInfosList().size() != 1 || certInfos.getCertInfos(0).getCert().isEmpty()) {
            return false;
        }
        return certInfos.getCertInfos(0).getHash().equals(ByteUtils.toHexString((byte[])certHash));
    }

    private boolean getCheckAlias() throws ChainClientException, ChainMakerCryptoSuiteException {
        ResultOuterClass.AliasInfos aliasInfos = this.queryAlias(new String[]{this.clientUser.getAlias()}, 10000L);
        if (aliasInfos == null) {
            throw new ChainClientException("get alias infos failed");
        }
        return aliasInfos.getAliasInfos(0).getAlias().equals(this.clientUser.getAlias());
    }

    public Request.Payload createContractCreatePayload(String contractName, String version, byte[] byteCode, ContractOuterClass.RuntimeType runtime, Map<String, byte[]> params) throws ChainMakerCryptoSuiteException {
        return this.createContractManageWithByteCodePayload(contractName, ContractManage.ContractManageFunction.INIT_CONTRACT.toString(), version, byteCode, runtime, params);
    }

    public Request.Payload createContractUpgradePayload(String contractName, String version, byte[] byteCode, ContractOuterClass.RuntimeType runtime, Map<String, byte[]> params) throws ChainMakerCryptoSuiteException {
        return this.createContractManageWithByteCodePayload(contractName, ContractManage.ContractManageFunction.UPGRADE_CONTRACT.toString(), version, byteCode, runtime, params);
    }

    public Request.Payload createContractFreezePayload(String contractName) throws ChainMakerCryptoSuiteException {
        return this.createContractManagePayload(contractName, ContractManage.ContractManageFunction.FREEZE_CONTRACT.toString());
    }

    public Request.Payload createContractUnFreezePayload(String contractName) throws ChainMakerCryptoSuiteException {
        return this.createContractManagePayload(contractName, ContractManage.ContractManageFunction.UNFREEZE_CONTRACT.toString());
    }

    public Request.Payload createContractRevokePayload(String contractName) throws ChainMakerCryptoSuiteException {
        return this.createContractManagePayload(contractName, ContractManage.ContractManageFunction.REVOKE_CONTRACT.toString());
    }

    public ResultOuterClass.TxResponse sendContractManageRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse invokeContract(String contractName, String method, String txId, Map<String, byte[]> params, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Request.Payload payload = this.createPayload(txId, Request.TxType.INVOKE_CONTRACT, contractName, method, params, 0L);
        return this.sendContractRequest(payload, null, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse queryContract(String contractName, String method, String txId, Map<String, byte[]> params, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Request.Payload payload = this.createPayload(txId, Request.TxType.QUERY_CONTRACT, contractName, method, params, 0L);
        return this.sendContractRequest(payload, null, rpcCallTimeout, -1L);
    }

    public ChainmakerTransaction.TransactionInfo getTxByTxId(String txId, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainmakerTransaction.TransactionInfo transactionInfo;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(TX_ID, txId.getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_TX_BY_TX_ID.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        try {
            transactionInfo = ChainmakerTransaction.TransactionInfo.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("transactionInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("transactionInfo parseFrom result : " + e.getMessage());
        }
        return transactionInfo;
    }

    public ChainmakerTransaction.TransactionInfoWithRWSet getTxWithRWSetByTxId(String txId, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainmakerTransaction.TransactionInfoWithRWSet transactionInfoWithRWSet;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(TX_ID, txId.getBytes());
        params.put(WITH_RW_SET, String.valueOf(true).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_TX_BY_TX_ID.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            transactionInfoWithRWSet = ChainmakerTransaction.TransactionInfoWithRWSet.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("transactionInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("transactionInfo parseFrom result : " + e.getMessage());
        }
        return transactionInfoWithRWSet;
    }

    public ChainmakerBlock.BlockInfo getBlockByHeight(long blockHeight, boolean withRWSet, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainmakerBlock.BlockInfo blockInfo;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(BLOCK_HEIGHT, String.valueOf(blockHeight).getBytes());
        params.put(WITH_RW_SET, String.valueOf(withRWSet).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_BLOCK_BY_HEIGHT.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            blockInfo = ChainmakerBlock.BlockInfo.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("blockInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("blockInfo parseFrom result : " + e.getMessage());
        }
        return blockInfo;
    }

    public ChainmakerBlock.BlockInfo getBlockByHash(String blockHash, boolean withRWSet, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainmakerBlock.BlockInfo blockInfo;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(BLOCK_HASH, blockHash.getBytes());
        params.put(WITH_RW_SET, String.valueOf(withRWSet).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_BLOCK_BY_HASH.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            blockInfo = ChainmakerBlock.BlockInfo.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("blockInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("blockInfo parseFrom result : " + e.getMessage());
        }
        return blockInfo;
    }

    public ChainmakerBlock.BlockInfo getBlockByTxId(String txId, boolean withRWSet, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainmakerBlock.BlockInfo blockInfo;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(TX_ID, txId.getBytes());
        params.put(WITH_RW_SET, String.valueOf(withRWSet).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_BLOCK_BY_TX_ID.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            blockInfo = ChainmakerBlock.BlockInfo.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("blockInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("blockInfo parseFrom result : " + e.getMessage());
        }
        return blockInfo;
    }

    public ChainmakerBlock.BlockInfo getLastConfigBlock(boolean withRWSet, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainmakerBlock.BlockInfo blockInfo;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(WITH_RW_SET, Boolean.toString(withRWSet).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_LAST_CONFIG_BLOCK.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            blockInfo = ChainmakerBlock.BlockInfo.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("blockInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("blockInfo parseFrom result : " + e.getMessage());
        }
        return blockInfo;
    }

    public Discovery.ChainList getNodeChainList(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Discovery.ChainList chainList;
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_NODE_CHAIN_LIST.toString(), null, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            chainList = Discovery.ChainList.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("chainList parseFrom result : ", (Throwable)e);
            throw new ChainClientException("chainList parseFrom result : " + e.getMessage());
        }
        return chainList;
    }

    public Discovery.ChainInfo getChainInfo(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Discovery.ChainInfo chainInfo;
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_CHAIN_INFO.toString(), null, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            chainInfo = Discovery.ChainInfo.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("chainInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("chainInfo parseFrom result : " + e.getMessage());
        }
        return chainInfo;
    }

    public long getBlockHeightByTxId(String txId, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.getBlockHeight(txId, null, rpcCallTimeout);
    }

    public long getBlockHeightByBlockHash(String blockHash, long timeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.getBlockHeight("", blockHash, timeout);
    }

    public Store.BlockWithRWSet getFullBlockByHeight(long blockHeight, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        Store.BlockWithRWSet blockWithRWSet;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(BLOCK_HEIGHT, String.valueOf(blockHeight).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_FULL_BLOCK_BY_HEIGHT.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            blockWithRWSet = Store.BlockWithRWSet.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("blockWithRWSet parseFrom result : ", (Throwable)e);
            throw new ChainClientException("blockWithRWSet parseFrom result : " + e.getMessage());
        }
        return blockWithRWSet;
    }

    public ChainmakerBlock.BlockInfo getLastBlock(boolean withRWSet, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        ChainmakerBlock.BlockInfo blockInfo;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(WITH_RW_SET, Boolean.toString(withRWSet).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_LAST_BLOCK.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            blockInfo = ChainmakerBlock.BlockInfo.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("blockInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("blockInfo parseFrom result : " + e.getMessage());
        }
        return blockInfo;
    }

    public long getCurrentBlockHeight(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainmakerBlock.BlockInfo blockInfo = this.getLastBlock(false, rpcCallTimeout);
        return blockInfo.getBlock().getHeader().getBlockHeight();
    }

    public ChainmakerBlock.BlockHeader getBlockHeaderByHeight(long blockHeight, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        ChainmakerBlock.BlockHeader blockHeader;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(BLOCK_HEIGHT, Long.toString(blockHeight).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_BLOCK_HEADER_BY_HEIGHT.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            blockHeader = ChainmakerBlock.BlockHeader.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("blockHeader parseFrom result : ", (Throwable)e);
            throw new ChainClientException("blockHeader parseFrom result : " + e.getMessage());
        }
        return blockHeader;
    }

    public ResultOuterClass.TxResponse invokeSystemContract(String contractName, String method, String txId, Map<String, byte[]> params, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Request.Payload payload = this.createPayload(txId, Request.TxType.INVOKE_CONTRACT, contractName, method, params, 0L);
        return this.sendContractRequest(payload, null, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse querySystemContract(String contractName, String method, String txId, Map<String, byte[]> params, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Request.Payload payload = this.createPayload(txId, Request.TxType.QUERY_CONTRACT, contractName, method, params, 0L);
        return this.sendContractRequest(payload, null, rpcCallTimeout, -1L);
    }

    public byte[] getMerklePathByTxId(String txId, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(TX_ID, txId.getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), ChainQuery.ChainQueryFunction.GET_MERKLE_PATH_BY_TX_ID.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        return txResponse.getContractResult().getResult().toByteArray();
    }

    public Request.Payload createNativeContractAccessGrantPayload(String[] grantContractList) throws ChainMakerCryptoSuiteException {
        return this.createNativeContractAccessPayload(ContractManage.ContractManageFunction.GRANT_CONTRACT_ACCESS.toString(), grantContractList);
    }

    public Request.Payload createNativeContractAccessRevokePayload(String[] revokeContractList) throws ChainMakerCryptoSuiteException {
        return this.createNativeContractAccessPayload(ContractManage.ContractManageFunction.REVOKE_CONTRACT_ACCESS.toString(), revokeContractList);
    }

    public Request.Payload createGetDisabledNativeContractListPayload() throws ChainMakerCryptoSuiteException {
        return this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CONTRACT_MANAGE.toString(), ContractManage.ContractQueryFunction.GET_DISABLED_CONTRACT_LIST.toString(), null, 0L);
    }

    public String getContractInfo(String contractName, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(ContractManage.GetContractInfo.Parameter.CONTRACT_NAME.toString(), contractName.getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CONTRACT_MANAGE.toString(), ContractManage.ContractQueryFunction.GET_CONTRACT_INFO.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        return txResponse.getContractResult().getResult().toStringUtf8();
    }

    public String getContractList(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CONTRACT_MANAGE.toString(), ContractManage.ContractQueryFunction.GET_CONTRACT_LIST.toString(), null, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        return txResponse.getContractResult().getResult().toStringUtf8();
    }

    public String getDisabledNativeContractList(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CONTRACT_MANAGE.toString(), ContractManage.ContractQueryFunction.GET_DISABLED_CONTRACT_LIST.toString(), null, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        return txResponse.getContractResult().getResult().toStringUtf8();
    }

    public ChainConfigOuterClass.ChainConfig getChainConfig(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainConfigOuterClass.ChainConfig chainConfig;
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.GET_CHAIN_CONFIG.toString(), null, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            chainConfig = ChainConfigOuterClass.ChainConfig.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("chainConfig parseFrom result : ", (Throwable)e);
            throw new ChainClientException("chainConfig parseFrom result : " + e.getMessage());
        }
        return chainConfig;
    }

    public ChainConfigOuterClass.ChainConfig getChainConfigByBlockHeight(long blockHeight, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainConfigOuterClass.ChainConfig chainConfig;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("block_height", String.valueOf(blockHeight).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.GET_CHAIN_CONFIG_AT.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            chainConfig = ChainConfigOuterClass.ChainConfig.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("ChainConfig parseFrom result : ", (Throwable)e);
            throw new ChainClientException("ChainConfig parseFrom result : " + e.getMessage());
        }
        return chainConfig;
    }

    public long getChainConfigSequence(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ChainConfigOuterClass.ChainConfig chainConfig = this.getChainConfig(rpcCallTimeout);
        return chainConfig.getSequence();
    }

    public Request.Payload createPayloadOfChainConfigCoreUpdate(int txSchedulerTimeout, int txSchedulerValidateTimeout, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        if (txSchedulerTimeout > 60 || txSchedulerValidateTimeout > 60) {
            throw new ChainClientException("invalid txSchedulerTimeout or txSchedulerValidateTimeout");
        }
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        if (txSchedulerTimeout > 0) {
            params.put("tx_scheduler_timeout", String.valueOf(txSchedulerTimeout).getBytes());
        }
        if (txSchedulerValidateTimeout > 0) {
            params.put("tx_scheduler_validate_timeout", String.valueOf(txSchedulerTimeout).getBytes());
        }
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.CORE_UPDATE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigBlockUpdate(boolean txTimestampVerify, int txTimeout, int blockTxCapacity, int blockSize, int blockInterval, int txParamterSize, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        if (txTimeout < 600 || blockTxCapacity < 1 || blockSize < 1 || blockInterval < 10) {
            throw new ChainClientException("invalid parameters");
        }
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("tx_timestamp_verify", String.valueOf(txTimestampVerify).getBytes());
        params.put("tx_timeout", String.valueOf(txTimeout).getBytes());
        params.put("block_tx_capacity", String.valueOf(blockTxCapacity).getBytes());
        params.put("block_size", String.valueOf(blockSize).getBytes());
        params.put("block_interval", String.valueOf(blockInterval).getBytes());
        params.put("tx_parameter_size", String.valueOf(txParamterSize).getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.BLOCK_UPDATE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigTrustRootAdd(String trustRootOrgId, String[] trustRootCrt, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", trustRootOrgId.getBytes());
        if (trustRootCrt.length > 0) {
            params.put("root", Utils.joinList(trustRootCrt).getBytes());
        }
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.TRUST_ROOT_ADD.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigTrustRootUpdate(String trustRootOrgId, String[] trustRootCrt, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", trustRootOrgId.getBytes());
        if (trustRootCrt.length > 0) {
            params.put("root", Utils.joinList(trustRootCrt).getBytes());
        }
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.TRUST_ROOT_UPDATE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigTrustRootDelete(String trustRootOrgId, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", trustRootOrgId.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.TRUST_ROOT_DELETE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigPermissionAdd(String permissionResourceName, PolicyOuterClass.Policy principal, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(permissionResourceName, principal.toByteArray());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.PERMISSION_ADD.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigPermissionUpdate(String permissionResourceName, PolicyOuterClass.Policy principal, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(permissionResourceName, principal.toByteArray());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.PERMISSION_UPDATE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigPermissionDelete(String permissionResourceName, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(permissionResourceName, "".getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.PERMISSION_DELETE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusNodeAddrAdd(String nodeOrgId, String[] nodeAddresses, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", nodeOrgId.getBytes());
        if (nodeAddresses.length > 0) {
            params.put(NODE_IDS, Utils.joinList(nodeAddresses).getBytes());
        }
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.NODE_ID_ADD.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusNodeAddrUpdate(String nodeOrgId, String nodeOldAddress, String nodeNewAddress, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", nodeOrgId.getBytes());
        params.put(NODE_ID, nodeOldAddress.getBytes());
        params.put("new_node_id", nodeNewAddress.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.NODE_ID_UPDATE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusNodeAddrDelete(String nodeOrgId, String nodeAddress, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", nodeOrgId.getBytes());
        params.put(NODE_ID, nodeAddress.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.NODE_ID_DELETE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusNodeOrgAdd(String nodeOrgId, String[] nodeAddresses, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", nodeOrgId.getBytes());
        if (nodeAddresses.length > 0) {
            params.put(NODE_IDS, Utils.joinList(nodeAddresses).getBytes());
        }
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.NODE_ORG_ADD.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusNodeOrgUpdate(String nodeOrgId, String[] nodeAddresses, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", nodeOrgId.getBytes());
        if (nodeAddresses.length > 0) {
            params.put(NODE_IDS, Utils.joinList(nodeAddresses).getBytes());
        }
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.NODE_ORG_UPDATE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusNodeOrgDelete(String nodeOrgId, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", nodeOrgId.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.NODE_ORG_DELETE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusExtAdd(Map<String, byte[]> params, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.CONSENSUS_EXT_ADD.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusExtUpdate(Map<String, byte[]> params, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.CONSENSUS_EXT_UPDATE.toString(), params, sequence + 1L);
    }

    public Request.Payload createPayloadOfChainConfigConsensusExtDelete(String[] keys, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        if (keys.length > 0) {
            for (String key : keys) {
                params.put(key, "".getBytes());
            }
        }
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.CONSENSUS_EXT_DELETE.toString(), params, sequence + 1L);
    }

    public Request.Payload createChainConfigTrustMemberAddPayload(String trustMemberOrgId, String trustMemberNodeId, String trustMemberRole, String trustMemberInfo, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("org_id", trustMemberOrgId.getBytes());
        params.put(MEMBER_INFO, trustMemberInfo.getBytes());
        params.put(NODE_ID, trustMemberNodeId.getBytes());
        params.put("role", trustMemberRole.getBytes());
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.TRUST_MEMBER_ADD.toString(), params, sequence + 1L);
    }

    public Request.Payload createChainConfigTrustMemberAddPayload(String trustMemberInfo, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(MEMBER_INFO, trustMemberInfo.getBytes());
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.TRUST_MEMBER_DELETE.toString(), params, sequence + 1L);
    }

    public ResultOuterClass.TxResponse updateChainConfig(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse addCert(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        byte[] certHash = this.getCertHash();
        Request.Payload payload = this.createCertManagePayload(CertManage.CertManageFunction.CERT_ADD.toString(), null);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, false);
        ResultOuterClass.TxResponse.Builder txResponseBuilder = txResponse.toBuilder();
        txResponseBuilder.setContractResult(ResultOuterClass.ContractResult.newBuilder().setResult(ByteString.copyFrom((byte[])certHash)));
        return txResponseBuilder.build();
    }

    public ResultOuterClass.TxResponse deleteCert(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.CertInfos queryCert(String[] certHashes, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ResultOuterClass.CertInfos certInfos;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        if (certHashes.length > 0) {
            params.put(KEYCERTHASHS, Utils.joinList(certHashes).getBytes());
        }
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CERT_MANAGE.toString(), CertManage.CertManageFunction.CERTS_QUERY.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        try {
            certInfos = ResultOuterClass.CertInfos.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("certInfos parseFrom result : ", (Throwable)e);
            throw new ChainClientException("certInfos parseFrom result : " + e.getMessage());
        }
        return certInfos;
    }

    public ResultOuterClass.TxResponse freezeCerts(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse unfreezeCerts(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse revokeCerts(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public Request.Payload createCertManagePayload(String method, Map<String, byte[]> params) throws ChainMakerCryptoSuiteException {
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CERT_MANAGE.toString(), method, params, 0L);
    }

    public Request.Payload createCertDeletePayload(String[] certHashes) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        if (certHashes.length > 0) {
            params.put(KEYCERTHASHS, Utils.joinList(certHashes).getBytes());
        }
        return this.createCertManagePayload(CertManage.CertManageFunction.CERTS_DELETE.toString(), params);
    }

    public Request.Payload createCertFreezePayload(String[] certHashes) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        if (certHashes.length > 0) {
            params.put(KEYCERTS, Utils.joinList(certHashes).getBytes());
        }
        return this.createCertManagePayload(CertManage.CertManageFunction.CERTS_FREEZE.toString(), params);
    }

    public Request.Payload createPayloadOfUnfreezeCerts(String[] certHashes) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        if (certHashes.length > 0) {
            params.put(KEYCERTS, Utils.joinList(certHashes).getBytes());
        }
        return this.createCertManagePayload(CertManage.CertManageFunction.CERTS_UNFREEZE.toString(), params);
    }

    public Request.Payload createPayloadOfRevokeCerts(String certCrl) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEYCERTCRL, certCrl.getBytes());
        return this.createCertManagePayload(CertManage.CertManageFunction.CERTS_REVOKE.toString(), params);
    }

    public void subscribeBlock(long startBlock, long endBlock, boolean withRwSet, boolean onlyHeader, StreamObserver<ResultOuterClass.SubscribeResult> blockStreamObserver) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Subscribe.SubscribeBlock.Parameter.START_BLOCK.toString(), Utils.longToByteLittleEndian(startBlock));
        params.put(Subscribe.SubscribeBlock.Parameter.END_BLOCK.toString(), Utils.longToByteLittleEndian(endBlock));
        params.put(Subscribe.SubscribeBlock.Parameter.WITH_RWSET.toString(), String.valueOf(withRwSet).getBytes());
        params.put(Subscribe.SubscribeBlock.Parameter.ONLY_HEADER.toString(), String.valueOf(onlyHeader).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.SUBSCRIBE, SystemContractOuterClass.SystemContract.SUBSCRIBE_MANAGE.toString(), Subscribe.SubscribeFunction.SUBSCRIBE_BLOCK.toString(), params, 0L);
        this.subscribe(payload, blockStreamObserver);
    }

    public void subscribeTx(long startBlock, long endBlock, String contractName, String[] txIds, StreamObserver<ResultOuterClass.SubscribeResult> txStreamObserver) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Subscribe.SubscribeTx.Parameter.START_BLOCK.toString(), Utils.longToByteLittleEndian(startBlock));
        params.put(Subscribe.SubscribeTx.Parameter.END_BLOCK.toString(), Utils.longToByteLittleEndian(endBlock));
        params.put(Subscribe.SubscribeTx.Parameter.CONTRACT_NAME.toString(), contractName.getBytes());
        if (txIds.length > 0) {
            params.put(Subscribe.SubscribeTx.Parameter.TX_IDS.toString(), Utils.joinList(txIds).getBytes());
        }
        Request.Payload payload = this.createPayload("", Request.TxType.SUBSCRIBE, SystemContractOuterClass.SystemContract.SUBSCRIBE_MANAGE.toString(), Subscribe.SubscribeFunction.SUBSCRIBE_TX.toString(), params, 0L);
        this.subscribe(payload, txStreamObserver);
    }

    public void subscribeContractEvent(long startBlock, long endBlock, String topic, String contractName, StreamObserver<ResultOuterClass.SubscribeResult> contractEventStreamObserver) throws ChainClientException, ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Subscribe.SubscribeContractEvent.Parameter.START_BLOCK.toString(), Utils.longToByteLittleEndian(startBlock));
        params.put(Subscribe.SubscribeContractEvent.Parameter.END_BLOCK.toString(), Utils.longToByteLittleEndian(endBlock));
        params.put(Subscribe.SubscribeContractEvent.Parameter.TOPIC.toString(), topic.getBytes());
        params.put(Subscribe.SubscribeContractEvent.Parameter.CONTRACT_NAME.toString(), contractName.getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.SUBSCRIBE, SystemContractOuterClass.SystemContract.SUBSCRIBE_MANAGE.toString(), Subscribe.SubscribeFunction.SUBSCRIBE_CONTRACT_EVENT.toString(), params, 0L);
        this.subscribe(payload, contractEventStreamObserver);
    }

    public ResultOuterClass.TxResponse sendArchiveBlockRequest(Request.Payload payload, long timeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendRequest(payload, null, timeout);
    }

    public ResultOuterClass.TxResponse sendRestoreBlockRequest(Request.Payload payload, long timeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendRequest(payload, null, timeout);
    }

    public Request.Payload createArchiveBlockPayload(long targetBlockHeight) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Archive.ArchiveBlock.Parameter.BLOCK_HEIGHT.toString(), Utils.longToByteLittleEndian(targetBlockHeight));
        return this.createPayload("", Request.TxType.ARCHIVE, SystemContractOuterClass.SystemContract.ARCHIVE_MANAGE.toString(), Archive.ArchiveFunction.ARCHIVE_BLOCK.toString(), params, 0L);
    }

    public Request.Payload createRestoreBlockPayload(byte[] fullBlock) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Archive.RestoreBlock.Parameter.FULL_BLOCK.toString(), fullBlock);
        return this.createPayload("", Request.TxType.ARCHIVE, SystemContractOuterClass.SystemContract.ARCHIVE_MANAGE.toString(), Archive.ArchiveFunction.RESTORE_BLOCK.toString(), params, 0L);
    }

    public Store.BlockWithRWSet getArchivedFullBlockByHeight(long blockHeight) throws ChainClientException {
        return this.getFromArchiveStore(blockHeight);
    }

    public ChainmakerBlock.BlockInfo getArchivedBlockByHeight(long blockHeight, boolean withRWSet) throws ChainClientException {
        Store.BlockWithRWSet fullBlock = this.getFromArchiveStore(blockHeight);
        ChainmakerBlock.BlockInfo blockInfo = ChainmakerBlock.BlockInfo.newBuilder().setBlock(fullBlock.getBlock()).build();
        ChainmakerBlock.BlockInfo.Builder blockInfoBuilder = blockInfo.toBuilder();
        if (withRWSet) {
            blockInfoBuilder.addAllRwsetList(blockInfo.getRwsetListList());
        }
        return blockInfoBuilder.build();
    }

    public Request.Payload createPubkeyAddPayload(String pubkey, String orgId, String role) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_PUBKEY, pubkey.getBytes());
        params.put("org_id", orgId.getBytes());
        params.put("role", role.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.PUBKEY_MANAGE.toString(), PubkeyManage.PubkeyManageFunction.PUBKEY_ADD.toString(), params, 0L);
    }

    public Request.Payload createPubkeyDelPayload(String pubkey, String orgId) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_PUBKEY, pubkey.getBytes());
        params.put("org_id", orgId.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.PUBKEY_MANAGE.toString(), PubkeyManage.PubkeyManageFunction.PUBKEY_DELETE.toString(), params, 0L);
    }

    public Request.Payload createPubkeyQueryPayload(String pubkey) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_PUBKEY, pubkey.getBytes());
        return this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.PUBKEY_MANAGE.toString(), PubkeyManage.PubkeyManageFunction.PUBKEY_QUERY.toString(), params, 0L);
    }

    public ResultOuterClass.TxResponse sendPubkeyManageRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public ResultOuterClass.TxResponse multiSignContractReq(Request.Payload payload, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        return this.proposalRequest(payload, null, rpcCallTimeout);
    }

    public ResultOuterClass.TxResponse multiSignContractVote(Request.Payload payload, Request.EndorsementEntry endorsementEntry, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        MultiSign.MultiSignVoteInfo.Builder multiSignVoteInfoBuilder = MultiSign.MultiSignVoteInfo.newBuilder();
        multiSignVoteInfoBuilder.setEndorsement(endorsementEntry);
        multiSignVoteInfoBuilder.setVote(MultiSign.VoteStatus.AGREE);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(MultiSign.MultiVote.Parameter.VOTE_INFO.toString(), multiSignVoteInfoBuilder.build().toByteArray());
        params.put(MultiSign.MultiVote.Parameter.TX_ID.toString(), payload.getTxId().getBytes());
        Request.Payload multiSignVotePayload = this.createMultiSignVotePayload(params);
        return this.proposalRequest(multiSignVotePayload, null, rpcCallTimeout);
    }

    public ResultOuterClass.TxResponse multiSignContractQuery(String txId, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(MultiSign.MultiVote.Parameter.TX_ID.toString(), txId.getBytes());
        Request.Payload payload = this.createMultiSignQueryPayload(params);
        return this.proposalRequest(payload, null, rpcCallTimeout);
    }

    public Request.Payload createMultiSignReqPayload(Map<String, byte[]> params) throws ChainMakerCryptoSuiteException {
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.MULTI_SIGN.toString(), MultiSign.MultiSignFunction.REQ.toString(), params, 0L);
    }

    public Request.Payload createMultiSignVotePayload(Map<String, byte[]> params) throws ChainMakerCryptoSuiteException {
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.MULTI_SIGN.toString(), MultiSign.MultiSignFunction.VOTE.toString(), params, 0L);
    }

    public Request.Payload createMultiSignQueryPayload(Map<String, byte[]> params) throws ChainMakerCryptoSuiteException {
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.MULTI_SIGN.toString(), MultiSign.MultiSignFunction.QUERY.toString(), params, 0L);
    }

    public void stop() {
        this.connectionPool.stop();
    }

    public String getChainMakerServerVersion(long timeout) throws ChainClientException {
        ChainmakerServer.ChainMakerVersionResponse response;
        RpcServiceClient rpcServiceClient = this.connectionPool.getConnection();
        if (rpcServiceClient == null) {
            logger.error("all connections no Idle or Ready");
            throw new ChainClientException("all connections no Idle or Ready, please reSet connection count");
        }
        ChainmakerServer.ChainMakerVersionRequest.Builder chainMakerVersionRequest = ChainmakerServer.ChainMakerVersionRequest.newBuilder();
        try {
            response = (ChainmakerServer.ChainMakerVersionResponse)rpcServiceClient.getRpcNodeFutureStub().getChainMakerVersion(chainMakerVersionRequest.build()).get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.error("connect to peer error : ", (Throwable)e);
            throw new ChainClientException("connect to peer error : " + e.getMessage());
        }
        if (response.getCode() != 0) {
            logger.error("get chain version failed : " + response.getMessage());
            throw new ChainClientException("get chain version failed : " + response.getMessage());
        }
        return response.getVersion();
    }

    public LocalConfig.CheckNewBlockChainConfigResponse checkNewBlockChainConfig(long timeout) throws ChainClientException {
        LocalConfig.CheckNewBlockChainConfigResponse response;
        RpcServiceClient rpcServiceClient = this.connectionPool.getConnection();
        if (rpcServiceClient == null) {
            logger.error("all connections no Idle or Ready");
            throw new ChainClientException("all connections no Idle or Ready, please reSet connection count");
        }
        LocalConfig.CheckNewBlockChainConfigRequest.Builder checkNewBlockChainConfigRequest = LocalConfig.CheckNewBlockChainConfigRequest.newBuilder();
        try {
            response = (LocalConfig.CheckNewBlockChainConfigResponse)rpcServiceClient.getRpcNodeFutureStub().checkNewBlockChainConfig(checkNewBlockChainConfigRequest.build()).get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.error("connect to peer error : ", (Throwable)e);
            throw new ChainClientException("connect to peer error : " + e.getMessage());
        }
        if (response.getCode() != 0) {
            logger.error("check new block chain config failed : " + response.getMessage());
            throw new ChainClientException("check new block chain config failed : " + response.getMessage());
        }
        return response;
    }

    public Request.Payload createSetGasAdminPayload(String address) throws ChainMakerCryptoSuiteException, UtilsException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_GASADDRESSKEY, address.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.SET_ADMIN.toString(), params, 0L);
    }

    public String getGasAdmin(long rpcCallTimeout) throws ChainClientException {
        ResultOuterClass.TxResponse resp;
        try {
            Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.GET_ADMIN.toString(), null, 0L);
            resp = this.proposalRequest(payload, null, rpcCallTimeout);
            this.checkProposalRequestResp(resp, true);
        }
        catch (Exception e) {
            logger.error("[SDK] begin to QUERY system contract, method:", (Throwable)e);
            throw new ChainClientException("Gas Admin error:" + e.getMessage());
        }
        return resp.getContractResult().getResult().toStringUtf8();
    }

    public Request.Payload createRechargeGasPayload(AccountManager.RechargeGas[] rechargeGasList) throws ChainMakerCryptoSuiteException {
        AccountManager.RechargeGasReq.Builder rechargeGasReqBuilder = AccountManager.RechargeGasReq.newBuilder();
        rechargeGasReqBuilder.addAllBatchRechargeGas(Arrays.asList((Object[])rechargeGasList.clone()));
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(Key_GASBATCHRECHARGE, rechargeGasReqBuilder.build().toByteArray());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.RECHARGE_GAS.toString(), params, 0L);
    }

    public long getGasBalance(String address, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException, UtilsException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_GASADDRESSKEY, address.getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.GET_BALANCE.toString(), params, 0L);
        ResultOuterClass.TxResponse resp = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(resp, true);
        return Long.parseLong(resp.getContractResult().getResult().toStringUtf8());
    }

    public Request.Payload createRefundGasPayload(String address, long amount) throws ChainMakerCryptoSuiteException {
        if (amount <= 0L) {
            logger.error("amount must > 0");
        }
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_GASADDRESSKEY, address.getBytes());
        params.put(Key_GASCHARGEGASAMOUNT, String.valueOf(amount).getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.REFUND_GAS.toString(), params, 0L);
    }

    public Request.Payload createFrozenGasAccountPayload(String address) throws ChainMakerCryptoSuiteException, UtilsException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_GASADDRESSKEY, address.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.FROZEN_ACCOUNT.toString(), params, 0L);
    }

    public Request.Payload createUnfrozenGasAccountPayload(String address) throws ChainMakerCryptoSuiteException, UtilsException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_GASADDRESSKEY, address.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.UNFROZEN_ACCOUNT.toString(), params, 0L);
    }

    public boolean getGasAccountStatus(String address, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException, UtilsException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_GASADDRESSKEY, address.getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.ACCOUNT_MANAGER.toString(), AccountManager.GasAccountFunction.ACCOUNT_STATUS.toString(), params, 0L);
        ResultOuterClass.TxResponse resp = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(resp, true);
        return resp.getContractResult().getResult().toStringUtf8().equals("0");
    }

    public ResultOuterClass.TxResponse sendGasManageRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    public Request.Payload attachGasLimit(Request.Payload payload, Request.Limit limit) {
        Request.Payload.Builder payloadBuilder = payload.toBuilder();
        payloadBuilder.setLimit(limit);
        payload = payloadBuilder.build();
        return payload;
    }

    public Request.Payload createChainConfigEnableOrDisableGasPayload(long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        long sequence = this.getChainConfigSequence(rpcCallTimeout);
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_CONFIG.toString(), ChainConfig.ChainConfigFunction.ENABLE_OR_DISABLE_GAS.toString(), null, sequence + 1L);
    }

    public ResultOuterClass.TxResponse addAlias(long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_ALIAS, this.clientUser.getAlias().getBytes());
        Request.Payload payload = this.createCertManagePayload(CertManage.CertManageFunction.CERT_ALIAS_ADD.toString(), params);
        ResultOuterClass.TxResponse txResponse = this.sendContractRequest(payload, null, rpcCallTimeout, 10000L);
        this.checkProposalRequestResp(txResponse, true);
        ResultOuterClass.TxResponse.Builder txResponseBuilder = txResponse.toBuilder();
        txResponseBuilder.setContractResult(ResultOuterClass.ContractResult.newBuilder().setResult(ByteString.copyFrom((byte[])this.clientUser.getAlias().getBytes())));
        return txResponseBuilder.build();
    }

    public Request.Payload createUpdateAliasPayload(String alias, String certPem) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_ALIAS, alias.getBytes());
        params.put(KEY_CERT, certPem.getBytes());
        return this.createCertManagePayload(CertManage.CertManageFunction.CERT_ALIAS_UPDATE.toString(), params);
    }

    public ResultOuterClass.TxResponse updateAlias(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, -1L);
    }

    public ResultOuterClass.AliasInfos queryAlias(String[] aliasList, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        ResultOuterClass.AliasInfos aliasInfos;
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_ALIASES, Utils.joinList(aliasList).getBytes());
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CERT_MANAGE.toString(), CertManage.CertManageFunction.CERTS_ALIAS_QUERY.toString(), params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        this.checkProposalRequestResp(txResponse, true);
        try {
            aliasInfos = ResultOuterClass.AliasInfos.parseFrom(txResponse.getContractResult().getResult());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("aliasInfo parseFrom result : ", (Throwable)e);
            throw new ChainClientException("aliasInfo parseFrom result : " + e.getMessage());
        }
        return aliasInfos;
    }

    public Request.Payload createAliasDeletePayload(String[] aliasList) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(KEY_ALIASES, Utils.joinList(aliasList).getBytes());
        return this.createCertManagePayload(CertManage.CertManageFunction.CERTS_ALIAS_DELETE.toString(), params);
    }

    public ResultOuterClass.TxResponse deleteAlias(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        return this.sendContractRequest(payload, endorsementEntries, rpcCallTimeout, syncResultTimeout);
    }

    private Request.TxRequest createTxRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries) throws ChainMakerCryptoSuiteException {
        Request.EndorsementEntry.Builder endorsementEntryBuilder;
        if (this.clientUser.getAuthType().equals(AuthType.PermissionedWithCert.getMsg())) {
            MemberOuterClass.Member sender = this.isEnabledCertHash && this.clientUser.getCertHash() != null && this.clientUser.getCertHash().length > 0 ? MemberOuterClass.Member.newBuilder().setOrgId(this.clientUser.getOrgId()).setMemberInfo(ByteString.copyFrom((byte[])this.clientUser.getCertHash())).setMemberType(MemberOuterClass.MemberType.CERT_HASH).build() : (this.isEnabledAlias && this.clientUser.getAlias() != null && this.clientUser.getAlias().length() > 0 ? MemberOuterClass.Member.newBuilder().setOrgId(this.clientUser.getOrgId()).setMemberInfo(ByteString.copyFrom((byte[])this.clientUser.getAlias().getBytes())).setMemberType(MemberOuterClass.MemberType.ALIAS).build() : MemberOuterClass.Member.newBuilder().setOrgId(this.clientUser.getOrgId()).setMemberInfo(ByteString.copyFrom((byte[])this.clientUser.getCertBytes())).setMemberType(MemberOuterClass.MemberType.CERT).build());
            endorsementEntryBuilder = Request.EndorsementEntry.newBuilder().setSigner(sender).setSignature(ByteString.copyFrom((byte[])this.clientUser.getCryptoSuite().sign(this.clientUser.getPrivateKey(), payload.toByteArray())));
        } else {
            MemberOuterClass.Member sender = MemberOuterClass.Member.newBuilder().setOrgId(this.clientUser.getOrgId()).setMemberInfo(ByteString.copyFrom((byte[])this.clientUser.getPukBytes())).setMemberType(MemberOuterClass.MemberType.PUBLIC_KEY).build();
            endorsementEntryBuilder = Request.EndorsementEntry.newBuilder().setSigner(sender).setSignature(ByteString.copyFrom((byte[])this.clientUser.getCryptoSuite().rsaSign(this.clientUser.getPrivateKey(), payload.toByteArray())));
        }
        Request.TxRequest.Builder txRequestBuilder = Request.TxRequest.newBuilder().setPayload(payload).setSender(endorsementEntryBuilder);
        if (endorsementEntries != null) {
            txRequestBuilder.addAllEndorsers(Arrays.asList((Object[])endorsementEntries.clone()));
        }
        return txRequestBuilder.build();
    }

    private ResultOuterClass.TxResponse sendTxRequest(Request.TxRequest signedRequest, long timeout) throws ChainClientException {
        ResultOuterClass.TxResponse txResponse;
        RpcServiceClient rpcServiceClient = this.connectionPool.getConnection();
        if (rpcServiceClient == null) {
            logger.error("all connections no Idle or Ready");
            throw new ChainClientException("all connections no Idle or Ready, please reSet connection count");
        }
        try {
            txResponse = (ResultOuterClass.TxResponse)rpcServiceClient.getRpcNodeFutureStub().sendRequest(signedRequest).get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.error("connect to peer error : ", (Throwable)e);
            throw new ChainClientException("connect to peer error : " + e.getMessage());
        }
        return txResponse;
    }

    public ChainmakerBlock.BlockInfo getArchivedBlockByTxId(String txId, boolean withRWSet, long timeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long blockHeight = this.getBlockHeightByTxId(txId, timeout);
        return this.getArchivedBlockByHeight(blockHeight, withRWSet);
    }

    public ChainmakerBlock.BlockInfo getArchivedBlockByHash(String blockHash, boolean withRWSet, long timeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long blockHeight = this.getBlockHeightByBlockHash(blockHash, timeout);
        return this.getArchivedBlockByHeight(blockHeight, withRWSet);
    }

    public ChainmakerTransaction.TransactionInfo getArchivedTxByTxId(String txId, long timeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long blockHeight = this.getBlockHeightByTxId(txId, timeout);
        ChainmakerBlock.BlockInfo blockInfo = this.getArchivedBlockByHeight(blockHeight, false);
        for (int i = 0; i < blockInfo.getBlock().getTxsList().size(); ++i) {
            ChainmakerTransaction.Transaction tx = blockInfo.getBlock().getTxs(i);
            if (!tx.getPayload().getTxId().equals(txId)) continue;
            return ChainmakerTransaction.TransactionInfo.newBuilder().setTransaction(tx).setBlockHeight(blockInfo.getBlock().getHeader().getBlockHeight()).setBlockHash(blockInfo.getBlock().getHeader().getBlockHash()).setTxIndex(i).build();
        }
        return null;
    }

    private long getBlockHeight(String txId, String blockHash, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        String method = "";
        if (txId != null && !txId.equals("")) {
            method = ChainQuery.ChainQueryFunction.GET_BLOCK_HEIGHT_BY_TX_ID.toString();
            params.put(TX_ID, txId.getBytes());
        } else if (blockHash != null && !blockHash.equals("")) {
            method = ChainQuery.ChainQueryFunction.GET_BLOCK_HEIGHT_BY_HASH.toString();
            params.put(BLOCK_HASH, blockHash.getBytes());
        }
        Request.Payload payload = this.createPayload("", Request.TxType.QUERY_CONTRACT, SystemContractOuterClass.SystemContract.CHAIN_QUERY.toString(), method, params, 0L);
        ResultOuterClass.TxResponse txResponse = this.proposalRequest(payload, null, rpcCallTimeout);
        return Integer.parseInt(txResponse.getContractResult().getResult().toStringUtf8());
    }

    private Request.Payload createContractManagePayload(String contractName, String method) throws ChainMakerCryptoSuiteException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(ContractManage.GetContractInfo.Parameter.CONTRACT_NAME.toString(), contractName.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CONTRACT_MANAGE.toString(), method, params, 0L);
    }

    private Request.Payload createContractManageWithByteCodePayload(String contractName, String method, String version, byte[] byteCode, ContractOuterClass.RuntimeType runtime, Map<String, byte[]> params) throws ChainMakerCryptoSuiteException {
        Request.Payload payload = this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CONTRACT_MANAGE.toString(), method, params, 0L);
        Request.Payload.Builder payloadBuilder = payload.toBuilder();
        payloadBuilder.addParameters(Request.KeyValuePair.newBuilder().setKey(ContractManage.InitContract.Parameter.CONTRACT_NAME.toString()).setValue(ByteString.copyFromUtf8((String)contractName)));
        payloadBuilder.addParameters(Request.KeyValuePair.newBuilder().setKey(ContractManage.InitContract.Parameter.CONTRACT_VERSION.toString()).setValue(ByteString.copyFromUtf8((String)version)));
        payloadBuilder.addParameters(Request.KeyValuePair.newBuilder().setKey(ContractManage.InitContract.Parameter.CONTRACT_RUNTIME_TYPE.toString()).setValue(ByteString.copyFromUtf8((String)runtime.toString())));
        payloadBuilder.addParameters(Request.KeyValuePair.newBuilder().setKey(ContractManage.InitContract.Parameter.CONTRACT_BYTECODE.toString()).setValue(ByteString.copyFrom((byte[])byteCode)));
        return payloadBuilder.build();
    }

    private Request.Payload createNativeContractAccessPayload(String method, String[] accessContractList) throws ChainMakerCryptoSuiteException {
        String jsonString = JSON.toJSONString((Object)accessContractList);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put(ContractManage.ContractAccess.Parameter.NATIVE_CONTRACT_NAME.toString(), jsonString.getBytes());
        return this.createPayload("", Request.TxType.INVOKE_CONTRACT, SystemContractOuterClass.SystemContract.CONTRACT_MANAGE.toString(), method, params, 0L);
    }

    private Request.Payload createPayload(String txId, Request.TxType txType, String contractName, String method, Map<String, byte[]> params, long seq) throws ChainMakerCryptoSuiteException {
        if (txId == null || txId.equals("")) {
            txId = Utils.generateTxId(ByteString.copyFrom((byte[])UUID.randomUUID().toString().getBytes()).concat(ByteString.copyFrom((byte[])UUID.randomUUID().toString().getBytes())), this.clientUser.getCryptoSuite());
        }
        Request.Payload.Builder payloadBuilder = Request.Payload.newBuilder().setChainId(this.chainId).setTxType(txType).setTxId(txId).setTimestamp(Utils.getCurrentTimeSeconds()).setContractName(contractName).setMethod(method).setSequence(seq);
        if (params != null && !params.isEmpty()) {
            params.forEach((key, value) -> payloadBuilder.addParameters(Request.KeyValuePair.newBuilder().setKey((String)key).setValue(ByteString.copyFrom((byte[])value)).build()));
        }
        return payloadBuilder.build();
    }

    private ResultOuterClass.TxResponse proposalRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        return this.sendRequest(payload, endorsementEntries, rpcCallTimeout);
    }

    private ResultOuterClass.TxResponse sendContractRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout, long syncResultTimeout) throws ChainClientException, ChainMakerCryptoSuiteException {
        ResultOuterClass.TxResponse responseInfo = this.sendRequest(payload, endorsementEntries, rpcCallTimeout);
        ResultOuterClass.TxResponse.Builder responseInfoBuilder = responseInfo.toBuilder();
        if (responseInfo.getCode() == ResultOuterClass.TxStatusCode.SUCCESS && syncResultTimeout > 0L) {
            ChainmakerTransaction.TransactionInfo transactionInfo = this.loopQueryResultByTxId(responseInfo.getTxId(), syncResultTimeout);
            if (transactionInfo == null || transactionInfo.getTransaction() == null || transactionInfo.getTransaction().getResult() == null) {
                throw new ChainClientException(String.format("get tx by txId %s failed", responseInfo.getTxId()));
            }
            responseInfoBuilder.setContractResult(transactionInfo.getTransaction().getResult().getContractResult().toBuilder()).build();
        }
        return responseInfoBuilder.build();
    }

    private ResultOuterClass.TxResponse sendRequest(Request.Payload payload, Request.EndorsementEntry[] endorsementEntries, long rpcCallTimeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        return this.sendTxRequest(this.createTxRequest(payload, endorsementEntries), rpcCallTimeout);
    }

    private ChainmakerTransaction.TransactionInfo loopQueryResultByTxId(String txId, long timeout) throws ChainMakerCryptoSuiteException, ChainClientException {
        long tryCount;
        long l = tryCount = timeout % 2000L == 0L ? timeout / 2000L : timeout / 2000L + 1L;
        if (tryCount == 0L) {
            ++tryCount;
        }
        for (long i = 0L; i < tryCount; ++i) {
            ChainmakerTransaction.TransactionInfo transactionInfo = this.getTxByTxId(txId, timeout);
            if (transactionInfo == null || !transactionInfo.hasTransaction()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    logger.error("Thread sleep error : ", (Throwable)e);
                }
                continue;
            }
            return transactionInfo;
        }
        return null;
    }

    private void subscribe(Request.Payload payload, StreamObserver<ResultOuterClass.SubscribeResult> txStreamObserver) throws ChainClientException {
        RpcServiceClient rpcServiceClient = this.connectionPool.getConnection();
        if (rpcServiceClient == null) {
            logger.error("all connections no Idle or Ready");
            throw new ChainClientException("all connections no Idle or Ready, please reSet connection count");
        }
        try {
            rpcServiceClient.getRpcNodeStub().subscribe(this.createTxRequest(payload, null), txStreamObserver);
        }
        catch (Exception e) {
            logger.error("subscribeTx to peer error : ", (Throwable)e);
            throw new ChainClientException("subscribeTx to peer error : " + e.getMessage());
        }
    }

    public Store.BlockWithRWSet getFromArchiveStore(long blockHeight) throws ChainClientException {
        if (this.archiveConfig.getType().equals("mysql")) {
            return this.getArchivedBlockFromMySQL(blockHeight);
        }
        return null;
    }

    public Store.BlockWithRWSet getArchivedBlockFromMySQL(long blockHeight) throws ChainClientException {
        Store.BlockWithRWSet blockWithRWSet;
        String archiveDest = this.archiveConfig.getDest();
        String[] destList = archiveDest.split(":");
        String user = destList[0];
        String pwd = destList[1];
        String host = destList[2];
        String port = destList[3];
        try {
            Class.forName(DRIVER_NAME);
        }
        catch (ClassNotFoundException e) {
            logger.error("com.mysql.cj.jdbc.Driver class not found : ", (Throwable)e);
            throw new ChainClientException("class not found : " + e.getMessage());
        }
        String url = String.format("jdbc:mysql://%s:%s/%s_%s?serverTimezone=GMT", host, port, MYSQL_DBNAME_PREFIX, this.chainId);
        byte[] blockWithRWSetBytes = null;
        String hmac = "";
        try {
            Connection connection = DriverManager.getConnection(url, user, pwd);
            Statement statement = connection.createStatement();
            String sql = String.format("SELECT Fblock_with_rwset, Fhmac from %s_%d WHERE Fblock_height = %d", MYSQL_TABLENAME_PREFIX, blockHeight / 100000L + 1L, blockHeight);
            ResultSet resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                ResultSetMetaData metaData = resultSet.getMetaData();
                for (int i = 1; i < metaData.getColumnCount() + 1; ++i) {
                    if (metaData.getColumnName(i).equals("Fblock_with_rwset")) {
                        blockWithRWSetBytes = (byte[])resultSet.getObject(i);
                    }
                    if (!metaData.getColumnName(i).equals("Fhmac")) continue;
                    hmac = (String)resultSet.getObject(i);
                }
            }
            connection.close();
        }
        catch (SQLException e) {
            logger.error("sql err : ", (Throwable)e);
            throw new ChainClientException("sql err : " + e.getMessage());
        }
        try {
            blockWithRWSet = Store.BlockWithRWSet.parseFrom(blockWithRWSetBytes);
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("blockWithRWSet parseFrom result : ", (Throwable)e);
            throw new ChainClientException("blockWithRWSet parseFrom result : " + e.getMessage());
        }
        return blockWithRWSet;
    }

    public void checkProposalRequestResp(ResultOuterClass.TxResponse resp, boolean needContractResult) throws ChainClientException {
        if (resp.getCode() != ResultOuterClass.TxStatusCode.SUCCESS) {
            throw new ChainClientException(resp.getMessage());
        }
        if (needContractResult && resp.getContractResult() == null) {
            throw new ChainClientException("contract result is nulll");
        }
        if (resp.getContractResult() != null && resp.getContractResult().getCode() != 0) {
            throw new ChainClientException(resp.getContractResult().getMessage());
        }
    }
}

