/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk;

import io.grpc.ConnectivityState;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.List;
import org.chainmaker.sdk.RpcServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPool {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionPool.class);
    private List<RpcServiceClient> rpcServiceClients;
    private PrivateKey privateKey;
    private Certificate certificate;
    private int retryInterval = 500;
    private int retryLimit = 10;

    public List<RpcServiceClient> getRpcServiceClients() {
        return this.rpcServiceClients;
    }

    public void setRpcServiceClients(List<RpcServiceClient> rpcServiceClients) {
        this.rpcServiceClients = rpcServiceClients;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public RpcServiceClient getConnection() {
        for (int i = 0; i < this.retryLimit; ++i) {
            for (RpcServiceClient rpcServiceClient : this.rpcServiceClients) {
                ConnectivityState connectivityState = rpcServiceClient.getManagedChannel().getState(true);
                if (!connectivityState.equals((Object)ConnectivityState.IDLE) && !connectivityState.equals((Object)ConnectivityState.READY)) continue;
                return rpcServiceClient;
            }
            try {
                Thread.sleep(this.retryInterval);
                continue;
            }
            catch (InterruptedException e) {
                logger.error("Thread sleep error : ", (Throwable)e);
            }
        }
        return null;
    }

    public void stop() {
        for (RpcServiceClient rpcServiceClient : this.rpcServiceClients) {
            rpcServiceClient.getManagedChannel().shutdown();
        }
    }
}

