/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk;

import com.google.protobuf.ByteString;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import org.chainmaker.pb.accesscontrol.MemberOuterClass;
import org.chainmaker.pb.common.Request;
import org.chainmaker.sdk.config.AuthType;
import org.chainmaker.sdk.crypto.ChainMakerCryptoSuiteException;
import org.chainmaker.sdk.crypto.ChainmakerX509CryptoSuite;
import org.chainmaker.sdk.crypto.CryptoSuite;
import org.chainmaker.sdk.utils.CryptoUtils;

public class User {
    private String orgId;
    private PrivateKey privateKey;
    private Certificate certificate;
    private PrivateKey tlsPrivateKey;
    private Certificate tlsCertificate;
    private byte[] certBytes;
    private byte[] certHash;
    private String alias;
    private byte[] pukBytes;
    private byte[] priBytes;
    private PublicKey publicKey;
    private String authType = AuthType.PermissionedWithCert.getMsg();
    private CryptoSuite cryptoSuite;

    public User(String orgId, byte[] userKeyBytes, byte[] userCertBytes, byte[] tlsUserKeyBytes, byte[] tlsUserCertBytes) throws ChainMakerCryptoSuiteException {
        PrivateKey generatedPrivateKey = CryptoUtils.getPrivateKeyFromBytes(userKeyBytes);
        PrivateKey generatedTlsPrivateKey = CryptoUtils.getPrivateKeyFromBytes(tlsUserKeyBytes);
        ChainmakerX509CryptoSuite generatedCryptoSuite = ChainmakerX509CryptoSuite.newInstance();
        Certificate generatedCertificate = generatedCryptoSuite.getCertificateFromBytes(userCertBytes);
        Certificate generatedTlsCertificate = generatedCryptoSuite.getCertificateFromBytes(tlsUserCertBytes);
        this.orgId = orgId;
        this.certBytes = userCertBytes;
        this.privateKey = generatedPrivateKey;
        this.tlsCertificate = generatedTlsCertificate;
        this.tlsPrivateKey = generatedTlsPrivateKey;
        this.cryptoSuite = generatedCryptoSuite;
        this.certificate = generatedCertificate;
    }

    public User(String orgId) throws ChainMakerCryptoSuiteException {
        this.cryptoSuite = ChainmakerX509CryptoSuite.newInstance();
        this.orgId = orgId;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public PrivateKey getTlsPrivateKey() {
        return this.tlsPrivateKey;
    }

    public void setTlsPrivateKey(PrivateKey tlsPrivateKey) {
        this.tlsPrivateKey = tlsPrivateKey;
    }

    public Certificate getTlsCertificate() {
        return this.tlsCertificate;
    }

    public void setTlsCertificate(Certificate tlsCertificate) {
        this.tlsCertificate = tlsCertificate;
    }

    public byte[] getCertBytes() {
        return this.certBytes;
    }

    public void setCertBytes(byte[] certBytes) {
        this.certBytes = certBytes;
    }

    public byte[] getCertHash() {
        return this.certHash;
    }

    public void setCertHash(byte[] certHash) {
        this.certHash = certHash;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public byte[] getPukBytes() {
        return this.pukBytes;
    }

    public void setPukBytes(byte[] pukBytes) {
        this.pukBytes = pukBytes;
    }

    public byte[] getPriBytes() {
        return this.priBytes;
    }

    public void setPriBytes(byte[] priBytes) {
        this.priBytes = priBytes;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public CryptoSuite getCryptoSuite() {
        return this.cryptoSuite;
    }

    public void setCryptoSuite(CryptoSuite cryptoSuite) {
        this.cryptoSuite = cryptoSuite;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public byte[] signPayload(byte[] payload, boolean isEnabledCertHash) throws ChainMakerCryptoSuiteException {
        Request.EndorsementEntry endorsementEntry = Request.EndorsementEntry.newBuilder().setSignature(ByteString.copyFrom((byte[])this.cryptoSuite.sign(this.privateKey, payload))).setSigner(this.getSerializedMember(isEnabledCertHash)).build();
        return endorsementEntry.toByteArray();
    }

    public Request.EndorsementEntry signPayloadOfMultiSign(byte[] payload, boolean isEnabledCertHash) throws ChainMakerCryptoSuiteException {
        return Request.EndorsementEntry.newBuilder().setSignature(ByteString.copyFrom((byte[])this.cryptoSuite.sign(this.privateKey, payload))).setSigner(this.getSerializedMember(isEnabledCertHash)).build();
    }

    public MemberOuterClass.Member getSerializedMember(boolean isEnabledCertHash) {
        if (isEnabledCertHash && this.certHash != null && this.certHash.length > 0) {
            return MemberOuterClass.Member.newBuilder().setOrgId(this.orgId).setMemberInfo(ByteString.copyFrom((byte[])this.certHash)).setMemberType(MemberOuterClass.MemberType.CERT_HASH).build();
        }
        return MemberOuterClass.Member.newBuilder().setOrgId(this.orgId).setMemberInfo(ByteString.copyFrom((byte[])this.certBytes)).setMemberType(MemberOuterClass.MemberType.CERT).build();
    }
}

