/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.chainmaker.sdk.crypto.ChainMakerCryptoSuiteException;
import org.chainmaker.sdk.utils.UtilsException;

public class CryptoUtils {
    private static final int ZX_ADDR_SUFFIX_LENGTH = 20;
    private static final String ZX_ADDR_PREFIX = "ZX";
    private static final String RSA_PRE = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A";
    private static final String HEX_ADDR_PREFIX = "0x";

    private CryptoUtils() {
        throw new IllegalStateException("Crypto Utils class");
    }

    public static PrivateKey getPrivateKeyFromBytes(byte[] pemKey) throws ChainMakerCryptoSuiteException {
        PrivateKey pk = null;
        try {
            PemReader pr = new PemReader((Reader)new StringReader(new String(pemKey)));
            PemObject po = pr.readPemObject();
            PEMParser pem = new PEMParser((Reader)new StringReader(new String(pemKey)));
            if (po.getType().equals("PRIVATE KEY")) {
                pk = new JcaPEMKeyConverter().getPrivateKey((PrivateKeyInfo)pem.readObject());
            } else {
                PEMKeyPair kp = (PEMKeyPair)pem.readObject();
                pk = new JcaPEMKeyConverter().getPrivateKey(kp.getPrivateKeyInfo());
            }
        }
        catch (Exception e) {
            throw new ChainMakerCryptoSuiteException(e.toString());
        }
        return pk;
    }

    public static String makeAddrFromPukPem(PublicKey publicKey) throws IOException {
        byte[] encoded = publicKey.getEncoded();
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(ASN1Sequence.getInstance((Object)encoded));
        byte[] subjectPublicKeyEncoded = subjectPublicKeyInfo.parsePublicKey().getEncoded();
        SHA256Digest digest = new SHA256Digest();
        byte[] retValue = new byte[digest.getDigestSize()];
        digest.update(subjectPublicKeyEncoded, 0, subjectPublicKeyEncoded.length);
        digest.doFinal(retValue, 0);
        String ski = Hex.toHexString((byte[])retValue);
        byte[] data = Hex.decode((String)ski);
        Keccak.Digest256 kecc = new Keccak.Digest256();
        kecc.update(data, 0, data.length);
        byte[] address = kecc.digest();
        String addr = Hex.toHexString((byte[])address);
        return HEX_ADDR_PREFIX + addr.substring(24);
    }

    public static String makeAddrFromCert(java.security.cert.Certificate certificate) throws UtilsException {
        ByteArrayInputStream bIn = null;
        try {
            bIn = new ByteArrayInputStream(certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new UtilsException("certificate to ByteArrayInputStream err : " + e.getMessage());
        }
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        ASN1Sequence seq = null;
        try {
            seq = (ASN1Sequence)aIn.readObject();
        }
        catch (IOException e) {
            throw new UtilsException("certificate to ASN1Sequence err : " + e.getMessage());
        }
        Certificate obj = Certificate.getInstance((Object)seq);
        TBSCertificate tbsCertificate = obj.getTBSCertificate();
        Extensions ext = tbsCertificate.getExtensions();
        SubjectKeyIdentifier si = SubjectKeyIdentifier.fromExtensions((Extensions)ext);
        String ski = Hex.toHexString((byte[])si.getKeyIdentifier());
        byte[] data = Hex.decode((String)ski);
        Keccak.Digest256 kecc = new Keccak.Digest256();
        kecc.update(data, 0, data.length);
        byte[] address = kecc.digest();
        String addr = Hex.toHexString((byte[])address);
        return HEX_ADDR_PREFIX + addr.substring(24);
    }

    public static String getPemStrFromPublicKey(PublicKey publicKey) throws UtilsException {
        StringWriter writer = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)writer);
        try {
            pemWriter.writeObject((PemObjectGenerator)new PemObject("PUBLIC KEY", publicKey.getEncoded()));
            pemWriter.flush();
            pemWriter.close();
        }
        catch (IOException e) {
            throw new UtilsException("publicKey parse to pem err :" + e.getMessage());
        }
        return writer.toString();
    }

    public static String getZXAddressFromPKPEM(String pk) throws UtilsException {
        pk = pk.replace(RSA_PRE, "");
        PemReader pr = new PemReader((Reader)new StringReader(new String(pk)));
        PemObject po = null;
        byte[] plainText = null;
        try {
            po = pr.readPemObject();
            RSAPublicKey rsaPublicKey = RSAPublicKey.getInstance((Object)po.getContent());
            plainText = rsaPublicKey.toASN1Primitive().getEncoded();
        }
        catch (IOException e) {
            throw new UtilsException("publicKey parse to addr err :" + e.getMessage());
        }
        SM3Digest digest = new SM3Digest();
        byte[] retValue = new byte[digest.getDigestSize()];
        digest.update(plainText, 0, plainText.length);
        digest.doFinal(retValue, 0);
        byte[] addrBytes = new byte[20];
        System.arraycopy(retValue, 0, addrBytes, 0, 20);
        return ZX_ADDR_PREFIX + Hex.toHexString((byte[])addrBytes);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

