/*
 * Decompiled with CFR 0.152.
 */
package org.chainmaker.sdk.utils;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.chainmaker.pb.accesscontrol.MemberOuterClass;
import org.chainmaker.pb.common.Request;
import org.chainmaker.sdk.User;
import org.chainmaker.sdk.config.AuthType;
import org.chainmaker.sdk.crypto.ChainMakerCryptoSuiteException;
import org.chainmaker.sdk.utils.CryptoUtils;
import org.chainmaker.sdk.utils.UtilsException;

public class SdkUtils {
    public static Request.EndorsementEntry[] getEndorsers(Request.Payload payload, User[] users) throws ChainMakerCryptoSuiteException, UtilsException {
        Request.EndorsementEntry[] endorsementEntries = new Request.EndorsementEntry[users.length];
        for (int i = 0; i < users.length; ++i) {
            Request.EndorsementEntry entry;
            endorsementEntries[i] = entry = SdkUtils.signPayload(users[i], payload.toByteArray());
        }
        return endorsementEntries;
    }

    private static Request.EndorsementEntry signPayload(User user, byte[] payload) throws ChainMakerCryptoSuiteException, UtilsException {
        if (user.getAuthType().equals(AuthType.PermissionedWithCert.getMsg())) {
            return Request.EndorsementEntry.newBuilder().setSignature(ByteString.copyFrom((byte[])user.getCryptoSuite().sign(user.getPrivateKey(), payload))).setSigner(SdkUtils.getSerializedMember(user)).build();
        }
        return Request.EndorsementEntry.newBuilder().setSignature(ByteString.copyFrom((byte[])user.getCryptoSuite().rsaSign(CryptoUtils.getPrivateKeyFromBytes(user.getPriBytes()), payload))).setSigner(SdkUtils.getSerializedMember(user.getOrgId(), user.getPriBytes())).build();
    }

    public static MemberOuterClass.Member getSerializedMember(User user) {
        return MemberOuterClass.Member.newBuilder().setOrgId(user.getOrgId()).setMemberInfo(ByteString.copyFrom((byte[])user.getCertBytes())).setMemberType(MemberOuterClass.MemberType.CERT).build();
    }

    public static MemberOuterClass.Member getSerializedMember(String orgId, byte[] pkBytes) throws UtilsException {
        return MemberOuterClass.Member.newBuilder().setOrgId(orgId).setMemberInfo(ByteString.copyFrom((byte[])SdkUtils.dealRsaPk(pkBytes))).setMemberType(MemberOuterClass.MemberType.PUBLIC_KEY).build();
    }

    public static byte[] dealRsaPk(byte[] pemKey) throws UtilsException {
        PublicKey publicKey;
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            RSAPrivateKeySpec priv = kf.getKeySpec(CryptoUtils.getPrivateKeyFromBytes(pemKey), RSAPrivateKeySpec.class);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(priv.getModulus(), BigInteger.valueOf(65537L));
            publicKey = kf.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException | ChainMakerCryptoSuiteException e) {
            throw new UtilsException("new RSAPublicKeySpec err: " + e.getMessage());
        }
        StringWriter writer = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)writer);
        try {
            pemWriter.writeObject((PemObjectGenerator)new PemObject("PUBLIC KEY", publicKey.getEncoded()));
            pemWriter.flush();
            pemWriter.close();
        }
        catch (IOException e) {
            throw new UtilsException("publicKey parse to pem err :" + e.getMessage());
        }
        return writer.toString().getBytes();
    }
}

