/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.graph.AbstractUndirectedNetworkConnections;
import com.google.common.graph.EdgesConnecting;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.common.value.qual.UnknownVal;

final class UndirectedNetworkConnections<@SubstringIndexBottom N, @SubstringIndexBottom E>
extends AbstractUndirectedNetworkConnections<N, E> {
    protected UndirectedNetworkConnections(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Map<E, N> incidentEdgeMap) {
        super(incidentEdgeMap);
    }

    static <N, E> @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness UndirectedNetworkConnections<N, E> of() {
        return new UndirectedNetworkConnections(HashBiMap.create(2));
    }

    static <N, E> @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness UndirectedNetworkConnections<N, E> ofImmutable(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Map<E, N> incidentEdges) {
        return new UndirectedNetworkConnections<N, E>(ImmutableBiMap.copyOf(incidentEdges));
    }

    @Override
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(((BiMap)this.incidentEdgeMap).values());
    }

    @Override
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Set<E> edgesConnecting(N node) {
        return new EdgesConnecting(((BiMap)this.incidentEdgeMap).inverse(), node);
    }
}

