/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.lock;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.GuardedByBottom;
import org.checkerframework.checker.lock.qual.GuardedByTop;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class LockAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    private List<String> heldLocks = new ArrayList<String>();
    protected final AnnotationMirror GUARDED_BY = AnnotationUtils.fromClass(this.elements, GuardedBy.class);
    protected final AnnotationMirror GUARDEDBY_TOP = AnnotationUtils.fromClass(this.elements, GuardedByTop.class);
    protected final AnnotationMirror GUARDEDBY_BOT = AnnotationUtils.fromClass(this.elements, GuardedByBottom.class);

    public LockAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.addAliasedAnnotation(net.jcip.annotations.GuardedBy.class, this.GUARDED_BY);
        this.postInit();
    }

    public void setHeldLocks(List<String> heldLocks) {
        this.heldLocks = heldLocks;
    }

    public List<String> getHeldLock() {
        return Collections.unmodifiableList(this.heldLocks);
    }

    private void removeHeldLocks(AnnotatedTypeMirror type) {
        AnnotationMirror guarded = type.getAnnotation(GuardedBy.class);
        if (guarded == null) {
            return;
        }
        String lock = AnnotationUtils.getElementValue(guarded, "value", String.class, false);
        if (this.heldLocks.contains(lock)) {
            type.replaceAnnotation(this.GUARDEDBY_BOT);
        }
    }

    private AnnotationMirror createGuarded(String lock) {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, GuardedBy.class);
        builder.setValue((CharSequence)"value", lock);
        return builder.build();
    }

    private ExpressionTree receiver(ExpressionTree expr) {
        if (expr.getKind() == Tree.Kind.METHOD_INVOCATION) {
            expr = ((MethodInvocationTree)expr).getMethodSelect();
        }
        if ((expr = TreeUtils.skipParens(expr)).getKind() == Tree.Kind.MEMBER_SELECT) {
            return ((MemberSelectTree)expr).getExpression();
        }
        return null;
    }

    private void replaceThis(AnnotatedTypeMirror type, Tree tree) {
        if (tree.getKind() != Tree.Kind.IDENTIFIER && tree.getKind() != Tree.Kind.MEMBER_SELECT && tree.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return;
        }
        ExpressionTree expr = (ExpressionTree)tree;
        if (!type.hasAnnotationRelaxed(this.GUARDED_BY) || this.isMostEnclosingThisDeref(expr)) {
            return;
        }
        AnnotationMirror guardedBy = type.getAnnotation(GuardedBy.class);
        if (!"this".equals(AnnotationUtils.getElementValue(guardedBy, "value", String.class, false))) {
            return;
        }
        ExpressionTree receiver = this.receiver(expr);
        assert (receiver != null);
        if (receiver != null) {
            AnnotationMirror newAnno = this.createGuarded(receiver.toString());
            type.replaceAnnotation(newAnno);
        }
    }

    private void replaceItself(AnnotatedTypeMirror type, Tree tree) {
        if (tree.getKind() != Tree.Kind.IDENTIFIER && tree.getKind() != Tree.Kind.MEMBER_SELECT && tree.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return;
        }
        ExpressionTree expr = (ExpressionTree)tree;
        if (!type.hasAnnotationRelaxed(this.GUARDED_BY)) {
            return;
        }
        AnnotationMirror guardedBy = type.getAnnotation(GuardedBy.class);
        if (!"itself".equals(AnnotationUtils.getElementValue(guardedBy, "value", String.class, false))) {
            return;
        }
        AnnotationMirror newAnno = this.createGuarded(expr.toString());
        type.replaceAnnotation(newAnno);
    }

    protected boolean hasGuardedBy(AnnotatedTypeMirror t) {
        return t.hasAnnotation(GuardedBy.class) || t.hasAnnotation(net.jcip.annotations.GuardedBy.class);
    }

    @Override
    protected void annotateImplicit(Tree tree, AnnotatedTypeMirror type, boolean useFlow) {
        if (!this.hasGuardedBy(type)) {
            super.annotateImplicit(tree, type, useFlow);
        }
        this.replaceThis(type, tree);
        this.replaceItself(type, tree);
        this.removeHeldLocks(type);
    }

    @Override
    public AnnotationMirror aliasedAnnotation(AnnotationMirror a) {
        if (TypesUtils.isDeclaredOfName(a.getAnnotationType(), net.jcip.annotations.GuardedBy.class.getCanonicalName())) {
            AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, GuardedBy.class);
            builder.setValue((CharSequence)"value", AnnotationUtils.getElementValue(a, "value", String.class, false));
            return builder.build();
        }
        return super.aliasedAnnotation(a);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory ignorefactory) {
        MultiGraphQualifierHierarchy.MultiGraphFactory factory = this.createQualifierHierarchyFactory();
        factory.addQualifier(this.GUARDEDBY_TOP);
        factory.addQualifier(this.GUARDED_BY);
        factory.addQualifier(this.GUARDEDBY_BOT);
        factory.addSubtype(this.GUARDEDBY_BOT, this.GUARDED_BY);
        factory.addSubtype(this.GUARDED_BY, this.GUARDEDBY_TOP);
        return new LockQualifierHierarchy(factory);
    }

    private final class LockQualifierHierarchy
    extends GraphQualifierHierarchy {
        public LockQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory, LockAnnotatedTypeFactory.this.GUARDEDBY_BOT);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameIgnoringValues(rhs, LockAnnotatedTypeFactory.this.GUARDEDBY_BOT) && AnnotationUtils.areSameIgnoringValues(lhs, LockAnnotatedTypeFactory.this.GUARDED_BY)) {
                return true;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, LockAnnotatedTypeFactory.this.GUARDED_BY)) {
                lhs = LockAnnotatedTypeFactory.this.GUARDED_BY;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, LockAnnotatedTypeFactory.this.GUARDED_BY)) {
                rhs = LockAnnotatedTypeFactory.this.GUARDED_BY;
            }
            return super.isSubtype(rhs, lhs);
        }
    }
}

