/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.lock;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import net.jcip.annotations.GuardedBy;
import org.checkerframework.checker.lock.LockAnnotatedTypeFactory;
import org.checkerframework.checker.lock.qual.Holding;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.TreeUtils;

public class LockVisitor
extends BaseTypeVisitor<LockAnnotatedTypeFactory> {
    public LockVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    public Void visitVariable(VariableTree node, Void p) {
        Void r = this.scan((Tree)node.getModifiers(), p);
        r = this.reduce(this.scan(node.getType(), p), r);
        r = this.reduce(this.scan((Tree)node.getInitializer(), p), r);
        return r;
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void p) {
        AnnotatedTypeMirror type = ((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node);
        if (((LockAnnotatedTypeFactory)this.atypeFactory).hasGuardedBy(type)) {
            this.checker.report(Result.failure("unguarded.access", node, type), node);
        }
        return super.visitIdentifier(node, p);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void p) {
        AnnotatedTypeMirror type = ((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node);
        if (((LockAnnotatedTypeFactory)this.atypeFactory).hasGuardedBy(type)) {
            this.checker.report(Result.failure("unguarded.access", node, type), node);
        }
        return (Void)super.visitMemberSelect(node, p);
    }

    private <T> List<T> append(List<T> lst, T o) {
        if (o == null) {
            return lst;
        }
        ArrayList<T> newList = new ArrayList<T>(lst.size() + 1);
        newList.addAll(lst);
        newList.add(o);
        return newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitSynchronized(SynchronizedTree node, Void p) {
        List<String> prevLocks = ((LockAnnotatedTypeFactory)this.atypeFactory).getHeldLock();
        try {
            List<String> locks = this.append(prevLocks, TreeUtils.skipParens(node.getExpression()).toString());
            ((LockAnnotatedTypeFactory)this.atypeFactory).setHeldLocks(locks);
            Void void_ = (Void)super.visitSynchronized(node, p);
            return void_;
        }
        finally {
            ((LockAnnotatedTypeFactory)this.atypeFactory).setHeldLocks(prevLocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitMethod(MethodTree node, Void p) {
        List<String> prevLocks;
        List<String> locks = prevLocks = ((LockAnnotatedTypeFactory)this.atypeFactory).getHeldLock();
        try {
            List<String> methodLocks;
            ExecutableElement method = TreeUtils.elementFromDeclaration(node);
            if (method.getModifiers().contains((Object)Modifier.SYNCHRONIZED) || method.getKind() == ElementKind.CONSTRUCTOR) {
                if (method.getModifiers().contains((Object)Modifier.STATIC)) {
                    String enclosingClass = method.getEnclosingElement().getSimpleName().toString();
                    locks = this.append(locks, enclosingClass + ".class");
                } else {
                    locks = this.append(locks, "this");
                }
            }
            if (!(methodLocks = this.methodHolding(method)).isEmpty()) {
                locks = new ArrayList<String>(locks);
                locks.addAll(methodLocks);
            }
            ((LockAnnotatedTypeFactory)this.atypeFactory).setHeldLocks(locks);
            Void void_ = super.visitMethod(node, p);
            return void_;
        }
        finally {
            ((LockAnnotatedTypeFactory)this.atypeFactory).setHeldLocks(prevLocks);
        }
    }

    private String receiver(ExpressionTree methodSel) {
        if (methodSel.getKind() == Tree.Kind.IDENTIFIER) {
            return "this";
        }
        if (methodSel.getKind() == Tree.Kind.MEMBER_SELECT) {
            return ((MemberSelectTree)methodSel).getExpression().toString();
        }
        ErrorReporter.errorAbort("LockVisitor found unknown receiver tree type: " + methodSel);
        return null;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        List<String> locks;
        ExecutableElement methodElt = TreeUtils.elementFromUse(node);
        String lock = this.receiver(node.getMethodSelect());
        if (methodElt.getSimpleName().contentEquals("lock")) {
            locks = this.append(((LockAnnotatedTypeFactory)this.atypeFactory).getHeldLock(), lock);
            ((LockAnnotatedTypeFactory)this.atypeFactory).setHeldLocks(locks);
        } else if (methodElt.getSimpleName().contentEquals("unlock")) {
            locks = new ArrayList<String>(((LockAnnotatedTypeFactory)this.atypeFactory).getHeldLock());
            locks.remove(lock);
            ((LockAnnotatedTypeFactory)this.atypeFactory).setHeldLocks(locks);
        }
        List<String> methodLocks = this.methodHolding(methodElt);
        if (!methodLocks.isEmpty() && !((LockAnnotatedTypeFactory)this.atypeFactory).getHeldLock().containsAll(methodLocks)) {
            this.checker.report(Result.failure("unguarded.invocation", methodElt, methodLocks), node);
        }
        return super.visitMethodInvocation(node, p);
    }

    @Override
    protected boolean checkOverride(MethodTree overriderTree, AnnotatedTypeMirror.AnnotatedDeclaredType enclosingType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, Void p) {
        List<String> overriderLocks = this.methodHolding(TreeUtils.elementFromDeclaration(overriderTree));
        List<String> overriddenLocks = this.methodHolding(overridden.getElement());
        boolean isValid = overriddenLocks.containsAll(overriderLocks);
        if (!isValid) {
            this.checker.report(Result.failure("override.holding.invalid", TreeUtils.elementFromDeclaration(overriderTree), overridden.getElement(), overriderLocks, overriddenLocks), overriderTree);
        }
        return super.checkOverride(overriderTree, enclosingType, overridden, overriddenType, p) && isValid;
    }

    @Override
    protected void checkMethodInvocability(AnnotatedTypeMirror.AnnotatedExecutableType method, MethodInvocationTree node) {
    }

    protected List<String> methodHolding(ExecutableElement element) {
        AnnotationMirror holding = ((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(element, Holding.class);
        AnnotationMirror guardedBy = ((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(element, GuardedBy.class);
        if (holding == null && guardedBy == null) {
            return Collections.emptyList();
        }
        ArrayList<String> locks = new ArrayList<String>();
        if (holding != null) {
            List<String> holdingValue = AnnotationUtils.getElementValueArray(holding, "value", String.class, false);
            locks.addAll(holdingValue);
        }
        if (guardedBy != null) {
            String guardedByValue = AnnotationUtils.getElementValue(guardedBy, "value", String.class, false);
            locks.add(guardedByValue);
        }
        return locks;
    }

    @Override
    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType declarationType, AnnotatedTypeMirror.AnnotatedDeclaredType useType, Tree tree) {
        return true;
    }
}

