/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.propkey;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.propkey.qual.PropertyKey;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.qual.Bottom;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.TreeAnnotator;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;

public class PropertyKeyAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    private final Set<String> lookupKeys = Collections.unmodifiableSet(this.buildLookupKeys());

    public PropertyKeyAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        AnnotationMirror BOTTOM = AnnotationUtils.fromClass(this.elements, Bottom.class);
        this.postInit();
        this.treeAnnotator.addTreeKind(Tree.Kind.NULL_LITERAL, BOTTOM);
        this.typeAnnotator.addTypeName(Void.class, BOTTOM);
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new KeyLookupTreeAnnotator(this, PropertyKey.class);
    }

    private static boolean strContains(Set<String> messages, String messageKey) {
        String key = messageKey;
        while (!messages.contains(key)) {
            int dot = key.indexOf(46);
            if (dot < 0) {
                return false;
            }
            key = key.substring(dot + 1);
        }
        return true;
    }

    public Set<String> getLookupKeys() {
        return this.lookupKeys;
    }

    private Set<String> buildLookupKeys() {
        HashSet<String> result = new HashSet<String>();
        if (this.checker.hasOption("propfiles")) {
            result.addAll(this.keysOfPropertyFiles(this.checker.getOption("propfiles")));
        }
        if (this.checker.hasOption("bundlenames")) {
            result.addAll(this.keysOfResourceBundle(this.checker.getOption("bundlenames")));
        }
        return result;
    }

    private Set<String> keysOfPropertyFiles(String names) {
        String[] namesArr = names.split(":");
        if (namesArr == null) {
            System.err.println("Couldn't parse the properties files: <" + names + ">");
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String name : namesArr) {
            try {
                Properties prop = new Properties();
                InputStream in = null;
                ClassLoader cl = this.getClass().getClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                if ((in = cl.getResourceAsStream(name)) == null) {
                    try {
                        in = new FileInputStream(name);
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                }
                if (in == null) {
                    System.err.println("Couldn't find the properties file: " + name);
                    continue;
                }
                prop.load(in);
                result.addAll(prop.stringPropertyNames());
            }
            catch (Exception e) {
                System.err.println("Exception in PropertyKeyChecker.keysOfPropertyFile: " + e);
                e.printStackTrace();
            }
        }
        return result;
    }

    private Set<String> keysOfResourceBundle(String bundleNames) {
        String[] namesArr = bundleNames.split(":");
        if (namesArr == null) {
            System.err.println("Couldn't parse the resource bundles: <" + bundleNames + ">");
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String bundleName : namesArr) {
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName);
            if (bundle == null) {
                System.err.println("Couldn't find the resource bundle: <" + bundleName + "> for locale <" + Locale.getDefault() + ">");
                continue;
            }
            result.addAll(bundle.keySet());
        }
        return result;
    }

    @Override
    public GraphQualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new GraphQualifierHierarchy(factory, AnnotationUtils.fromClass(this.elements, Bottom.class));
    }

    protected class KeyLookupTreeAnnotator
    extends TreeAnnotator {
        AnnotationMirror theAnnot;

        public KeyLookupTreeAnnotator(BaseAnnotatedTypeFactory atf, Class<? extends Annotation> annot) {
            super(atf);
            this.theAnnot = AnnotationUtils.fromClass(PropertyKeyAnnotatedTypeFactory.this.elements, annot);
        }

        @Override
        public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
            if (!type.isAnnotatedInHierarchy(this.theAnnot) && tree.getKind() == Tree.Kind.STRING_LITERAL && PropertyKeyAnnotatedTypeFactory.strContains(PropertyKeyAnnotatedTypeFactory.this.lookupKeys, tree.getValue().toString())) {
                type.addAnnotation(this.theAnnot);
            }
            return super.visitLiteral(tree, type);
        }

        @Override
        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type) {
            type.removeAnnotation(this.theAnnot);
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
            type.removeAnnotation(this.theAnnot);
            return null;
        }
    }
}

