/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.units;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.tools.Diagnostic;
import org.checkerframework.checker.units.UnitsRelations;
import org.checkerframework.checker.units.UnitsRelationsDefault;
import org.checkerframework.checker.units.qual.A;
import org.checkerframework.checker.units.qual.Acceleration;
import org.checkerframework.checker.units.qual.Angle;
import org.checkerframework.checker.units.qual.Area;
import org.checkerframework.checker.units.qual.C;
import org.checkerframework.checker.units.qual.Current;
import org.checkerframework.checker.units.qual.K;
import org.checkerframework.checker.units.qual.Length;
import org.checkerframework.checker.units.qual.Luminance;
import org.checkerframework.checker.units.qual.Mass;
import org.checkerframework.checker.units.qual.MixedUnits;
import org.checkerframework.checker.units.qual.Prefix;
import org.checkerframework.checker.units.qual.Speed;
import org.checkerframework.checker.units.qual.Substance;
import org.checkerframework.checker.units.qual.Temperature;
import org.checkerframework.checker.units.qual.Time;
import org.checkerframework.checker.units.qual.UnitsBottom;
import org.checkerframework.checker.units.qual.UnitsMultiple;
import org.checkerframework.checker.units.qual.UnknownUnits;
import org.checkerframework.checker.units.qual.cd;
import org.checkerframework.checker.units.qual.degrees;
import org.checkerframework.checker.units.qual.g;
import org.checkerframework.checker.units.qual.h;
import org.checkerframework.checker.units.qual.km2;
import org.checkerframework.checker.units.qual.kmPERh;
import org.checkerframework.checker.units.qual.m;
import org.checkerframework.checker.units.qual.m2;
import org.checkerframework.checker.units.qual.mPERs;
import org.checkerframework.checker.units.qual.mPERs2;
import org.checkerframework.checker.units.qual.min;
import org.checkerframework.checker.units.qual.mm2;
import org.checkerframework.checker.units.qual.mol;
import org.checkerframework.checker.units.qual.radians;
import org.checkerframework.checker.units.qual.s;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TreeAnnotator;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;

public class UnitsAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    protected final AnnotationMirror mixedUnits;
    private Map<String, UnitsRelations> unitsRel;
    private final Map<String, AnnotationMirror> aliasMap;

    public UnitsAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker, false);
        this.mixedUnits = AnnotationUtils.fromClass(this.elements, MixedUnits.class);
        this.aliasMap = new HashMap<String, AnnotationMirror>();
        AnnotationMirror BOTTOM = AnnotationUtils.fromClass(this.elements, UnitsBottom.class);
        this.postInit();
        this.treeAnnotator.addTreeKind(Tree.Kind.NULL_LITERAL, BOTTOM);
        this.typeAnnotator.addTypeName(Void.class, BOTTOM);
    }

    protected Map<String, UnitsRelations> getUnitsRel() {
        if (this.unitsRel == null) {
            this.unitsRel = new HashMap<String, UnitsRelations>();
        }
        return this.unitsRel;
    }

    @Override
    public AnnotationMirror aliasedAnnotation(AnnotationMirror a) {
        String aname = a.getAnnotationType().toString();
        if (this.aliasMap.containsKey(aname)) {
            return this.aliasMap.get(aname);
        }
        for (AnnotationMirror annotationMirror : a.getAnnotationType().asElement().getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(UnitsMultiple.class.getCanonicalName())) continue;
            Class<?> theclass = AnnotationUtils.getElementValueClass(annotationMirror, "quantity", true);
            Prefix prefix = AnnotationUtils.getElementValueEnum(annotationMirror, "prefix", Prefix.class, true);
            AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, theclass);
            builder.setValue((CharSequence)"value", prefix);
            AnnotationMirror res = builder.build();
            this.aliasMap.put(aname, res);
            return res;
        }
        return super.aliasedAnnotation(a);
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        HashSet qualSet = new HashSet();
        String qualNames = this.checker.getOption("units");
        if (qualNames != null) {
            for (String qualName : qualNames.split(",")) {
                try {
                    Class<?> q = Class.forName(qualName);
                    qualSet.add(q);
                    this.addUnitsRelations(q);
                }
                catch (ClassNotFoundException e) {
                    String msg = "Could not find class for unit: " + qualName + ". Ignoring unit.";
                    this.checker.message(Diagnostic.Kind.WARNING, this.root, msg, new Object[0]);
                }
            }
        }
        this.getUnitsRel().put("org.checkerframework.checker.units.UnitsRelationsDefault", new UnitsRelationsDefault().init(this.processingEnv));
        qualSet.add(UnknownUnits.class);
        qualSet.add(Length.class);
        qualSet.add(m.class);
        qualSet.add(Time.class);
        qualSet.add(s.class);
        qualSet.add(min.class);
        qualSet.add(h.class);
        qualSet.add(Speed.class);
        qualSet.add(mPERs.class);
        qualSet.add(kmPERh.class);
        qualSet.add(Area.class);
        qualSet.add(mm2.class);
        qualSet.add(m2.class);
        qualSet.add(km2.class);
        qualSet.add(Current.class);
        qualSet.add(A.class);
        qualSet.add(Mass.class);
        qualSet.add(g.class);
        qualSet.add(Substance.class);
        qualSet.add(mol.class);
        qualSet.add(Luminance.class);
        qualSet.add(cd.class);
        qualSet.add(Temperature.class);
        qualSet.add(C.class);
        qualSet.add(K.class);
        qualSet.add(Acceleration.class);
        qualSet.add(mPERs2.class);
        qualSet.add(Angle.class);
        qualSet.add(degrees.class);
        qualSet.add(radians.class);
        qualSet.add(UnitsBottom.class);
        return Collections.unmodifiableSet(qualSet);
    }

    private void addUnitsRelations(Class<? extends Annotation> qual) {
        AnnotationMirror am = AnnotationUtils.fromClass(this.elements, qual);
        for (AnnotationMirror annotationMirror : am.getAnnotationType().asElement().getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(UnitsRelations.class.getCanonicalName())) continue;
            Class<?> theclass = AnnotationUtils.getElementValueClass(annotationMirror, "value", true);
            String classname = theclass.getCanonicalName();
            if (this.getUnitsRel().containsKey(classname)) continue;
            try {
                this.unitsRel.put(classname, ((UnitsRelations)theclass.newInstance()).init(this.processingEnv));
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new UnitsTreeAnnotator(this);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new UnitsQualifierHierarchy(factory, AnnotationUtils.fromClass(this.elements, UnitsBottom.class));
    }

    private AnnotationMirror stripValues(AnnotationMirror anno) {
        return AnnotationUtils.fromName(this.elements, anno.getAnnotationType().toString());
    }

    protected class UnitsQualifierHierarchy
    extends GraphQualifierHierarchy {
        public UnitsQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f, AnnotationMirror bottom) {
            super(f, bottom);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameIgnoringValues(lhs, rhs)) {
                return AnnotationUtils.areSame(lhs, rhs);
            }
            lhs = UnitsAnnotatedTypeFactory.this.stripValues(lhs);
            rhs = UnitsAnnotatedTypeFactory.this.stripValues(rhs);
            return super.isSubtype(rhs, lhs);
        }
    }

    private class UnitsTreeAnnotator
    extends TreeAnnotator {
        UnitsTreeAnnotator(UnitsAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type) {
            AnnotatedTypeMirror lht = UnitsAnnotatedTypeFactory.this.getAnnotatedType(node.getLeftOperand());
            AnnotatedTypeMirror rht = UnitsAnnotatedTypeFactory.this.getAnnotatedType(node.getRightOperand());
            Tree.Kind kind = node.getKind();
            AnnotationMirror bestres = null;
            for (UnitsRelations ur : UnitsAnnotatedTypeFactory.this.unitsRel.values()) {
                AnnotationMirror res = this.useUnitsRelation(kind, ur, lht, rht);
                if (bestres != null && res != null && !bestres.equals(res)) {
                    System.out.println("UnitsRelation mismatch, taking neither! Previous: " + bestres + " and current: " + res);
                    return null;
                }
                if (res == null) continue;
                bestres = res;
            }
            if (bestres != null) {
                type.addAnnotation(bestres);
            } else {
                switch (kind) {
                    case MINUS: 
                    case PLUS: {
                        if (lht.getAnnotations().equals(rht.getAnnotations())) {
                            type.addAnnotations(lht.getAnnotations());
                            break;
                        }
                        type.addAnnotation(UnitsAnnotatedTypeFactory.this.mixedUnits);
                        break;
                    }
                    case DIVIDE: {
                        if (!lht.getAnnotations().equals(rht.getAnnotations())) break;
                        break;
                    }
                    case MULTIPLY: {
                        if (this.noUnits(lht)) {
                            type.addAnnotations(rht.getAnnotations());
                            break;
                        }
                        if (this.noUnits(rht)) {
                            type.addAnnotations(lht.getAnnotations());
                            break;
                        }
                        type.addAnnotation(UnitsAnnotatedTypeFactory.this.mixedUnits);
                        break;
                    }
                    case REMAINDER: {
                        break;
                    }
                }
            }
            return null;
        }

        private boolean noUnits(AnnotatedTypeMirror t) {
            Set<AnnotationMirror> annos = t.getAnnotations();
            return annos.isEmpty() || annos.size() == 1 && AnnotationUtils.areSameByClass(annos.iterator().next(), UnknownUnits.class);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
            ExpressionTree var = node.getVariable();
            AnnotatedTypeMirror varType = UnitsAnnotatedTypeFactory.this.getAnnotatedType(var);
            type.replaceAnnotations(varType.getAnnotations());
            return super.visitCompoundAssignment(node, type);
        }

        private AnnotationMirror useUnitsRelation(Tree.Kind kind, UnitsRelations ur, AnnotatedTypeMirror lht, AnnotatedTypeMirror rht) {
            AnnotationMirror res = null;
            if (ur != null) {
                switch (kind) {
                    case DIVIDE: {
                        res = ur.division(lht, rht);
                        break;
                    }
                    case MULTIPLY: {
                        res = ur.multiplication(lht, rht);
                        break;
                    }
                }
            }
            return res;
        }
    }
}

