/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.reflection;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.reflection.ClassValAnnotatedTypeFactory;
import org.checkerframework.common.reflection.DefaultReflectionResolver;
import org.checkerframework.common.reflection.MethodValAnnotatedTypeFactory;
import org.checkerframework.common.reflection.ReflectionResolver;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.Pair;

public class ReflectionResolutionAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    private final ReflectionResolver resolver;
    private final List<BaseAnnotatedTypeFactory> factories = new LinkedList<BaseAnnotatedTypeFactory>();

    public ReflectionResolutionAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        boolean debug = Boolean.getBoolean("org.checkerframework.common.reflection.debug");
        this.resolver = new DefaultReflectionResolver(this, debug, checker.getProcessingEnvironment());
        this.factories.add(new ValueAnnotatedTypeFactory(checker));
        this.factories.add(new ClassValAnnotatedTypeFactory(checker, this));
        this.factories.add(new MethodValAnnotatedTypeFactory(checker, this));
        if (this.getClass().equals(ReflectionResolutionAnnotatedTypeFactory.class)) {
            this.postInit();
        }
    }

    @Override
    public void setRoot(CompilationUnitTree root) {
        super.setRoot(root);
        for (BaseAnnotatedTypeFactory factory : this.factories) {
            factory.setRoot(root);
        }
    }

    @Override
    protected void annotateImplicit(Tree tree, AnnotatedTypeMirror type, boolean iUseFlow) {
        super.annotateImplicit(tree, type, iUseFlow);
        if (iUseFlow) {
            for (BaseAnnotatedTypeFactory factory : this.factories) {
                factory.setUseFlow(iUseFlow);
                factory.annotateImplicit(tree, type);
            }
        }
    }

    @Override
    public AnnotationMirror getAnnotationMirror(Tree tree, Class<? extends Annotation> target) {
        AnnotationMirror mirror = AnnotationUtils.fromClass(this.elements, target);
        for (BaseAnnotatedTypeFactory factory : this.factories) {
            if (factory == null || !factory.isSupportedQualifier(mirror)) continue;
            AnnotatedTypeMirror atm = factory.getAnnotatedType(tree);
            return atm.getAnnotation(target);
        }
        return null;
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> methodFromUse(MethodInvocationTree tree) {
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = super.methodFromUse(tree);
        if (this.resolver.shouldResolveReflection(tree)) {
            mfuPair = this.resolver.resolveReflectiveCall(this, tree, mfuPair);
            AnnotatedTypeMirror.AnnotatedExecutableType method = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
            this.poly.annotate(tree, method);
        }
        return mfuPair;
    }
}

