/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.processing.AbstractProcessor;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.checkerframework.framework.test.TestInput;
import org.checkerframework.framework.test.TestRun;
import org.checkerframework.framework.test.TestUtilities;
import org.junit.Assert;

public abstract class CheckerTest {
    protected final String checkerName;
    protected final String checkerDir;
    protected final List<String> checkerOptions;

    public CheckerTest(Class<? extends AbstractProcessor> checker, String checkerDir, String ... checkerOptions) {
        this.checkerName = checker.getName();
        this.checkerDir = "tests" + File.separator + checkerDir;
        this.checkerOptions = Arrays.asList(checkerOptions);
    }

    protected void test(File testFile) {
        String expectedFileName = testFile.getPath().replace(".java", ".out");
        File expectedFile = new File(expectedFileName);
        this.runTest(expectedFile, testFile);
    }

    protected void test() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        assert (stack.length >= 3);
        String method = stack[2].getMethodName();
        if (!method.startsWith("test")) {
            throw new AssertionError((Object)"caller's name is invalid");
        }
        String[] parts = method.split("test");
        String testName = parts[parts.length - 1];
        this.test(new File(this.checkerDir + File.separator + testName + ".java"));
    }

    protected TestRun getTest(String ... files) {
        LinkedList<String> fileStrings = new LinkedList<String>();
        for (String s2 : files) {
            fileStrings.add(this.checkerDir + File.separator + s2);
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> tests = fileManager.getJavaFileObjectsFromStrings(fileStrings);
        TestRun pureCompilation = TestInput.compileAndCheck(this.checkerDir, tests, null, Collections.emptyList());
        if (!pureCompilation.getResult()) {
            String message = "Java file is not valid Java code: " + fileStrings;
            System.err.println(message);
            for (Diagnostic<? extends JavaFileObject> d : pureCompilation) {
                System.err.println(d);
            }
            throw new IllegalArgumentException(message);
        }
        return TestInput.compileAndCheck(this.checkerDir, tests, this.checkerName, this.checkerOptions);
    }

    protected TestRun getTest(File ... files) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> tests = fileManager.getJavaFileObjects(files);
        return TestInput.compileAndCheck(this.checkerDir, tests, this.checkerName, this.checkerOptions);
    }

    protected void runTest(File expectedFile, File ... javaFiles) {
        TestRun run = this.getTest(javaFiles);
        if (expectedFile.exists()) {
            CheckerTest.checkTestResult(run, expectedFile, TestUtilities.shouldSucceed(expectedFile), CheckerTest.joinPrefixed(javaFiles, " ", this.checkerDir + File.separator), this.checkerOptions);
        } else {
            List<String> expectedErrors = TestUtilities.expectedDiagnostics(javaFiles);
            CheckerTest.checkTestResult(run, expectedErrors, expectedErrors.isEmpty(), CheckerTest.joinPrefixed(javaFiles, " ", this.checkerDir + File.separator), this.checkerOptions);
        }
    }

    protected static void test(String checkerName, List<String> checkerOptions, File ... javaFiles) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> tests = fileManager.getJavaFileObjects(javaFiles);
        TestRun run = TestInput.compileAndCheck(null, tests, checkerName, checkerOptions);
        List<String> expectedErrors = TestUtilities.expectedDiagnostics(javaFiles);
        CheckerTest.checkTestResult(run, expectedErrors, expectedErrors.isEmpty(), CheckerTest.join(javaFiles, " "), checkerOptions);
    }

    protected void runTest(List<String> expectedErrors, boolean shouldSucceed, String ... javaFiles) {
        TestRun run = this.getTest(javaFiles);
        CheckerTest.checkTestResult(run, expectedErrors, shouldSucceed, CheckerTest.joinPrefixed(javaFiles, " ", this.checkerDir + File.separator), this.checkerOptions);
    }

    protected void runTest(String expectedFileName, boolean shouldSucceed, File ... javaFiles) {
        String expectedPath = this.checkerDir + File.separator + expectedFileName;
        File expectedFile = new File(expectedPath);
        this.runTest(expectedFile, shouldSucceed, javaFiles);
    }

    protected void runTest(File expectedFile, boolean shouldSucceed, File ... javaFiles) {
        TestRun run = this.getTest(javaFiles);
        CheckerTest.checkTestResult(run, expectedFile, shouldSucceed, CheckerTest.join(javaFiles, " "), this.checkerOptions);
    }

    protected static void checkTestResult(TestRun run, File expectedFile, boolean shouldSucceed, String javaFile, List<String> checkerOptions) {
        if (shouldSucceed) {
            CheckerTest.assertSuccess(run);
        } else {
            CheckerTest.assertFailure(run);
        }
        if (!shouldSucceed && !expectedFile.exists()) {
            throw new Error("Did not find expected file " + expectedFile);
        }
        if (shouldSucceed && !expectedFile.exists()) {
            return;
        }
        List<Diagnostic<? extends JavaFileObject>> list = run.getDiagnostics();
        CheckerTest.assertDiagnostics(list, expectedFile, javaFile, checkerOptions);
    }

    protected static void checkTestResult(TestRun run, List<String> expectedErrors, boolean shouldSucceed, String javaFile, List<String> checkerOptions) {
        String msg = null;
        msg = shouldSucceed ? CheckerTest.assertSuccess(run) : CheckerTest.assertFailure(run);
        List<Diagnostic<? extends JavaFileObject>> list = run.getDiagnostics();
        CheckerTest.assertDiagnostics(msg, list, expectedErrors, javaFile, checkerOptions);
    }

    protected static String assertSuccess(TestRun run) {
        if (run.getResult()) {
            return "";
        }
        return "The test run was not expected to issue errors/warnings, but it did.";
    }

    protected static String assertFailure(TestRun run) {
        if (run.getResult()) {
            return "The test run was expected to issue errors/warnings, but it did not.";
        }
        return "";
    }

    protected static void assertDiagnostics(List<Diagnostic<? extends JavaFileObject>> actualDiagnostics, File expectedDiagnosticFile, String javaFile, List<String> checkerOptions) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(expectedDiagnosticFile));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                int colonIndex;
                if (line.startsWith("#") || (colonIndex = line.indexOf(58)) == -1) continue;
                lines.add(line.substring(colonIndex).trim());
            }
            reader.close();
            CheckerTest.assertDiagnostics("", actualDiagnostics, lines, javaFile, checkerOptions);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static void assertDiagnostics(String msg, List<Diagnostic<? extends JavaFileObject>> actual_diagnostics, List<String> expected_diagnostics, String filename, List<String> checkerOptions) {
        LinkedList<String> expectedList = new LinkedList<String>();
        for (String string : expected_diagnostics) {
            expectedList.add(string);
        }
        LinkedList<String> resultsList = new LinkedList<String>();
        for (Diagnostic<? extends JavaFileObject> diagnostic : actual_diagnostics) {
            String result = diagnostic.toString().trim();
            if (result.contains("uses unchecked or unsafe operations.") || result.contains("Recompile with -Xlint:unchecked for details.") || result.endsWith(" declares unsafe vararg methods.") || result.contains("Recompile with -Xlint:varargs for details.")) continue;
            boolean nomsgtext = false;
            for (String string : checkerOptions) {
                if (!string.equals("-Anomsgtext")) continue;
                nomsgtext = true;
            }
            if (nomsgtext) {
                if (result.contains("\n")) {
                    result = result.substring(0, result.indexOf(10));
                }
                if (result.contains(".java:")) {
                    result = result.substring(result.indexOf(".java:") + 5).trim();
                }
            }
            resultsList.add(result);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(resultsList);
        linkedList.retainAll(expectedList);
        String string = "";
        if (linkedList.size() != expectedList.size()) {
            String string2 = linkedList.size() + " out of " + expectedList.size() + " expected diagnostics " + (linkedList.size() == 1 ? "was" : "were") + " found.\n";
        }
        boolean failed = false;
        LinkedList<String> notFoundList = new LinkedList<String>();
        notFoundList.addAll(expectedList);
        notFoundList.removeAll(resultsList);
        if (!notFoundList.isEmpty()) {
            void var8_13;
            failed = true;
            String message = notFoundList.size() == 1 ? "1 expected diagnostic was not found:\n" : notFoundList.size() + " expected diagnostics were not found:\n";
            String string3 = (String)var8_13 + "\n" + message;
            for (String a : notFoundList) {
                void var8_15;
                String string4 = (String)var8_15 + a + "\n";
            }
        }
        LinkedList<String> unexpectedList = new LinkedList<String>();
        unexpectedList.addAll(resultsList);
        unexpectedList.removeAll(expectedList);
        if (!unexpectedList.isEmpty()) {
            void var8_17;
            failed = true;
            String string5 = unexpectedList.size() == 1 ? "1 unexpected diagnostic was found:\n" : unexpectedList.size() + " unexpected diagnostics were found:\n";
            String string6 = (String)var8_17 + "\n" + string5;
            for (String a : unexpectedList) {
                void var8_19;
                String string7 = (String)var8_19 + a + "\n";
            }
        }
        if (failed) {
            void var8_21;
            void var12_34;
            if (msg != "") {
                String string8 = msg + "\n";
            } else {
                String string9 = "";
            }
            String string10 = (String)var12_34 + "While type-checking " + filename + ":\n";
            Assert.fail((String)(string10 + (String)var8_21));
        }
    }

    public static String join(Object[] a, String delim) {
        if (a.length == 0) {
            return "";
        }
        if (a.length == 1) {
            return String.valueOf(a[0]);
        }
        StringBuffer sb = new StringBuffer(String.valueOf(a[0]));
        for (int i = 1; i < a.length; ++i) {
            sb.append(delim).append(a[i]);
        }
        return sb.toString();
    }

    public static String joinPrefixed(Object[] a, String delim, String prefix) {
        if (a.length == 0) {
            return "";
        }
        if (a.length == 1) {
            return prefix + String.valueOf(a[0]);
        }
        StringBuffer sb = new StringBuffer(prefix + String.valueOf(a[0]));
        for (int i = 1; i < a.length; ++i) {
            sb.append(delim).append(prefix).append(a[i]);
        }
        return sb.toString();
    }
}

