/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TreeAnnotator;
import org.checkerframework.javacutil.Pair;

public class PropagationTreeAnnotator
extends TreeAnnotator {
    private final QualifierHierarchy qualHierarchy;

    public PropagationTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
        super(atypeFactory);
        this.qualHierarchy = atypeFactory.getQualifierHierarchy();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitNewArray(NewArrayTree tree, AnnotatedTypeMirror type) {
        void var6_11;
        assert (type.getKind() == TypeKind.ARRAY) : "PropagationTreeAnnotator.visitNewArray: should be an array type";
        AnnotatedTypeMirror componentType = ((AnnotatedTypeMirror.AnnotatedArrayType)type).getComponentType();
        Set<AnnotationMirror> prev = null;
        if (tree.getInitializers() != null && tree.getInitializers().size() != 0) {
            for (ExpressionTree expressionTree : tree.getInitializers()) {
                AnnotatedTypeMirror initType = this.atypeFactory.getAnnotatedType(expressionTree);
                Set<AnnotationMirror> annos = initType.getEffectiveAnnotations();
                prev = prev == null ? annos : this.qualHierarchy.leastUpperBounds(prev, annos);
            }
        } else {
            prev = componentType.getAnnotations();
        }
        assert (prev != null) : "PropagationTreeAnnotator.visitNewArray: violated assumption about qualifiers";
        Pair<Tree, AnnotatedTypeMirror> context = this.atypeFactory.getVisitorState().getAssignmentContext();
        if (context != null && context.second != null && context.second instanceof AnnotatedTypeMirror.AnnotatedArrayType) {
            AnnotatedTypeMirror contextComponentType = ((AnnotatedTypeMirror.AnnotatedArrayType)context.second).getComponentType();
            boolean prevIsSubtype = true;
            for (AnnotationMirror am : prev) {
                if (!contextComponentType.isAnnotatedInHierarchy(am) || this.qualHierarchy.isSubtype(am, contextComponentType.getAnnotationInHierarchy(am))) continue;
                prevIsSubtype = false;
            }
            if (contextComponentType.getKind() == componentType.getKind() && (prev.isEmpty() || !contextComponentType.getAnnotations().isEmpty() && prevIsSubtype)) {
                Set<AnnotationMirror> set = contextComponentType.getAnnotations();
            } else {
                Set<AnnotationMirror> set = prev;
            }
        } else {
            Set<AnnotationMirror> set = prev;
        }
        componentType.addMissingAnnotations((Iterable<? extends AnnotationMirror>)var6_11);
        return null;
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
        AnnotatedTypeMirror rhs = this.atypeFactory.getAnnotatedType(node.getExpression());
        AnnotatedTypeMirror lhs = this.atypeFactory.getAnnotatedType(node.getVariable());
        Set<? extends AnnotationMirror> lubs = this.qualHierarchy.leastUpperBounds(rhs.getAnnotations(), lhs.getAnnotations());
        type.addMissingAnnotations(lubs);
        return null;
    }

    @Override
    public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type) {
        AnnotatedTypeMirror a = this.atypeFactory.getAnnotatedType(node.getLeftOperand());
        AnnotatedTypeMirror b = this.atypeFactory.getAnnotatedType(node.getRightOperand());
        Set<? extends AnnotationMirror> lubs = this.qualHierarchy.leastUpperBounds(a.getEffectiveAnnotations(), b.getEffectiveAnnotations());
        type.addMissingAnnotations(lubs);
        return null;
    }

    @Override
    public Void visitUnary(UnaryTree node, AnnotatedTypeMirror type) {
        AnnotatedTypeMirror exp = this.atypeFactory.getAnnotatedType(node.getExpression());
        type.addMissingAnnotations(exp.getAnnotations());
        return null;
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, AnnotatedTypeMirror type) {
        AnnotatedTypeMirror exprType = this.atypeFactory.getAnnotatedType(node.getExpression());
        if (type.getKind() == TypeKind.TYPEVAR) {
            if (exprType.getKind() == TypeKind.TYPEVAR) {
                type.addMissingAnnotations(exprType.getAnnotations());
            }
        } else {
            type.addMissingAnnotations(exprType.getEffectiveAnnotations());
        }
        return null;
    }
}

