/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.fenum;

import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.fenum.qual.Fenum;
import org.checkerframework.checker.fenum.qual.FenumTop;
import org.checkerframework.checker.fenum.qual.FenumUnqualified;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.qual.Bottom;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;

public class FenumAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    protected AnnotationMirror FENUM;
    protected AnnotationMirror BOTTOM;

    public FenumAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.BOTTOM = AnnotationUtils.fromClass(this.elements, Bottom.class);
        this.FENUM = AnnotationUtils.fromClass(this.elements, Fenum.class);
        this.postInit();
        this.treeAnnotator.addTreeKind(Tree.Kind.NULL_LITERAL, this.BOTTOM);
        this.typeAnnotator.addTypeName(Void.class, this.BOTTOM);
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        HashSet qualSet = new HashSet();
        String qualNames = this.checker.getOption("quals");
        if (qualNames != null) {
            for (String qualName : qualNames.split(",")) {
                try {
                    Class<?> q = Class.forName(qualName);
                    qualSet.add(q);
                }
                catch (ClassNotFoundException e) {
                    this.checker.errorAbort("FenumChecker: could not load class for qualifier: " + qualName + "; ensure that your classpath is correct.");
                }
            }
        }
        qualSet.add(FenumTop.class);
        qualSet.add(Fenum.class);
        qualSet.add(FenumUnqualified.class);
        qualSet.add(Bottom.class);
        qualSet.addAll(super.createSupportedTypeQualifiers());
        return Collections.unmodifiableSet(qualSet);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new FenumQualifierHierarchy(factory);
    }

    protected class FenumQualifierHierarchy
    extends GraphQualifierHierarchy {
        public FenumQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory, FenumAnnotatedTypeFactory.this.BOTTOM);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameIgnoringValues(lhs, FenumAnnotatedTypeFactory.this.FENUM) && AnnotationUtils.areSameIgnoringValues(rhs, FenumAnnotatedTypeFactory.this.FENUM)) {
                return AnnotationUtils.areSame(lhs, rhs);
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, FenumAnnotatedTypeFactory.this.FENUM)) {
                lhs = FenumAnnotatedTypeFactory.this.FENUM;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, FenumAnnotatedTypeFactory.this.FENUM)) {
                rhs = FenumAnnotatedTypeFactory.this.FENUM;
            }
            return super.isSubtype(rhs, lhs);
        }
    }
}

