/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.Element;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;

public class PackageNameNode
extends Node {
    protected final Tree tree;
    protected final Element element;
    protected final PackageNameNode parent;

    public PackageNameNode(IdentifierTree tree) {
        super(InternalUtils.typeOf(tree));
        this.tree = tree;
        this.element = TreeUtils.elementFromUse(tree);
        this.parent = null;
    }

    public PackageNameNode(MemberSelectTree tree, PackageNameNode parent) {
        super(InternalUtils.typeOf(tree));
        this.tree = tree;
        this.element = TreeUtils.elementFromUse(tree);
        this.parent = parent;
    }

    public Element getElement() {
        return this.element;
    }

    public PackageNameNode getParent() {
        return this.parent;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitPackageName(this, p);
    }

    public String toString() {
        return this.getElement().getSimpleName().toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PackageNameNode)) {
            return false;
        }
        PackageNameNode other = (PackageNameNode)obj;
        if (this.getParent() == null) {
            return other.getParent() == null && this.getElement().equals(other.getElement());
        }
        return this.getParent().equals(other.getParent()) && this.getElement().equals(other.getElement());
    }

    public int hashCode() {
        if (this.parent == null) {
            return HashCodeUtils.hash((Object)this.getElement());
        }
        return HashCodeUtils.hash(this.getElement(), this.getParent());
    }

    @Override
    public Collection<Node> getOperands() {
        if (this.parent == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(this.parent);
    }
}

