/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.QualifierPolymorphism;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;

public class TypeHierarchy {
    private final QualifierHierarchy qualifierHierarchy;
    protected final Set<AnnotatedTypeMirror> visited;
    protected final BaseTypeChecker checker;

    public TypeHierarchy(BaseTypeChecker checker, QualifierHierarchy qualifierHierarchy) {
        this.qualifierHierarchy = qualifierHierarchy;
        this.visited = new HashSet<AnnotatedTypeMirror>();
        this.checker = checker;
    }

    public boolean isSubtype(AnnotatedTypeMirror rhs, AnnotatedTypeMirror lhs) {
        try {
            rhs = this.handlePolyAll(rhs);
            lhs = this.handlePolyAll(lhs);
            boolean result = this.isSubtypeImpl(rhs, lhs);
            this.visited.clear();
            return result;
        }
        catch (Throwable t) {
            ErrorReporter.errorAbort("Found exception during TypeHierarchy.isSubtype of " + rhs + " and " + lhs, t);
            return false;
        }
    }

    protected AnnotatedTypeMirror handlePolyAll(AnnotatedTypeMirror in) {
        AnnotatedTypeMirror out;
        Set<AnnotationMirror> outAnnos = AnnotationUtils.createAnnotationSet();
        Set<AnnotationMirror> inAnnos = in.getAnnotations();
        boolean hasPolyAll = false;
        for (AnnotationMirror am : inAnnos) {
            if (QualifierPolymorphism.isPolyAll(am)) {
                hasPolyAll = true;
                continue;
            }
            outAnnos.add(am);
        }
        if (hasPolyAll) {
            out = in.getCopy(false);
            out.addAnnotations(outAnnos);
            for (AnnotationMirror annotationMirror : this.qualifierHierarchy.getTopAnnotations()) {
                if (out.isAnnotatedInHierarchy(annotationMirror)) continue;
                AnnotationMirror poly = this.qualifierHierarchy.getPolymorphicAnnotation(annotationMirror);
                if (poly != null) {
                    out.addAnnotation(poly);
                    continue;
                }
                out.addAnnotation(this.qualifierHierarchy.getBottomAnnotation(annotationMirror));
            }
        } else {
            out = in;
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean isSubtypeImpl(AnnotatedTypeMirror rhs, AnnotatedTypeMirror lhs) {
        void var4_16;
        if (this.visited.contains(lhs)) {
            return true;
        }
        switch (rhs.getKind()) {
            case INTERSECTION: {
                for (AnnotatedTypeMirror annotatedTypeMirror : rhs.directSuperTypes()) {
                    if (!this.isSubtypeImpl(annotatedTypeMirror, lhs)) continue;
                    return true;
                }
                return false;
            }
            case UNION: {
                for (AnnotatedTypeMirror annotatedTypeMirror : ((AnnotatedTypeMirror.AnnotatedUnionType)rhs).getAlternatives()) {
                    if (this.isSubtypeImpl(annotatedTypeMirror, lhs)) continue;
                    return false;
                }
                return true;
            }
        }
        switch (lhs.getKind()) {
            case INTERSECTION: {
                for (AnnotatedTypeMirror annotatedTypeMirror : lhs.directSuperTypes()) {
                    if (this.isSubtypeImpl(rhs, annotatedTypeMirror)) continue;
                    return false;
                }
                return true;
            }
            case UNION: {
                for (AnnotatedTypeMirror annotatedTypeMirror : ((AnnotatedTypeMirror.AnnotatedUnionType)rhs).getAlternatives()) {
                    if (!this.isSubtypeImpl(annotatedTypeMirror, lhs)) continue;
                    return true;
                }
                return false;
            }
        }
        AnnotatedTypeMirror lhsBase = lhs;
        while (lhsBase.getKind() != rhs.getKind() && (lhsBase.getKind() == TypeKind.WILDCARD || lhsBase.getKind() == TypeKind.TYPEVAR)) {
            if (lhsBase.getKind() == TypeKind.WILDCARD && rhs.getKind() != TypeKind.WILDCARD) {
                Set<AnnotationMirror> bnd;
                AnnotatedTypeMirror.AnnotatedWildcardType annotatedWildcardType = (AnnotatedTypeMirror.AnnotatedWildcardType)lhsBase;
                if (annotatedWildcardType.isTypeArgHack()) {
                    bnd = ((AnnotatedTypeMirror.AnnotatedTypeVariable)annotatedWildcardType.getExtendsBound()).getEffectiveUpperBound();
                    return this.isSubtypeImpl(rhs, (AnnotatedTypeMirror)((Object)bnd));
                }
                if (annotatedWildcardType.getSuperBound() != null && this.isSubtypeImpl(rhs, annotatedWildcardType.getEffectiveSuperBound())) {
                    return true;
                }
                if (!annotatedWildcardType.getAnnotations().isEmpty() && this.qualifierHierarchy.isSubtype(lhs, rhs, rhs.getEffectiveAnnotations(), annotatedWildcardType.getAnnotations())) {
                    return true;
                }
                bnd = annotatedWildcardType.getEffectiveAnnotations();
                if (bnd.isEmpty()) {
                    return true;
                }
                Set<AnnotationMirror> bot = AnnotationUtils.createAnnotationSet();
                for (AnnotationMirror annotationMirror : bnd) {
                    bot.add(this.qualifierHierarchy.getBottomAnnotation(annotationMirror));
                }
                Set<AnnotationMirror> rhsAnnos = rhs.getEffectiveAnnotations();
                if (AnnotationUtils.areSame(bot, rhsAnnos)) {
                    return true;
                }
                if (!(bnd.isEmpty() || bnd.size() != bot.size() || this.qualifierHierarchy.isSubtype(lhs, rhs, (Collection<? extends AnnotationMirror>)bnd, bot) && this.qualifierHierarchy.isSubtype(lhs, rhs, rhs.getEffectiveAnnotations(), bot))) {
                    return false;
                }
                lhsBase = ((AnnotatedTypeMirror.AnnotatedWildcardType)lhsBase).getExtendsBound();
                this.visited.add(lhsBase);
                continue;
            }
            if (rhs.getKind() == TypeKind.WILDCARD) {
                rhs = ((AnnotatedTypeMirror.AnnotatedWildcardType)rhs).getExtendsBound();
                continue;
            }
            if (lhsBase.getKind() != TypeKind.TYPEVAR || rhs.getKind() == TypeKind.TYPEVAR) continue;
            AnnotatedTypeMirror.AnnotatedTypeVariable annotatedTypeVariable = (AnnotatedTypeMirror.AnnotatedTypeVariable)lhsBase;
            Set<AnnotationMirror> lAnnos = annotatedTypeVariable.getEffectiveLowerBound().getAnnotations();
            return this.qualifierHierarchy.isSubtype(lhs, rhs, rhs.getAnnotations(), lAnnos);
        }
        if (lhsBase.getKind() == TypeKind.WILDCARD && rhs.getKind() == TypeKind.WILDCARD) {
            return this.isSubtypeImpl(((AnnotatedTypeMirror.AnnotatedWildcardType)rhs).getEffectiveExtendsBound(), ((AnnotatedTypeMirror.AnnotatedWildcardType)lhsBase).getEffectiveExtendsBound());
        }
        AnnotatedTypeMirror annotatedTypeMirror = AnnotatedTypes.asSuper(this.checker.getProcessingEnvironment().getTypeUtils(), rhs.atypeFactory, rhs, lhsBase);
        if (annotatedTypeMirror == null) {
            AnnotatedTypeMirror annotatedTypeMirror2 = rhs;
        }
        if (!QualifierHierarchy.canHaveEmptyAnnotationSet(lhsBase)) {
            Set<AnnotationMirror> lhsAnnos = lhsBase.getEffectiveAnnotations();
            Set<AnnotationMirror> rhsAnnos = var4_16.getEffectiveAnnotations();
            assert (lhsAnnos.size() == this.qualifierHierarchy.getWidth()) : "Found invalid number of annotations on lhsBase " + lhsBase + "; comparing lhs: " + lhs + " rhs: " + rhs + "; expected number: " + this.qualifierHierarchy.getWidth();
            assert (rhsAnnos.size() == this.qualifierHierarchy.getWidth()) : "Found invalid number of annotations on rhsBase " + var4_16 + "; comparing lhs: " + lhs + " rhs: " + rhs + "; expected number: " + this.qualifierHierarchy.getWidth();
            if (!this.qualifierHierarchy.isSubtype(rhsAnnos, lhsAnnos)) {
                return false;
            }
        }
        if (lhs.getKind() == TypeKind.ARRAY && var4_16.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror rhsComponent = ((AnnotatedTypeMirror.AnnotatedArrayType)var4_16).getComponentType();
            AnnotatedTypeMirror lhsComponent = ((AnnotatedTypeMirror.AnnotatedArrayType)lhsBase).getComponentType();
            return this.isSubtypeAsArrayComponent(rhsComponent, lhsComponent);
        }
        if (lhsBase.getKind() == TypeKind.DECLARED && var4_16.getKind() == TypeKind.DECLARED) {
            return this.isSubtypeTypeArguments((AnnotatedTypeMirror.AnnotatedDeclaredType)var4_16, (AnnotatedTypeMirror.AnnotatedDeclaredType)lhsBase);
        }
        if (lhsBase.getKind() == TypeKind.TYPEVAR && var4_16.getKind() == TypeKind.TYPEVAR) {
            if (this.areCorrespondingTypeVariables(lhsBase, (AnnotatedTypeMirror)var4_16)) {
                Set<? extends AnnotationMirror> tops = this.qualifierHierarchy.getTopAnnotations();
                int good = 0;
                for (AnnotationMirror annotationMirror : tops) {
                    AnnotationMirror curRhsAnno = this.qualifierHierarchy.getAnnotationInHierarchy(var4_16.getAnnotations(), annotationMirror);
                    AnnotationMirror curLhsAnno = this.qualifierHierarchy.getAnnotationInHierarchy(lhsBase.getAnnotations(), annotationMirror);
                    if (curLhsAnno != null && curRhsAnno != null && this.qualifierHierarchy.isSubtype(curRhsAnno, curLhsAnno)) {
                        ++good;
                        continue;
                    }
                    if (curRhsAnno != null && curLhsAnno == null) {
                        AnnotationMirror bot = this.qualifierHierarchy.getBottomAnnotation(annotationMirror);
                        if (!AnnotationUtils.areSame(bot, curRhsAnno)) {
                            return false;
                        }
                        ++good;
                        continue;
                    }
                    if (curLhsAnno != null && curRhsAnno == null) {
                        if (this.qualifierHierarchy.isSubtype(((AnnotatedTypeMirror.AnnotatedTypeVariable)var4_16).getEffectiveUpperBound().getAnnotationInHierarchy(annotationMirror), curLhsAnno)) {
                            ++good;
                            continue;
                        }
                        return false;
                    }
                    if (curRhsAnno == null && curLhsAnno == null) {
                        ++good;
                        continue;
                    }
                    return false;
                }
                if (good == tops.size()) {
                    return true;
                }
            }
            AnnotatedTypeMirror rhsSuperClass = var4_16;
            while (rhsSuperClass.getKind() == TypeKind.TYPEVAR) {
                if (lhsBase.equals(rhsSuperClass)) {
                    return true;
                }
                rhsSuperClass = ((AnnotatedTypeMirror.AnnotatedTypeVariable)rhsSuperClass).getUpperBound();
            }
            Set<AnnotationMirror> las = ((AnnotatedTypeMirror.AnnotatedTypeVariable)lhsBase).getEffectiveLowerBound().getAnnotations();
            Set<AnnotationMirror> ras = ((AnnotatedTypeMirror.AnnotatedTypeVariable)var4_16).getEffectiveUpperBound().getAnnotations();
            return las.isEmpty() || this.qualifierHierarchy.isSubtype(ras, las);
        }
        if ((lhsBase.getKind().isPrimitive() || lhsBase.getKind() == TypeKind.DECLARED) && var4_16.getKind().isPrimitive()) {
            return true;
        }
        if (lhsBase.getKind() == TypeKind.NULL || var4_16.getKind() == TypeKind.NULL) {
            return true;
        }
        return lhsBase.getKind() == TypeKind.ARRAY;
    }

    private boolean areCorrespondingTypeVariables(AnnotatedTypeMirror lhs, AnnotatedTypeMirror rhs) {
        Symbol.TypeSymbol lTS;
        int i;
        Symbol.TypeSymbol lhstsym = ((Type)lhs.actualType).tsym;
        Symbol.TypeSymbol rhstsym = ((Type)rhs.actualType).tsym;
        List<Symbol.TypeVariableSymbol> lhsTPs = ((Symbol)lhstsym.getEnclosingElement()).getTypeParameters();
        List<Symbol.TypeVariableSymbol> rhsTPs = ((Symbol)rhstsym.getEnclosingElement()).getTypeParameters();
        if (lhsTPs.size() != rhsTPs.size()) {
            return false;
        }
        for (i = 0; i < lhsTPs.size() && !(lTS = (Symbol.TypeSymbol)lhsTPs.get(i)).equals(lhstsym); ++i) {
        }
        if (i < lhsTPs.size()) {
            return ((Symbol.TypeVariableSymbol)rhsTPs.get(i)).equals(rhstsym);
        }
        return false;
    }

    protected boolean ignoreRawTypeArguments(AnnotatedTypeMirror.AnnotatedDeclaredType rhs, AnnotatedTypeMirror.AnnotatedDeclaredType lhs) {
        return this.checker.hasOption("ignoreRawTypeArguments") && (rhs.wasRaw() || lhs.wasRaw());
    }

    protected boolean isSubtypeTypeArguments(AnnotatedTypeMirror.AnnotatedDeclaredType rhs, AnnotatedTypeMirror.AnnotatedDeclaredType lhs) {
        if (this.ignoreRawTypeArguments(rhs, lhs)) {
            return true;
        }
        java.util.List<AnnotatedTypeMirror> rhsTypeArgs = rhs.getTypeArguments();
        java.util.List<AnnotatedTypeMirror> lhsTypeArgs = lhs.getTypeArguments();
        if (rhsTypeArgs.isEmpty() || lhsTypeArgs.isEmpty()) {
            return true;
        }
        if (lhsTypeArgs.size() != rhsTypeArgs.size()) {
            return true;
        }
        for (int i = 0; i < lhsTypeArgs.size(); ++i) {
            if (this.isSubtypeAsTypeArgument(rhsTypeArgs.get(i), lhsTypeArgs.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean isSubtypeAsTypeArgument(AnnotatedTypeMirror rhs, AnnotatedTypeMirror lhs) {
        Set<AnnotationMirror> ras;
        if (lhs.getKind() == TypeKind.WILDCARD && rhs.getKind() != TypeKind.WILDCARD) {
            if (this.visited.contains(lhs)) {
                return true;
            }
            this.visited.add(lhs);
            if (!lhs.getAnnotations().isEmpty() && !lhs.getEffectiveAnnotations().equals(rhs.getEffectiveAnnotations())) {
                return false;
            }
            if ((lhs = ((AnnotatedTypeMirror.AnnotatedWildcardType)lhs).getEffectiveExtendsBound()) == null) {
                return true;
            }
            if (this.visited.contains(lhs)) {
                return true;
            }
            this.visited.add(lhs);
            return this.isSubtypeImpl(rhs, lhs);
        }
        if (lhs.getKind() == TypeKind.WILDCARD && rhs.getKind() == TypeKind.WILDCARD) {
            if (this.visited.contains(rhs)) {
                return true;
            }
            this.visited.add(rhs);
            if (((AnnotatedTypeMirror.AnnotatedWildcardType)lhs).getExtendsBoundField() == null || ((AnnotatedTypeMirror.AnnotatedWildcardType)lhs).getExtendsBoundField().getAnnotations().isEmpty()) {
                return true;
            }
            AnnotatedTypeMirror rhsbnd = ((AnnotatedTypeMirror.AnnotatedWildcardType)rhs).getEffectiveExtendsBound();
            AnnotatedTypeMirror lhsbnd = ((AnnotatedTypeMirror.AnnotatedWildcardType)lhs).getEffectiveExtendsBound();
            if (lhsbnd.getKind() == TypeKind.TYPEVAR && InternalUtils.isCaptured((TypeVariable)lhsbnd.getUnderlyingType())) {
                lhsbnd = ((AnnotatedTypeMirror.AnnotatedTypeVariable)lhsbnd).getEffectiveUpperBound();
            }
            if (this.visited.contains(rhsbnd)) {
                return true;
            }
            this.visited.add(rhsbnd);
            return this.isSubtypeImpl(rhsbnd, lhsbnd);
        }
        if (lhs.getKind() == TypeKind.TYPEVAR && rhs.getKind() != TypeKind.TYPEVAR) {
            if (this.visited.contains(lhs)) {
                return true;
            }
            this.visited.add(lhs);
            if (this.visited.contains(((AnnotatedTypeMirror.AnnotatedTypeVariable)lhs).getUpperBound())) {
                return true;
            }
            this.visited.add(((AnnotatedTypeMirror.AnnotatedTypeVariable)lhs).getUpperBound());
            return this.isSubtypeImpl(rhs, ((AnnotatedTypeMirror.AnnotatedTypeVariable)lhs).getUpperBound());
        }
        Set<AnnotationMirror> las = lhs.getAnnotations();
        if (!AnnotationUtils.areSame(las, ras = rhs.getAnnotations())) {
            return false;
        }
        if (lhs.getKind() == TypeKind.DECLARED && rhs.getKind() == TypeKind.DECLARED) {
            return this.isSubtypeTypeArguments((AnnotatedTypeMirror.AnnotatedDeclaredType)rhs, (AnnotatedTypeMirror.AnnotatedDeclaredType)lhs);
        }
        if (lhs.getKind() == TypeKind.ARRAY && rhs.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror rhsComponent = ((AnnotatedTypeMirror.AnnotatedArrayType)rhs).getComponentType();
            AnnotatedTypeMirror lhsComponent = ((AnnotatedTypeMirror.AnnotatedArrayType)lhs).getComponentType();
            return this.isSubtypeAsTypeArgument(rhsComponent, lhsComponent);
        }
        return true;
    }

    protected boolean isSubtypeAsArrayComponent(AnnotatedTypeMirror rhs, AnnotatedTypeMirror lhs) {
        if (lhs.getKind() == TypeKind.WILDCARD && rhs.getKind() != TypeKind.WILDCARD) {
            if (this.visited.contains(lhs)) {
                return true;
            }
            this.visited.add(lhs);
            if (!lhs.getAnnotations().isEmpty() && !lhs.getAnnotations().equals(rhs.getEffectiveAnnotations())) {
                return false;
            }
            if ((lhs = ((AnnotatedTypeMirror.AnnotatedWildcardType)lhs).isTypeArgHack() ? ((AnnotatedTypeMirror.AnnotatedTypeVariable)((AnnotatedTypeMirror.AnnotatedWildcardType)lhs).getEffectiveExtendsBound()).getEffectiveUpperBound() : ((AnnotatedTypeMirror.AnnotatedWildcardType)lhs).getEffectiveExtendsBound()) == null) {
                return true;
            }
            return this.isSubtypeImpl(rhs, lhs);
        }
        if (this.checker.hasOption("invariantArrays") && !AnnotationUtils.areSame(lhs.getAnnotations(), rhs.getAnnotations())) {
            return false;
        }
        return this.isSubtypeImpl(rhs, lhs);
    }
}

