package org.checkerframework.checker.lock.qual;

import org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import org.checkerframework.framework.qual.SubtypeOf;
import org.checkerframework.framework.qual.TypeQualifier;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * {@link LockPossiblyHeld} is a type annotation that indicates that the value is not
 * known to be @LockHeld (see {@link LockHeld}).
 *
 * @see LockHeld
 * @checker_framework_manual #lock-checker Lock Checker
 */
@TypeQualifier
@SubtypeOf({}) // The top type in the hierarchy
@Documented
@DefaultQualifierInHierarchy
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.TYPE_USE })
public @interface LockPossiblyHeld {
}