package org.checkerframework.common.value.qual;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import org.checkerframework.framework.qual.SubtypeOf;
import org.checkerframework.framework.qual.TypeQualifier;

/**
 * UnknownVal is a type annotation indicating that the value is not
 * known at compile type.
 * <p>
 * 
 * This annotation may not be written in source code; it is an implementation
 * detail of the Constant Value Checker.
 *
 * @checker_framework_manual #constant-value-checker Constant Value Checker
 */
@TypeQualifier
@SubtypeOf({})
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.TYPE_PARAMETER, ElementType.TYPE_USE })
@DefaultQualifierInHierarchy
public @interface UnknownVal {
}
