/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.experimental.tainting_qual_poly;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.experimental.tainting_qual_poly.Tainting;
import org.checkerframework.checker.experimental.tainting_qual_poly.TaintingQualifierHierarchy;
import org.checkerframework.checker.experimental.tainting_qual_poly.qual.Extends;
import org.checkerframework.checker.experimental.tainting_qual_poly.qual.MultiTainted;
import org.checkerframework.checker.experimental.tainting_qual_poly.qual.PolyTainting;
import org.checkerframework.checker.experimental.tainting_qual_poly.qual.Super;
import org.checkerframework.checker.experimental.tainting_qual_poly.qual.Tainted;
import org.checkerframework.checker.experimental.tainting_qual_poly.qual.TaintingParam;
import org.checkerframework.checker.experimental.tainting_qual_poly.qual.Untainted;
import org.checkerframework.checker.experimental.tainting_qual_poly.qual.Var;
import org.checkerframework.checker.experimental.tainting_qual_poly.qual.Wild;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.qualframework.poly.CombiningOperation;
import org.checkerframework.qualframework.poly.PolyQual;
import org.checkerframework.qualframework.poly.QualParams;
import org.checkerframework.qualframework.poly.QualifierParameterAnnotationConverter;
import org.checkerframework.qualframework.poly.Wildcard;

public class TaintingAnnotationConverter
implements QualifierParameterAnnotationConverter<Tainting> {
    private Map<String, Wildcard<Tainting>> lookup;
    private CombiningOperation<Tainting> lubOp = new CombiningOperation.Lub<Tainting>(new TaintingQualifierHierarchy());
    private static final Tainting BOTTOM = Tainting.UNTAINTED;
    private static final Tainting TOP = Tainting.TAINTED;
    private static final String MULTI_ANNO_NAME_PREFIX = MultiTainted.class.getPackage().getName() + ".Multi";
    private static final String DEFAULT_NAME = "Main";
    private static final String POLY_NAME = "_poly";

    private void mergeParams(Map<String, Wildcard<Tainting>> params, Map<String, Wildcard<Tainting>> newParams) {
        if (newParams == null) {
            return;
        }
        for (String name : newParams.keySet()) {
            if (!params.containsKey(name)) {
                params.put(name, newParams.get(name));
                continue;
            }
            Wildcard<Tainting> oldWild = params.get(name);
            Wildcard<Tainting> newWild = newParams.get(name);
            Wildcard<Tainting> combinedWild = oldWild.combineWith(newWild, this.lubOp, this.lubOp);
            params.put(name, combinedWild);
        }
    }

    private Map<String, Wildcard<Tainting>> fromAnnotation(AnnotationMirror anno) {
        String name = AnnotationUtils.annotationName(anno);
        if (name.startsWith(MULTI_ANNO_NAME_PREFIX)) {
            AnnotationMirror[] subAnnos;
            HashMap<String, Wildcard<Tainting>> result = new HashMap<String, Wildcard<Tainting>>();
            for (AnnotationMirror subAnno : subAnnos = AnnotationUtils.getElementValue(anno, "value", AnnotationMirror[].class, true)) {
                this.mergeParams(result, this.fromAnnotation(subAnno));
            }
            return result;
        }
        if (name.equals(Tainted.class.getName())) {
            String target = AnnotationUtils.getElementValue(anno, "target", String.class, true);
            return Collections.singletonMap(target, new Wildcard<Tainting>(Tainting.TAINTED));
        }
        if (name.equals(Untainted.class.getName())) {
            String target = AnnotationUtils.getElementValue(anno, "target", String.class, true);
            return Collections.singletonMap(target, new Wildcard<Tainting>(Tainting.UNTAINTED));
        }
        if (name.equals(Var.class.getName())) {
            String target = AnnotationUtils.getElementValue(anno, "target", String.class, true);
            String value = AnnotationUtils.getElementValue(anno, "value", String.class, true);
            Wildcard<PolyQual.QualVar<Tainting>> valueWild = new Wildcard<PolyQual.QualVar<Tainting>>(new PolyQual.QualVar<Tainting>(value, BOTTOM, TOP));
            return Collections.singletonMap(target, valueWild);
        }
        if (name.equals(PolyTainting.class.getName())) {
            String target = AnnotationUtils.getElementValue(anno, "target", String.class, true);
            Wildcard<PolyQual.QualVar<Tainting>> polyWild = new Wildcard<PolyQual.QualVar<Tainting>>(new PolyQual.QualVar<Tainting>(POLY_NAME, BOTTOM, TOP));
            return Collections.singletonMap(target, polyWild);
        }
        if (name.equals(Wild.class.getName())) {
            String target = AnnotationUtils.getElementValue(anno, "target", String.class, true);
            return Collections.singletonMap(target, new Wildcard<Tainting>(BOTTOM, TOP));
        }
        return null;
    }

    private boolean handleExtendsSuper(AnnotationMirror anno, Map<String, Wildcard<Tainting>> params) {
        String name = AnnotationUtils.annotationName(anno);
        if (name.startsWith(MULTI_ANNO_NAME_PREFIX)) {
            AnnotationMirror[] subAnnos;
            HashMap result = new HashMap();
            for (AnnotationMirror subAnno : subAnnos = AnnotationUtils.getElementValue(anno, "value", AnnotationMirror[].class, true)) {
                this.handleExtendsSuper(subAnno, params);
            }
            return subAnnos.length > 0;
        }
        if (name.equals(Extends.class.getName())) {
            String target = AnnotationUtils.getElementValue(anno, "target", String.class, true);
            Wildcard<Tainting> oldWild = params.get(target);
            Wildcard<PolyQual<Tainting>> newWild = new Wildcard<PolyQual<Tainting>>((PolyQual<Tainting>)new PolyQual.GroundQual<Tainting>(BOTTOM), oldWild.getUpperBound());
            params.put(target, newWild);
            return true;
        }
        if (name.equals(Super.class.getName())) {
            String target = AnnotationUtils.getElementValue(anno, "target", String.class, true);
            Wildcard<Tainting> oldWild = params.get(target);
            Wildcard<PolyQual.GroundQual<Tainting>> newWild = new Wildcard<PolyQual.GroundQual<Tainting>>((PolyQual.GroundQual<Tainting>)oldWild.getLowerBound(), new PolyQual.GroundQual<Tainting>(TOP));
            params.put(target, newWild);
            return true;
        }
        return false;
    }

    @Override
    public QualParams<Tainting> fromAnnotations(Collection<? extends AnnotationMirror> annos) {
        HashMap<String, Wildcard<Tainting>> params = new HashMap<String, Wildcard<Tainting>>();
        for (AnnotationMirror annotationMirror : annos) {
            this.mergeParams(params, this.fromAnnotation(annotationMirror));
        }
        for (AnnotationMirror annotationMirror : annos) {
            this.handleExtendsSuper(annotationMirror, params);
        }
        return params.isEmpty() ? null : new QualParams(params);
    }

    @Override
    public boolean isAnnotationSupported(AnnotationMirror anno) {
        String name = AnnotationUtils.annotationName(anno);
        return name.startsWith(MULTI_ANNO_NAME_PREFIX) || name.equals(Extends.class.getName()) || name.equals(Super.class.getName()) || this.fromAnnotation(anno) != null;
    }

    @Override
    public Set<String> getDeclaredParameters(Element elt) {
        HashSet<String> result = new HashSet<String>();
        for (TaintingParam a : (TaintingParam[])elt.getAnnotationsByType(TaintingParam.class)) {
            result.add(a.value());
        }
        switch (elt.getKind()) {
            case CLASS: 
            case INTERFACE: 
            case ENUM: {
                result.add(DEFAULT_NAME);
                break;
            }
            case CONSTRUCTOR: 
            case METHOD: {
                if (!this.hasPolyAnnotation((ExecutableElement)elt)) break;
                result.add(POLY_NAME);
                break;
            }
        }
        return result;
    }

    private boolean hasPolyAnnotation(ExecutableElement elt) {
        if (this.hasPolyAnnotation(elt.getReturnType())) {
            return true;
        }
        if (this.hasPolyAnnotation(elt.getReceiverType())) {
            return true;
        }
        for (VariableElement variableElement : elt.getParameters()) {
            if (!this.hasPolyAnnotation(variableElement.asType())) continue;
            return true;
        }
        return false;
    }

    private boolean hasPolyAnnotation(TypeMirror type) {
        if (type == null) {
            return false;
        }
        for (AnnotationMirror annotationMirror : type.getAnnotationMirrors()) {
            if (!AnnotationUtils.annotationName(annotationMirror).equals(PolyTainting.class.getName())) continue;
            return true;
        }
        return false;
    }
}

