/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.fenum;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import org.checkerframework.checker.fenum.FenumAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.TreeUtils;

public class FenumVisitor
extends BaseTypeVisitor<FenumAnnotatedTypeFactory> {
    public FenumVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    public Void visitBinary(BinaryTree node, Void p) {
        if (!TreeUtils.isStringConcatenation(node)) {
            AnnotatedTypeMirror lhs = ((FenumAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getLeftOperand());
            AnnotatedTypeMirror rhs = ((FenumAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getRightOperand());
            if (!((FenumAnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(lhs, rhs) && !((FenumAnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(rhs, lhs)) {
                this.checker.report(Result.failure("binary.type.incompatible", lhs, rhs), node);
            }
        }
        return (Void)super.visitBinary(node, p);
    }

    @Override
    public Void visitSwitch(SwitchTree node, Void p) {
        ExpressionTree expr = node.getExpression();
        AnnotatedTypeMirror exprType = ((FenumAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(expr);
        for (CaseTree caseTree : node.getCases()) {
            ExpressionTree realCaseExpr = caseTree.getExpression();
            if (realCaseExpr == null) continue;
            AnnotatedTypeMirror caseType = ((FenumAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(realCaseExpr);
            this.commonAssignmentCheck(exprType, caseType, caseTree, "switch.type.incompatible", false);
        }
        return (Void)super.visitSwitch(node, p);
    }

    @Override
    protected boolean checkConstructorInvocation(AnnotatedTypeMirror.AnnotatedDeclaredType dt, AnnotatedTypeMirror.AnnotatedExecutableType constructor, Tree src) {
        return true;
    }

    @Override
    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType declarationType, AnnotatedTypeMirror.AnnotatedDeclaredType useType, Tree tree) {
        return true;
    }
}

