/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.regex;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.regex.RegexAnalysis;
import org.checkerframework.checker.regex.RegexAnnotatedTypeFactory;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.IntegerLiteralNode;
import org.checkerframework.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAbstractTransfer;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.AnnotationUtils;

public class RegexTransfer
extends CFAbstractTransfer<CFValue, CFStore, RegexTransfer> {
    protected RegexAnalysis analysis;

    public RegexTransfer(RegexAnalysis analysis) {
        super(analysis);
        this.analysis = analysis;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitMethodInvocation(MethodInvocationNode n, TransferInput<CFValue, CFStore> in) {
        RegexAnnotatedTypeFactory factory = (RegexAnnotatedTypeFactory)this.analysis.getTypeFactory();
        TransferResult<CFValue, CFStore> result = super.visitMethodInvocation(n, in);
        MethodAccessNode target = n.getTarget();
        ExecutableElement method = target.getMethod();
        Node receiver = target.getReceiver();
        if (receiver instanceof ClassNameNode) {
            ClassNameNode cn = (ClassNameNode)receiver;
            String receiverName = cn.getElement().toString();
            if (this.isRegexUtil(receiverName) && method.toString().equals("isRegex(java.lang.String,int)")) {
                ConditionalTransferResult<CFValue, CFStore> newResult;
                block9: {
                    CFStore thenStore = result.getRegularStore();
                    CFStore elseStore = (CFStore)thenStore.copy();
                    newResult = new ConditionalTransferResult<CFValue, CFStore>(result.getResultValue(), thenStore, elseStore);
                    FlowExpressionParseUtil.FlowExpressionContext context = FlowExpressionParseUtil.buildFlowExprContextForUse(n, factory);
                    try {
                        FlowExpressions.Receiver firstParam = FlowExpressionParseUtil.parse("#1", context, factory.getPath(n.getTree()));
                        Node count = n.getArgument(1);
                        if (count instanceof IntegerLiteralNode) {
                            IntegerLiteralNode iln = (IntegerLiteralNode)count;
                            Integer groupCount = iln.getValue();
                            AnnotationMirror regexAnnotation = factory.createRegexAnnotation(groupCount);
                            thenStore.insertValue(firstParam, regexAnnotation);
                        } else {
                            AnnotationMirror regexAnnotation = AnnotationUtils.fromClass(factory.getElementUtils(), Regex.class);
                            thenStore.insertValue(firstParam, regexAnnotation);
                        }
                    }
                    catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError();
                    }
                }
                return newResult;
            }
            if (this.isRegexUtil(receiverName) && method.toString().equals("asRegex(java.lang.String,int)")) {
                AnnotationMirror regexAnnotation;
                Node count = n.getArgument(1);
                if (count instanceof IntegerLiteralNode) {
                    IntegerLiteralNode iln = (IntegerLiteralNode)count;
                    Integer groupCount = iln.getValue();
                    regexAnnotation = factory.createRegexAnnotation(groupCount);
                } else {
                    regexAnnotation = AnnotationUtils.fromClass(factory.getElementUtils(), Regex.class);
                }
                CFValue newResultValue = (CFValue)this.analysis.createSingleAnnotationValue(regexAnnotation, result.getResultValue().getType().getUnderlyingType());
                return new RegularTransferResult<CFValue, CFStore>(newResultValue, result.getRegularStore());
            }
        }
        return result;
    }

    private boolean isRegexUtil(String receiver) {
        return receiver.equals("RegexUtil") || receiver.endsWith(".RegexUtil");
    }
}

