/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.basetype;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.common.basetype.BaseTypeContext;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.SourceChecker;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.javacutil.ErrorReporter;

public abstract class BaseTypeChecker
extends SourceChecker
implements BaseTypeContext {
    protected BaseTypeVisitor<?> createSourceVisitor() {
        for (Class<?> checkerClass = this.getClass(); checkerClass != BaseTypeChecker.class; checkerClass = checkerClass.getSuperclass()) {
            String classToLoad = checkerClass.getName().replace("Checker", "Visitor").replace("Subchecker", "Visitor");
            BaseTypeVisitor result = (BaseTypeVisitor)BaseTypeChecker.invokeConstructorFor(classToLoad, new Class[]{BaseTypeChecker.class}, new Object[]{this});
            if (result == null) continue;
            return result;
        }
        return new BaseTypeVisitor(this);
    }

    @Override
    public Set<String> getSupportedLintOptions() {
        HashSet<String> lintSet = new HashSet<String>(super.getSupportedLintOptions());
        lintSet.add("cast");
        lintSet.add("cast:redundant");
        lintSet.add("cast:unsafe");
        return Collections.unmodifiableSet(lintSet);
    }

    public static <T> T invokeConstructorFor(String name, Class<?>[] paramTypes, Object[] args) {
        Class<?> cls = null;
        try {
            cls = Class.forName(name);
        }
        catch (Exception e) {
            return null;
        }
        assert (cls != null) : "reflectively loading " + name + " failed";
        try {
            Constructor<?> ctor = cls.getConstructor(paramTypes);
            return (T)ctor.newInstance(args);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                String msg;
                Throwable err = t.getCause();
                if (err instanceof SourceChecker.CheckerError) {
                    SourceChecker.CheckerError ce = (SourceChecker.CheckerError)err;
                    if (ce.userError) {
                        throw ce;
                    }
                    msg = err.getMessage();
                } else {
                    msg = err.toString();
                }
                ErrorReporter.errorAbort("InvocationTargetException when invoking constructor for class " + name + "; Underlying cause: " + msg, t);
            } else {
                ErrorReporter.errorAbort("Unexpected " + t.getClass().getSimpleName() + " for " + "class " + name + " when invoking the constructor; parameter types: " + Arrays.toString(paramTypes), t);
            }
            return null;
        }
    }

    @Override
    public BaseTypeContext getContext() {
        return this;
    }

    @Override
    public BaseTypeChecker getChecker() {
        return this;
    }

    public BaseTypeVisitor<?> getVisitor() {
        return (BaseTypeVisitor)super.getVisitor();
    }

    @Override
    public GenericAnnotatedTypeFactory<?, ?, ?, ?> getTypeFactory() {
        return ((BaseTypeVisitor)this.getVisitor()).getTypeFactory();
    }
}

