/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.flow;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.TypeAnnotationUtils;
import org.checkerframework.javacutil.trees.TreeBuilder;

public class CFTreeBuilder
extends TreeBuilder {
    public CFTreeBuilder(ProcessingEnvironment env) {
        super(env);
    }

    public Tree buildAnnotatedType(AnnotatedTypeMirror annotatedType) {
        return this.createAnnotatedType(annotatedType);
    }

    private Tree createAnnotatedType(AnnotatedTypeMirror annotatedType) {
        JCTree.JCExpression underlyingTypeTree;
        Set<AnnotationMirror> annotations = annotatedType.getAnnotations();
        List<JCTree.JCAnnotation> annotationTrees = List.nil();
        for (AnnotationMirror am : annotations) {
            Attribute.TypeCompound typeCompound = TypeAnnotationUtils.createTypeCompoundFromAnnotationMirror(this.env, am, TypeAnnotationUtils.unknownTAPosition(this.env.getSourceVersion()));
            JCTree.JCAnnotation annotationTree = this.maker.Annotation(typeCompound);
            JCTree.JCAnnotation typeAnnotationTree = this.maker.TypeAnnotation(annotationTree.getAnnotationType(), (List<JCTree.JCExpression>)annotationTree.getArguments());
            typeAnnotationTree.attribute = typeCompound;
            annotationTrees = annotationTrees.append(typeAnnotationTree);
        }
        switch (annotatedType.getKind()) {
            case BYTE: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.BYTE);
                break;
            }
            case CHAR: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.BYTE);
                break;
            }
            case SHORT: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.SHORT);
                break;
            }
            case INT: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.INT);
                break;
            }
            case LONG: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.LONG);
                break;
            }
            case FLOAT: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.FLOAT);
                break;
            }
            case DOUBLE: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.DOUBLE);
                break;
            }
            case BOOLEAN: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.BOOLEAN);
                break;
            }
            case VOID: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.VOID);
                break;
            }
            case TYPEVAR: {
                AnnotatedTypeMirror.AnnotatedTypeVariable variable = (AnnotatedTypeMirror.AnnotatedTypeVariable)annotatedType;
                TypeVariable underlyingTypeVar = variable.getUnderlyingType();
                underlyingTypeTree = this.maker.Ident((Symbol.TypeSymbol)underlyingTypeVar.asElement());
                break;
            }
            case WILDCARD: {
                AnnotatedTypeMirror.AnnotatedWildcardType wildcard = (AnnotatedTypeMirror.AnnotatedWildcardType)annotatedType;
                if (wildcard.getExtendsBound() != null) {
                    Tree annotatedExtendsBound = this.createAnnotatedType(wildcard.getExtendsBound());
                    underlyingTypeTree = this.maker.Wildcard(this.maker.TypeBoundKind(BoundKind.EXTENDS), (JCTree)annotatedExtendsBound);
                    break;
                }
                if (wildcard.getSuperBound() != null) {
                    Tree annotatedSuperBound = this.createAnnotatedType(wildcard.getSuperBound());
                    underlyingTypeTree = this.maker.Wildcard(this.maker.TypeBoundKind(BoundKind.SUPER), (JCTree)annotatedSuperBound);
                    break;
                }
                underlyingTypeTree = this.maker.Wildcard(this.maker.TypeBoundKind(BoundKind.UNBOUND), this.maker.TypeIdent(TypeTag.VOID));
                break;
            }
            case DECLARED: {
                underlyingTypeTree = this.maker.Type((Type)annotatedType.getUnderlyingType());
                if (!(underlyingTypeTree instanceof JCTree.JCTypeApply)) break;
                AnnotatedTypeMirror.AnnotatedDeclaredType annotatedDeclaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)annotatedType;
                List<JCTree.JCExpression> typeArgTrees = List.nil();
                for (AnnotatedTypeMirror arg : annotatedDeclaredType.getTypeArguments()) {
                    typeArgTrees = typeArgTrees.append((JCTree.JCExpression)this.createAnnotatedType(arg));
                }
                JCTree.JCExpression clazz = (JCTree.JCExpression)((JCTree.JCTypeApply)underlyingTypeTree).getType();
                underlyingTypeTree = this.maker.TypeApply(clazz, typeArgTrees);
                break;
            }
            case ARRAY: {
                AnnotatedTypeMirror.AnnotatedArrayType annotatedArrayType = (AnnotatedTypeMirror.AnnotatedArrayType)annotatedType;
                Tree annotatedComponentTree = this.createAnnotatedType(annotatedArrayType.getComponentType());
                underlyingTypeTree = this.maker.TypeArray((JCTree.JCExpression)annotatedComponentTree);
                break;
            }
            case ERROR: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.ERROR);
                break;
            }
            default: {
                assert (false) : "unexpected type: " + annotatedType;
                underlyingTypeTree = null;
            }
        }
        ((JCTree)underlyingTypeTree).setType((Type)annotatedType.getUnderlyingType());
        if (annotationTrees.isEmpty()) {
            return underlyingTypeTree;
        }
        JCTree.JCAnnotatedType annotatedTypeTree = this.maker.AnnotatedType(annotationTrees, underlyingTypeTree);
        annotatedTypeTree.setType((Type)annotatedType.getUnderlyingType());
        return annotatedTypeTree;
    }
}

