/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.io.File;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.checkerframework.framework.test.TestRun;

public class TestInput {
    private static final boolean debug = false;
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(null, null, null);
    private final Iterable<? extends JavaFileObject> files;
    private final Iterable<String> processors;
    private final List<String> options;
    private static final String OUTDIR = System.getProperty("tests.outputDir", "tests" + File.separator + "build" + File.separator + "testclasses");

    private TestInput(String checkerDir, Iterable<? extends JavaFileObject> files, Iterable<String> processors, List<String> options) {
        this.files = files;
        this.processors = processors;
        this.options = new LinkedList<String>();
        String classpath = System.getProperty("tests.classpath", "tests" + File.separator + "build");
        String globalclasspath = System.getProperty("java.class.path", "");
        this.options.add("-Xmaxerrs");
        this.options.add("9999");
        this.options.add("-g");
        this.options.add("-Xlint:unchecked");
        this.options.add("-XDrawDiagnostics");
        this.options.add("-AprintErrorStack");
        String jdkJarPath = System.getProperty("JDK_JAR");
        if (jdkJarPath != null && jdkJarPath.length() > 0) {
            this.options.add("-Xbootclasspath/p:" + jdkJarPath);
        }
        if (checkerDir != null && !checkerDir.isEmpty()) {
            this.options.add("-sourcepath");
            this.options.add(checkerDir);
        }
        this.options.add("-implicit:class");
        this.options.add("-d");
        this.options.add(OUTDIR);
        this.options.add("-classpath");
        this.options.add("build" + File.pathSeparator + "junit.jar" + File.pathSeparator + classpath + File.pathSeparator + globalclasspath);
        this.options.addAll(options);
    }

    private static void ensureExistance(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public TestRun run() {
        StringWriter output = new StringWriter();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaCompiler.CompilationTask task = this.compiler.getTask(output, this.fileManager, diagnostics, this.options, this.processors, this.files);
        Boolean result = task.call();
        return new TestRun(result, output.toString(), diagnostics.getDiagnostics());
    }

    public static TestRun compileAndCheck(String checkerDir, Iterable<? extends JavaFileObject> files, String processor, List<String> options) {
        LinkedList<String> opts = new LinkedList<String>();
        if (processor != null) {
            opts.add("-processor");
            opts.add(processor);
        }
        opts.addAll(options);
        TestInput input = new TestInput(checkerDir, files, Collections.emptySet(), opts);
        return input.run();
    }

    static {
        TestInput.ensureExistance(OUTDIR);
    }
}

