/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Elements;
import org.checkerframework.framework.qual.DefaultLocation;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.checkerframework.framework.qual.DefaultQualifiers;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

public class QualifierDefaults {
    private final Elements elements;
    private final AnnotatedTypeFactory atypeFactory;
    private final AMLocTreeSet absoluteDefaults = new AMLocTreeSet();
    private final Map<Element, AMLocTreeSet> elementDefaults = new IdentityHashMap<Element, AMLocTreeSet>();

    public QualifierDefaults(Elements elements, AnnotatedTypeFactory atypeFactory) {
        this.elements = elements;
        this.atypeFactory = atypeFactory;
    }

    public void addAbsoluteDefault(AnnotationMirror absoluteDefaultAnno, DefaultLocation location) {
        this.checkDuplicates(this.absoluteDefaults, absoluteDefaultAnno, location);
        this.absoluteDefaults.add(Pair.of(absoluteDefaultAnno, location));
    }

    public void addAbsoluteDefaults(AnnotationMirror absoluteDefaultAnno, DefaultLocation[] locations) {
        for (DefaultLocation location : locations) {
            this.addAbsoluteDefault(absoluteDefaultAnno, location);
        }
    }

    public void addElementDefault(Element elem, AnnotationMirror elementDefaultAnno, DefaultLocation location) {
        AMLocTreeSet prevset = this.elementDefaults.get(elem);
        if (prevset != null) {
            this.checkDuplicates(prevset, elementDefaultAnno, location);
        } else {
            prevset = new AMLocTreeSet();
        }
        prevset.add(Pair.of(elementDefaultAnno, location));
        this.elementDefaults.put(elem, prevset);
    }

    private void checkDuplicates(Set<Pair<AnnotationMirror, DefaultLocation>> prevset, AnnotationMirror newanno, DefaultLocation newloc) {
        for (Pair<AnnotationMirror, DefaultLocation> def : prevset) {
            AnnotationMirror anno = (AnnotationMirror)def.first;
            QualifierHierarchy qh = this.atypeFactory.getQualifierHierarchy();
            if (newanno.equals(anno) || !qh.isSubtype(newanno, qh.getTopAnnotation(anno)) || newloc != def.second) continue;
            ErrorReporter.errorAbort("Only one qualifier from a hierarchy can be the default! Existing: " + prevset + " and new: " + newanno);
        }
    }

    public void annotate(Element elt, AnnotatedTypeMirror type) {
        this.applyDefaultsElement(elt, type);
    }

    public void annotate(Tree tree, AnnotatedTypeMirror type) {
        this.applyDefaults(tree, type);
    }

    private Element nearestEnclosingExceptLocal(Tree tree) {
        TreePath path = this.atypeFactory.getPath(tree);
        if (path == null) {
            Element method = this.atypeFactory.getEnclosingMethod(tree);
            if (method != null) {
                return method;
            }
            return InternalUtils.symbol(tree);
        }
        Tree prev = null;
        for (Tree t : path) {
            switch (t.getKind()) {
                case VARIABLE: {
                    VariableTree vtree = (VariableTree)t;
                    ExpressionTree vtreeInit = vtree.getInitializer();
                    if (vtreeInit != null && prev == vtreeInit) {
                        VariableElement elt = TreeUtils.elementFromDeclaration((VariableTree)t);
                        DefaultQualifier d = elt.getAnnotation(DefaultQualifier.class);
                        DefaultQualifiers ds = elt.getAnnotation(DefaultQualifiers.class);
                        if (d == null && ds == null) break;
                    }
                    if (prev != null && prev.getKind() == Tree.Kind.MODIFIERS) break;
                    return TreeUtils.elementFromDeclaration((VariableTree)t);
                }
                case METHOD: {
                    return TreeUtils.elementFromDeclaration((MethodTree)t);
                }
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case ANNOTATION_TYPE: {
                    return TreeUtils.elementFromDeclaration((ClassTree)t);
                }
            }
            prev = t;
        }
        return null;
    }

    private void applyDefaults(Tree tree, AnnotatedTypeMirror type) {
        Element elt = null;
        switch (tree.getKind()) {
            case MEMBER_SELECT: {
                elt = TreeUtils.elementFromUse((MemberSelectTree)tree);
                break;
            }
            case IDENTIFIER: {
                elt = TreeUtils.elementFromUse((IdentifierTree)tree);
                break;
            }
            case METHOD_INVOCATION: {
                elt = TreeUtils.elementFromUse((MethodInvocationTree)tree);
                break;
            }
            default: {
                elt = this.nearestEnclosingExceptLocal(tree);
            }
        }
        if (elt != null) {
            this.applyDefaultsElement(elt, type);
        }
    }

    private Set<Pair<AnnotationMirror, DefaultLocation>> fromDefaultQualifier(DefaultQualifier dq) {
        Class<Annotation> cls;
        try {
            cls = dq.value();
        }
        catch (MirroredTypeException mte) {
            try {
                Class<?> clscast = Class.forName(mte.getTypeMirror().toString());
                cls = clscast;
            }
            catch (ClassNotFoundException e) {
                ErrorReporter.errorAbort("Could not load qualifier: " + e.getMessage(), e);
                cls = null;
            }
        }
        AnnotationMirror anno = AnnotationUtils.fromClass(this.elements, cls);
        if (anno == null) {
            return null;
        }
        if (!this.atypeFactory.isSupportedQualifier(anno)) {
            anno = this.atypeFactory.aliasedAnnotation(anno);
        }
        if (this.atypeFactory.isSupportedQualifier(anno)) {
            EnumSet<DefaultLocation[]> locations = EnumSet.of(dq.locations()[0], dq.locations());
            HashSet<Pair<AnnotationMirror, DefaultLocation>> ret = new HashSet<Pair<AnnotationMirror, DefaultLocation>>(locations.size());
            for (DefaultLocation defaultLocation : locations) {
                ret.add(Pair.of(anno, defaultLocation));
            }
            return ret;
        }
        return null;
    }

    private AMLocTreeSet defaultsAt(Element elt) {
        DefaultQualifiers ds;
        if (elt == null) {
            return AMLocTreeSet.EMPTY_SET;
        }
        if (this.elementDefaults.containsKey(elt)) {
            return this.elementDefaults.get(elt);
        }
        AMLocTreeSet qualifiers = null;
        DefaultQualifier d = elt.getAnnotation(DefaultQualifier.class);
        if (d != null) {
            qualifiers = new AMLocTreeSet();
            DefaultQualifier[] p = this.fromDefaultQualifier(d);
            if (p != null) {
                qualifiers.addAll(p);
            }
        }
        if ((ds = elt.getAnnotation(DefaultQualifiers.class)) != null) {
            if (qualifiers == null) {
                qualifiers = new AMLocTreeSet();
            }
            for (DefaultQualifier d2 : ds.value()) {
                Set<Pair<AnnotationMirror, DefaultLocation>> p = this.fromDefaultQualifier(d2);
                if (p == null) continue;
                qualifiers.addAll(p);
            }
        }
        Element parent = elt.getKind() == ElementKind.PACKAGE ? ((Symbol)elt).owner : elt.getEnclosingElement();
        AMLocTreeSet parentDefaults = this.defaultsAt(parent);
        if (qualifiers == null || qualifiers.isEmpty()) {
            qualifiers = parentDefaults;
        } else {
            qualifiers.addAll(parentDefaults);
        }
        if (qualifiers != null && !qualifiers.isEmpty()) {
            this.elementDefaults.put(elt, qualifiers);
            return qualifiers;
        }
        return AMLocTreeSet.EMPTY_SET;
    }

    private void applyDefaultsElement(Element annotationScope, AnnotatedTypeMirror type) {
        AMLocTreeSet defaults = this.defaultsAt(annotationScope);
        DefaultApplierElement applier = new DefaultApplierElement(this.atypeFactory, annotationScope, type);
        for (Pair def : defaults) {
            applier.apply((AnnotationMirror)def.first, (DefaultLocation)((Object)def.second));
        }
        for (Pair def : this.absoluteDefaults) {
            applier.apply((AnnotationMirror)def.first, (DefaultLocation)((Object)def.second));
        }
    }

    public static class DefaultApplierElement {
        private final AnnotatedTypeFactory atypeFactory;
        private final Element scope;
        private final AnnotatedTypeMirror type;
        private DefaultLocation location;
        private final DefaultApplierElementImpl impl;

        public DefaultApplierElement(AnnotatedTypeFactory atypeFactory, Element scope, AnnotatedTypeMirror type) {
            this.atypeFactory = atypeFactory;
            this.scope = scope;
            this.type = type;
            this.impl = new DefaultApplierElementImpl();
        }

        public void apply(AnnotationMirror toApply, DefaultLocation location) {
            this.location = location;
            this.impl.visit(this.type, toApply);
        }

        private static boolean shouldBeAnnotated(AnnotatedTypeMirror type, AnnotationMirror qual) {
            return type != null && type.getKind() != TypeKind.NONE && type.getKind() != TypeKind.WILDCARD && type.getKind() != TypeKind.TYPEVAR && !(type instanceof AnnotatedTypeMirror.AnnotatedNoType);
        }

        private static void doApply(AnnotatedTypeMirror type, AnnotationMirror qual) {
            List<AnnotatedTypeMirror.AnnotatedDeclaredType> sups;
            if (!DefaultApplierElement.shouldBeAnnotated(type, qual)) {
                return;
            }
            if (!type.isAnnotatedInHierarchy(qual)) {
                type.addAnnotation(qual);
            }
            if (type.getKind() == TypeKind.INTERSECTION && (sups = ((AnnotatedTypeMirror.AnnotatedIntersectionType)type).directSuperTypesField()) != null) {
                for (AnnotatedTypeMirror annotatedTypeMirror : sups) {
                    if (annotatedTypeMirror.isAnnotatedInHierarchy(qual)) continue;
                    annotatedTypeMirror.addAnnotation(qual);
                }
            }
        }

        private class DefaultApplierElementImpl
        extends AnnotatedTypeScanner<Void, AnnotationMirror> {
            private boolean isTypeVarExtendsImplicit = false;
            private boolean isTypeVarExtendsExplicit = false;

            private DefaultApplierElementImpl() {
            }

            @Override
            public Void scan(AnnotatedTypeMirror t, AnnotationMirror qual) {
                if (!DefaultApplierElement.shouldBeAnnotated(t, qual)) {
                    return (Void)super.scan(t, qual);
                }
                switch (DefaultApplierElement.this.location) {
                    case FIELD: {
                        if (DefaultApplierElement.this.scope.getKind() != ElementKind.FIELD || t != DefaultApplierElement.this.type) break;
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    case LOCAL_VARIABLE: {
                        if (DefaultApplierElement.this.scope.getKind() != ElementKind.LOCAL_VARIABLE || t != DefaultApplierElement.this.type) break;
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    case RESOURCE_VARIABLE: {
                        if (DefaultApplierElement.this.scope.getKind() != ElementKind.RESOURCE_VARIABLE || t != DefaultApplierElement.this.type) break;
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    case EXCEPTION_PARAMETER: {
                        if (DefaultApplierElement.this.scope.getKind() != ElementKind.EXCEPTION_PARAMETER || t != DefaultApplierElement.this.type) break;
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    case PARAMETERS: {
                        if (DefaultApplierElement.this.scope.getKind() == ElementKind.PARAMETER && t == DefaultApplierElement.this.type) {
                            DefaultApplierElement.doApply(t, qual);
                            break;
                        }
                        if (DefaultApplierElement.this.scope.getKind() != ElementKind.METHOD && DefaultApplierElement.this.scope.getKind() != ElementKind.CONSTRUCTOR || t.getKind() != TypeKind.EXECUTABLE || t != DefaultApplierElement.this.type) break;
                        for (AnnotatedTypeMirror atm : ((AnnotatedTypeMirror.AnnotatedExecutableType)t).getParameterTypes()) {
                            DefaultApplierElement.doApply(atm, qual);
                        }
                        break;
                    }
                    case RECEIVERS: {
                        if (DefaultApplierElement.this.scope.getKind() == ElementKind.PARAMETER && t == DefaultApplierElement.this.type && "this".equals(DefaultApplierElement.this.scope.getSimpleName())) {
                            DefaultApplierElement.doApply(t, qual);
                            break;
                        }
                        if (DefaultApplierElement.this.scope.getKind() != ElementKind.METHOD || t.getKind() != TypeKind.EXECUTABLE || t != DefaultApplierElement.this.type) break;
                        DefaultApplierElement.doApply(((AnnotatedTypeMirror.AnnotatedExecutableType)t).getReceiverType(), qual);
                        break;
                    }
                    case RETURNS: {
                        if (DefaultApplierElement.this.scope.getKind() != ElementKind.METHOD || t.getKind() != TypeKind.EXECUTABLE || t != DefaultApplierElement.this.type) break;
                        DefaultApplierElement.doApply(((AnnotatedTypeMirror.AnnotatedExecutableType)t).getReturnType(), qual);
                        break;
                    }
                    case IMPLICIT_UPPER_BOUNDS: {
                        if (!this.isTypeVarExtendsImplicit) break;
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    case EXPLICIT_UPPER_BOUNDS: {
                        if (!this.isTypeVarExtendsExplicit) break;
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    case UPPER_BOUNDS: {
                        if (!this.isTypeVarExtendsImplicit && !this.isTypeVarExtendsExplicit) break;
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    case OTHERWISE: 
                    case ALL: {
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    default: {
                        ErrorReporter.errorAbort("QualifierDefaults.DefaultApplierElement: unhandled location: " + (Object)((Object)DefaultApplierElement.this.location));
                        return null;
                    }
                }
                return (Void)super.scan(t, qual);
            }

            @Override
            public void reset() {
                super.reset();
                ((DefaultApplierElement)DefaultApplierElement.this).impl.isTypeVarExtendsImplicit = false;
                ((DefaultApplierElement)DefaultApplierElement.this).impl.isTypeVarExtendsExplicit = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotationMirror qual) {
                if (this.visitedNodes.containsKey(type)) {
                    return (Void)this.visitedNodes.get(type);
                }
                Void r = this.scan(type.getLowerBoundField(), qual);
                this.visitedNodes.put(type, r);
                Element tvel = type.getUnderlyingType().asElement();
                TreePath treepath = DefaultApplierElement.this.atypeFactory.getTreeUtils().getPath(tvel);
                Tree tree = treepath == null ? null : treepath.getLeaf();
                boolean prevIsTypeVarExtendsImplicit = this.isTypeVarExtendsImplicit;
                boolean prevIsTypeVarExtendsExplicit = this.isTypeVarExtendsExplicit;
                if (tree == null) {
                    this.isTypeVarExtendsImplicit = false;
                    this.isTypeVarExtendsExplicit = true;
                } else if (tree.getKind() == Tree.Kind.TYPE_PARAMETER) {
                    TypeParameterTree tptree = (TypeParameterTree)tree;
                    List<? extends Tree> bnds = tptree.getBounds();
                    if (bnds != null && !bnds.isEmpty()) {
                        this.isTypeVarExtendsImplicit = false;
                        this.isTypeVarExtendsExplicit = true;
                    } else {
                        this.isTypeVarExtendsImplicit = true;
                        this.isTypeVarExtendsExplicit = false;
                    }
                }
                try {
                    r = this.scanAndReduce(type.getUpperBoundField(), qual, r);
                }
                finally {
                    this.isTypeVarExtendsImplicit = prevIsTypeVarExtendsImplicit;
                    this.isTypeVarExtendsExplicit = prevIsTypeVarExtendsExplicit;
                }
                this.visitedNodes.put(type, r);
                return r;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotationMirror qual) {
                Void r;
                if (this.visitedNodes.containsKey(type)) {
                    return (Void)this.visitedNodes.get(type);
                }
                boolean prevIsTypeVarExtendsImplicit = this.isTypeVarExtendsImplicit;
                boolean prevIsTypeVarExtendsExplicit = this.isTypeVarExtendsExplicit;
                Type.WildcardType wc = (Type.WildcardType)type.getUnderlyingType();
                if (wc.isUnbound() && wc.bound != null) {
                    Tree tree;
                    Element tvel = wc.bound.asElement();
                    TreePath treepath = DefaultApplierElement.this.atypeFactory.getTreeUtils().getPath(tvel);
                    Tree tree2 = tree = treepath == null ? null : treepath.getLeaf();
                    if (tree != null && tree.getKind() == Tree.Kind.TYPE_PARAMETER) {
                        TypeParameterTree tptree = (TypeParameterTree)tree;
                        List<? extends Tree> bnds = tptree.getBounds();
                        if (bnds != null && !bnds.isEmpty()) {
                            this.isTypeVarExtendsImplicit = false;
                            this.isTypeVarExtendsExplicit = true;
                        } else {
                            this.isTypeVarExtendsImplicit = true;
                            this.isTypeVarExtendsExplicit = false;
                        }
                    } else {
                        this.isTypeVarExtendsImplicit = false;
                        this.isTypeVarExtendsExplicit = true;
                    }
                } else {
                    this.isTypeVarExtendsImplicit = false;
                    this.isTypeVarExtendsExplicit = true;
                }
                try {
                    r = this.scan(type.getExtendsBoundField(), qual);
                }
                finally {
                    this.isTypeVarExtendsImplicit = prevIsTypeVarExtendsImplicit;
                    this.isTypeVarExtendsExplicit = prevIsTypeVarExtendsExplicit;
                }
                this.visitedNodes.put(type, r);
                r = this.scanAndReduce(type.getSuperBoundField(), qual, r);
                this.visitedNodes.put(type, r);
                return r;
            }
        }
    }

    private static class AMLocTreeSet
    extends TreeSet<Pair<AnnotationMirror, DefaultLocation>> {
        public static final AMLocTreeSet EMPTY_SET = new AMLocTreeSet();

        public AMLocTreeSet() {
            super(new AMLocComparator());
        }

        static class AMLocComparator
        implements Comparator<Pair<AnnotationMirror, DefaultLocation>> {
            AMLocComparator() {
            }

            @Override
            public int compare(Pair<AnnotationMirror, DefaultLocation> o1, Pair<AnnotationMirror, DefaultLocation> o2) {
                int snd = ((DefaultLocation)((Object)o1.second)).compareTo((Enum)o2.second);
                if (snd == 0) {
                    return AnnotationUtils.annotationOrdering().compare((AnnotationMirror)o1.first, (AnnotationMirror)o2.first);
                }
                return snd;
            }
        }
    }
}

