/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.flow;

import java.util.Collection;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.dataflow.util.HashCodeUtils;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TypesUtils;

public abstract class CFAbstractValue<V extends CFAbstractValue<V>>
implements AbstractValue<V> {
    protected final CFAbstractAnalysis<V, ?, ?> analysis;
    protected final TypeHierarchy typeHierarchy;
    protected final AnnotatedTypeMirror type;

    public CFAbstractValue(CFAbstractAnalysis<V, ?, ?> analysis, AnnotatedTypeMirror type) {
        assert (AnnotatedTypes.isValidType(analysis.qualifierHierarchy, type)) : "Encountered invalid type: " + type.toString(true);
        this.analysis = analysis;
        this.type = type;
        this.typeHierarchy = analysis.getTypeHierarchy();
    }

    @Pure
    public AnnotatedTypeMirror getType() {
        return this.type;
    }

    @Override
    public V leastUpperBound(@Nullable V other) {
        if (other == null) {
            CFAbstractValue v = this;
            return (V)v;
        }
        AnnotatedTypeMirror otherType = ((CFAbstractValue)other).getType();
        AnnotatedTypeMirror type = this.getType();
        AnnotatedTypeMirror lubAnnotatedType = this.leastUpperBound(type, otherType);
        return this.analysis.createAbstractValue(lubAnnotatedType);
    }

    public AnnotatedTypeMirror leastUpperBound(AnnotatedTypeMirror type, AnnotatedTypeMirror otherType) {
        Set<AnnotationMirror> annos2;
        Set<AnnotationMirror> annos1;
        AnnotatedTypeMirror lubAnnotatedType;
        GenericAnnotatedTypeFactory<V, ?, ?, CFAbstractAnalysis<V, ?, ?>> factory = this.analysis.getTypeFactory();
        ProcessingEnvironment processingEnv = factory.getProcessingEnv();
        QualifierHierarchy qualifierHierarchy = factory.getQualifierHierarchy();
        if (type.getKind() == TypeKind.ARRAY && otherType.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType a = (AnnotatedTypeMirror.AnnotatedArrayType)type;
            AnnotatedTypeMirror.AnnotatedArrayType b = (AnnotatedTypeMirror.AnnotatedArrayType)otherType;
            AnnotatedTypeMirror componentLub = this.leastUpperBound(a.getComponentType(), b.getComponentType());
            if (componentLub.getUnderlyingType().getKind() == TypeKind.NONE) {
                Elements elements = this.analysis.getEnv().getElementUtils();
                TypeMirror underlyingType = elements.getTypeElement("java.lang.Object").asType();
                lubAnnotatedType = AnnotatedTypeMirror.createType(underlyingType, factory, false);
            } else {
                ArrayType underlyingType = TypesUtils.createArrayType(this.analysis.getTypes(), componentLub.getUnderlyingType());
                lubAnnotatedType = AnnotatedTypeMirror.createType(underlyingType, factory, false);
                AnnotatedTypeMirror.AnnotatedArrayType aLubAnnotatedType = (AnnotatedTypeMirror.AnnotatedArrayType)lubAnnotatedType;
                aLubAnnotatedType.setComponentType(componentLub);
            }
        } else {
            TypeMirror lubType = InternalUtils.leastUpperBound(processingEnv, type.getUnderlyingType(), otherType.getUnderlyingType());
            lubAnnotatedType = AnnotatedTypeMirror.createType(lubType, factory, false);
        }
        if (QualifierHierarchy.canHaveEmptyAnnotationSet(lubAnnotatedType)) {
            annos1 = type.getAnnotations();
            annos2 = otherType.getAnnotations();
        } else {
            annos1 = type.getEffectiveAnnotations();
            annos2 = otherType.getEffectiveAnnotations();
        }
        lubAnnotatedType.addAnnotations(qualifierHierarchy.leastUpperBounds(type, otherType, annos1, annos2));
        TypeKind kind = lubAnnotatedType.getKind();
        if (kind == TypeKind.WILDCARD) {
            AnnotatedTypeMirror.AnnotatedWildcardType wLubAnnotatedType = (AnnotatedTypeMirror.AnnotatedWildcardType)lubAnnotatedType;
            AnnotatedTypeMirror extendsBound = wLubAnnotatedType.getExtendsBound();
            extendsBound.clearAnnotations();
            Collection<AnnotationMirror> extendsBound1 = CFAbstractValue.getUpperBound(type);
            Collection<AnnotationMirror> extendsBound2 = CFAbstractValue.getUpperBound(otherType);
            extendsBound.addAnnotations(qualifierHierarchy.leastUpperBounds(extendsBound1, extendsBound2));
        } else if (kind == TypeKind.TYPEVAR) {
            AnnotatedTypeMirror.AnnotatedTypeVariable tLubAnnotatedType = (AnnotatedTypeMirror.AnnotatedTypeVariable)lubAnnotatedType;
            AnnotatedTypeMirror upperBound = tLubAnnotatedType.getUpperBound();
            Collection<AnnotationMirror> upperBound1 = CFAbstractValue.getUpperBound(type);
            Collection<AnnotationMirror> upperBound2 = CFAbstractValue.getUpperBound(otherType);
            if (upperBound1.size() != 0 && upperBound2.size() != 0) {
                upperBound.clearAnnotations();
                upperBound.addAnnotations(qualifierHierarchy.leastUpperBounds(upperBound1, upperBound2));
            }
            if ((type.getKind() != TypeKind.TYPEVAR || otherType.getKind() != TypeKind.TYPEVAR) && otherType.getKind() == TypeKind.NULL) {
                if (type.getKind() != TypeKind.TYPEVAR) {
                    AnnotatedTypeMirror tmp = otherType;
                    otherType = type;
                    type = tmp;
                }
                lubAnnotatedType.clearAnnotations();
                lubAnnotatedType.addAnnotations(type.getAnnotations());
                for (AnnotationMirror annotationMirror : qualifierHierarchy.getTopAnnotations()) {
                    AnnotationMirror o = otherType.getAnnotationInHierarchy(annotationMirror);
                    assert (o != null) : "null should have all annotations.";
                    if (AnnotationUtils.areSame(o, qualifierHierarchy.getBottomAnnotation(annotationMirror))) continue;
                    lubAnnotatedType.replaceAnnotation(qualifierHierarchy.leastUpperBound(o, type.getEffectiveAnnotationInHierarchy(annotationMirror)));
                }
            }
        } else if (kind == TypeKind.ARRAY && (type.getKind() != TypeKind.ARRAY || otherType.getKind() != TypeKind.ARRAY)) {
            AnnotatedTypeMirror.AnnotatedArrayType array;
            AnnotatedTypeMirror.AnnotatedArrayType aLubAnnotatedType = (AnnotatedTypeMirror.AnnotatedArrayType)lubAnnotatedType;
            if (type.getKind() == TypeKind.ARRAY) {
                assert (otherType.getKind() == TypeKind.NULL);
                array = (AnnotatedTypeMirror.AnnotatedArrayType)type;
            } else {
                assert (otherType.getKind() == TypeKind.ARRAY);
                assert (type.getKind() == TypeKind.NULL);
                array = (AnnotatedTypeMirror.AnnotatedArrayType)otherType;
            }
            CFAbstractValue.copyArrayComponentAnnotations(array, aLubAnnotatedType);
        }
        return lubAnnotatedType;
    }

    private static void copyArrayComponentAnnotations(AnnotatedTypeMirror.AnnotatedArrayType source, AnnotatedTypeMirror.AnnotatedArrayType dest) {
        AnnotatedTypeMirror destComp = dest.getComponentType();
        AnnotatedTypeMirror sourceComp = source.getComponentType();
        destComp.addAnnotations(sourceComp.getAnnotations());
        if (sourceComp instanceof AnnotatedTypeMirror.AnnotatedArrayType) {
            assert (dest instanceof AnnotatedTypeMirror.AnnotatedArrayType);
            CFAbstractValue.copyArrayComponentAnnotations((AnnotatedTypeMirror.AnnotatedArrayType)sourceComp, (AnnotatedTypeMirror.AnnotatedArrayType)destComp);
        }
    }

    private static Collection<AnnotationMirror> getUpperBound(AnnotatedTypeMirror t) {
        AnnotatedTypeMirror upperBound;
        if (t.getKind() == TypeKind.WILDCARD) {
            AnnotatedTypeMirror extendsBound = ((AnnotatedTypeMirror.AnnotatedWildcardType)t).getExtendsBound();
            if (extendsBound != null) {
                return extendsBound.getEffectiveAnnotations();
            }
        } else if (t.getKind() == TypeKind.TYPEVAR && (upperBound = ((AnnotatedTypeMirror.AnnotatedTypeVariable)t).getUpperBound()) != null) {
            return upperBound.getEffectiveAnnotations();
        }
        return t.getEffectiveAnnotations();
    }

    public boolean isSubtypeOf(CFAbstractValue<V> other) {
        if (other == null) {
            return true;
        }
        return this.typeHierarchy.isSubtype(this.type, other.getType());
    }

    public V mostSpecific(@Nullable V other, @Nullable V backup) {
        if (other == null) {
            CFAbstractValue v = this;
            return (V)v;
        }
        TypeMirror underlyingType = InternalUtils.greatestLowerBound(this.analysis.getEnv(), this.getType().getUnderlyingType(), ((CFAbstractValue)other).getType().getUnderlyingType());
        if (underlyingType.getKind() == TypeKind.ERROR || underlyingType.getKind() == TypeKind.NONE) {
            underlyingType = backup != null ? ((CFAbstractValue)backup).getType().getUnderlyingType() : this.getType().getUnderlyingType();
        }
        AnnotatedTypeMirror result = AnnotatedTypeMirror.createType(underlyingType, this.analysis.getTypeFactory(), false);
        QualifierHierarchy qualHierarchy = this.analysis.getTypeFactory().getQualifierHierarchy();
        AnnotatedTypeMirror otherType = ((CFAbstractValue)other).getType();
        if (CFAbstractValue.mostSpecific(qualHierarchy, this.getType(), otherType, backup == null ? null : ((CFAbstractValue)backup).getType(), result)) {
            return this.analysis.createAbstractValue(result);
        }
        return backup;
    }

    private static boolean mostSpecific(QualifierHierarchy qualHierarchy, AnnotatedTypeMirror a, AnnotatedTypeMirror b, AnnotatedTypeMirror backup, AnnotatedTypeMirror result) {
        boolean canContainEmpty = QualifierHierarchy.canHaveEmptyAnnotationSet(a) && QualifierHierarchy.canHaveEmptyAnnotationSet(b) && QualifierHierarchy.canHaveEmptyAnnotationSet(result);
        for (AnnotationMirror annotationMirror : qualHierarchy.getTopAnnotations()) {
            AnnotationMirror bAnno;
            AnnotationMirror aAnno = canContainEmpty ? a.getAnnotationInHierarchy(annotationMirror) : a.getEffectiveAnnotationInHierarchy(annotationMirror);
            AnnotationMirror annotationMirror2 = bAnno = canContainEmpty ? b.getAnnotationInHierarchy(annotationMirror) : b.getEffectiveAnnotationInHierarchy(annotationMirror);
            if (qualHierarchy.isSubtype(a, b, aAnno, bAnno)) {
                if (aAnno == null) {
                    result.removeAnnotationInHierarchy(annotationMirror);
                    continue;
                }
                result.addAnnotation(aAnno);
                continue;
            }
            if (qualHierarchy.isSubtype(a, b, bAnno, aAnno)) {
                if (bAnno == null) {
                    result.removeAnnotationInHierarchy(annotationMirror);
                    continue;
                }
                result.addAnnotation(bAnno);
                continue;
            }
            if (backup != null) {
                result.addAnnotation(backup.getAnnotationInHierarchy(annotationMirror));
                continue;
            }
            return false;
        }
        TypeKind kind = result.getKind();
        if (kind == TypeKind.WILDCARD) {
            AnnotatedTypeMirror.AnnotatedWildcardType annotatedWildcardType = (AnnotatedTypeMirror.AnnotatedWildcardType)result;
            AnnotatedTypeMirror extendsBound = annotatedWildcardType.getExtendsBound();
            extendsBound.clearAnnotations();
            Collection<AnnotationMirror> extendsBound1 = CFAbstractValue.getUpperBound(a);
            Collection<AnnotationMirror> extendsBound2 = CFAbstractValue.getUpperBound(b);
            extendsBound.addAnnotations(CFAbstractValue.mostSpecific(qualHierarchy, extendsBound1, extendsBound2));
        } else if (kind == TypeKind.TYPEVAR) {
            AnnotatedTypeMirror.AnnotatedTypeVariable annotatedTypeVariable = (AnnotatedTypeMirror.AnnotatedTypeVariable)result;
            AnnotatedTypeMirror upperBound = annotatedTypeVariable.getUpperBound();
            Collection<AnnotationMirror> upperBound1 = CFAbstractValue.getUpperBound(a);
            Collection<AnnotationMirror> upperBound2 = CFAbstractValue.getUpperBound(b);
            if (upperBound1.size() != 0 && upperBound2.size() != 0) {
                upperBound.clearAnnotations();
                upperBound.addAnnotations(CFAbstractValue.mostSpecific(qualHierarchy, upperBound1, upperBound2));
            }
        } else {
            if (a.getKind() == TypeKind.ARRAY && b.getKind() == TypeKind.ARRAY) {
                AnnotatedTypeMirror.AnnotatedArrayType annotatedArrayType = (AnnotatedTypeMirror.AnnotatedArrayType)result;
                AnnotatedTypeMirror.AnnotatedArrayType aa = (AnnotatedTypeMirror.AnnotatedArrayType)a;
                AnnotatedTypeMirror.AnnotatedArrayType bb = (AnnotatedTypeMirror.AnnotatedArrayType)b;
                return CFAbstractValue.mostSpecific(qualHierarchy, aa.getComponentType(), bb.getComponentType(), null, annotatedArrayType.getComponentType());
            }
            if (kind == TypeKind.ARRAY) {
                AnnotatedTypeMirror.AnnotatedArrayType annotatedArrayType = (AnnotatedTypeMirror.AnnotatedArrayType)result;
                if (a.getKind() == TypeKind.ARRAY) {
                    CFAbstractValue.copyArrayComponentAnnotations((AnnotatedTypeMirror.AnnotatedArrayType)a, annotatedArrayType);
                } else {
                    assert (b.getKind() == TypeKind.ARRAY);
                    CFAbstractValue.copyArrayComponentAnnotations((AnnotatedTypeMirror.AnnotatedArrayType)b, annotatedArrayType);
                }
            }
        }
        return true;
    }

    private static Set<AnnotationMirror> mostSpecific(QualifierHierarchy qualHierarchy, Collection<AnnotationMirror> a, Collection<AnnotationMirror> b) {
        Set<AnnotationMirror> result = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror annotationMirror : qualHierarchy.getTopAnnotations()) {
            AnnotationMirror aAnno = qualHierarchy.findCorrespondingAnnotation(annotationMirror, a);
            AnnotationMirror bAnno = qualHierarchy.findCorrespondingAnnotation(annotationMirror, b);
            assert (aAnno != null) : "Did not find an annotation for '" + annotationMirror + "' in '" + a + "'.";
            assert (bAnno != null) : "Did not find an annotation for '" + annotationMirror + "' in '" + b + "'.";
            if (qualHierarchy.isSubtype(aAnno, bAnno)) {
                result.add(aAnno);
                continue;
            }
            if (qualHierarchy.isSubtype(bAnno, aAnno)) {
                result.add(bAnno);
                continue;
            }
            assert (false) : "Neither of the two values is more specific: " + a + ", " + b + ".";
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CFAbstractValue)) {
            return false;
        }
        boolean result = this.getType().equals(((CFAbstractValue)obj).getType());
        return result;
    }

    @Pure
    public int hashCode() {
        return HashCodeUtils.hash((Object)this.type);
    }

    @SideEffectFree
    public String toString() {
        return this.getType().toString();
    }

    protected static String annotationToString(AnnotationMirror a) {
        String fullString = a.toString();
        int indexOfParen = fullString.indexOf("(");
        String annoName = fullString;
        if (indexOfParen >= 0) {
            annoName = fullString.substring(0, indexOfParen);
        }
        return fullString.substring(annoName.lastIndexOf(46) + 1, fullString.length());
    }
}

