package org.checkerframework.checker.experimental.tainting_qual_poly.qual;

import org.checkerframework.qualframework.poly.SimpleQualifierParameterAnnotationConverter;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * MethodTaintingParam declares a qualifier parameter on a method.
 *
 * <pre>
 * {@code
 *  {@literal @}MethodTaintingParam("aParam") void foo() { }
 *
 *  is equivalent to:
 *
 *  <<aParam>> void food() { }
 * }
 * </pre>
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.CONSTRUCTOR})
@Repeatable(MultiMethodTaintingParam.class)
public @interface MethodTaintingParam {
    String value() default SimpleQualifierParameterAnnotationConverter.PRIMARY_TARGET;
}
