/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.basetype;

import com.sun.source.util.TreePath;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import org.checkerframework.common.basetype.BaseTypeContext;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.SourceChecker;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.ErrorReporter;

public abstract class BaseTypeChecker
extends SourceChecker
implements BaseTypeContext {
    private List<BaseTypeChecker> subcheckers = null;
    private List<BaseTypeChecker> immediateSubcheckers;

    @Override
    public void initChecker() {
        for (BaseTypeChecker checker : this.getSubcheckers()) {
            checker.initChecker();
            checker.addOptions(super.getOptions());
            checker.setSupportedLintOptions(this.getSupportedLintOptions());
        }
        super.initChecker();
    }

    protected LinkedHashSet<Class<? extends BaseTypeChecker>> getImmediateSubcheckerClasses() {
        return new LinkedHashSet<Class<? extends BaseTypeChecker>>();
    }

    protected BaseTypeVisitor<?> createSourceVisitor() {
        for (Class<?> checkerClass = this.getClass(); checkerClass != BaseTypeChecker.class; checkerClass = checkerClass.getSuperclass()) {
            String classToLoad = checkerClass.getName().replace("Checker", "Visitor").replace("Subchecker", "Visitor");
            BaseTypeVisitor result = (BaseTypeVisitor)BaseTypeChecker.invokeConstructorFor(classToLoad, new Class[]{BaseTypeChecker.class}, new Object[]{this});
            if (result == null) continue;
            return result;
        }
        return new BaseTypeVisitor(this);
    }

    @Override
    public Set<String> getSupportedLintOptions() {
        HashSet<String> lintSet = new HashSet<String>(super.getSupportedLintOptions());
        lintSet.add("cast");
        lintSet.add("cast:redundant");
        lintSet.add("cast:unsafe");
        for (BaseTypeChecker checker : this.getSubcheckers()) {
            lintSet.addAll(checker.getSupportedLintOptions());
        }
        return Collections.unmodifiableSet(lintSet);
    }

    public static <T> T invokeConstructorFor(String name, Class<?>[] paramTypes, Object[] args) {
        Class<?> cls = null;
        try {
            cls = Class.forName(name);
        }
        catch (Exception e) {
            return null;
        }
        assert (cls != null) : "reflectively loading " + name + " failed";
        try {
            Constructor<?> ctor = cls.getConstructor(paramTypes);
            return (T)ctor.newInstance(args);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                String msg;
                Throwable err = t.getCause();
                if (err instanceof SourceChecker.CheckerError) {
                    SourceChecker.CheckerError ce = (SourceChecker.CheckerError)err;
                    if (ce.userError) {
                        throw ce;
                    }
                    msg = err.getMessage();
                } else {
                    msg = err.toString();
                }
                ErrorReporter.errorAbort("InvocationTargetException when invoking constructor for class " + name + "; Underlying cause: " + msg, t);
            } else {
                ErrorReporter.errorAbort("Unexpected " + t.getClass().getSimpleName() + " for " + "class " + name + " when invoking the constructor; parameter types: " + Arrays.toString(paramTypes), t);
            }
            return null;
        }
    }

    @Override
    public BaseTypeContext getContext() {
        return this;
    }

    @Override
    public BaseTypeChecker getChecker() {
        return this;
    }

    @Override
    public BaseTypeVisitor<?> getVisitor() {
        return (BaseTypeVisitor)super.getVisitor();
    }

    @Override
    public GenericAnnotatedTypeFactory<?, ?, ?, ?> getTypeFactory() {
        return ((BaseTypeVisitor)this.getVisitor()).getTypeFactory();
    }

    @Override
    public AnnotationProvider getAnnotationProvider() {
        return this.getTypeFactory();
    }

    public <T extends BaseTypeChecker> T getSubchecker(Class<T> checkerClass) {
        for (BaseTypeChecker checker : this.immediateSubcheckers) {
            if (!checker.getClass().equals(checkerClass)) continue;
            return (T)checker;
        }
        return null;
    }

    public <T extends GenericAnnotatedTypeFactory<?, ?, ?, ?>, U extends BaseTypeChecker> T getTypeFactoryOfSubchecker(Class<U> checkerClass) {
        U checker = this.getSubchecker(checkerClass);
        if (checker != null) {
            return (T)((BaseTypeChecker)checker).getTypeFactory();
        }
        return null;
    }

    private List<BaseTypeChecker> instantiateSubcheckers(LinkedHashMap<Class<? extends BaseTypeChecker>, BaseTypeChecker> alreadyInitializedSubcheckerMap) {
        LinkedHashSet<Class<? extends BaseTypeChecker>> classesOfImmediateSubcheckers = this.getImmediateSubcheckerClasses();
        ArrayList<BaseTypeChecker> immediateSubcheckers = new ArrayList<BaseTypeChecker>();
        for (Class clazz : classesOfImmediateSubcheckers) {
            BaseTypeChecker subchecker = alreadyInitializedSubcheckerMap.get(clazz);
            if (subchecker != null) {
                immediateSubcheckers.add(subchecker);
                continue;
            }
            try {
                BaseTypeChecker instance = (BaseTypeChecker)clazz.newInstance();
                instance.subcheckers = Collections.unmodifiableList(new ArrayList());
                immediateSubcheckers.add(instance);
                alreadyInitializedSubcheckerMap.put(clazz, instance);
                instance.immediateSubcheckers = instance.instantiateSubcheckers(alreadyInitializedSubcheckerMap);
            }
            catch (Exception e) {
                ErrorReporter.errorAbort("Could not create an instance of " + clazz);
            }
        }
        return Collections.unmodifiableList(immediateSubcheckers);
    }

    @Override
    protected void setProcessingEnvironment(ProcessingEnvironment env) {
        for (BaseTypeChecker checker : this.getSubcheckers()) {
            checker.setProcessingEnvironment(env);
        }
        super.setProcessingEnvironment(env);
    }

    private List<BaseTypeChecker> getSubcheckers() {
        if (this.subcheckers == null) {
            LinkedHashMap<Class<? extends BaseTypeChecker>, BaseTypeChecker> checkerMap = new LinkedHashMap<Class<? extends BaseTypeChecker>, BaseTypeChecker>();
            this.immediateSubcheckers = this.instantiateSubcheckers(checkerMap);
            this.subcheckers = Collections.unmodifiableList(new ArrayList<BaseTypeChecker>(checkerMap.values()));
        }
        return this.subcheckers;
    }

    @Override
    public void typeProcess(TypeElement element, TreePath tree) {
        for (BaseTypeChecker checker : this.getSubcheckers()) {
            checker.errsOnLastExit = this.errsOnLastExit;
            checker.typeProcess(element, tree);
            this.errsOnLastExit = checker.errsOnLastExit;
        }
        super.typeProcess(element, tree);
        if (!this.getSubcheckers().isEmpty()) {
            Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
            Log log = Log.instance(context);
            if (log.nerrors > this.errsOnLastExit) {
                this.errsOnLastExit = log.nerrors;
            }
        }
    }

    @Override
    public void typeProcessingOver() {
        for (BaseTypeChecker checker : this.getSubcheckers()) {
            checker.typeProcessingOver();
        }
        super.typeProcessingOver();
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> options = new HashSet<String>();
        options.addAll(super.getSupportedOptions());
        for (BaseTypeChecker checker : this.getSubcheckers()) {
            options.addAll(checker.getSupportedOptions());
        }
        options.addAll(this.expandCFOptions(Arrays.asList(this.getClass()), options.toArray(new String[0])));
        return Collections.unmodifiableSet(options);
    }

    @Override
    public Map<String, String> getOptions() {
        HashMap<String, String> options = new HashMap<String, String>(super.getOptions());
        for (BaseTypeChecker checker : this.getSubcheckers()) {
            options.putAll(checker.getOptions());
        }
        return options;
    }
}

