/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.units;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Elements;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.units.UnitsRelations;
import org.checkerframework.checker.units.qual.Prefix;
import org.checkerframework.checker.units.qual.h;
import org.checkerframework.checker.units.qual.km2;
import org.checkerframework.checker.units.qual.kmPERh;
import org.checkerframework.checker.units.qual.m;
import org.checkerframework.checker.units.qual.m2;
import org.checkerframework.checker.units.qual.mPERs;
import org.checkerframework.checker.units.qual.mPERs2;
import org.checkerframework.checker.units.qual.mm2;
import org.checkerframework.checker.units.qual.s;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;

public class UnitsRelationsDefault
implements UnitsRelations {
    protected AnnotationMirror m;
    protected AnnotationMirror km;
    protected AnnotationMirror mm;
    protected AnnotationMirror m2;
    protected AnnotationMirror km2;
    protected AnnotationMirror mm2;
    protected AnnotationMirror s;
    protected AnnotationMirror h;
    protected AnnotationMirror mPERs;
    protected AnnotationMirror mPERs2;
    protected AnnotationMirror kmPERh;

    @Override
    public UnitsRelations init(ProcessingEnvironment env) {
        AnnotationBuilder builder = new AnnotationBuilder(env, m.class);
        Elements elements = env.getElementUtils();
        builder.setValue((CharSequence)"value", Prefix.one);
        this.m = builder.build();
        builder = new AnnotationBuilder(env, m.class);
        builder.setValue((CharSequence)"value", Prefix.kilo);
        this.km = builder.build();
        builder = new AnnotationBuilder(env, m.class);
        builder.setValue((CharSequence)"value", Prefix.milli);
        this.mm = builder.build();
        this.m2 = AnnotationUtils.fromClass(elements, m2.class);
        this.km2 = AnnotationUtils.fromClass(elements, km2.class);
        this.mm2 = AnnotationUtils.fromClass(elements, mm2.class);
        builder = new AnnotationBuilder(env, s.class);
        builder.setValue((CharSequence)"value", Prefix.one);
        this.s = builder.build();
        this.h = AnnotationUtils.fromClass(elements, h.class);
        this.mPERs = AnnotationUtils.fromClass(elements, mPERs.class);
        this.kmPERh = AnnotationUtils.fromClass(elements, kmPERh.class);
        this.mPERs2 = AnnotationUtils.fromClass(elements, mPERs2.class);
        return this;
    }

    @Override
    public @Nullable AnnotationMirror multiplication(AnnotatedTypeMirror p1, AnnotatedTypeMirror p2) {
        if (AnnotationUtils.containsSameIgnoringValues(p1.getAnnotations(), this.m) && AnnotationUtils.containsSameIgnoringValues(p2.getAnnotations(), this.m)) {
            Prefix p1prefix = this.getTypeMirrorPrefix(p1);
            Prefix p2prefix = this.getTypeMirrorPrefix(p2);
            if (p1prefix == null || p2prefix == null) {
                return null;
            }
            if (p1prefix.equals((Object)p2prefix) && p2prefix.equals((Object)Prefix.kilo)) {
                return this.km2;
            }
            if (p1prefix.equals((Object)p2prefix) && p2prefix.equals((Object)Prefix.milli)) {
                return this.mm2;
            }
            if (p1prefix.equals((Object)p2prefix) && p2prefix.equals((Object)Prefix.one)) {
                return this.m2;
            }
            return null;
        }
        if (AnnotationUtils.containsSame(p1.getAnnotations(), this.s) && AnnotationUtils.containsSame(p2.getAnnotations(), this.mPERs) || AnnotationUtils.containsSame(p1.getAnnotations(), this.mPERs) && AnnotationUtils.containsSame(p2.getAnnotations(), this.s)) {
            return this.m;
        }
        if (AnnotationUtils.containsSame(p1.getAnnotations(), this.s) && AnnotationUtils.containsSame(p2.getAnnotations(), this.mPERs2) || AnnotationUtils.containsSame(p1.getAnnotations(), this.mPERs2) && AnnotationUtils.containsSame(p2.getAnnotations(), this.s)) {
            return this.mPERs;
        }
        if (AnnotationUtils.containsSame(p1.getAnnotations(), this.h) && AnnotationUtils.containsSame(p2.getAnnotations(), this.kmPERh) || AnnotationUtils.containsSame(p1.getAnnotations(), this.kmPERh) && AnnotationUtils.containsSame(p2.getAnnotations(), this.h)) {
            return this.km;
        }
        return null;
    }

    @Override
    public @Nullable AnnotationMirror division(AnnotatedTypeMirror p1, AnnotatedTypeMirror p2) {
        if (AnnotationUtils.containsSame(p1.getAnnotations(), this.m) && AnnotationUtils.containsSame(p2.getAnnotations(), this.s)) {
            return this.mPERs;
        }
        if (AnnotationUtils.containsSame(p1.getAnnotations(), this.km) && AnnotationUtils.containsSame(p2.getAnnotations(), this.h)) {
            return this.kmPERh;
        }
        if (AnnotationUtils.containsSame(p1.getAnnotations(), this.m2) && AnnotationUtils.containsSame(p2.getAnnotations(), this.m)) {
            return this.m;
        }
        if (AnnotationUtils.containsSame(p1.getAnnotations(), this.km2) && AnnotationUtils.containsSame(p2.getAnnotations(), this.km)) {
            return this.km;
        }
        if (AnnotationUtils.containsSame(p1.getAnnotations(), this.mm2) && AnnotationUtils.containsSame(p2.getAnnotations(), this.mm)) {
            return this.mm;
        }
        if (AnnotationUtils.containsSame(p1.getAnnotations(), this.m) && AnnotationUtils.containsSame(p2.getAnnotations(), this.mPERs)) {
            return this.s;
        }
        if (AnnotationUtils.containsSame(p1.getAnnotations(), this.km) && AnnotationUtils.containsSame(p2.getAnnotations(), this.kmPERh)) {
            return this.h;
        }
        if (AnnotationUtils.containsSame(p1.getAnnotations(), this.mPERs) && AnnotationUtils.containsSame(p2.getAnnotations(), this.s)) {
            return this.mPERs2;
        }
        if (AnnotationUtils.containsSame(p1.getAnnotations(), this.mPERs) && AnnotationUtils.containsSame(p2.getAnnotations(), this.mPERs2)) {
            return this.s;
        }
        return null;
    }

    private Prefix getTypeMirrorPrefix(AnnotatedTypeMirror atm) {
        for (AnnotationMirror mirror : atm.getAnnotations()) {
            AnnotationValue annotationValue = this.getAnnotationMirrorPrefix(mirror);
            if (annotationValue == null) {
                return Prefix.one;
            }
            String prefixString = annotationValue.getValue().toString();
            if (prefixString.equals(Prefix.kilo.toString())) {
                return Prefix.kilo;
            }
            if (prefixString.equals(Prefix.milli.toString())) {
                return Prefix.milli;
            }
            if (!prefixString.equals(Prefix.one.toString())) continue;
            return Prefix.one;
        }
        return null;
    }

    private AnnotationValue getAnnotationMirrorPrefix(AnnotationMirror mirror) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = mirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            if (!"value".equals(entry.getKey().getSimpleName().toString())) continue;
            return entry.getValue();
        }
        return null;
    }
}

