/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference.solver;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.typeinference.TypeArgInferenceUtil;
import org.checkerframework.framework.util.typeinference.solver.ConstraintMap;
import org.checkerframework.framework.util.typeinference.solver.InferenceResult;
import org.checkerframework.framework.util.typeinference.solver.InferredValue;
import org.checkerframework.framework.util.typeinference.solver.TargetConstraints;
import org.checkerframework.javacutil.ErrorReporter;

public class EqualitiesSolver {
    private boolean dirty = false;

    public InferenceResult solveEqualities(Set<TypeVariable> targets, ConstraintMap constraintMap, AnnotatedTypeFactory typeFactory) {
        InferenceResult solution = new InferenceResult();
        do {
            this.dirty = false;
            for (TypeVariable target : targets) {
                TargetConstraints.Equalities equalities;
                InferredValue inferred;
                if (solution.containsKey(target) || (inferred = this.mergeConstraints(target, equalities = constraintMap.getConstraints((TypeVariable)target).equalities, solution, constraintMap, typeFactory)) == null) continue;
                if (inferred instanceof InferredValue.InferredType) {
                    this.rewriteWithInferredType(target, ((InferredValue.InferredType)inferred).type, constraintMap);
                } else {
                    this.rewriteWithInferredTarget(target, ((InferredValue.InferredTarget)inferred).target, constraintMap, typeFactory);
                }
                solution.put(target, inferred);
            }
        } while (this.dirty);
        solution.resolveChainedTargets();
        return solution;
    }

    private void rewriteWithInferredType(TypeVariable target, AnnotatedTypeMirror type, ConstraintMap constraints) {
        Set otherHierarchies;
        AnnotatedTypeMirror copy;
        LinkedHashMap<AnnotatedTypeMirror, Set<AnnotationMirror>> toIterate;
        Set<AnnotationMirror> hierarchies;
        TargetConstraints record;
        TargetConstraints targetRecord = constraints.getConstraints(target);
        Map<TypeVariable, Set<AnnotationMirror>> equivalentTargets = targetRecord.equalities.targets;
        for (Map.Entry<TypeVariable, Set<AnnotationMirror>> eqEntry : equivalentTargets.entrySet()) {
            constraints.addTypeEqualities(eqEntry.getKey(), type, eqEntry.getValue());
        }
        for (TypeVariable otherTarget : constraints.getTargets()) {
            if (otherTarget == target) continue;
            record = constraints.getConstraints(otherTarget);
            hierarchies = record.equalities.targets.get(target);
            if (hierarchies != null) {
                record.equalities.targets.remove(target);
                constraints.addTypeEqualities(otherTarget, type, hierarchies);
            }
            toIterate = new LinkedHashMap<AnnotatedTypeMirror, Set<AnnotationMirror>>(record.equalities.types);
            record.equalities.types.clear();
            for (AnnotatedTypeMirror otherType : toIterate.keySet()) {
                copy = TypeArgInferenceUtil.substitute(target, type, otherType);
                otherHierarchies = (Set)toIterate.get(otherType);
                record.equalities.types.put(copy, otherHierarchies);
            }
        }
        for (TypeVariable otherTarget : constraints.getTargets()) {
            if (otherTarget == target) continue;
            record = constraints.getConstraints(otherTarget);
            hierarchies = record.supertypes.targets.get(target);
            if (hierarchies != null) {
                record.supertypes.targets.remove(target);
                constraints.addTypeEqualities(otherTarget, type, hierarchies);
            }
            toIterate = new LinkedHashMap<AnnotatedTypeMirror, Set<AnnotationMirror>>(record.supertypes.types);
            record.supertypes.types.clear();
            for (AnnotatedTypeMirror otherType : toIterate.keySet()) {
                copy = TypeArgInferenceUtil.substitute(target, type, otherType);
                otherHierarchies = (Set)toIterate.get(otherType);
                record.supertypes.types.put(copy, otherHierarchies);
            }
        }
        targetRecord.equalities.clear();
        targetRecord.supertypes.clear();
    }

    private void rewriteWithInferredTarget(TypeVariable target, TypeVariable inferredTarget, ConstraintMap constraints, AnnotatedTypeFactory typeFactory) {
        Set otherHierarchies;
        AnnotatedTypeMirror copy;
        LinkedHashMap<AnnotatedTypeMirror, Set<AnnotationMirror>> toIterate;
        Set<AnnotationMirror> hierarchies;
        TargetConstraints record;
        TargetConstraints targetRecord = constraints.getConstraints(target);
        Map<AnnotatedTypeMirror, Set<AnnotationMirror>> equivalentTypes = targetRecord.equalities.types;
        Map<AnnotatedTypeMirror, Set<AnnotationMirror>> supertypes = targetRecord.supertypes.types;
        for (Map.Entry<AnnotatedTypeMirror, Set<AnnotationMirror>> eqEntry : equivalentTypes.entrySet()) {
            constraints.addTypeEqualities(inferredTarget, eqEntry.getKey(), eqEntry.getValue());
        }
        for (Map.Entry<AnnotatedTypeMirror, Set<AnnotationMirror>> superEntry : supertypes.entrySet()) {
            constraints.addTypeSupertype(inferredTarget, superEntry.getKey(), superEntry.getValue());
        }
        for (TypeVariable otherTarget : constraints.getTargets()) {
            if (otherTarget == target || otherTarget == inferredTarget) continue;
            record = constraints.getConstraints(otherTarget);
            hierarchies = record.equalities.targets.get(target);
            if (hierarchies != null) {
                record.equalities.targets.remove(target);
                constraints.addTargetEquality(otherTarget, inferredTarget, hierarchies);
            }
            toIterate = new LinkedHashMap<AnnotatedTypeMirror, Set<AnnotationMirror>>(record.equalities.types);
            record.equalities.types.clear();
            for (AnnotatedTypeMirror otherType : toIterate.keySet()) {
                copy = TypeArgInferenceUtil.substitute(target, this.createAnnotatedTypeVar(target, typeFactory), otherType);
                otherHierarchies = (Set)toIterate.get(otherType);
                record.equalities.types.put(copy, otherHierarchies);
            }
        }
        for (TypeVariable otherTarget : constraints.getTargets()) {
            if (otherTarget == target || otherTarget == inferredTarget) continue;
            record = constraints.getConstraints(otherTarget);
            hierarchies = record.supertypes.targets.get(target);
            if (hierarchies != null) {
                record.supertypes.targets.remove(target);
                constraints.addTargetSupertype(otherTarget, inferredTarget, hierarchies);
            }
            toIterate = new LinkedHashMap<AnnotatedTypeMirror, Set<AnnotationMirror>>(record.supertypes.types);
            record.supertypes.types.clear();
            for (AnnotatedTypeMirror otherType : toIterate.keySet()) {
                copy = TypeArgInferenceUtil.substitute(target, this.createAnnotatedTypeVar(target, typeFactory), otherType);
                otherHierarchies = (Set)toIterate.get(otherType);
                record.supertypes.types.put(copy, otherHierarchies);
            }
        }
        targetRecord.equalities.clear();
        targetRecord.supertypes.clear();
    }

    private AnnotatedTypeMirror.AnnotatedTypeVariable createAnnotatedTypeVar(TypeVariable typeVariable, AnnotatedTypeFactory typeFactory) {
        return (AnnotatedTypeMirror.AnnotatedTypeVariable)typeFactory.getAnnotatedType(typeVariable.asElement());
    }

    private InferredValue.InferredType mergeTypesAndPrimaries(Map<AnnotatedTypeMirror, Set<AnnotationMirror>> typesToHierarchies, Map<AnnotationMirror, AnnotationMirror> primaries, Set<? extends AnnotationMirror> tops) {
        HashSet<? extends AnnotationMirror> missingAnnos = new HashSet<AnnotationMirror>(tops);
        Iterator<Map.Entry<AnnotatedTypeMirror, Set<AnnotationMirror>>> entryIterator = typesToHierarchies.entrySet().iterator();
        if (!entryIterator.hasNext()) {
            ErrorReporter.errorAbort("Merging a list of empty types!");
        }
        Map.Entry<AnnotatedTypeMirror, Set<AnnotationMirror>> head = entryIterator.next();
        AnnotatedTypeMirror mergedType = head.getKey();
        missingAnnos.removeAll((Collection)head.getValue());
        while (entryIterator.hasNext() && !missingAnnos.isEmpty()) {
            Map.Entry<AnnotatedTypeMirror, Set<AnnotationMirror>> current = entryIterator.next();
            AnnotatedTypeMirror currentType = current.getKey();
            Set<AnnotationMirror> set = current.getValue();
            HashSet<AnnotationMirror> found = new HashSet<AnnotationMirror>();
            for (AnnotationMirror annotationMirror : missingAnnos) {
                if (!set.contains(annotationMirror)) continue;
                AnnotationMirror newAnno = currentType.getAnnotationInHierarchy(annotationMirror);
                if (newAnno != null) {
                    mergedType.replaceAnnotation(newAnno);
                    found.add(annotationMirror);
                    continue;
                }
                if (mergedType.getKind() == TypeKind.TYPEVAR && currentType.getUnderlyingType().equals(mergedType.getUnderlyingType())) {
                    found.add(annotationMirror);
                    continue;
                }
                ErrorReporter.errorAbort("Missing annotation.\n\nmergedType=" + mergedType + "\ncurrentType=" + currentType);
            }
            missingAnnos.removeAll(found);
        }
        HashSet<AnnotationMirror> foundHierarchies = new HashSet<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : missingAnnos) {
            AnnotationMirror anno = primaries.get(annotationMirror);
            if (anno == null) continue;
            foundHierarchies.add(annotationMirror);
            mergedType.replaceAnnotation(anno);
        }
        typesToHierarchies.clear();
        if (missingAnnos.isEmpty()) {
            return new InferredValue.InferredType(mergedType);
        }
        HashSet<? extends AnnotationMirror> hierarchies = new HashSet<AnnotationMirror>(tops);
        hierarchies.removeAll(missingAnnos);
        typesToHierarchies.put(mergedType, hierarchies);
        return null;
    }

    public InferredValue mergeConstraints(TypeVariable target, TargetConstraints.Equalities equalities, InferenceResult solution, ConstraintMap constraintMap, AnnotatedTypeFactory typeFactory) {
        Set<? extends AnnotationMirror> tops = typeFactory.getQualifierHierarchy().getTopAnnotations();
        InferredValue inferred = null;
        if (!equalities.types.isEmpty()) {
            inferred = this.mergeTypesAndPrimaries(equalities.types, equalities.primaries, tops);
        }
        if (inferred != null) {
            return inferred;
        }
        this.dirty |= this.updateTargetsWithPartiallyInferredType(equalities, constraintMap, typeFactory);
        inferred = this.findEqualTarget(equalities, tops);
        return inferred;
    }

    public boolean updateTargetsWithPartiallyInferredType(TargetConstraints.Equalities equalities, ConstraintMap constraintMap, AnnotatedTypeFactory typeFactory) {
        boolean updated = false;
        if (!equalities.types.isEmpty()) {
            if (equalities.types.size() != 1) {
                ErrorReporter.errorAbort("Equalities should have at most 1 constraint.");
            }
            Map.Entry<AnnotatedTypeMirror, Set<AnnotationMirror>> remainingTypeEquality = equalities.types.entrySet().iterator().next();
            AnnotatedTypeMirror remainingType = remainingTypeEquality.getKey();
            Set<AnnotationMirror> remainingHierarchies = remainingTypeEquality.getValue();
            for (Map.Entry<TypeVariable, Set<AnnotationMirror>> targetToHierarchies : equalities.targets.entrySet()) {
                TypeVariable equalTarget = targetToHierarchies.getKey();
                Set<AnnotationMirror> hierarchies = targetToHierarchies.getValue();
                HashSet<AnnotationMirror> equalTypeHierarchies = new HashSet<AnnotationMirror>(remainingHierarchies);
                equalTypeHierarchies.retainAll(hierarchies);
                Map<AnnotatedTypeMirror, Set<AnnotationMirror>> otherTargetsEqualTypes = constraintMap.getConstraints((TypeVariable)equalTarget).equalities.types;
                Set<AnnotationMirror> equalHierarchies = otherTargetsEqualTypes.get(remainingType);
                if (equalHierarchies == null) {
                    equalHierarchies = new HashSet<AnnotationMirror>();
                    otherTargetsEqualTypes.put(remainingType, equalHierarchies);
                    updated = true;
                    continue;
                }
                int size = equalHierarchies.size();
                equalHierarchies.addAll(equalTypeHierarchies);
                updated = size == equalHierarchies.size();
            }
        }
        return updated;
    }

    public InferredValue.InferredTarget findEqualTarget(TargetConstraints.Equalities equalities, Set<? extends AnnotationMirror> tops) {
        for (Map.Entry<TypeVariable, Set<AnnotationMirror>> targetToHierarchies : equalities.targets.entrySet()) {
            boolean targetIsEqualInAllHierarchies;
            TypeVariable equalTarget = targetToHierarchies.getKey();
            Set<AnnotationMirror> hierarchies = targetToHierarchies.getValue();
            boolean bl = targetIsEqualInAllHierarchies = equalities.targets.get(equalTarget).size() == tops.size();
            if (targetIsEqualInAllHierarchies) {
                return new InferredValue.InferredTarget(equalTarget, new HashSet());
            }
            HashSet<AnnotationMirror> requiredPrimaries = new HashSet<AnnotationMirror>(equalities.primaries.keySet());
            requiredPrimaries.removeAll(hierarchies);
            boolean typeWithPrimariesIsEqual = requiredPrimaries.size() + hierarchies.size() == tops.size();
            if (!typeWithPrimariesIsEqual) continue;
            return new InferredValue.InferredTarget(equalTarget, requiredPrimaries);
        }
        return null;
    }
}

