/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.i18nformatter;

import com.sun.source.tree.MethodInvocationTree;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.formatter.FormatterTreeUtil;
import org.checkerframework.checker.i18nformatter.I18nFormatterAnnotatedTypeFactory;
import org.checkerframework.checker.i18nformatter.I18nFormatterTreeUtil;
import org.checkerframework.checker.i18nformatter.qual.I18nConversionCategory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;

public class I18nFormatterVisitor
extends BaseTypeVisitor<I18nFormatterAnnotatedTypeFactory> {
    public I18nFormatterVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        I18nFormatterTreeUtil tu = ((I18nFormatterAnnotatedTypeFactory)this.atypeFactory).treeUtil;
        MethodInvocationNode nodeNode = (MethodInvocationNode)((I18nFormatterAnnotatedTypeFactory)this.atypeFactory).getNodeForTree(node);
        I18nFormatterTreeUtil.I18nFormatCall fc = tu.createFormatForCall(node, nodeNode, (I18nFormatterAnnotatedTypeFactory)this.atypeFactory);
        if (fc != null) {
            this.checkInvocationFormatFor(fc);
            return p;
        }
        return super.visitMethodInvocation(node, p);
    }

    private void checkInvocationFormatFor(I18nFormatterTreeUtil.I18nFormatCall fc) {
        I18nFormatterTreeUtil tu = ((I18nFormatterAnnotatedTypeFactory)this.atypeFactory).treeUtil;
        FormatterTreeUtil.Result<I18nFormatterTreeUtil.FormatType> type = fc.getFormatType();
        block0 : switch (type.value()) {
            case I18NINVALID: {
                tu.failure(type, "i18nformat.string.invalid", fc.getInvalidError());
                break;
            }
            case I18NFORMATFOR: {
                if (fc.isValidFormatForInvocation()) break;
                FormatterTreeUtil.Result<I18nFormatterTreeUtil.FormatType> failureType = fc.getInvalidInvocationType();
                tu.failure(failureType, "i18nformat.invalid.formatfor", new Object[0]);
                break;
            }
            case I18NFORMAT: {
                FormatterTreeUtil.Result<FormatterTreeUtil.InvocationType> invc = fc.getInvocationType();
                I18nConversionCategory[] formatCats = fc.getFormatCategories();
                switch (invc.value()) {
                    case VARARG: {
                        FormatterTreeUtil.Result<TypeMirror>[] paramTypes = fc.getParamTypes();
                        int paraml = paramTypes.length;
                        int formatl = formatCats.length;
                        if (paraml < formatl) {
                            tu.warning(invc, "i18nformat.missing.arguments", formatl, paraml);
                        }
                        if (paraml > formatl) {
                            tu.warning(invc, "i18nformat.excess.arguments", formatl, paraml);
                        }
                        block13: for (int i = 0; i < formatl && i < paraml; ++i) {
                            I18nConversionCategory formatCat = formatCats[i];
                            FormatterTreeUtil.Result<TypeMirror> param = paramTypes[i];
                            TypeMirror paramType = param.value();
                            switch (formatCat) {
                                case UNUSED: {
                                    tu.warning(param, "i18nformat.argument.unused", " " + (1 + i));
                                    continue block13;
                                }
                                case GENERAL: {
                                    continue block13;
                                }
                                default: {
                                    if (fc.isValidParameter(formatCat, paramType)) continue block13;
                                    tu.failure(param, "argument.type.incompatible", new Object[]{paramType, formatCat});
                                }
                            }
                        }
                        break block0;
                    }
                    case NULLARRAY: 
                    case ARRAY: {
                        for (I18nConversionCategory cat : formatCats) {
                            if (cat != I18nConversionCategory.UNUSED) continue;
                            tu.warning(invc, "i18nformat.argument.unused", "");
                        }
                        tu.warning(invc, "i18nformat.indirect.arguments", new Object[0]);
                        break;
                    }
                }
                break;
            }
        }
    }
}

