/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.value;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ReflectiveEvalutator;
import org.checkerframework.common.value.ValueCheckerUtils;
import org.checkerframework.common.value.ValueTransfer;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.common.value.qual.BoolVal;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.DoubleVal;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.common.value.qual.StaticallyExecutable;
import org.checkerframework.common.value.qual.StringVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.common.value.util.NumberMath;
import org.checkerframework.common.value.util.NumberUtils;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.qual.DefaultLocation;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ImplicitsTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.type.typeannotator.ListTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.TypeAnnotator;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.defaults.QualifierDefaults;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class ValueAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    protected final AnnotationMirror UNKNOWNVAL;
    protected final AnnotationMirror BOTTOMVAL;
    protected static final int MAX_VALUES = 10;
    protected Set<String> coveredClassStrings;
    private boolean reportWarnings = true;
    private final ReflectiveEvalutator evalutator = new ReflectiveEvalutator(this.checker, this, this.reportWarnings);

    public ValueAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.BOTTOMVAL = AnnotationUtils.fromClass(this.elements, BottomVal.class);
        this.UNKNOWNVAL = AnnotationUtils.fromClass(this.elements, UnknownVal.class);
        this.coveredClassStrings = new HashSet<String>(19);
        this.coveredClassStrings.add("int");
        this.coveredClassStrings.add("java.lang.Integer");
        this.coveredClassStrings.add("double");
        this.coveredClassStrings.add("java.lang.Double");
        this.coveredClassStrings.add("byte");
        this.coveredClassStrings.add("java.lang.Byte");
        this.coveredClassStrings.add("java.lang.String");
        this.coveredClassStrings.add("char");
        this.coveredClassStrings.add("java.lang.Character");
        this.coveredClassStrings.add("float");
        this.coveredClassStrings.add("java.lang.Float");
        this.coveredClassStrings.add("boolean");
        this.coveredClassStrings.add("java.lang.Boolean");
        this.coveredClassStrings.add("long");
        this.coveredClassStrings.add("java.lang.Long");
        this.coveredClassStrings.add("short");
        this.coveredClassStrings.add("java.lang.Short");
        this.coveredClassStrings.add("byte[]");
        if (this.getClass().equals(ValueAnnotatedTypeFactory.class)) {
            this.postInit();
        }
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return this.getBundledTypeQualifiersWithPolyAll(BottomVal.class);
    }

    public void disableWarnings() {
        this.reportWarnings = false;
    }

    public void enableWarnings() {
        this.reportWarnings = true;
    }

    @Override
    public CFTransfer createFlowTransferFunction(CFAbstractAnalysis<CFValue, CFStore, CFTransfer> analysis) {
        return new ValueTransfer(analysis);
    }

    @Override
    public AnnotatedTypeMirror getAnnotatedType(Tree tree) {
        if (tree.getKind() == Tree.Kind.POSTFIX_DECREMENT || tree.getKind() == Tree.Kind.POSTFIX_INCREMENT) {
            return this.getPostFixAnno((UnaryTree)tree, super.getAnnotatedType(tree));
        }
        return super.getAnnotatedType(tree);
    }

    private AnnotatedTypeMirror getPostFixAnno(UnaryTree tree, AnnotatedTypeMirror anno) {
        if (anno.hasAnnotation(DoubleVal.class)) {
            return this.postFixDouble(anno, tree.getKind() == Tree.Kind.POSTFIX_INCREMENT);
        }
        if (anno.hasAnnotation(IntVal.class)) {
            return this.postFixInt(anno, tree.getKind() == Tree.Kind.POSTFIX_INCREMENT);
        }
        return anno;
    }

    private AnnotatedTypeMirror postFixInt(AnnotatedTypeMirror anno, boolean increment) {
        List<Long> values = ValueAnnotatedTypeFactory.getIntValues(anno.getAnnotation(IntVal.class));
        List<? extends Number> castedValues = NumberUtils.castNumbers(anno.getUnderlyingType(), values);
        ArrayList<Long> results = new ArrayList<Long>();
        for (Number number : castedValues) {
            NumberMath<?> number2 = NumberMath.getNumberMath(number);
            if (increment) {
                results.add(number2.minus(1).longValue());
                continue;
            }
            results.add(number2.plus(1).longValue());
        }
        anno.replaceAnnotation(this.createIntValAnnotation(results));
        return anno;
    }

    private AnnotatedTypeMirror postFixDouble(AnnotatedTypeMirror anno, boolean increment) {
        List<Double> values = ValueAnnotatedTypeFactory.getDoubleValues(anno.getAnnotation(DoubleVal.class));
        List<? extends Number> castedValues = NumberUtils.castNumbers(anno.getUnderlyingType(), values);
        ArrayList<Double> results = new ArrayList<Double>();
        for (Number number : castedValues) {
            NumberMath<?> number2 = NumberMath.getNumberMath(number);
            if (increment) {
                results.add(number2.minus(1).doubleValue());
                continue;
            }
            results.add(number2.plus(1).doubleValue());
        }
        anno.replaceAnnotation(this.createDoubleValAnnotation(results));
        return anno;
    }

    private AnnotationMirror createAnnotation(String name, Set<?> values) {
        if (values.size() > 0 && values.size() <= 10) {
            AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, name);
            ArrayList valuesList = new ArrayList(values);
            builder.setValue((CharSequence)"value", valuesList);
            return builder.build();
        }
        return this.UNKNOWNVAL;
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new ValueQualifierHierarchy(factory);
    }

    @Override
    protected QualifierDefaults createQualifierDefaults() {
        QualifierDefaults defaults = super.createQualifierDefaults();
        defaults.addCheckedCodeDefault(this.UNKNOWNVAL, DefaultLocation.OTHERWISE);
        defaults.addCheckedCodeDefault(this.BOTTOMVAL, DefaultLocation.LOWER_BOUNDS);
        return defaults;
    }

    @Override
    protected TypeAnnotator createTypeAnnotator() {
        return new ListTypeAnnotator(new ValueTypeAnnotator(this), super.createTypeAnnotator());
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new ValueTreeAnnotator(this), new ImplicitsTreeAnnotator(this));
    }

    public AnnotationMirror createIntValAnnotation(List<Long> intValues) {
        if ((intValues = ValueCheckerUtils.removeDuplicates(intValues)).isEmpty() || intValues.size() > 10) {
            return this.UNKNOWNVAL;
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, IntVal.class);
        builder.setValue((CharSequence)"value", intValues);
        return builder.build();
    }

    public AnnotationMirror createDoubleValAnnotation(List<Double> doubleValues) {
        if ((doubleValues = ValueCheckerUtils.removeDuplicates(doubleValues)).isEmpty() || doubleValues.size() > 10) {
            return this.UNKNOWNVAL;
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, DoubleVal.class);
        builder.setValue((CharSequence)"value", doubleValues);
        return builder.build();
    }

    public AnnotationMirror createStringAnnotation(List<String> values) {
        if ((values = ValueCheckerUtils.removeDuplicates(values)).isEmpty() || values.size() > 10) {
            return this.UNKNOWNVAL;
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, StringVal.class);
        builder.setValue((CharSequence)"value", values);
        return builder.build();
    }

    public AnnotationMirror createArrayLenAnnotation(List<Integer> values) {
        if ((values = ValueCheckerUtils.removeDuplicates(values)).isEmpty() || values.size() > 10) {
            return this.UNKNOWNVAL;
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, ArrayLen.class);
        builder.setValue((CharSequence)"value", values);
        return builder.build();
    }

    public AnnotationMirror createBooleanAnnotation(List<Boolean> values) {
        if ((values = ValueCheckerUtils.removeDuplicates(values)).isEmpty() || values.size() > 10) {
            return this.UNKNOWNVAL;
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, BoolVal.class);
        builder.setValue((CharSequence)"value", values);
        return builder.build();
    }

    public AnnotationMirror createCharAnnotation(List<Character> values) {
        if ((values = ValueCheckerUtils.removeDuplicates(values)).isEmpty() || values.size() > 10) {
            return this.UNKNOWNVAL;
        }
        ArrayList<Long> longValues = new ArrayList<Long>();
        for (char value : values) {
            longValues.add(Long.valueOf(value));
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, IntVal.class);
        builder.setValue((CharSequence)"value", longValues);
        return builder.build();
    }

    private AnnotationMirror createNumberAnnotationMirror(List<Number> values) {
        if (values.isEmpty()) {
            return this.UNKNOWNVAL;
        }
        Number first = values.get(0);
        if (first instanceof Integer || first instanceof Short || first instanceof Long || first instanceof Byte) {
            ArrayList<Long> intValues = new ArrayList<Long>();
            for (Number number : values) {
                intValues.add(number.longValue());
            }
            return this.createIntValAnnotation(intValues);
        }
        if (first instanceof Double || first instanceof Float) {
            ArrayList<Double> intValues = new ArrayList<Double>();
            for (Number number : values) {
                intValues.add(number.doubleValue());
            }
            return this.createDoubleValAnnotation(intValues);
        }
        throw new UnsupportedOperationException("ValueAnnotatedTypeFactory: unexpected class: " + first.getClass());
    }

    public static List<Long> getIntValues(AnnotationMirror intAnno) {
        return AnnotationUtils.getElementValueArray(intAnno, "value", Long.class, true);
    }

    public static List<Double> getDoubleValues(AnnotationMirror doubleAnno) {
        return AnnotationUtils.getElementValueArray(doubleAnno, "value", Double.class, true);
    }

    public static List<Integer> getArrayLength(AnnotationMirror arrayAnno) {
        return AnnotationUtils.getElementValueArray(arrayAnno, "value", Integer.class, true);
    }

    public static List<Character> getCharValues(AnnotationMirror intAnno) {
        if (intAnno != null) {
            List<Long> intValues = AnnotationUtils.getElementValueArray(intAnno, "value", Long.class, true);
            ArrayList<Character> charValues = new ArrayList<Character>();
            for (Long i : intValues) {
                charValues.add(Character.valueOf((char)i.intValue()));
            }
            return charValues;
        }
        return new ArrayList<Character>();
    }

    public static List<Boolean> getBooleanValues(AnnotationMirror boolAnno) {
        if (boolAnno != null) {
            List<Boolean> boolValues = AnnotationUtils.getElementValueArray(boolAnno, "value", Boolean.class, true);
            TreeSet<Boolean> boolSet = new TreeSet<Boolean>(boolValues);
            if (boolSet.size() > 1) {
                return new ArrayList<Boolean>();
            }
            if (boolSet.size() == 0) {
                return new ArrayList<Boolean>();
            }
            if (boolSet.size() == 1) {
                return new ArrayList<Boolean>(boolSet);
            }
        }
        return new ArrayList<Boolean>();
    }

    protected class ValueTreeAnnotator
    extends TreeAnnotator {
        public ValueTreeAnnotator(ValueAnnotatedTypeFactory factory) {
            super(factory);
        }

        @Override
        public Void visitNewArray(NewArrayTree tree, AnnotatedTypeMirror type) {
            List<? extends ExpressionTree> dimensions = tree.getDimensions();
            List<? extends ExpressionTree> initializers = tree.getInitializers();
            if (!dimensions.isEmpty()) {
                this.handleDimensions(dimensions, (AnnotatedTypeMirror.AnnotatedArrayType)type);
            } else {
                this.handleInitalizers(initializers, (AnnotatedTypeMirror.AnnotatedArrayType)type);
                Class<?> clazz = ValueCheckerUtils.getClassFromType(type.getUnderlyingType());
                String stringVal = null;
                if (clazz.equals(byte[].class)) {
                    stringVal = this.getByteArrayStringVal(initializers);
                } else if (clazz.equals(char[].class)) {
                    stringVal = this.getCharArrayStringVal(initializers);
                }
                if (stringVal != null) {
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createStringAnnotation(Collections.singletonList(stringVal));
                    type.replaceAnnotation(newQual);
                }
            }
            return null;
        }

        private void handleDimensions(List<? extends ExpressionTree> dimensions, AnnotatedTypeMirror.AnnotatedArrayType type) {
            AnnotationMirror dimType;
            if (dimensions.size() > 1) {
                this.handleDimensions(dimensions.subList(1, dimensions.size()), (AnnotatedTypeMirror.AnnotatedArrayType)type.getComponentType());
            }
            if (!AnnotationUtils.areSameIgnoringValues(dimType = ValueAnnotatedTypeFactory.this.getAnnotatedType(dimensions.get(0)).getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL), ValueAnnotatedTypeFactory.this.UNKNOWNVAL)) {
                List<Long> longLengths = ValueAnnotatedTypeFactory.getIntValues(dimType);
                HashSet<Integer> lengths = new HashSet<Integer>(longLengths.size());
                for (Long l : longLengths) {
                    lengths.add(l.intValue());
                }
                AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createArrayLenAnnotation(new ArrayList<Integer>(lengths));
                type.replaceAnnotation(newQual);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void handleInitalizers(List<? extends ExpressionTree> initializers, AnnotatedTypeMirror.AnnotatedArrayType type) {
            boolean singleDem;
            ArrayList<Integer> array = new ArrayList<Integer>();
            array.add(initializers.size());
            type.replaceAnnotation(ValueAnnotatedTypeFactory.this.createArrayLenAnnotation(array));
            boolean bl = singleDem = type.getComponentType().getKind() != TypeKind.ARRAY;
            if (singleDem) {
                return;
            }
            ArrayList summarylengths = new ArrayList();
            for (ExpressionTree expressionTree : initializers) {
                AnnotatedTypeMirror.AnnotatedArrayType subArrayType;
                AnnotatedTypeMirror componentType = subArrayType = (AnnotatedTypeMirror.AnnotatedArrayType)ValueAnnotatedTypeFactory.this.getAnnotatedType(expressionTree);
                int count = 0;
                while (componentType.getKind() == TypeKind.ARRAY) {
                    AnnotationMirror arrayLen = componentType.getAnnotation(ArrayLen.class);
                    List<Integer> currentLengths = arrayLen != null ? ValueAnnotatedTypeFactory.getArrayLength(arrayLen) : new ArrayList<Integer>();
                    if (count == summarylengths.size()) {
                        summarylengths.add(new ArrayList());
                    }
                    ((List)summarylengths.get(count)).addAll(currentLengths);
                    ++count;
                    componentType = componentType.getComponentType();
                }
            }
            AnnotatedTypeMirror componentType = type.getComponentType();
            boolean bl2 = false;
            while (componentType.getKind() == TypeKind.ARRAY) {
                void var7_9;
                componentType.addAnnotation(ValueAnnotatedTypeFactory.this.createArrayLenAnnotation((List)summarylengths.get((int)var7_9)));
                componentType = ((AnnotatedTypeMirror.AnnotatedArrayType)componentType).getComponentType();
                ++var7_9;
            }
        }

        private String getByteArrayStringVal(List<? extends ExpressionTree> initializers) {
            boolean allLiterals = true;
            byte[] bytes = new byte[initializers.size()];
            int i = 0;
            for (ExpressionTree expressionTree : initializers) {
                if (expressionTree.getKind() == Tree.Kind.INT_LITERAL) {
                    bytes[i] = (byte)((Integer)((LiteralTree)expressionTree).getValue()).intValue();
                } else if (expressionTree.getKind() == Tree.Kind.CHAR_LITERAL) {
                    bytes[i] = (byte)((Character)((LiteralTree)expressionTree).getValue()).charValue();
                } else {
                    allLiterals = false;
                }
                ++i;
            }
            if (allLiterals) {
                return new String(bytes);
            }
            return null;
        }

        private String getCharArrayStringVal(List<? extends ExpressionTree> initializers) {
            boolean allLiterals = true;
            String stringVal = "";
            for (ExpressionTree expressionTree : initializers) {
                char charVal;
                if (expressionTree.getKind() == Tree.Kind.INT_LITERAL) {
                    charVal = (char)((Integer)((LiteralTree)expressionTree).getValue()).intValue();
                    stringVal = stringVal + charVal;
                    continue;
                }
                if (expressionTree.getKind() == Tree.Kind.CHAR_LITERAL) {
                    charVal = ((Character)((LiteralTree)expressionTree).getValue()).charValue();
                    stringVal = stringVal + charVal;
                    continue;
                }
                allLiterals = false;
            }
            if (allLiterals) {
                return stringVal;
            }
            return null;
        }

        @Override
        public Void visitTypeCast(TypeCastTree tree, AnnotatedTypeMirror type) {
            if (this.isUnderlyingTypeAValue(type)) {
                AnnotatedTypeMirror castedAnnotation = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree.getExpression());
                List<?> values = this.getValues(castedAnnotation, type.getUnderlyingType());
                type.replaceAnnotation(this.resultAnnotationHandler(type.getUnderlyingType(), values, tree));
            } else if (type.getKind() == TypeKind.ARRAY && tree.getExpression().getKind() == Tree.Kind.NULL_LITERAL) {
                type.replaceAnnotation(ValueAnnotatedTypeFactory.this.BOTTOMVAL);
            }
            return null;
        }

        private List<?> getValues(AnnotatedTypeMirror type, TypeMirror castTo) {
            AnnotationMirror anno = type.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            if (anno == null) {
                return new ArrayList();
            }
            return ValueCheckerUtils.getValuesCastedToType(anno, castTo);
        }

        @Override
        public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
            if (this.isUnderlyingTypeAValue(type)) {
                switch (tree.getKind()) {
                    case BOOLEAN_LITERAL: {
                        AnnotationMirror boolAnno = ValueAnnotatedTypeFactory.this.createBooleanAnnotation(Collections.singletonList((Boolean)tree.getValue()));
                        type.replaceAnnotation(boolAnno);
                        return null;
                    }
                    case CHAR_LITERAL: {
                        AnnotationMirror charAnno = ValueAnnotatedTypeFactory.this.createCharAnnotation(Collections.singletonList((Character)tree.getValue()));
                        type.replaceAnnotation(charAnno);
                        return null;
                    }
                    case DOUBLE_LITERAL: {
                        AnnotationMirror doubleAnno = ValueAnnotatedTypeFactory.this.createNumberAnnotationMirror(Collections.singletonList((Double)tree.getValue()));
                        type.replaceAnnotation(doubleAnno);
                        return null;
                    }
                    case FLOAT_LITERAL: {
                        AnnotationMirror floatAnno = ValueAnnotatedTypeFactory.this.createNumberAnnotationMirror(Collections.singletonList((Float)tree.getValue()));
                        type.replaceAnnotation(floatAnno);
                        return null;
                    }
                    case INT_LITERAL: {
                        AnnotationMirror intAnno = ValueAnnotatedTypeFactory.this.createNumberAnnotationMirror(Collections.singletonList((Integer)tree.getValue()));
                        type.replaceAnnotation(intAnno);
                        return null;
                    }
                    case LONG_LITERAL: {
                        AnnotationMirror longAnno = ValueAnnotatedTypeFactory.this.createNumberAnnotationMirror(Collections.singletonList((Long)tree.getValue()));
                        type.replaceAnnotation(longAnno);
                        return null;
                    }
                    case STRING_LITERAL: {
                        AnnotationMirror stringAnno = ValueAnnotatedTypeFactory.this.createStringAnnotation(Collections.singletonList((String)tree.getValue()));
                        type.replaceAnnotation(stringAnno);
                        return null;
                    }
                }
                return null;
            }
            return null;
        }

        private boolean methodIsStaticallyExecutable(Element method) {
            return ValueAnnotatedTypeFactory.this.getDeclAnnotation(method, StaticallyExecutable.class) != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            if (this.isUnderlyingTypeAValue(type) && this.methodIsStaticallyExecutable(TreeUtils.elementFromUse(tree))) {
                void var6_9;
                AnnotatedTypeMirror receiver;
                ArrayList argValues;
                List<? extends ExpressionTree> arguments = tree.getArguments();
                if (arguments.size() > 0) {
                    argValues = new ArrayList();
                    for (ExpressionTree expressionTree : arguments) {
                        AnnotatedTypeMirror argType = ValueAnnotatedTypeFactory.this.getAnnotatedType(expressionTree);
                        List<?> values = this.getValues(argType, argType.getUnderlyingType());
                        if (values.isEmpty()) {
                            return null;
                        }
                        argValues.add(values);
                    }
                } else {
                    argValues = null;
                }
                if ((receiver = ValueAnnotatedTypeFactory.this.getReceiverType(tree)) != null && !ElementUtils.isStatic(TreeUtils.elementFromUse(tree))) {
                    List<?> list = this.getValues(receiver, receiver.getUnderlyingType());
                    if (list.isEmpty()) {
                        return null;
                    }
                } else {
                    Object var6_8 = null;
                }
                List<?> returnValues = ValueAnnotatedTypeFactory.this.evalutator.evaluteMethodCall(argValues, (List<?>)var6_9, tree);
                AnnotationMirror returnType = this.resultAnnotationHandler(type.getUnderlyingType(), returnValues, tree);
                type.replaceAnnotation(returnType);
            }
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree tree, AnnotatedTypeMirror type) {
            boolean wrapperClass;
            boolean bl = wrapperClass = TypesUtils.isBoxedPrimitive(type.getUnderlyingType()) || TypesUtils.isDeclaredOfName(type.getUnderlyingType(), "java.lang.String");
            if (wrapperClass || this.isUnderlyingTypeAValue(type) && this.methodIsStaticallyExecutable(TreeUtils.elementFromUse(tree))) {
                ArrayList argValues;
                List<? extends ExpressionTree> arguments = tree.getArguments();
                if (arguments.size() > 0) {
                    argValues = new ArrayList();
                    for (ExpressionTree expressionTree : arguments) {
                        AnnotatedTypeMirror argType = ValueAnnotatedTypeFactory.this.getAnnotatedType(expressionTree);
                        List<?> values = this.getValues(argType, argType.getUnderlyingType());
                        if (values.isEmpty()) {
                            return null;
                        }
                        argValues.add(values);
                    }
                } else {
                    argValues = null;
                }
                List<?> returnValues = ValueAnnotatedTypeFactory.this.evalutator.evaluteConstrutorCall(argValues, tree, type.getUnderlyingType());
                AnnotationMirror annotationMirror = this.resultAnnotationHandler(type.getUnderlyingType(), returnValues, tree);
                type.replaceAnnotation(annotationMirror);
            }
            return null;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree tree, AnnotatedTypeMirror type) {
            if (TreeUtils.isFieldAccess(tree) && this.isUnderlyingTypeAValue(type)) {
                AnnotationMirror arrayAnno;
                AnnotatedTypeMirror receiverType;
                Element e;
                VariableElement elem = (VariableElement)InternalUtils.symbol(tree);
                Object value = elem.getConstantValue();
                if (value != null) {
                    type.replaceAnnotation(this.resultAnnotationHandler(type.getUnderlyingType(), Collections.singletonList(value), tree));
                    return null;
                }
                if (ElementUtils.isStatic(elem) && ElementUtils.isFinal(elem) && (e = InternalUtils.symbol(tree.getExpression())) != null) {
                    String classname = ElementUtils.getQualifiedClassName(e).toString();
                    String fieldName = tree.getIdentifier().toString();
                    value = ValueAnnotatedTypeFactory.this.evalutator.evaluateStaticFieldAccess(classname, fieldName, tree);
                    if (value != null) {
                        type.replaceAnnotation(this.resultAnnotationHandler(type.getUnderlyingType(), Collections.singletonList(value), tree));
                    }
                    return null;
                }
                if (tree.getIdentifier().toString().equals("length") && (receiverType = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree.getExpression())).getKind() == TypeKind.ARRAY && (arrayAnno = receiverType.getAnnotation(ArrayLen.class)) != null) {
                    List<Integer> lengths = ValueAnnotatedTypeFactory.getArrayLength(arrayAnno);
                    type.replaceAnnotation(ValueAnnotatedTypeFactory.this.createNumberAnnotationMirror(new ArrayList<Integer>(lengths)));
                    return null;
                }
            }
            return null;
        }

        private boolean isUnderlyingTypeAValue(AnnotatedTypeMirror type) {
            return ValueAnnotatedTypeFactory.this.coveredClassStrings.contains(type.getUnderlyingType().toString());
        }

        private AnnotationMirror resultAnnotationHandler(TypeMirror resultType, List<?> results, Tree tree) {
            Class<?> resultClass = ValueCheckerUtils.getClassFromType(resultType);
            results.remove(null);
            if (results.size() == 0) {
                return ValueAnnotatedTypeFactory.this.UNKNOWNVAL;
            }
            if (resultClass == Boolean.class || resultClass == Boolean.TYPE) {
                HashSet<Boolean> boolVals = new HashSet<Boolean>(results.size());
                for (Object o : results) {
                    boolVals.add((Boolean)o);
                }
                return ValueAnnotatedTypeFactory.this.createBooleanAnnotation(new ArrayList<Boolean>(boolVals));
            }
            if (resultClass == Double.class || resultClass == Double.TYPE || resultClass == Float.class || resultClass == Float.TYPE || resultClass == Integer.class || resultClass == Integer.TYPE || resultClass == Long.class || resultClass == Long.TYPE || resultClass == Short.class || resultClass == Short.TYPE || resultClass == Byte.class || resultClass == Byte.TYPE) {
                HashSet<Number> numberVals = new HashSet<Number>(results.size());
                ArrayList<Character> charVals = new ArrayList<Character>();
                for (Object o : results) {
                    if (o instanceof Character) {
                        charVals.add((Character)o);
                        continue;
                    }
                    numberVals.add((Number)o);
                }
                if (numberVals.isEmpty()) {
                    return ValueAnnotatedTypeFactory.this.createCharAnnotation(charVals);
                }
                return ValueAnnotatedTypeFactory.this.createNumberAnnotationMirror(new ArrayList(numberVals));
            }
            if (resultClass == Character.TYPE || resultClass == Character.class) {
                HashSet<Character> intVals = new HashSet<Character>(results.size());
                for (Object o : results) {
                    if (o instanceof Number) {
                        intVals.add(Character.valueOf((char)((Number)o).intValue()));
                        continue;
                    }
                    intVals.add(Character.valueOf(((Character)o).charValue()));
                }
                return ValueAnnotatedTypeFactory.this.createCharAnnotation(new ArrayList<Character>(intVals));
            }
            if (resultClass == String.class) {
                HashSet<String> stringVals = new HashSet<String>(results.size());
                for (Object o : results) {
                    stringVals.add((String)o);
                }
                return ValueAnnotatedTypeFactory.this.createStringAnnotation(new ArrayList<String>(stringVals));
            }
            if (resultClass == byte[].class) {
                HashSet<String> stringVals = new HashSet<String>(results.size());
                for (Object o : results) {
                    if (o instanceof byte[]) {
                        stringVals.add(new String((byte[])o));
                        continue;
                    }
                    stringVals.add(o.toString());
                }
                return ValueAnnotatedTypeFactory.this.createStringAnnotation(new ArrayList<String>(stringVals));
            }
            return ValueAnnotatedTypeFactory.this.UNKNOWNVAL;
        }
    }

    private final class ValueQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        public ValueQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory);
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (this.isSubtype(a1, a2)) {
                return a1;
            }
            if (this.isSubtype(a2, a1)) {
                return a2;
            }
            return ValueAnnotatedTypeFactory.this.BOTTOMVAL;
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            AnnotationMirror intAnno;
            AnnotationMirror doubleAnno;
            if (!AnnotationUtils.areSameIgnoringValues(this.getTopAnnotation(a1), this.getTopAnnotation(a2))) {
                return null;
            }
            if (this.isSubtype(a1, a2)) {
                return a2;
            }
            if (this.isSubtype(a2, a1)) {
                return a1;
            }
            if (AnnotationUtils.areSameIgnoringValues(a1, a2)) {
                List<Object> a1Values = AnnotationUtils.getElementValueArray(a1, "value", Object.class, true);
                List<Object> a2Values = AnnotationUtils.getElementValueArray(a2, "value", Object.class, true);
                HashSet<Object> newValues = new HashSet<Object>(a1Values.size() + a2Values.size());
                newValues.addAll(a1Values);
                newValues.addAll(a2Values);
                return ValueAnnotatedTypeFactory.this.createAnnotation(a1.getAnnotationType().toString(), newValues);
            }
            if (!(AnnotationUtils.areSameByClass(a1, IntVal.class) || AnnotationUtils.areSameByClass(a1, DoubleVal.class) || AnnotationUtils.areSameByClass(a2, IntVal.class) || AnnotationUtils.areSameByClass(a2, DoubleVal.class))) {
                return ValueAnnotatedTypeFactory.this.UNKNOWNVAL;
            }
            if (AnnotationUtils.areSameByClass(a2, DoubleVal.class)) {
                doubleAnno = a2;
                intAnno = a1;
            } else {
                doubleAnno = a1;
                intAnno = a2;
            }
            List<Long> intVals = ValueAnnotatedTypeFactory.getIntValues(intAnno);
            List<Double> doubleVals = ValueAnnotatedTypeFactory.getDoubleValues(doubleAnno);
            for (Long n : intVals) {
                doubleVals.add(n.doubleValue());
            }
            return ValueAnnotatedTypeFactory.this.createDoubleValAnnotation(doubleVals);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameByClass(lhs, UnknownVal.class) || AnnotationUtils.areSameByClass(rhs, BottomVal.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(rhs, UnknownVal.class) || AnnotationUtils.areSameByClass(lhs, BottomVal.class)) {
                return false;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, rhs)) {
                List<Object> lhsValues = AnnotationUtils.getElementValueArray(lhs, "value", Object.class, true);
                List<Object> rhsValues = AnnotationUtils.getElementValueArray(rhs, "value", Object.class, true);
                return lhsValues.containsAll(rhsValues);
            }
            if (AnnotationUtils.areSameByClass(lhs, DoubleVal.class) && AnnotationUtils.areSameByClass(rhs, IntVal.class)) {
                List<Long> rhsValues = AnnotationUtils.getElementValueArray(rhs, "value", Long.class, true);
                List<Double> lhsValues = AnnotationUtils.getElementValueArray(lhs, "value", Double.class, true);
                boolean same = false;
                for (Long rhsLong : rhsValues) {
                    for (Double lhsDbl : lhsValues) {
                        if (lhsDbl.doubleValue() != rhsLong.doubleValue()) continue;
                        same = true;
                        break;
                    }
                    if (same) continue;
                    return false;
                }
                return same;
            }
            return false;
        }
    }

    private class ValueTypeAnnotator
    extends TypeAnnotator {
        public ValueTypeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, Void p) {
            this.replaceWithUnknownValIfTooManyValues(type);
            return (Void)super.visitPrimitive(type, p);
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Void p) {
            this.replaceWithUnknownValIfTooManyValues(type);
            return (Void)super.visitDeclared(type, p);
        }

        private void replaceWithUnknownValIfTooManyValues(AnnotatedTypeMirror atm) {
            List<Object> values;
            AnnotationMirror anno = atm.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            if (anno != null && anno.getElementValues().size() > 0 && (values = AnnotationUtils.getElementValueArray(anno, "value", Object.class, false)) != null && values.size() > 10) {
                atm.replaceAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            }
        }
    }
}

