/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.javari.qual.Mutable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.reflection.DefaultReflectionResolver;
import org.checkerframework.common.reflection.MethodValAnnotatedTypeFactory;
import org.checkerframework.common.reflection.MethodValChecker;
import org.checkerframework.common.reflection.ReflectionResolver;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.dataflow.qual.TerminatesExecution;
import org.checkerframework.framework.qual.FromByteCode;
import org.checkerframework.framework.qual.FromStubFile;
import org.checkerframework.framework.qual.InheritedAnnotation;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.qual.PolymorphicQualifier;
import org.checkerframework.framework.qual.StubFiles;
import org.checkerframework.framework.qual.SubtypeOf;
import org.checkerframework.framework.qual.TypeQualifiers;
import org.checkerframework.framework.stub.StubParser;
import org.checkerframework.framework.stub.StubResource;
import org.checkerframework.framework.stub.StubUtil;
import org.checkerframework.framework.type.AnnotatedTypeFormatter;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.AnnotatedTypeParameterBounds;
import org.checkerframework.framework.type.AnnotationClassLoader;
import org.checkerframework.framework.type.DeclarationsIntoElements;
import org.checkerframework.framework.type.DefaultAnnotatedTypeFormatter;
import org.checkerframework.framework.type.DefaultTypeHierarchy;
import org.checkerframework.framework.type.ElementAnnotationApplier;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeFromTree;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.type.TypeVariableSubstitutor;
import org.checkerframework.framework.type.TypesIntoElements;
import org.checkerframework.framework.type.VisitorState;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.AnnotationFormatter;
import org.checkerframework.framework.util.CFContext;
import org.checkerframework.framework.util.DefaultAnnotationFormatter;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.TreePathCacher;
import org.checkerframework.framework.util.typeinference.DefaultTypeArgumentInference;
import org.checkerframework.framework.util.typeinference.TypeArgumentInference;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.CollectionUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.trees.DetachedVarSymbol;

public class AnnotatedTypeFactory
implements AnnotationProvider {
    protected final Trees trees;
    protected @Nullable CompilationUnitTree root;
    protected final ProcessingEnvironment processingEnv;
    protected final Elements elements;
    protected final Types types;
    protected final VisitorState visitorState;
    protected QualifierHierarchy qualHierarchy;
    protected TypeHierarchy typeHierarchy;
    protected final AnnotatedTypeFormatter typeFormatter;
    private final AnnotationFormatter annotationFormatter;
    protected TypeVariableSubstitutor typeVarSubstitutor;
    protected TypeArgumentInference typeArgumentInference;
    private final Set<Class<? extends Annotation>> supportedQuals;
    private Map<Element, AnnotatedTypeMirror> indexTypes;
    private Map<String, Set<AnnotationMirror>> indexDeclAnnos;
    private final Map<Element, Set<AnnotationMirror>> cacheDeclAnnos;
    private final Set<AnnotationMirror> inheritedAnnotations = AnnotationUtils.createAnnotationSet();
    protected final BaseTypeChecker checker;
    private final Map<String, AnnotationMirror> aliases = new HashMap<String, AnnotationMirror>();
    private final Map<String, Pair<AnnotationMirror, Set<@Interned String>>> declAliases = new HashMap<String, Pair<AnnotationMirror, Set<String>>>();
    private static int uidCounter = 0;
    public final int uid;
    private final AnnotationMirror fromByteCode;
    private final AnnotationMirror fromStubFile;
    protected ReflectionResolver reflectionResolver;
    protected AnnotationClassLoader loader;
    protected static boolean SHOULD_CACHE = true;
    public boolean shouldCache = SHOULD_CACHE;
    protected static boolean SHOULD_READ_CACHE = true;
    public boolean shouldReadCache = SHOULD_READ_CACHE;
    private static final int CACHE_SIZE = 300;
    private final Map<Tree, AnnotatedTypeMirror> treeCache = CollectionUtils.createLRUCache(300);
    protected final Map<Tree, AnnotatedTypeMirror> fromTreeCache = CollectionUtils.createLRUCache(300);
    private final Map<Element, AnnotatedTypeMirror> elementCache = CollectionUtils.createLRUCache(300);
    private final Map<Element, Tree> elementToTreeCache = CollectionUtils.createLRUCache(300);
    private final TreePathCacher treePathCache = new TreePathCacher();
    private final Map<Tree, Element> pathHack = new HashMap<Tree, Element>();

    public AnnotatedTypeFactory(BaseTypeChecker checker) {
        this.uid = ++uidCounter;
        this.processingEnv = checker.getProcessingEnvironment();
        this.checker = checker;
        this.trees = Trees.instance(this.processingEnv);
        this.elements = this.processingEnv.getElementUtils();
        this.types = this.processingEnv.getTypeUtils();
        this.visitorState = new VisitorState();
        this.loader = new AnnotationClassLoader(checker);
        this.supportedQuals = this.createSupportedTypeQualifiers();
        this.fromByteCode = AnnotationUtils.fromClass(this.elements, FromByteCode.class);
        this.fromStubFile = AnnotationUtils.fromClass(this.elements, FromStubFile.class);
        this.cacheDeclAnnos = new HashMap<Element, Set<AnnotationMirror>>();
        this.typeFormatter = this.createAnnotatedTypeFormatter();
        this.annotationFormatter = this.createAnnotationFormatter();
    }

    protected void postInit() {
        this.qualHierarchy = this.createQualifierHierarchy();
        if (this.qualHierarchy == null) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory with null qualifier hierarchy not supported.");
        }
        this.typeHierarchy = this.createTypeHierarchy();
        this.typeVarSubstitutor = this.createTypeVariableSubstitutor();
        this.typeArgumentInference = this.createTypeArgumentInference();
        this.addAliasedDeclAnnotation(org.jmlspecs.annotation.Pure.class, Pure.class, AnnotationUtils.fromClass(this.elements, Pure.class));
        this.addInheritedAnnotation(AnnotationUtils.fromClass(this.elements, Pure.class));
        this.addInheritedAnnotation(AnnotationUtils.fromClass(this.elements, SideEffectFree.class));
        this.addInheritedAnnotation(AnnotationUtils.fromClass(this.elements, Deterministic.class));
        this.addInheritedAnnotation(AnnotationUtils.fromClass(this.elements, TerminatesExecution.class));
        this.initilizeReflectionResolution();
        if (this.getClass().equals(AnnotatedTypeFactory.class)) {
            this.buildIndexTypes();
        }
    }

    protected void initilizeReflectionResolution() {
        if (this.checker.shouldResolveReflection()) {
            boolean debug = "debug".equals(this.checker.getOption("resolveReflection"));
            MethodValChecker methodValChecker = this.checker.getSubchecker(MethodValChecker.class);
            assert (methodValChecker != null) : "AnnotatedTypeFactory: reflection resolution was requested, but MethodValChecker isn't a subchecker.";
            MethodValAnnotatedTypeFactory methodValATF = (MethodValAnnotatedTypeFactory)methodValChecker.getAnnotationProvider();
            this.reflectionResolver = new DefaultReflectionResolver(this.checker, methodValATF, debug);
        }
    }

    public void setRoot(@Nullable CompilationUnitTree root) {
        this.root = root;
        this.treePathCache.clear();
        this.pathHack.clear();
    }

    @SideEffectFree
    public String toString() {
        return this.getClass().getSimpleName() + "#" + this.uid;
    }

    protected MultiGraphQualifierHierarchy.MultiGraphFactory createQualifierHierarchyFactory() {
        return new MultiGraphQualifierHierarchy.MultiGraphFactory(this);
    }

    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new GraphQualifierHierarchy(factory, null);
    }

    protected QualifierHierarchy createQualifierHierarchy() {
        Set<Class<? extends Annotation>> supportedTypeQualifiers = this.getSupportedTypeQualifiers();
        MultiGraphQualifierHierarchy.MultiGraphFactory factory = this.createQualifierHierarchyFactory();
        return AnnotatedTypeFactory.createQualifierHierarchy(this.elements, supportedTypeQualifiers, factory);
    }

    protected static QualifierHierarchy createQualifierHierarchy(Elements elements, Set<Class<? extends Annotation>> supportedTypeQualifiers, MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        for (Class<? extends Annotation> typeQualifier : supportedTypeQualifiers) {
            Class<? extends Annotation>[] superQualifiers;
            AnnotationMirror typeQualifierAnno = AnnotationUtils.fromClass(elements, typeQualifier);
            assert (typeQualifierAnno != null) : "Loading annotation \"" + typeQualifier + "\" failed!";
            factory.addQualifier(typeQualifierAnno);
            if (typeQualifier.getAnnotation(PolymorphicQualifier.class) != null) {
                if (typeQualifier.getAnnotation(SubtypeOf.class) == null) continue;
                ErrorReporter.errorAbort("AnnotatedTypeFactory: " + typeQualifier + " is polymorphic and specifies super qualifiers. " + "Remove the @org.checkerframework.framework.qual.SubtypeOf or @org.checkerframework.framework.qual.PolymorphicQualifier annotation from it.");
                continue;
            }
            if (typeQualifier.getAnnotation(SubtypeOf.class) == null) {
                ErrorReporter.errorAbort("AnnotatedTypeFactory: " + typeQualifier + " does not specify its super qualifiers. " + "Add an @org.checkerframework.framework.qual.SubtypeOf annotation to it.");
            }
            for (Class<? extends Annotation> superQualifier : superQualifiers = typeQualifier.getAnnotation(SubtypeOf.class).value()) {
                if (!supportedTypeQualifiers.contains(superQualifier)) continue;
                AnnotationMirror superAnno = null;
                superAnno = AnnotationUtils.fromClass(elements, superQualifier);
                factory.addSubtype(typeQualifierAnno, superAnno);
            }
        }
        QualifierHierarchy hierarchy = factory.build();
        if (!hierarchy.isValid()) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory: invalid qualifier hierarchy: " + hierarchy.getClass() + " " + hierarchy);
        }
        return hierarchy;
    }

    public final QualifierHierarchy getQualifierHierarchy() {
        return this.qualHierarchy;
    }

    protected TypeHierarchy createTypeHierarchy() {
        return new DefaultTypeHierarchy(this.checker, this.getQualifierHierarchy(), this.checker.hasOption("ignoreRawTypeArguments"), this.checker.hasOption("invariantArrays"));
    }

    public final TypeHierarchy getTypeHierarchy() {
        return this.typeHierarchy;
    }

    protected TypeVariableSubstitutor createTypeVariableSubstitutor() {
        return new TypeVariableSubstitutor();
    }

    public TypeVariableSubstitutor getTypeVarSubstitutor() {
        return this.typeVarSubstitutor;
    }

    protected TypeArgumentInference createTypeArgumentInference() {
        return new DefaultTypeArgumentInference();
    }

    public TypeArgumentInference getTypeArgumentInference() {
        return this.typeArgumentInference;
    }

    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        HashSet<Class<? extends Annotation>> typeQualifiers = new HashSet<Class<? extends Annotation>>();
        Class<?> classType = this.getClass();
        TypeQualifiers typeQualifiersAnnotation = classType.getAnnotation(TypeQualifiers.class);
        if (typeQualifiersAnnotation == null) {
            classType = this.checker.getClass();
            typeQualifiersAnnotation = classType.getAnnotation(TypeQualifiers.class);
        }
        if (typeQualifiersAnnotation != null) {
            for (Class<? extends Annotation> qualifier : typeQualifiersAnnotation.value()) {
                typeQualifiers.add(qualifier);
            }
        }
        if (!typeQualifiers.isEmpty()) {
            return Collections.unmodifiableSet(typeQualifiers);
        }
        typeQualifiers.addAll(this.getBundledTypeQualifiersWithPolyAll(new Class[0]));
        return Collections.unmodifiableSet(typeQualifiers);
    }

    @SafeVarargs
    protected final Set<Class<? extends Annotation>> getBundledTypeQualifiersWithPolyAll(Class<? extends Annotation> ... explicitlyListedAnnotations) {
        Set<Class<? extends Annotation>> annotations = this.loadTypeAnnotationsFromQualDir(explicitlyListedAnnotations);
        annotations.add(PolyAll.class);
        return Collections.unmodifiableSet(annotations);
    }

    @SafeVarargs
    protected final Set<Class<? extends Annotation>> getBundledTypeQualifiersWithoutPolyAll(Class<? extends Annotation> ... explicitlyListedAnnotations) {
        return Collections.unmodifiableSet(this.loadTypeAnnotationsFromQualDir(explicitlyListedAnnotations));
    }

    @SafeVarargs
    private final Set<Class<? extends Annotation>> loadTypeAnnotationsFromQualDir(Class<? extends Annotation> ... explicitlyListedAnnotations) {
        Set<Class<? extends Annotation>> annotations = this.loader.getLoadedAnnotationClasses();
        if (explicitlyListedAnnotations != null) {
            annotations.addAll(Arrays.asList(explicitlyListedAnnotations));
        }
        return annotations;
    }

    protected AnnotatedTypeFormatter createAnnotatedTypeFormatter() {
        return new DefaultAnnotatedTypeFormatter(this.checker.hasOption("printVerboseGenerics"), this.checker.hasOption("printAllQualifiers"));
    }

    protected AnnotationFormatter createAnnotationFormatter() {
        return new DefaultAnnotationFormatter();
    }

    public AnnotationFormatter getAnnotationFormatter() {
        return this.annotationFormatter;
    }

    public final Set<Class<? extends Annotation>> getSupportedTypeQualifiers() {
        return this.supportedQuals;
    }

    public AnnotatedTypeMirror getAnnotatedType(Element elt) {
        if (elt == null) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.getAnnotatedType: null element");
            return null;
        }
        AnnotatedTypeMirror type = this.fromElement(elt);
        this.annotateInheritedFromClass(type);
        this.annotateImplicit(elt, type);
        return type;
    }

    @Override
    public AnnotationMirror getAnnotationMirror(Tree tree, Class<? extends Annotation> target) {
        AnnotationMirror mirror = AnnotationUtils.fromClass(this.elements, target);
        if (this.isSupportedQualifier(mirror)) {
            AnnotatedTypeMirror atm = this.getAnnotatedType(tree);
            return atm.getAnnotation(target);
        }
        return null;
    }

    public AnnotatedTypeMirror getAnnotatedType(Tree tree) {
        AnnotatedTypeMirror type;
        if (tree == null) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.getAnnotatedType: null tree");
            return null;
        }
        if (this.treeCache.containsKey(tree) && this.shouldReadCache) {
            return this.treeCache.get(tree).deepCopy();
        }
        if (TreeUtils.isClassTree(tree)) {
            type = this.fromClass((ClassTree)tree);
        } else if (tree.getKind() == Tree.Kind.METHOD || tree.getKind() == Tree.Kind.VARIABLE) {
            type = this.fromMember(tree);
        } else if (TreeUtils.isExpressionTree(tree)) {
            tree = TreeUtils.skipParens((ExpressionTree)tree);
            type = this.fromExpression((ExpressionTree)tree);
        } else {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.getAnnotatedType: query of annotated type for tree " + (Object)((Object)tree.getKind()));
            type = null;
        }
        this.annotateImplicit(tree, type);
        if ((TreeUtils.isClassTree(tree) || tree.getKind() == Tree.Kind.METHOD) && this.shouldCache) {
            this.treeCache.put(tree, ((AnnotatedTypeMirror)type).deepCopy());
        }
        if (TreeUtils.isClassTree(tree)) {
            this.postProcessClassTree((ClassTree)tree);
        }
        return type;
    }

    protected void postProcessClassTree(ClassTree tree) {
        TypesIntoElements.store(this.processingEnv, this, tree);
        DeclarationsIntoElements.store(this.processingEnv, this, tree);
    }

    public AnnotatedTypeMirror getAnnotatedTypeFromTypeTree(Tree tree) {
        if (tree == null) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.getAnnotatedTypeFromTypeTree: null tree");
            return null;
        }
        AnnotatedTypeMirror type = this.fromTypeTree(tree);
        this.annotateImplicit(tree, type);
        return type;
    }

    public AnnotatedTypeMirror fromElement(Element elt) {
        AnnotatedTypeMirror type;
        if (this.elementCache.containsKey(elt) && this.shouldReadCache) {
            return this.elementCache.get(elt).deepCopy();
        }
        if (elt.getKind() == ElementKind.PACKAGE) {
            return this.toAnnotatedType(elt.asType(), false);
        }
        Tree decl = this.declarationFromElement(elt);
        if (decl == null && this.indexTypes != null && this.indexTypes.containsKey(elt)) {
            type = this.indexTypes.get(elt).deepCopy();
        } else if (!(decl != null || this.indexTypes != null && this.indexTypes.containsKey(elt))) {
            type = this.toAnnotatedType(elt.asType(), ElementUtils.isTypeDeclaration(elt));
            ElementAnnotationApplier.apply(type, elt, this);
            if (elt instanceof ExecutableElement || elt instanceof VariableElement) {
                this.annotateInheritedFromClass(type);
            }
        } else if (decl instanceof ClassTree) {
            type = this.fromClass((ClassTree)decl);
        } else if (decl instanceof VariableTree) {
            type = this.fromMember(decl);
        } else if (decl instanceof MethodTree) {
            type = this.fromMember(decl);
        } else if (decl.getKind() == Tree.Kind.TYPE_PARAMETER) {
            type = this.fromTypeTree(decl);
        } else {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.fromElement: cannot be here! decl: " + (Object)((Object)decl.getKind()) + " elt: " + elt, null);
            type = null;
        }
        if (this.shouldCache && this.indexTypes != null) {
            this.elementCache.put(elt, type.deepCopy());
        }
        return type;
    }

    private void addFromByteCode(Element elt) {
        if (this.indexDeclAnnos == null) {
            return;
        }
        if ((elt.getKind() == ElementKind.CONSTRUCTOR || elt.getKind() == ElementKind.METHOD || elt.getKind() == ElementKind.FIELD) && ElementUtils.isElementFromByteCode(elt)) {
            Set<AnnotationMirror> annos = this.indexDeclAnnos.get(ElementUtils.getVerboseName(elt));
            if (annos == null) {
                annos = AnnotationUtils.createAnnotationSet();
                this.indexDeclAnnos.put(ElementUtils.getVerboseName(elt), annos);
            }
            if (!AnnotationUtils.containsSameIgnoringValues(annos, this.fromStubFile)) {
                annos.add(this.fromByteCode);
            }
        }
    }

    public AnnotatedTypeMirror.AnnotatedDeclaredType fromClass(ClassTree tree) {
        return TypeFromTree.fromClassTree(this, tree);
    }

    public AnnotatedTypeMirror fromMember(Tree tree) {
        if (!(tree instanceof MethodTree) && !(tree instanceof VariableTree)) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.fromMember: not a method or variable declaration: " + tree);
            return null;
        }
        if (this.fromTreeCache.containsKey(tree) && this.shouldReadCache) {
            return this.fromTreeCache.get(tree).deepCopy();
        }
        AnnotatedTypeMirror result = TypeFromTree.fromMember(this, tree);
        this.annotateInheritedFromClass(result);
        if (this.shouldCache) {
            this.fromTreeCache.put(tree, result.deepCopy());
        }
        return result;
    }

    public AnnotatedTypeMirror fromExpression(ExpressionTree tree) {
        if (this.fromTreeCache.containsKey(tree) && this.shouldReadCache) {
            return this.fromTreeCache.get(tree).deepCopy();
        }
        AnnotatedTypeMirror result = TypeFromTree.fromExpression(this, tree);
        this.annotateInheritedFromClass(result);
        if (this.shouldCache) {
            this.fromTreeCache.put(tree, result.deepCopy());
        }
        return result;
    }

    public AnnotatedTypeMirror fromTypeTree(Tree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType dt;
        if (this.fromTreeCache.containsKey(tree) && this.shouldReadCache) {
            return this.fromTreeCache.get(tree).deepCopy();
        }
        AnnotatedTypeMirror result = TypeFromTree.fromTypeTree(this, tree);
        if (result.getKind() == TypeKind.DECLARED && (dt = (AnnotatedTypeMirror.AnnotatedDeclaredType)result).wasRaw()) {
            List<Object> typeArgs;
            Pair<Tree, AnnotatedTypeMirror> ctx = this.visitorState.getAssignmentContext();
            if (ctx != null) {
                typeArgs = ((AnnotatedTypeMirror)ctx.second).getKind() == TypeKind.DECLARED && this.types.isSameType(this.types.erasure(((AnnotatedTypeMirror)ctx.second).actualType), this.types.erasure(dt.actualType)) ? ((AnnotatedTypeMirror.AnnotatedDeclaredType)ctx.second).getTypeArguments() : null;
            } else {
                typeArgs = new ArrayList();
                AnnotatedTypeMirror.AnnotatedDeclaredType declaration = this.fromElement((TypeElement)dt.getUnderlyingType().asElement());
                for (AnnotatedTypeMirror typeParam : declaration.getTypeArguments()) {
                    AnnotatedTypeMirror.AnnotatedWildcardType wct = this.getUninferredWildcardType((AnnotatedTypeMirror.AnnotatedTypeVariable)typeParam);
                    typeArgs.add(wct);
                }
            }
            dt.setTypeArguments(typeArgs);
        }
        this.annotateInheritedFromClass(result);
        if (this.shouldCache) {
            this.fromTreeCache.put(tree, result.deepCopy());
        }
        return result;
    }

    public void annotateImplicit(Tree tree, @Mutable AnnotatedTypeMirror type) {
    }

    protected void annotateImplicit(Element elt, @Mutable AnnotatedTypeMirror type) {
    }

    protected void postDirectSuperTypes(AnnotatedTypeMirror type, List<? extends AnnotatedTypeMirror> supertypes) {
        Set<AnnotationMirror> annotations = type.getEffectiveAnnotations();
        for (AnnotatedTypeMirror annotatedTypeMirror : supertypes) {
            if (annotations.equals(annotatedTypeMirror.getEffectiveAnnotations())) continue;
            annotatedTypeMirror.clearAnnotations();
            annotatedTypeMirror.addAnnotations(annotations);
        }
    }

    public void postAsMemberOf(AnnotatedTypeMirror type, AnnotatedTypeMirror owner, Element element) {
        this.annotateImplicit(element, type);
    }

    public void postTypeVarSubstitution(AnnotatedTypeMirror.AnnotatedTypeVariable varDecl, AnnotatedTypeMirror.AnnotatedTypeVariable varUse, AnnotatedTypeMirror value) {
        if (!varUse.getAnnotationsField().isEmpty() && !AnnotationUtils.areSame(varUse.getAnnotationsField(), varDecl.getAnnotationsField())) {
            value.replaceAnnotations(varUse.getAnnotationsField());
        }
    }

    public List<AnnotatedTypeParameterBounds> typeVariablesFromUse(AnnotatedTypeMirror.AnnotatedDeclaredType type, TypeElement element) {
        AnnotatedTypeMirror.AnnotatedDeclaredType generic = this.getAnnotatedType(element);
        List<AnnotatedTypeMirror> targs = type.getTypeArguments();
        List<AnnotatedTypeMirror> tvars = generic.getTypeArguments();
        assert (targs.size() == tvars.size()) : "Mismatch in type argument size between " + type + " and " + generic;
        HashMap<TypeVariable, AnnotatedTypeMirror> mapping = new HashMap<TypeVariable, AnnotatedTypeMirror>();
        for (int i = 0; i < targs.size(); ++i) {
            mapping.put(((AnnotatedTypeMirror.AnnotatedTypeVariable)tvars.get(i)).getUnderlyingType(), targs.get(i));
        }
        LinkedList<AnnotatedTypeParameterBounds> res = new LinkedList<AnnotatedTypeParameterBounds>();
        for (AnnotatedTypeMirror atm : tvars) {
            AnnotatedTypeMirror.AnnotatedTypeVariable atv = (AnnotatedTypeMirror.AnnotatedTypeVariable)atm;
            AnnotatedTypeMirror upper = this.typeVarSubstitutor.substitute(mapping, atv.getUpperBound());
            AnnotatedTypeMirror lower = this.typeVarSubstitutor.substitute(mapping, atv.getLowerBound());
            res.add(new AnnotatedTypeParameterBounds(upper, lower));
        }
        return res;
    }

    protected void annotateInheritedFromClass(@Mutable AnnotatedTypeMirror type) {
        InheritedFromClassAnnotator.INSTANCE.visit(type, this);
    }

    protected void annotateInheritedFromClass(@Mutable AnnotatedTypeMirror type, Set<AnnotationMirror> fromClass) {
        type.addMissingAnnotations(fromClass);
    }

    protected AnnotatedTypeMirror.AnnotatedDeclaredType getImplicitReceiverType(ExpressionTree tree) {
        assert (tree.getKind() == Tree.Kind.IDENTIFIER || tree.getKind() == Tree.Kind.MEMBER_SELECT || tree.getKind() == Tree.Kind.METHOD_INVOCATION || tree.getKind() == Tree.Kind.NEW_CLASS) : "Unexpected tree kind: " + (Object)((Object)tree.getKind());
        Element element = InternalUtils.symbol(tree);
        assert (element != null) : "Unexpected null element for tree: " + tree;
        if (!ElementUtils.hasReceiver(element)) {
            return null;
        }
        ExpressionTree receiver = TreeUtils.getReceiverTree(tree);
        if (receiver == null) {
            if (this.isMostEnclosingThisDeref(tree)) {
                return this.getSelfType(tree);
            }
            TreePath path = this.getPath(tree);
            if (path == null) {
                return null;
            }
            TypeElement typeElt = ElementUtils.enclosingClass(element);
            if (typeElt == null) {
                ErrorReporter.errorAbort("AnnotatedTypeFactory.getImplicitReceiver: enclosingClass()==null for element: " + element);
            }
            return this.getEnclosingType(typeElt, tree);
        }
        Element rcvelem = InternalUtils.symbol(receiver);
        assert (rcvelem != null) : "Unexpected null element for receiver: " + receiver;
        if (!ElementUtils.hasReceiver(rcvelem)) {
            return null;
        }
        if (receiver.getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)receiver).getName().contentEquals("this")) {
            return this.getSelfType(tree);
        }
        TypeElement typeElt = ElementUtils.enclosingClass(rcvelem);
        if (typeElt == null) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.getImplicitReceiver: enclosingClass()==null for element: " + rcvelem);
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType type = this.getAnnotatedType(typeElt);
        AnnotatedTypeMirror.AnnotatedDeclaredType methodReceiver = this.getCurrentMethodReceiver(tree);
        if (this.shouldTakeFromReceiver(methodReceiver)) {
            type.clearAnnotations();
            type.addAnnotations(methodReceiver.getAnnotations());
        }
        return type;
    }

    private boolean shouldTakeFromReceiver(AnnotatedTypeMirror.AnnotatedDeclaredType methodReceiver) {
        return methodReceiver != null;
    }

    public final boolean isMostEnclosingThisDeref(ExpressionTree tree) {
        if (!this.isAnyEnclosingThisDeref(tree)) {
            return false;
        }
        Element element = TreeUtils.elementFromUse(tree);
        TypeElement typeElt = ElementUtils.enclosingClass(element);
        ClassTree enclosingClass = this.getCurrentClassTree(tree);
        return enclosingClass != null && this.isSubtype(TreeUtils.elementFromDeclaration(enclosingClass), typeElt);
    }

    public final boolean isAnyEnclosingThisDeref(ExpressionTree tree) {
        if (!TreeUtils.isUseOfElement(tree)) {
            return false;
        }
        ExpressionTree recv = TreeUtils.getReceiverTree(tree);
        if (recv == null) {
            Name n;
            Element element = TreeUtils.elementFromUse(tree);
            if (!ElementUtils.hasReceiver(element)) {
                return false;
            }
            return (tree = TreeUtils.skipParens(tree)).getKind() != Tree.Kind.IDENTIFIER || !"this".contentEquals(n = ((IdentifierTree)tree).getName()) && !"super".contentEquals(n);
        }
        if (!TreeUtils.isUseOfElement(recv)) {
            return false;
        }
        Element element = TreeUtils.elementFromUse(recv);
        if (!ElementUtils.hasReceiver(element)) {
            return false;
        }
        return TreeUtils.isExplicitThisDereference(recv);
    }

    public AnnotatedTypeMirror.AnnotatedDeclaredType getSelfType(Tree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType methodReceiver;
        TreePath path = this.getPath(tree);
        ClassTree enclosingClass = TreeUtils.enclosingClass(path);
        if (enclosingClass == null) {
            enclosingClass = this.getCurrentClassTree(tree);
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType type = this.getAnnotatedType(enclosingClass);
        MethodTree enclosingMethod = TreeUtils.enclosingMethod(path);
        if (enclosingClass.getSimpleName().length() != 0 && enclosingMethod != null && this.shouldTakeFromReceiver(methodReceiver = TreeUtils.isConstructor(enclosingMethod) ? (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType(enclosingMethod).getReturnType() : this.getAnnotatedType(enclosingMethod).getReceiverType())) {
            type.clearAnnotations();
            type.addAnnotations(methodReceiver.getAnnotations());
        }
        return type;
    }

    public AnnotatedTypeMirror.AnnotatedDeclaredType getEnclosingType(TypeElement element, Tree tree) {
        for (Element enclosingElt = this.getMostInnerClassOrMethod(tree); enclosingElt != null; enclosingElt = enclosingElt.getEnclosingElement()) {
            if (enclosingElt instanceof ExecutableElement) {
                ExecutableElement method = (ExecutableElement)enclosingElt;
                if (method.asType() == null || !this.isSubtype((TypeElement)method.getEnclosingElement(), element) || ElementUtils.isStatic(method)) continue;
                if (method.getKind() == ElementKind.CONSTRUCTOR) {
                    return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType(method).getReturnType();
                }
                return this.getAnnotatedType(method).getReceiverType();
            }
            if (!(enclosingElt instanceof TypeElement) || !this.isSubtype((TypeElement)enclosingElt, element)) continue;
            return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType(enclosingElt);
        }
        return null;
    }

    private boolean isSubtype(TypeElement a1, TypeElement a2) {
        return a1.equals(a2) || this.types.isSubtype(this.types.erasure(a1.asType()), this.types.erasure(a2.asType()));
    }

    public final AnnotatedTypeMirror getReceiverType(ExpressionTree expression) {
        if (this.isAnyEnclosingThisDeref(expression)) {
            return this.getImplicitReceiverType(expression);
        }
        ExpressionTree receiver = TreeUtils.getReceiverTree(expression);
        if (receiver != null) {
            return this.getAnnotatedType(receiver);
        }
        return null;
    }

    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> methodFromUse(MethodInvocationTree tree) {
        ExecutableElement methodElt = TreeUtils.elementFromUse(tree);
        AnnotatedTypeMirror receiverType = this.getReceiverType(tree);
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = this.methodFromUse(tree, methodElt, receiverType);
        if (this.checker.shouldResolveReflection() && this.reflectionResolver.isReflectiveMethodInvocation(tree)) {
            mfuPair = this.reflectionResolver.resolveReflectiveCall(this, tree, mfuPair);
        }
        return mfuPair;
    }

    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> methodFromUse(ExpressionTree tree, ExecutableElement methodElt, AnnotatedTypeMirror receiverType) {
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = AnnotatedTypes.asMemberOf(this.types, this, receiverType, methodElt);
        LinkedList<AnnotatedTypeMirror> typeargs = new LinkedList<AnnotatedTypeMirror>();
        Map<TypeVariable, AnnotatedTypeMirror> typeVarMapping = AnnotatedTypes.findTypeArguments(this.processingEnv, this, tree, methodElt, methodType);
        if (!typeVarMapping.isEmpty()) {
            for (AnnotatedTypeMirror.AnnotatedTypeVariable tv : methodType.getTypeVariables()) {
                if (typeVarMapping.get(tv.getUnderlyingType()) == null) {
                    ErrorReporter.errorAbort("AnnotatedTypeFactory.methodFromUse:mismatch between declared method type variables and the inferred method type arguments! Method type variables: " + methodType.getTypeVariables() + "; " + "Inferred method type arguments: " + typeVarMapping);
                }
                typeargs.add(typeVarMapping.get(tv.getUnderlyingType()));
            }
            methodType = (AnnotatedTypeMirror.AnnotatedExecutableType)this.typeVarSubstitutor.substitute(typeVarMapping, methodType);
        }
        if (tree.getKind() == Tree.Kind.METHOD_INVOCATION && TreeUtils.isGetClassInvocation((MethodInvocationTree)tree)) {
            AnnotatedTypeFactory.adaptGetClassReturnTypeToReceiver(methodType, receiverType);
        }
        return Pair.of(methodType, typeargs);
    }

    protected static void adaptGetClassReturnTypeToReceiver(AnnotatedTypeMirror.AnnotatedExecutableType getClassType, AnnotatedTypeMirror receiverType) {
        AnnotatedTypeMirror newBound = receiverType.getErased();
        AnnotatedTypeMirror returnType = getClassType.getReturnType();
        if (returnType == null || returnType.getKind() != TypeKind.DECLARED || ((AnnotatedTypeMirror.AnnotatedDeclaredType)returnType).getTypeArguments().size() != 1) {
            ErrorReporter.errorAbort("Unexpected type passed to AnnotatedTypes.adaptGetClassReturnTypeToReceiver\ngetClassType=" + getClassType + "\n" + "receiverType=" + receiverType);
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType returnAdt = (AnnotatedTypeMirror.AnnotatedDeclaredType)getClassType.getReturnType();
        List<AnnotatedTypeMirror> typeArgs = returnAdt.getTypeArguments();
        AnnotatedTypeMirror.AnnotatedWildcardType classWildcardArg = (AnnotatedTypeMirror.AnnotatedWildcardType)typeArgs.get(0);
        newBound.replaceAnnotations(classWildcardArg.getExtendsBound().getAnnotations());
        classWildcardArg.setExtendsBound(newBound);
    }

    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> constructorFromUse(NewClassTree tree) {
        ExecutableElement ctor = InternalUtils.constructor(tree);
        AnnotatedTypeMirror.AnnotatedDeclaredType type = this.fromNewClass(tree);
        this.annotateImplicit(tree.getIdentifier(), (AnnotatedTypeMirror)type);
        AnnotatedTypeMirror.AnnotatedExecutableType con = AnnotatedTypes.asMemberOf(this.types, this, (AnnotatedTypeMirror)type, ctor);
        if (tree.getArguments().size() == con.getParameterTypes().size() + 1 && this.isSyntheticArgument(tree.getArguments().get(0))) {
            ArrayList<AnnotatedTypeMirror> actualParams = new ArrayList<AnnotatedTypeMirror>();
            actualParams.add(this.getAnnotatedType(tree.getArguments().get(0)));
            actualParams.addAll(con.getParameterTypes());
            con.setParameterTypes(actualParams);
        }
        LinkedList<AnnotatedTypeMirror> typeargs = new LinkedList<AnnotatedTypeMirror>();
        Map<TypeVariable, AnnotatedTypeMirror> typeVarMapping = AnnotatedTypes.findTypeArguments(this.processingEnv, this, tree, ctor, con);
        if (!typeVarMapping.isEmpty()) {
            for (AnnotatedTypeMirror.AnnotatedTypeVariable tv : con.getTypeVariables()) {
                typeargs.add(typeVarMapping.get(tv.getUnderlyingType()));
            }
            con = (AnnotatedTypeMirror.AnnotatedExecutableType)this.typeVarSubstitutor.substitute(typeVarMapping, con);
        }
        return Pair.of(con, typeargs);
    }

    public AnnotatedTypeMirror getMethodReturnType(MethodTree m3) {
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = this.getAnnotatedType(m3);
        AnnotatedTypeMirror ret = methodType.getReturnType();
        return ret;
    }

    public AnnotatedTypeMirror getMethodReturnType(MethodTree m3, ReturnTree r) {
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = this.getAnnotatedType(m3);
        AnnotatedTypeMirror ret = methodType.getReturnType();
        return ret;
    }

    private boolean isSyntheticArgument(Tree tree) {
        return tree.toString().contains("<*nullchk*>");
    }

    public AnnotatedTypeMirror.AnnotatedDeclaredType fromNewClass(NewClassTree tree) {
        Pair<Tree, AnnotatedTypeMirror> ctx;
        AnnotatedTypeMirror.AnnotatedDeclaredType type = !TreeUtils.isDiamondTree(tree) ? (AnnotatedTypeMirror.AnnotatedDeclaredType)this.fromTypeTree(tree.getIdentifier()) : (AnnotatedTypeMirror.AnnotatedDeclaredType)this.toAnnotatedType(InternalUtils.typeOf(tree), false);
        if (tree.getClassBody() != null) {
            List<? extends AnnotationTree> annos = tree.getClassBody().getModifiers().getAnnotations();
            type.replaceAnnotations(InternalUtils.annotationsFromTypeAnnotationTrees(annos));
        }
        if (TreeUtils.isDiamondTree(tree) && ((Type)type.actualType).tsym.getTypeParameters().nonEmpty() && (ctx = this.visitorState.getAssignmentContext()) != null) {
            AnnotatedTypeMirror ctxtype = (AnnotatedTypeMirror)ctx.second;
            this.fromNewClassContextHelper(type, ctxtype);
        }
        return type;
    }

    private void fromNewClassContextHelper(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeMirror ctxtype) {
        switch (ctxtype.getKind()) {
            case DECLARED: {
                AnnotatedTypeMirror.AnnotatedDeclaredType adctx = (AnnotatedTypeMirror.AnnotatedDeclaredType)ctxtype;
                if (type.getTypeArguments().size() != adctx.getTypeArguments().size()) break;
                List<AnnotatedTypeMirror> oldArgs = type.getTypeArguments();
                List<AnnotatedTypeMirror> newArgs = adctx.getTypeArguments();
                for (int i = 0; i < type.getTypeArguments().size(); ++i) {
                    if (this.types.isSameType(oldArgs.get((int)i).actualType, newArgs.get((int)i).actualType)) continue;
                    return;
                }
                type.setTypeArguments(newArgs);
                break;
            }
            case ARRAY: {
                break;
            }
            case TYPEVAR: {
                break;
            }
            default: {
                if (ctxtype.getKind().isPrimitive()) break;
                ErrorReporter.errorAbort("AnnotatedTypeFactory.fromNewClassContextHelper: unexpected context: " + ctxtype + " (" + (Object)((Object)ctxtype.getKind()) + ")");
            }
        }
    }

    public AnnotatedTypeMirror.AnnotatedDeclaredType getBoxedType(AnnotatedTypeMirror.AnnotatedPrimitiveType type) {
        TypeElement typeElt = this.types.boxedClass(type.getUnderlyingType());
        AnnotatedTypeMirror.AnnotatedDeclaredType dt = this.fromElement(typeElt);
        dt.addAnnotations(type.getAnnotations());
        return dt;
    }

    public AnnotatedTypeMirror.AnnotatedPrimitiveType getUnboxedType(AnnotatedTypeMirror.AnnotatedDeclaredType type) throws IllegalArgumentException {
        PrimitiveType primitiveType = this.types.unboxedType(type.getUnderlyingType());
        AnnotatedTypeMirror.AnnotatedPrimitiveType pt = (AnnotatedTypeMirror.AnnotatedPrimitiveType)AnnotatedTypeMirror.createType(primitiveType, this, false);
        pt.addAnnotations(type.getAnnotations());
        return pt;
    }

    public VisitorState getVisitorState() {
        return this.visitorState;
    }

    public final AnnotatedTypeMirror.AnnotatedDeclaredType getAnnotatedType(ClassTree tree) {
        return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType((Tree)tree);
    }

    public final AnnotatedTypeMirror.AnnotatedDeclaredType getAnnotatedType(NewClassTree tree) {
        return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType((Tree)tree);
    }

    public final AnnotatedTypeMirror.AnnotatedArrayType getAnnotatedType(NewArrayTree tree) {
        return (AnnotatedTypeMirror.AnnotatedArrayType)this.getAnnotatedType((Tree)tree);
    }

    public final AnnotatedTypeMirror.AnnotatedExecutableType getAnnotatedType(MethodTree tree) {
        return (AnnotatedTypeMirror.AnnotatedExecutableType)this.getAnnotatedType((Tree)tree);
    }

    public final AnnotatedTypeMirror.AnnotatedDeclaredType getAnnotatedType(TypeElement elt) {
        return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType((Element)elt);
    }

    public final AnnotatedTypeMirror.AnnotatedExecutableType getAnnotatedType(ExecutableElement elt) {
        return (AnnotatedTypeMirror.AnnotatedExecutableType)this.getAnnotatedType((Element)elt);
    }

    public final AnnotatedTypeMirror.AnnotatedDeclaredType fromElement(TypeElement elt) {
        return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.fromElement((Element)elt);
    }

    public final AnnotatedTypeMirror.AnnotatedExecutableType fromElement(ExecutableElement elt) {
        return (AnnotatedTypeMirror.AnnotatedExecutableType)this.fromElement((Element)elt);
    }

    public boolean isSupportedQualifier(@Nullable AnnotationMirror a) {
        if (a == null) {
            return false;
        }
        return AnnotationUtils.containsSameIgnoringValues(this.getQualifierHierarchy().getTypeQualifiers(), a);
    }

    protected void addAliasedAnnotation(Class<?> alias, AnnotationMirror type) {
        this.aliases.put(alias.getCanonicalName(), type);
    }

    public @Nullable AnnotationMirror aliasedAnnotation(AnnotationMirror a) {
        TypeElement elem = (TypeElement)a.getAnnotationType().asElement();
        String qualName = elem.getQualifiedName().toString();
        return this.aliases.get(qualName);
    }

    protected void addAliasedDeclAnnotation(Class<? extends Annotation> alias, Class<? extends Annotation> annotation, AnnotationMirror annotationToUse) {
        String aliasName = alias.getCanonicalName();
        @Interned String annotationName = annotation.getCanonicalName();
        HashSet<@Interned String> set = new HashSet<String>();
        if (this.declAliases.containsKey(annotationName)) {
            set.addAll((Collection)this.declAliases.get((Object)annotationName).second);
        }
        set.add(aliasName.intern());
        this.declAliases.put(annotationName, Pair.of(annotationToUse, set));
    }

    protected void addInheritedAnnotation(AnnotationMirror annotation) {
        this.inheritedAnnotations.add(annotation);
    }

    public final AnnotatedTypeMirror toAnnotatedType(TypeMirror t, boolean declaration) {
        return AnnotatedTypeMirror.createType(t, this, declaration);
    }

    public AnnotatedTypeMirror type(Tree node) {
        boolean isDeclaration = TreeUtils.isTypeDeclaration(node);
        if (InternalUtils.typeOf(node) != null) {
            AnnotatedTypeMirror result = this.toAnnotatedType(InternalUtils.typeOf(node), isDeclaration);
            return result;
        }
        TreePath path = this.getPath(node);
        assert (path != null) : "No path or type in tree: " + node;
        TypeMirror t = this.trees.getTypeMirror(path);
        assert (AnnotatedTypeFactory.validType(t)) : "Invalid type " + t + " for node " + t;
        return this.toAnnotatedType(t, isDeclaration);
    }

    public final Tree declarationFromElement(Element elt) {
        Tree fromElt;
        if (this.root == null) {
            return null;
        }
        if (this.elementToTreeCache.containsKey(elt) && this.shouldReadCache) {
            return this.elementToTreeCache.get(elt);
        }
        if (elt instanceof DetachedVarSymbol) {
            return ((DetachedVarSymbol)elt).getDeclaration();
        }
        switch (elt.getKind()) {
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: 
            case FIELD: 
            case ENUM_CONSTANT: 
            case METHOD: 
            case CONSTRUCTOR: {
                fromElt = this.trees.getTree(elt);
                break;
            }
            default: {
                fromElt = TreeInfo.declarationFor((Symbol)elt, (JCTree)((Object)this.root));
            }
        }
        if (this.shouldCache) {
            this.elementToTreeCache.put(elt, fromElt);
        }
        return fromElt;
    }

    protected final ClassTree getCurrentClassTree(Tree tree) {
        if (this.visitorState.getClassTree() != null) {
            return this.visitorState.getClassTree();
        }
        return TreeUtils.enclosingClass(this.getPath(tree));
    }

    protected final AnnotatedTypeMirror.AnnotatedDeclaredType getCurrentClassType(Tree tree) {
        return this.getAnnotatedType(this.getCurrentClassTree(tree));
    }

    protected final @Nullable AnnotatedTypeMirror.AnnotatedDeclaredType getCurrentMethodReceiver(Tree tree) {
        TreePath path;
        AnnotatedTypeMirror.AnnotatedDeclaredType res = this.visitorState.getMethodReceiver();
        if (res == null && (path = this.getPath(tree)) != null) {
            MethodTree enclosingMethod = TreeUtils.enclosingMethod(path);
            ClassTree enclosingClass = TreeUtils.enclosingClass(path);
            boolean found = false;
            for (Tree tree2 : enclosingClass.getMembers()) {
                if (tree2.getKind() != Tree.Kind.METHOD || tree2 != enclosingMethod) continue;
                found = true;
            }
            if (found && enclosingMethod != null) {
                AnnotatedTypeMirror.AnnotatedExecutableType method = this.getAnnotatedType(enclosingMethod);
                res = method.getReceiverType();
            } else {
                res = this.getAnnotatedType(enclosingClass);
            }
        }
        return res;
    }

    protected final boolean isWithinConstructor(Tree tree) {
        if (this.visitorState.getClassType() != null) {
            return this.visitorState.getMethodTree() != null && TreeUtils.isConstructor(this.visitorState.getMethodTree());
        }
        MethodTree enclosingMethod = TreeUtils.enclosingMethod(this.getPath(tree));
        return enclosingMethod != null && TreeUtils.isConstructor(enclosingMethod);
    }

    private final Element getMostInnerClassOrMethod(Tree tree) {
        if (this.visitorState.getMethodTree() != null) {
            return TreeUtils.elementFromDeclaration(this.visitorState.getMethodTree());
        }
        if (this.visitorState.getClassTree() != null) {
            return TreeUtils.elementFromDeclaration(this.visitorState.getClassTree());
        }
        TreePath path = this.getPath(tree);
        if (path == null) {
            ErrorReporter.errorAbort(String.format("AnnotatedTypeFactory.getMostInnerClassOrMethod: getPath(tree)=>null%n  TreePath.getPath(root, tree)=>%s\n  for tree (%s) = %s%n  root=%s", TreePath.getPath(this.root, tree), tree.getClass(), tree, this.root));
            return null;
        }
        for (Tree pathTree : path) {
            if (pathTree instanceof MethodTree) {
                return TreeUtils.elementFromDeclaration((MethodTree)pathTree);
            }
            if (!(pathTree instanceof ClassTree)) continue;
            return TreeUtils.elementFromDeclaration((ClassTree)pathTree);
        }
        ErrorReporter.errorAbort("AnnotatedTypeFactory.getMostInnerClassOrMethod: cannot be here!");
        return null;
    }

    public final void setPathHack(Tree node, Element enclosing) {
        this.pathHack.put(node, enclosing);
    }

    public final TreePath getPath(Tree node) {
        assert (this.root != null) : "AnnotatedTypeFactory.getPath: root needs to be set when used on trees; factory: " + this.getClass();
        if (node == null) {
            return null;
        }
        if (this.treePathCache.isCached(node)) {
            return this.treePathCache.getPath(this.root, node);
        }
        TreePath currentPath = this.visitorState.getPath();
        if (currentPath == null) {
            return TreePath.getPath(this.root, node);
        }
        if (currentPath.getLeaf() == node) {
            return currentPath;
        }
        if (currentPath.getParentPath() != null) {
            currentPath = currentPath.getParentPath();
        }
        if (currentPath.getLeaf() == node) {
            return currentPath;
        }
        if (currentPath.getParentPath() != null) {
            currentPath = currentPath.getParentPath();
        }
        if (currentPath.getLeaf() == node) {
            return currentPath;
        }
        TreePath pathWithinSubtree = TreePath.getPath(currentPath, node);
        if (pathWithinSubtree != null) {
            return pathWithinSubtree;
        }
        for (TreePath current = currentPath; current != null; current = current.getParentPath()) {
            if (current.getLeaf() != node) continue;
            return current;
        }
        return this.treePathCache.getPath(this.root, node);
    }

    public final Element getEnclosingMethod(Tree node) {
        return this.pathHack.get(node);
    }

    static final boolean validAnnotatedType(AnnotatedTypeMirror type) {
        if (type == null) {
            return false;
        }
        if (type.getUnderlyingType() == null) {
            return true;
        }
        return AnnotatedTypeFactory.validType(type.getUnderlyingType());
    }

    private static final boolean validType(TypeMirror type) {
        if (type == null) {
            return false;
        }
        switch (type.getKind()) {
            case ERROR: 
            case OTHER: 
            case PACKAGE: {
                return false;
            }
        }
        return true;
    }

    protected void buildIndexTypes() {
        String[] stubArray;
        StubFiles sfanno;
        InputStream input;
        StubParser stubParser;
        if (this.indexTypes != null || this.indexDeclAnnos != null) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.buildIndexTypes called more than once");
        }
        HashMap<Element, AnnotatedTypeMirror> indexTypes = new HashMap<Element, AnnotatedTypeMirror>();
        HashMap<String, Set<AnnotationMirror>> indexDeclAnnos = new HashMap<String, Set<AnnotationMirror>>();
        if (!this.checker.hasOption("ignorejdkastub")) {
            InputStream in = null;
            if (this.checker != null) {
                in = this.checker.getClass().getResourceAsStream("jdk.astub");
            }
            if (in != null) {
                stubParser = new StubParser("jdk.astub", in, this, this.processingEnv);
                stubParser.parse(indexTypes, indexDeclAnnos);
            }
        }
        if ((input = BaseTypeChecker.class.getResourceAsStream("flow.astub")) != null) {
            stubParser = new StubParser("flow.astub", input, this, this.processingEnv);
            stubParser.parse(indexTypes, indexDeclAnnos);
        }
        String allstubFiles = "";
        String stubFiles = this.checker.getOption("stubs");
        if (stubFiles != null) {
            allstubFiles = allstubFiles + File.pathSeparator + stubFiles;
        }
        if ((stubFiles = System.getProperty("stubs")) != null) {
            allstubFiles = allstubFiles + File.pathSeparator + stubFiles;
        }
        if ((stubFiles = System.getenv("stubs")) != null) {
            allstubFiles = allstubFiles + File.pathSeparator + stubFiles;
        }
        if ((sfanno = this.checker.getClass().getAnnotation(StubFiles.class)) != null) {
            String[] sfarr = sfanno.value();
            stubFiles = "";
            String[] stringArray = sfarr;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String sf = stringArray[i];
                stubFiles = stubFiles + File.pathSeparator + sf;
            }
            allstubFiles = allstubFiles + stubFiles;
        }
        if (allstubFiles.isEmpty()) {
            this.indexTypes = indexTypes;
            this.indexDeclAnnos = indexDeclAnnos;
            return;
        }
        for (String stubPath : stubArray = allstubFiles.split(File.pathSeparator)) {
            List<StubResource> stubs;
            if (stubPath == null || stubPath.isEmpty()) continue;
            String base = System.getProperty("test.src");
            String stubPathFull = stubPath;
            if (base != null) {
                stubPathFull = base + "/" + stubPath;
            }
            if ((stubs = StubUtil.allStubFiles(stubPathFull)).size() == 0) {
                InputStream in = null;
                if (this.checker != null) {
                    in = this.checker.getClass().getResourceAsStream(stubPath);
                }
                if (in != null) {
                    StubParser stubParser2 = new StubParser(stubPath, in, this, this.processingEnv);
                    stubParser2.parse(indexTypes, indexDeclAnnos);
                    continue;
                }
                this.checker.message(Diagnostic.Kind.NOTE, "Did not find stub file or files within directory: " + stubPath + " " + new File(stubPath).getAbsolutePath(), new Object[0]);
            }
            for (StubResource resource : stubs) {
                InputStream stubStream;
                try {
                    stubStream = resource.getInputStream();
                }
                catch (IOException e) {
                    this.checker.message(Diagnostic.Kind.NOTE, "Could not read stub resource: " + resource.getDescription(), new Object[0]);
                    continue;
                }
                StubParser stubParser3 = new StubParser(resource.getDescription(), stubStream, this, this.processingEnv);
                stubParser3.parse(indexTypes, indexDeclAnnos);
            }
        }
        this.indexTypes = indexTypes;
        this.indexDeclAnnos = indexDeclAnnos;
    }

    @Override
    public AnnotationMirror getDeclAnnotation(Element elt, Class<? extends Annotation> anno) {
        String annoName = anno.getCanonicalName().intern();
        return this.getDeclAnnotation(elt, annoName, true);
    }

    public boolean isFromStubFile(Element element) {
        return this.getDeclAnnotation(element, FromStubFile.class) != null;
    }

    public boolean isFromByteCode(Element element) {
        if (this.isFromStubFile(element)) {
            return false;
        }
        return this.getDeclAnnotation(element, FromByteCode.class) != null;
    }

    protected AnnotationMirror getDeclAnnotation(Element elt, @Interned String annoName, boolean checkAliases) {
        Pair<AnnotationMirror, Set<String>> aliases;
        Set<AnnotationMirror> declAnnos = this.getDeclAnnotations(elt);
        for (AnnotationMirror am : declAnnos) {
            if (!AnnotationUtils.areSameByName(am, annoName)) continue;
            return am;
        }
        if (checkAliases && (aliases = this.declAliases.get(annoName)) != null) {
            for (String alias : (Set)aliases.second) {
                AnnotationMirror declAnnotation = this.getDeclAnnotation(elt, alias, false);
                if (declAnnotation == null) continue;
                return (AnnotationMirror)aliases.first;
            }
        }
        return null;
    }

    public Set<AnnotationMirror> getDeclAnnotations(Element elt) {
        if (this.cacheDeclAnnos.containsKey(elt)) {
            return this.cacheDeclAnnos.get(elt);
        }
        Set<AnnotationMirror> results = AnnotationUtils.createAnnotationSet();
        results.addAll(elt.getAnnotationMirrors());
        if (this.indexDeclAnnos != null) {
            this.addFromByteCode(elt);
            String eltName = ElementUtils.getVerboseName(elt);
            Set<AnnotationMirror> stubAnnos = this.indexDeclAnnos.get(eltName);
            if (stubAnnos != null) {
                results.addAll(stubAnnos);
            }
            if (elt.getKind() == ElementKind.METHOD) {
                this.inheritOverriddenDeclAnnos((ExecutableElement)elt, results);
            }
            this.cacheDeclAnnos.put(elt, results);
        }
        return results;
    }

    private void inheritOverriddenDeclAnnos(ExecutableElement elt, Set<AnnotationMirror> results) {
        Map<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overriddenMethods = AnnotatedTypes.overriddenMethods(this.elements, this, elt);
        if (overriddenMethods != null) {
            for (Map.Entry<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> pair : overriddenMethods.entrySet()) {
                AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType = pair.getKey();
                AnnotatedTypeMirror.AnnotatedExecutableType overriddenMethod = AnnotatedTypes.asMemberOf(this.types, this, (AnnotatedTypeMirror)overriddenType, pair.getValue());
                ExecutableElement superElt = overriddenMethod.getElement();
                Set<AnnotationMirror> superAnnos = this.getDeclAnnotations(superElt);
                for (AnnotationMirror annotation : superAnnos) {
                    List<? extends AnnotationMirror> annotationsOnAnnotation;
                    try {
                        annotationsOnAnnotation = annotation.getAnnotationType().asElement().getAnnotationMirrors();
                    }
                    catch (Symbol.CompletionFailure cf) {
                        this.checker.message(Diagnostic.Kind.WARNING, annotation.getAnnotationType().asElement(), "annotation.not.completed", ElementUtils.getVerboseName(elt), annotation);
                        continue;
                    }
                    if (!AnnotationUtils.containsSameByClass(annotationsOnAnnotation, InheritedAnnotation.class) && !AnnotationUtils.containsSameIgnoringValues(this.inheritedAnnotations, annotation)) continue;
                    this.addOrMerge(results, annotation);
                }
            }
        }
    }

    private void addOrMerge(Set<AnnotationMirror> results, AnnotationMirror annotation) {
        if (!AnnotationUtils.containsSameIgnoringValues(results, annotation)) {
            results.add(annotation);
        }
    }

    public List<Pair<AnnotationMirror, AnnotationMirror>> getDeclAnnotationWithMetaAnnotation(Element element, Class<? extends Annotation> metaAnnotation) {
        ArrayList<Pair<AnnotationMirror, AnnotationMirror>> result = new ArrayList<Pair<AnnotationMirror, AnnotationMirror>>();
        Set<AnnotationMirror> annotationMirrors = this.getDeclAnnotations(element);
        for (AnnotationMirror annotation : annotationMirrors) {
            List<? extends AnnotationMirror> annotationsOnAnnotation;
            try {
                annotationsOnAnnotation = annotation.getAnnotationType().asElement().getAnnotationMirrors();
            }
            catch (Symbol.CompletionFailure cf) {
                this.checker.message(Diagnostic.Kind.WARNING, annotation.getAnnotationType().asElement(), "annotation.not.completed", ElementUtils.getVerboseName(element), annotation);
                continue;
            }
            for (AnnotationMirror annotationMirror : annotationsOnAnnotation) {
                if (!AnnotationUtils.areSameByClass(annotationMirror, metaAnnotation)) continue;
                result.add(Pair.of(annotation, annotationMirror));
            }
        }
        return result;
    }

    public List<Pair<AnnotationMirror, AnnotationMirror>> getAnnotationWithMetaAnnotation(Element element, Class<? extends Annotation> metaAnnotation) {
        ArrayList<Pair<AnnotationMirror, AnnotationMirror>> result = new ArrayList<Pair<AnnotationMirror, AnnotationMirror>>();
        Set<AnnotationMirror> annotationMirrors = AnnotationUtils.createAnnotationSet();
        annotationMirrors.addAll(this.getAnnotatedType(element).getAnnotations());
        annotationMirrors.addAll(this.getDeclAnnotations(element));
        for (AnnotationMirror annotation : annotationMirrors) {
            List<? extends AnnotationMirror> annotationsOnAnnotation = annotation.getAnnotationType().asElement().getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annotationsOnAnnotation) {
                if (!AnnotationUtils.areSameByClass(annotationMirror, metaAnnotation)) continue;
                result.add(Pair.of(annotation, annotationMirror));
            }
        }
        return result;
    }

    public AnnotatedTypeMirror.AnnotatedWildcardType getUninferredWildcardType(AnnotatedTypeMirror.AnnotatedTypeVariable typeVar) {
        boolean intersectionType;
        TypeMirror boundType;
        if (typeVar.getUpperBound().getKind() == TypeKind.INTERSECTION) {
            boundType = typeVar.getUpperBound().directSuperTypes().get(0).getUnderlyingType();
            intersectionType = true;
        } else {
            boundType = typeVar.getUnderlyingType().getUpperBound();
            intersectionType = false;
        }
        WildcardType wc = this.types.getWildcardType(boundType, null);
        AnnotatedTypeMirror.AnnotatedWildcardType wctype = (AnnotatedTypeMirror.AnnotatedWildcardType)AnnotatedTypeMirror.createType(wc, this, false);
        if (!intersectionType) {
            wctype.setExtendsBound(typeVar.getUpperBound().deepCopy());
        } else {
            wctype.getExtendsBound().addAnnotations(typeVar.getUpperBound().getAnnotations());
        }
        wctype.setSuperBound(typeVar.getLowerBound().deepCopy());
        wctype.addAnnotations(typeVar.getAnnotations());
        wctype.setTypeArgHack();
        return wctype;
    }

    public AnnotatedTypeMirror widenToUpperBound(AnnotatedTypeMirror annotatedTypeMirror, AnnotatedTypeMirror.AnnotatedWildcardType wildcard) {
        TypeMirror toModifyTypeMirror = annotatedTypeMirror.getUnderlyingType();
        TypeMirror wildcardUpperBoundTypeMirror = wildcard.getExtendsBound().getUnderlyingType();
        if (!this.types.isSubtype(wildcardUpperBoundTypeMirror, toModifyTypeMirror) && this.types.isSubtype(toModifyTypeMirror, wildcardUpperBoundTypeMirror)) {
            return AnnotatedTypes.asSuper(this.types, this, annotatedTypeMirror, wildcard);
        }
        return annotatedTypeMirror;
    }

    public Pair<AnnotatedTypeMirror.AnnotatedDeclaredType, AnnotatedTypeMirror.AnnotatedExecutableType> getFnInterfaceFromTree(MemberReferenceTree tree) {
        return this.getFnInterfaceFromTree((Tree)tree);
    }

    public Pair<AnnotatedTypeMirror.AnnotatedDeclaredType, AnnotatedTypeMirror.AnnotatedExecutableType> getFnInterfaceFromTree(LambdaExpressionTree tree) {
        return this.getFnInterfaceFromTree((Tree)tree);
    }

    private Pair<AnnotatedTypeMirror.AnnotatedDeclaredType, AnnotatedTypeMirror.AnnotatedExecutableType> getFnInterfaceFromTree(Tree tree) {
        Context ctx = ((JavacProcessingEnvironment)this.getProcessingEnv()).getContext();
        com.sun.tools.javac.code.Types javacTypes = com.sun.tools.javac.code.Types.instance(ctx);
        AnnotatedTypeMirror.AnnotatedDeclaredType functionalInterfaceType = this.getFunctionalInterfaceType(tree, javacTypes);
        this.makeGroundTargetType(functionalInterfaceType);
        Symbol fnElement = javacTypes.findDescriptorSymbol(((Type)((Object)functionalInterfaceType.getUnderlyingType())).asElement());
        AnnotatedTypeMirror.AnnotatedExecutableType methodExe = (AnnotatedTypeMirror.AnnotatedExecutableType)AnnotatedTypes.asMemberOf(this.types, this, (AnnotatedTypeMirror)functionalInterfaceType, fnElement);
        return Pair.of(functionalInterfaceType, methodExe);
    }

    private AnnotatedTypeMirror.AnnotatedDeclaredType getFunctionalInterfaceType(Tree lambdaTree, com.sun.tools.javac.code.Types javacTypes) {
        Tree parentTree = TreePath.getPath(this.root, lambdaTree).getParentPath().getLeaf();
        switch (parentTree.getKind()) {
            case TYPE_CAST: {
                TypeCastTree cast = (TypeCastTree)parentTree;
                this.assertFunctionalInterface(javacTypes, (Type)this.trees.getTypeMirror(this.getPath(cast.getType())), parentTree, lambdaTree);
                AnnotatedTypeMirror castATM = this.getAnnotatedType(cast.getType());
                if (castATM.getKind() == TypeKind.INTERSECTION) {
                    AnnotatedTypeMirror.AnnotatedIntersectionType itype = (AnnotatedTypeMirror.AnnotatedIntersectionType)castATM;
                    for (AnnotatedTypeMirror annotatedTypeMirror : itype.directSuperTypes()) {
                        if (!javacTypes.isFunctionalInterface((Type)annotatedTypeMirror.getUnderlyingType())) continue;
                        return (AnnotatedTypeMirror.AnnotatedDeclaredType)annotatedTypeMirror;
                    }
                    ErrorReporter.errorAbort(String.format("Expected the type of a cast tree in an assignment context to contain a functional interface bound. Found type: %s for tree: %s in lambda tree: %s", castATM, cast, lambdaTree));
                }
                return (AnnotatedTypeMirror.AnnotatedDeclaredType)castATM;
            }
            case NEW_CLASS: {
                NewClassTree newClass = (NewClassTree)parentTree;
                int indexOfLambda = newClass.getArguments().indexOf(lambdaTree);
                Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> pair = this.constructorFromUse(newClass);
                AnnotatedTypeMirror constructorParam = AnnotatedTypes.unwrapVarargs(((AnnotatedTypeMirror.AnnotatedExecutableType)pair.first).getParameterTypes(), indexOfLambda);
                this.assertFunctionalInterface(javacTypes, (Type)constructorParam.getUnderlyingType(), parentTree, lambdaTree);
                return (AnnotatedTypeMirror.AnnotatedDeclaredType)constructorParam;
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree method = (MethodInvocationTree)parentTree;
                int index = method.getArguments().indexOf(lambdaTree);
                Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> exe = this.methodFromUse(method);
                AnnotatedTypeMirror param = AnnotatedTypes.unwrapVarargs(((AnnotatedTypeMirror.AnnotatedExecutableType)exe.first).getParameterTypes(), index);
                this.assertFunctionalInterface(javacTypes, (Type)param.getUnderlyingType(), parentTree, lambdaTree);
                return (AnnotatedTypeMirror.AnnotatedDeclaredType)param;
            }
            case VARIABLE: {
                VariableTree varTree = (VariableTree)parentTree;
                this.assertFunctionalInterface(javacTypes, (Type)InternalUtils.typeOf(varTree), parentTree, lambdaTree);
                return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType(varTree.getType());
            }
            case ASSIGNMENT: {
                AssignmentTree assignmentTree = (AssignmentTree)parentTree;
                this.assertFunctionalInterface(javacTypes, (Type)InternalUtils.typeOf(assignmentTree), parentTree, lambdaTree);
                return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType(assignmentTree.getVariable());
            }
            case RETURN: {
                Tree enclosing = TreeUtils.enclosingOfKind(TreePath.getPath(this.root, parentTree), new HashSet<Tree.Kind>(Arrays.asList(Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION)));
                if (enclosing.getKind() == Tree.Kind.METHOD) {
                    MethodTree enclosingMethod = (MethodTree)enclosing;
                    return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType(enclosingMethod.getReturnType());
                }
                LambdaExpressionTree enclosingLambda = (LambdaExpressionTree)enclosing;
                Pair<AnnotatedTypeMirror.AnnotatedDeclaredType, AnnotatedTypeMirror.AnnotatedExecutableType> result = this.getFnInterfaceFromTree(enclosingLambda);
                AnnotatedTypeMirror.AnnotatedExecutableType methodExe = (AnnotatedTypeMirror.AnnotatedExecutableType)result.second;
                return (AnnotatedTypeMirror.AnnotatedDeclaredType)methodExe.getReturnType();
            }
            case LAMBDA_EXPRESSION: {
                LambdaExpressionTree enclosingLambda = (LambdaExpressionTree)parentTree;
                Pair<AnnotatedTypeMirror.AnnotatedDeclaredType, AnnotatedTypeMirror.AnnotatedExecutableType> result = this.getFnInterfaceFromTree(enclosingLambda);
                AnnotatedTypeMirror.AnnotatedExecutableType methodExe = (AnnotatedTypeMirror.AnnotatedExecutableType)result.second;
                return (AnnotatedTypeMirror.AnnotatedDeclaredType)methodExe.getReturnType();
            }
            case CONDITIONAL_EXPRESSION: {
                ConditionalExpressionTree conditionalExpressionTree = (ConditionalExpressionTree)parentTree;
                AnnotatedTypeMirror falseType = this.getAnnotatedType(conditionalExpressionTree.getFalseExpression());
                AnnotatedTypeMirror trueType = this.getAnnotatedType(conditionalExpressionTree.getTrueExpression());
                AnnotatedTypeMirror conditionalType = AnnotatedTypes.leastUpperBound(this.processingEnv, this, trueType, falseType);
                this.assertFunctionalInterface(javacTypes, (Type)conditionalType.getUnderlyingType(), parentTree, lambdaTree);
                return (AnnotatedTypeMirror.AnnotatedDeclaredType)conditionalType;
            }
        }
        ErrorReporter.errorAbort("Could not find functional interface from assignment context. Unexpected tree type: " + (Object)((Object)parentTree.getKind()) + " For lambda tree: " + lambdaTree);
        return null;
    }

    private void assertFunctionalInterface(com.sun.tools.javac.code.Types javacTypes, Type type, Tree contextTree, Tree lambdaTree) {
        if (!javacTypes.isFunctionalInterface(type)) {
            if (type.getKind() == TypeKind.INTERSECTION) {
                IntersectionType itype = (IntersectionType)((Object)type);
                for (TypeMirror typeMirror : itype.getBounds()) {
                    if (!javacTypes.isFunctionalInterface((Type)typeMirror)) continue;
                    return;
                }
            }
            ErrorReporter.errorAbort(String.format("Expected the type of %s tree in assignment context to be a functional interface. Found type: %s for tree: %s in lambda tree: %s", new Object[]{contextTree.getKind(), type, contextTree, lambdaTree}));
        }
    }

    private void makeGroundTargetType(AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType) {
        if (overriddenType.getTypeArguments().size() > 0) {
            List<AnnotatedTypeParameterBounds> bounds = this.typeVariablesFromUse(overriddenType, (TypeElement)overriddenType.getUnderlyingType().asElement());
            ArrayList<AnnotatedTypeMirror> newTypeArguments = new ArrayList<AnnotatedTypeMirror>(overriddenType.getTypeArguments());
            for (int i = 0; i < overriddenType.getTypeArguments().size(); ++i) {
                AnnotatedTypeMirror argType = overriddenType.getTypeArguments().get(i);
                if (argType.getKind() != TypeKind.WILDCARD) continue;
                AnnotatedTypeMirror.AnnotatedWildcardType wildcardType = (AnnotatedTypeMirror.AnnotatedWildcardType)argType;
                TypeMirror wilcardUbType = wildcardType.getExtendsBound().getUnderlyingType();
                TypeMirror typeParamUbType = bounds.get(i).getUpperBound().getUnderlyingType();
                if (this.isExtendsWildcard(wildcardType)) {
                    AnnotatedTypeMirror newArg;
                    TypeMirror glbType = InternalUtils.greatestLowerBound(this.checker.getProcessingEnvironment(), typeParamUbType, wilcardUbType);
                    if (this.types.isSameType(wilcardUbType, glbType)) {
                        newArg = wildcardType.getExtendsBound().deepCopy();
                    } else {
                        newArg = this.toAnnotatedType(glbType, false);
                        newArg.replaceAnnotations(wildcardType.getExtendsBound().getAnnotations());
                    }
                    newTypeArguments.set(i, newArg);
                    continue;
                }
                newTypeArguments.set(i, wildcardType.getSuperBound());
            }
            overriddenType.setTypeArguments(newTypeArguments);
        }
    }

    private boolean isExtendsWildcard(AnnotatedTypeMirror.AnnotatedWildcardType awt) {
        return awt.getUnderlyingType().getSuperBound() == null;
    }

    public Elements getElementUtils() {
        return this.elements;
    }

    public Trees getTreeUtils() {
        return this.trees;
    }

    public ProcessingEnvironment getProcessingEnv() {
        return this.processingEnv;
    }

    public CFContext getContext() {
        return this.checker;
    }

    protected static class InheritedFromClassAnnotator
    extends AnnotatedTypeScanner<Void, AnnotatedTypeFactory> {
        public static final InheritedFromClassAnnotator INSTANCE = new InheritedFromClassAnnotator();
        private final Map<TypeParameterElement, AnnotatedTypeMirror.AnnotatedTypeVariable> visited = new HashMap<TypeParameterElement, AnnotatedTypeMirror.AnnotatedTypeVariable>();

        private InheritedFromClassAnnotator() {
        }

        @Override
        public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, AnnotatedTypeFactory p) {
            Symbol.MethodSymbol methodElt = (Symbol.MethodSymbol)type.getElement();
            if (methodElt == null || !methodElt.isConstructor()) {
                this.scan(type.getReturnType(), p);
            }
            this.scanAndReduce(type.getParameterTypes(), p, null);
            this.scanAndReduce(type.getThrownTypes(), p, null);
            this.scanAndReduce(type.getTypeVariables(), p, null);
            return null;
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeFactory p) {
            Element classElt = type.getUnderlyingType().asElement();
            if (classElt != null) {
                AnnotatedTypeMirror classType = p.fromElement(classElt);
                assert (classType != null) : "Unexpected null type for class element: " + classElt;
                p.annotateInheritedFromClass(type, classType.getAnnotations());
            }
            return (Void)super.visitDeclared(type, p);
        }

        @Override
        public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeFactory p) {
            TypeParameterElement tpelt = (TypeParameterElement)type.getUnderlyingType().asElement();
            if (!this.visited.containsKey(tpelt)) {
                this.visited.put(tpelt, type);
                if (type.getAnnotations().isEmpty() && type.getUpperBound().getAnnotations().isEmpty() && tpelt.getEnclosingElement().getKind() != ElementKind.TYPE_PARAMETER) {
                    ElementAnnotationApplier.apply(type, tpelt, p);
                }
                super.visitTypeVariable(type, p);
                this.visited.remove(tpelt);
            }
            return null;
        }

        @Override
        public void reset() {
            this.visited.clear();
            super.reset();
        }
    }
}

