/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.defaults;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Elements;
import org.checkerframework.framework.qual.AnnotatedFor;
import org.checkerframework.framework.qual.DefaultLocation;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.checkerframework.framework.qual.DefaultQualifiers;
import org.checkerframework.framework.source.SourceChecker;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;
import org.checkerframework.framework.util.CheckerMain;
import org.checkerframework.framework.util.defaults.Default;
import org.checkerframework.framework.util.defaults.DefaultSet;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.CollectionUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;

public class QualifierDefaults {
    private boolean applyToTypeVar = false;
    private final Elements elements;
    private final AnnotatedTypeFactory atypeFactory;
    private final List<String> upstreamCheckerNames;
    private final DefaultSet checkedCodeDefaults = new DefaultSet();
    private final DefaultSet uncheckedCodeDefaults = new DefaultSet();
    private static final int CACHE_SIZE = 300;
    protected static final Map<Element, BoundType> elementToBoundType = CollectionUtils.createLRUCache(300);
    private final Map<Element, DefaultSet> elementDefaults = new IdentityHashMap<Element, DefaultSet>();
    private final Map<Element, Boolean> elementAnnotatedFors = new IdentityHashMap<Element, Boolean>();
    private static final DefaultLocation[] validUncheckedCodeDefaultLocations = new DefaultLocation[]{DefaultLocation.FIELD, DefaultLocation.PARAMETERS, DefaultLocation.RETURNS, DefaultLocation.RECEIVERS, DefaultLocation.UPPER_BOUNDS, DefaultLocation.LOWER_BOUNDS, DefaultLocation.OTHERWISE, DefaultLocation.ALL};

    public static DefaultLocation[] validLocationsForUncheckedCodeDefaults() {
        return validUncheckedCodeDefaultLocations;
    }

    public QualifierDefaults(Elements elements, AnnotatedTypeFactory atypeFactory) {
        this.elements = elements;
        this.atypeFactory = atypeFactory;
        this.upstreamCheckerNames = atypeFactory.getContext().getChecker().getUpstreamCheckerNames();
    }

    public void addCheckedCodeDefault(AnnotationMirror absoluteDefaultAnno, DefaultLocation location) {
        this.checkDuplicates(this.checkedCodeDefaults, absoluteDefaultAnno, location);
        this.checkedCodeDefaults.add(new Default(absoluteDefaultAnno, location));
    }

    public void addUncheckedCodeDefault(AnnotationMirror uncheckedDefaultAnno, DefaultLocation location) {
        this.checkDuplicates(this.uncheckedCodeDefaults, uncheckedDefaultAnno, location);
        this.checkIsValidUncheckedCodeLocation(uncheckedDefaultAnno, location);
        this.uncheckedCodeDefaults.add(new Default(uncheckedDefaultAnno, location));
    }

    public void addUncheckedCodeDefaults(AnnotationMirror absoluteDefaultAnno, DefaultLocation[] locations) {
        for (DefaultLocation location : locations) {
            this.addUncheckedCodeDefault(absoluteDefaultAnno, location);
        }
    }

    public void addCheckedCodeDefaults(AnnotationMirror absoluteDefaultAnno, DefaultLocation[] locations) {
        for (DefaultLocation location : locations) {
            this.addCheckedCodeDefault(absoluteDefaultAnno, location);
        }
    }

    public void addElementDefault(Element elem, AnnotationMirror elementDefaultAnno, DefaultLocation location) {
        DefaultSet prevset = this.elementDefaults.get(elem);
        if (prevset != null) {
            this.checkDuplicates(prevset, elementDefaultAnno, location);
        } else {
            prevset = new DefaultSet();
        }
        prevset.add(new Default(elementDefaultAnno, location));
        this.elementDefaults.put(elem, prevset);
    }

    private void checkIsValidUncheckedCodeLocation(AnnotationMirror uncheckedDefaultAnno, DefaultLocation location) {
        boolean isValidUntypeLocation = false;
        for (DefaultLocation validLoc : QualifierDefaults.validLocationsForUncheckedCodeDefaults()) {
            if (location != validLoc) continue;
            isValidUntypeLocation = true;
            break;
        }
        if (!isValidUntypeLocation) {
            ErrorReporter.errorAbort("Invalid unchecked code default location: " + (Object)((Object)location) + " -> " + uncheckedDefaultAnno);
        }
    }

    private void checkDuplicates(DefaultSet previousDefaults, AnnotationMirror newAnno, DefaultLocation newLoc) {
        QualifierHierarchy qualHierarchy = this.atypeFactory.getQualifierHierarchy();
        for (Default previous : previousDefaults) {
            AnnotationMirror previousTop;
            if (newAnno.equals(previous.anno) || previous.location != newLoc || !qualHierarchy.isSubtype(newAnno, previousTop = qualHierarchy.getTopAnnotation(previous.anno))) continue;
            ErrorReporter.errorAbort("Only one qualifier from a hierarchy can be the default! Existing: " + previousDefaults + " and new: " + new Default(newAnno, newLoc));
        }
    }

    public void annotate(Element elt, AnnotatedTypeMirror type) {
        this.applyDefaultsElement(elt, type);
    }

    public void annotate(Tree tree, AnnotatedTypeMirror type) {
        this.applyDefaults(tree, type);
    }

    private Element nearestEnclosingExceptLocal(Tree tree) {
        TreePath path = this.atypeFactory.getPath(tree);
        if (path == null) {
            Element method = this.atypeFactory.getEnclosingMethod(tree);
            if (method != null) {
                return method;
            }
            return InternalUtils.symbol(tree);
        }
        Tree prev = null;
        for (Tree t : path) {
            switch (t.getKind()) {
                case VARIABLE: {
                    VariableTree vtree = (VariableTree)t;
                    ExpressionTree vtreeInit = vtree.getInitializer();
                    if (vtreeInit != null && prev == vtreeInit) {
                        VariableElement elt = TreeUtils.elementFromDeclaration((VariableTree)t);
                        DefaultQualifier d = elt.getAnnotation(DefaultQualifier.class);
                        DefaultQualifiers ds = elt.getAnnotation(DefaultQualifiers.class);
                        if (d == null && ds == null) break;
                    }
                    if (prev != null && prev.getKind() == Tree.Kind.MODIFIERS) break;
                    return TreeUtils.elementFromDeclaration((VariableTree)t);
                }
                case METHOD: {
                    return TreeUtils.elementFromDeclaration((MethodTree)t);
                }
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case ANNOTATION_TYPE: {
                    return TreeUtils.elementFromDeclaration((ClassTree)t);
                }
            }
            prev = t;
        }
        return null;
    }

    private void applyDefaults(Tree tree, AnnotatedTypeMirror type) {
        Element elt;
        switch (tree.getKind()) {
            case MEMBER_SELECT: {
                elt = TreeUtils.elementFromUse((MemberSelectTree)tree);
                break;
            }
            case IDENTIFIER: {
                elt = TreeUtils.elementFromUse((IdentifierTree)tree);
                break;
            }
            case METHOD_INVOCATION: {
                elt = TreeUtils.elementFromUse((MethodInvocationTree)tree);
                break;
            }
            default: {
                elt = this.nearestEnclosingExceptLocal(tree);
            }
        }
        if (elt != null) {
            boolean useFlow = this.atypeFactory instanceof GenericAnnotatedTypeFactory && ((GenericAnnotatedTypeFactory)this.atypeFactory).getUseFlow();
            this.applyToTypeVar = useFlow && elt.getKind() == ElementKind.LOCAL_VARIABLE && type.getKind() == TypeKind.TYPEVAR && this.atypeFactory.type(tree).getKind() == TypeKind.TYPEVAR;
            this.applyDefaultsElement(elt, type);
            this.applyToTypeVar = false;
        }
    }

    private DefaultSet fromDefaultQualifier(DefaultQualifier dq) {
        Class<Annotation> cls;
        try {
            cls = dq.value();
        }
        catch (MirroredTypeException mte) {
            try {
                Class<?> clscast = Class.forName(mte.getTypeMirror().toString());
                cls = clscast;
            }
            catch (ClassNotFoundException e) {
                ErrorReporter.errorAbort("Could not load qualifier: " + e.getMessage(), e);
                cls = null;
            }
        }
        AnnotationMirror anno = AnnotationUtils.fromClass(this.elements, cls);
        if (anno == null) {
            return null;
        }
        if (!this.atypeFactory.isSupportedQualifier(anno)) {
            anno = this.atypeFactory.aliasedAnnotation(anno);
        }
        if (this.atypeFactory.isSupportedQualifier(anno)) {
            EnumSet<DefaultLocation[]> locations = EnumSet.of(dq.locations()[0], dq.locations());
            DefaultSet ret = new DefaultSet();
            for (DefaultLocation defaultLocation : locations) {
                ret.add(new Default(anno, defaultLocation));
            }
            return ret;
        }
        return null;
    }

    private boolean isElementAnnotatedForThisChecker(Element elt) {
        Element parent;
        String[] checkers;
        boolean elementAnnotatedForThisChecker = false;
        if (elt == null) {
            return false;
        }
        if (this.elementAnnotatedFors.containsKey(elt)) {
            return this.elementAnnotatedFors.get(elt);
        }
        AnnotatedFor af = elt.getAnnotation(AnnotatedFor.class);
        if (af != null && (checkers = af.value()) != null) {
            for (String checker : checkers) {
                if (!CheckerMain.matchesFullyQualifiedProcessor(checker, this.upstreamCheckerNames, true)) continue;
                elementAnnotatedForThisChecker = true;
                break;
            }
        }
        if (!elementAnnotatedForThisChecker && this.isElementAnnotatedForThisChecker(parent = elt.getKind() == ElementKind.PACKAGE ? ((Symbol)elt).owner : elt.getEnclosingElement())) {
            elementAnnotatedForThisChecker = true;
        }
        this.elementAnnotatedFors.put(elt, elementAnnotatedForThisChecker);
        return elementAnnotatedForThisChecker;
    }

    private DefaultSet defaultsAt(Element elt) {
        DefaultQualifiers ds;
        if (elt == null) {
            return DefaultSet.EMPTY;
        }
        if (this.elementDefaults.containsKey(elt)) {
            return this.elementDefaults.get(elt);
        }
        DefaultSet qualifiers = null;
        DefaultQualifier d = elt.getAnnotation(DefaultQualifier.class);
        if (d != null) {
            qualifiers = new DefaultSet();
            DefaultQualifier[] p = this.fromDefaultQualifier(d);
            if (p != null) {
                qualifiers.addAll(p);
            }
        }
        if ((ds = elt.getAnnotation(DefaultQualifiers.class)) != null) {
            if (qualifiers == null) {
                qualifiers = new DefaultSet();
            }
            for (DefaultQualifier d2 : ds.value()) {
                DefaultSet p = this.fromDefaultQualifier(d2);
                if (p == null) continue;
                qualifiers.addAll(p);
            }
        }
        Element parent = elt.getKind() == ElementKind.PACKAGE ? ((Symbol)elt).owner : elt.getEnclosingElement();
        DefaultSet parentDefaults = this.defaultsAt(parent);
        if (qualifiers == null || qualifiers.isEmpty()) {
            qualifiers = parentDefaults;
        } else {
            qualifiers.addAll(parentDefaults);
        }
        if (qualifiers != null && !qualifiers.isEmpty()) {
            this.elementDefaults.put(elt, qualifiers);
            return qualifiers;
        }
        return DefaultSet.EMPTY;
    }

    public boolean applyUncheckedCodeDefaults(Element annotationScope) {
        boolean annotatedForThisChecker = this.isElementAnnotatedForThisChecker(annotationScope);
        if (this.uncheckedCodeDefaults.size() > 0) {
            SourceChecker checker = this.atypeFactory.getContext().getChecker();
            return checker.hasOption("safeDefaultsForUnannotatedBytecode") && ElementUtils.isElementFromByteCode(annotationScope) && this.atypeFactory.declarationFromElement(annotationScope) == null && !this.atypeFactory.isFromStubFile(annotationScope) || checker.hasOption("useSafeDefaultsForUnannotatedSourceCode") && !annotatedForThisChecker;
        }
        return false;
    }

    private void applyDefaultsElement(Element annotationScope, AnnotatedTypeMirror type) {
        DefaultSet defaults = this.defaultsAt(annotationScope);
        DefaultApplierElement applier = new DefaultApplierElement(this.atypeFactory, annotationScope, type, this.applyToTypeVar);
        for (Default def : defaults) {
            applier.apply(def);
        }
        if (this.applyUncheckedCodeDefaults(annotationScope)) {
            for (Default def : this.uncheckedCodeDefaults) {
                applier.apply(def);
            }
        }
        for (Default def : this.checkedCodeDefaults) {
            applier.apply(def);
        }
    }

    private static BoundType getBoundType(AnnotatedTypeMirror type, AnnotatedTypeFactory typeFactory) {
        if (type instanceof AnnotatedTypeMirror.AnnotatedTypeVariable) {
            return QualifierDefaults.getTypeVarBoundType((AnnotatedTypeMirror.AnnotatedTypeVariable)type, typeFactory);
        }
        if (type instanceof AnnotatedTypeMirror.AnnotatedWildcardType) {
            return QualifierDefaults.getWilcardBoundType((AnnotatedTypeMirror.AnnotatedWildcardType)type, typeFactory);
        }
        ErrorReporter.errorAbort("Unexpected type kind: type=" + type);
        return null;
    }

    private static BoundType getTypeVarBoundType(AnnotatedTypeMirror.AnnotatedTypeVariable typeVar, AnnotatedTypeFactory typeFactory) {
        return QualifierDefaults.getTypeVarBoundType((TypeParameterElement)typeVar.getUnderlyingType().asElement(), typeFactory);
    }

    private static BoundType getTypeVarBoundType(TypeParameterElement typeParamElem, AnnotatedTypeFactory typeFactory) {
        BoundType boundType;
        Tree typeParamDecl;
        BoundType prev = elementToBoundType.get(typeParamElem);
        if (prev != null) {
            return prev;
        }
        TreePath declaredTypeVarEle = typeFactory.getTreeUtils().getPath(typeParamElem);
        Tree tree = typeParamDecl = declaredTypeVarEle == null ? null : declaredTypeVarEle.getLeaf();
        if (typeParamDecl == null) {
            boundType = BoundType.UNKNOWN;
        } else if (typeParamDecl.getKind() == Tree.Kind.TYPE_PARAMETER) {
            TypeParameterTree tptree = (TypeParameterTree)typeParamDecl;
            List<? extends Tree> bnds = tptree.getBounds();
            boundType = bnds != null && !bnds.isEmpty() ? BoundType.UPPER : BoundType.UNBOUND;
        } else {
            ErrorReporter.errorAbort("Unexpected tree type for typeVar Element:\ntypeParamElem=" + typeParamElem + "\n" + typeParamDecl);
            boundType = null;
        }
        elementToBoundType.put(typeParamElem, boundType);
        return boundType;
    }

    public static BoundType getWilcardBoundType(AnnotatedTypeMirror.AnnotatedWildcardType annotatedWildcard, AnnotatedTypeFactory typeFactory) {
        Type.WildcardType wildcard = (Type.WildcardType)annotatedWildcard.getUnderlyingType();
        BoundType boundType = wildcard.isUnbound() && wildcard.bound != null ? QualifierDefaults.getTypeVarBoundType((TypeParameterElement)wildcard.bound.asElement(), typeFactory) : (wildcard.isSuperBound() ? BoundType.LOWER : BoundType.UPPER);
        return boundType;
    }

    static enum BoundType {
        UPPER,
        LOWER,
        UNBOUND,
        UNKNOWN;


        public boolean isOneOf(BoundType ... choices) {
            for (BoundType choice : choices) {
                if (this != choice) continue;
                return true;
            }
            return false;
        }
    }

    public static class DefaultApplierElement {
        private final AnnotatedTypeFactory atypeFactory;
        private final Element scope;
        private final AnnotatedTypeMirror type;
        private DefaultLocation location;
        private final DefaultApplierElementImpl impl;
        private final AnnotatedTypeMirror.AnnotatedTypeVariable defaultableTypeVar;

        public DefaultApplierElement(AnnotatedTypeFactory atypeFactory, Element scope, AnnotatedTypeMirror type, boolean applyToTypeVar) {
            this.atypeFactory = atypeFactory;
            this.scope = scope;
            this.type = type;
            this.impl = new DefaultApplierElementImpl();
            this.defaultableTypeVar = applyToTypeVar ? (AnnotatedTypeMirror.AnnotatedTypeVariable)type : null;
        }

        public void apply(Default def) {
            this.location = def.location;
            this.impl.visit(this.type, def.anno);
        }

        private static boolean shouldBeAnnotated(AnnotatedTypeMirror type, boolean applyToTypeVar) {
            return type != null && type.getKind() != TypeKind.NONE && type.getKind() != TypeKind.WILDCARD && (type.getKind() != TypeKind.TYPEVAR || applyToTypeVar) && !(type instanceof AnnotatedTypeMirror.AnnotatedNoType);
        }

        private static void doApply(AnnotatedTypeMirror type, AnnotationMirror qual) {
            List<AnnotatedTypeMirror.AnnotatedDeclaredType> sups;
            if (!type.isAnnotatedInHierarchy(qual)) {
                type.addAnnotation(qual);
            }
            if (type.getKind() == TypeKind.INTERSECTION && (sups = ((AnnotatedTypeMirror.AnnotatedIntersectionType)type).directSuperTypesField()) != null) {
                for (AnnotatedTypeMirror annotatedTypeMirror : sups) {
                    if (annotatedTypeMirror.isAnnotatedInHierarchy(qual)) continue;
                    annotatedTypeMirror.addAnnotation(qual);
                }
            }
        }

        private class DefaultApplierElementImpl
        extends AnnotatedTypeScanner<Void, AnnotationMirror> {
            private boolean isLowerBound = false;
            private boolean isUpperBound = false;
            private BoundType boundType = BoundType.UNBOUND;

            private DefaultApplierElementImpl() {
            }

            @Override
            public Void scan(AnnotatedTypeMirror t, AnnotationMirror qual) {
                if (!DefaultApplierElement.shouldBeAnnotated(t, t == DefaultApplierElement.this.defaultableTypeVar)) {
                    return (Void)super.scan(t, qual);
                }
                switch (DefaultApplierElement.this.location) {
                    case FIELD: {
                        if (DefaultApplierElement.this.scope == null || DefaultApplierElement.this.scope.getKind() != ElementKind.FIELD || t != DefaultApplierElement.this.type) break;
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    case LOCAL_VARIABLE: {
                        if (DefaultApplierElement.this.scope == null || DefaultApplierElement.this.scope.getKind() != ElementKind.LOCAL_VARIABLE || t != DefaultApplierElement.this.type) break;
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    case RESOURCE_VARIABLE: {
                        if (DefaultApplierElement.this.scope == null || DefaultApplierElement.this.scope.getKind() != ElementKind.RESOURCE_VARIABLE || t != DefaultApplierElement.this.type) break;
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    case EXCEPTION_PARAMETER: {
                        if (DefaultApplierElement.this.scope == null || DefaultApplierElement.this.scope.getKind() != ElementKind.EXCEPTION_PARAMETER || t != DefaultApplierElement.this.type) break;
                        DefaultApplierElement.doApply(t, qual);
                        if (t.getKind() != TypeKind.UNION) break;
                        AnnotatedTypeMirror.AnnotatedUnionType aut = (AnnotatedTypeMirror.AnnotatedUnionType)t;
                        for (AnnotatedTypeMirror.AnnotatedDeclaredType anno : aut.getAlternatives()) {
                            DefaultApplierElement.doApply(anno, qual);
                        }
                        break;
                    }
                    case PARAMETERS: {
                        if (DefaultApplierElement.this.scope != null && DefaultApplierElement.this.scope.getKind() == ElementKind.PARAMETER && t == DefaultApplierElement.this.type) {
                            DefaultApplierElement.doApply(t, qual);
                            break;
                        }
                        if (DefaultApplierElement.this.scope == null || DefaultApplierElement.this.scope.getKind() != ElementKind.METHOD && DefaultApplierElement.this.scope.getKind() != ElementKind.CONSTRUCTOR || t.getKind() != TypeKind.EXECUTABLE || t != DefaultApplierElement.this.type) break;
                        for (AnnotatedTypeMirror atm : ((AnnotatedTypeMirror.AnnotatedExecutableType)t).getParameterTypes()) {
                            if (!DefaultApplierElement.shouldBeAnnotated(atm, false)) continue;
                            DefaultApplierElement.doApply(atm, qual);
                        }
                        break;
                    }
                    case RECEIVERS: {
                        AnnotatedTypeMirror.AnnotatedDeclaredType receiver;
                        if (DefaultApplierElement.this.scope != null && DefaultApplierElement.this.scope.getKind() == ElementKind.PARAMETER && t == DefaultApplierElement.this.type && "this".equals(DefaultApplierElement.this.scope.getSimpleName())) {
                            DefaultApplierElement.doApply(t, qual);
                            break;
                        }
                        if (DefaultApplierElement.this.scope == null || DefaultApplierElement.this.scope.getKind() != ElementKind.METHOD || t.getKind() != TypeKind.EXECUTABLE || t != DefaultApplierElement.this.type || !DefaultApplierElement.shouldBeAnnotated(receiver = ((AnnotatedTypeMirror.AnnotatedExecutableType)t).getReceiverType(), false)) break;
                        DefaultApplierElement.doApply(receiver, qual);
                        break;
                    }
                    case RETURNS: {
                        AnnotatedTypeMirror returnType;
                        if (DefaultApplierElement.this.scope == null || DefaultApplierElement.this.scope.getKind() != ElementKind.METHOD || t.getKind() != TypeKind.EXECUTABLE || t != DefaultApplierElement.this.type || !DefaultApplierElement.shouldBeAnnotated(returnType = ((AnnotatedTypeMirror.AnnotatedExecutableType)t).getReturnType(), false)) break;
                        DefaultApplierElement.doApply(returnType, qual);
                        break;
                    }
                    case IMPLICIT_LOWER_BOUNDS: {
                        if (!this.isLowerBound || !this.boundType.isOneOf(BoundType.UNBOUND, BoundType.UPPER, BoundType.UNKNOWN)) break;
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    case EXPLICIT_LOWER_BOUNDS: {
                        if (!this.isLowerBound || !this.boundType.isOneOf(BoundType.LOWER)) break;
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    case LOWER_BOUNDS: {
                        if (!this.isLowerBound) break;
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    case IMPLICIT_UPPER_BOUNDS: {
                        if (!this.isUpperBound || !this.boundType.isOneOf(BoundType.UNBOUND, BoundType.LOWER)) break;
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    case EXPLICIT_UPPER_BOUNDS: {
                        if (!this.isUpperBound || !this.boundType.isOneOf(BoundType.UPPER, BoundType.UNKNOWN)) break;
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    case UPPER_BOUNDS: {
                        if (!this.isUpperBound) break;
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    case OTHERWISE: 
                    case ALL: {
                        DefaultApplierElement.doApply(t, qual);
                        break;
                    }
                    default: {
                        ErrorReporter.errorAbort("QualifierDefaults.DefaultApplierElement: unhandled location: " + (Object)((Object)DefaultApplierElement.this.location));
                        return null;
                    }
                }
                return (Void)super.scan(t, qual);
            }

            @Override
            public void reset() {
                super.reset();
                ((DefaultApplierElement)DefaultApplierElement.this).impl.isLowerBound = false;
                ((DefaultApplierElement)DefaultApplierElement.this).impl.isUpperBound = false;
                ((DefaultApplierElement)DefaultApplierElement.this).impl.boundType = BoundType.UNBOUND;
            }

            @Override
            public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotationMirror qual) {
                if (this.visitedNodes.containsKey(type)) {
                    return (Void)this.visitedNodes.get(type);
                }
                this.visitBounds(type, type.getUpperBound(), type.getLowerBound(), qual);
                return null;
            }

            @Override
            public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotationMirror qual) {
                if (this.visitedNodes.containsKey(type)) {
                    return (Void)this.visitedNodes.get(type);
                }
                this.visitBounds(type, type.getExtendsBound(), type.getSuperBound(), qual);
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void visitBounds(AnnotatedTypeMirror boundedType, AnnotatedTypeMirror upperBound, AnnotatedTypeMirror lowerBound, AnnotationMirror qual) {
                boolean prevIsUpperBound = this.isUpperBound;
                boolean prevIsLowerBound = this.isLowerBound;
                BoundType prevBoundType = this.boundType;
                this.boundType = QualifierDefaults.getBoundType(boundedType, DefaultApplierElement.this.atypeFactory);
                try {
                    this.isLowerBound = true;
                    this.isUpperBound = false;
                    this.scanAndReduce(lowerBound, qual, null);
                    this.visitedNodes.put(DefaultApplierElement.this.type, null);
                    this.isLowerBound = false;
                    this.isUpperBound = true;
                    this.scanAndReduce(upperBound, qual, null);
                    this.visitedNodes.put(DefaultApplierElement.this.type, null);
                }
                finally {
                    this.isUpperBound = prevIsUpperBound;
                    this.isLowerBound = prevIsLowerBound;
                    this.boundType = prevBoundType;
                }
            }
        }
    }
}

