/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.poly.format;

import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.checkerframework.framework.type.AnnotatedTypeFormatter;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.DefaultAnnotatedTypeFormatter;
import org.checkerframework.framework.util.AnnotationFormatter;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.qualframework.base.TypeMirrorConverter;
import org.checkerframework.qualframework.base.format.DefaultQualifiedTypeFormatter;
import org.checkerframework.qualframework.poly.PolyQual;
import org.checkerframework.qualframework.poly.QualParams;
import org.checkerframework.qualframework.poly.format.PrettyQualParamsFormatter;
import org.checkerframework.qualframework.poly.format.QualParamsFormatter;

public class PrettyQualifiedTypeFormatter<Q>
extends DefaultQualifiedTypeFormatter<QualParams<Q>, PrettyQualParamsFormatter<Q>> {
    public PrettyQualifiedTypeFormatter(TypeMirrorConverter<QualParams<Q>> converter, Set<?> invisibleQualifiers, boolean useOldFormat, boolean defaultPrintInvisibleQualifiers) {
        super(new PrettyQualParamsFormatter(invisibleQualifiers), converter, useOldFormat, defaultPrintInvisibleQualifiers);
    }

    @Override
    protected AnnotatedTypeFormatter createAnnotatedTypeFormatter(AnnotationFormatter annotationFormatter) {
        return new QualParamsAnnoTypeFormatter(this.converter, (QualParamsFormatter)this.qualFormatter, annotationFormatter, this.useOldFormat, this.defaultPrintInvisibleQualifiers);
    }

    private static class QualParamsAnnoTypeFormatter<Q>
    extends DefaultAnnotatedTypeFormatter {
        protected QualParamsAnnoTypeFormatter(TypeMirrorConverter<QualParams<Q>> converter, QualParamsFormatter<Q> formatter, AnnotationFormatter annoFormatter, boolean printVerboseGenerics, boolean defaultPrintInvisibleQualifier) {
            super(new FormattingVisitor<Q>(converter, annoFormatter, formatter, printVerboseGenerics, defaultPrintInvisibleQualifier));
        }

        protected static class FormattingVisitor<Q>
        extends DefaultAnnotatedTypeFormatter.FormattingVisitor {
            private final TypeMirrorConverter<QualParams<Q>> converter;
            private final QualParamsFormatter<Q> formatter;

            public FormattingVisitor(TypeMirrorConverter<QualParams<Q>> converter, AnnotationFormatter annoFormatter, QualParamsFormatter<Q> formatter, boolean printVerboseGenerics, boolean defaultInvisiblesSetting) {
                super(annoFormatter, printVerboseGenerics, defaultInvisiblesSetting);
                this.converter = converter;
                this.formatter = formatter;
            }

            @Override
            public String visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Set<AnnotatedTypeMirror> visiting) {
                Element typeElt;
                String smpl;
                StringBuilder sb = new StringBuilder();
                if (type.isDeclaration()) {
                    sb.append("/*DECL*/ ");
                }
                if ((smpl = (typeElt = type.getUnderlyingType().asElement()).getSimpleName().toString()).isEmpty()) {
                    smpl = typeElt.toString();
                }
                for (AnnotationMirror annotationMirror : type.getAnnotations()) {
                    PolyQual<Q> qual;
                    String result;
                    if (!AnnotationUtils.areSameByClass(annotationMirror, TypeMirrorConverter.Key.class) || (result = this.formatter.format(qual = this.converter.getQualifier(annotationMirror).getPrimary(), this.currentPrintInvisibleSetting)) == null) continue;
                    sb.append(result);
                    sb.append(" ");
                }
                sb.append(smpl);
                boolean first = true;
                for (AnnotationMirror anno : type.getAnnotations()) {
                    QualParams<Q> qual;
                    String result;
                    if (!AnnotationUtils.areSameByClass(anno, TypeMirrorConverter.Key.class) || (result = this.formatter.format(qual = this.converter.getQualifier(anno), false, this.currentPrintInvisibleSetting)) == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        sb.append(" ");
                    }
                    sb.append(result);
                }
                List<AnnotatedTypeMirror> list = type.getTypeArguments();
                if (!list.isEmpty()) {
                    sb.append("<");
                    boolean isFirst = true;
                    for (AnnotatedTypeMirror typeArg : list) {
                        if (!isFirst) {
                            sb.append(", ");
                        }
                        sb.append(this.visit(typeArg, visiting));
                        isFirst = false;
                    }
                    sb.append(">");
                }
                return sb.toString();
            }
        }
    }
}

