/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.nullness.KeyForAnnotatedTypeFactory;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeValidator;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationUtils;

public class KeyForVisitor
extends BaseTypeVisitor<KeyForAnnotatedTypeFactory> {
    public KeyForVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, @CompilerMessageKey String errorKey, boolean isLocalVariableAssignement) {
        ((KeyForAnnotatedTypeFactory)this.atypeFactory).keyForCanonicalizeValues(varType, valueType, this.getCurrentPath());
        super.commonAssignmentCheck(varType, valueType, valueTree, errorKey, isLocalVariableAssignement);
    }

    @Override
    protected BaseTypeValidator createTypeValidator() {
        return new KeyForTypeValidator(this.checker, this, this.atypeFactory);
    }

    @Override
    protected boolean checkConstructorInvocation(AnnotatedTypeMirror.AnnotatedDeclaredType expectedReturnType, AnnotatedTypeMirror.AnnotatedExecutableType constructor, Tree src) {
        NewClassTree invocation = (NewClassTree)src;
        ((KeyForAnnotatedTypeFactory)this.atypeFactory).canonicalizeForViewpointAdaptation(invocation, expectedReturnType);
        return super.checkConstructorInvocation(expectedReturnType, constructor, invocation);
    }

    private static final class KeyForTypeValidator
    extends BaseTypeValidator {
        public KeyForTypeValidator(BaseTypeChecker checker, BaseTypeVisitor<?> visitor, AnnotatedTypeFactory atypeFactory) {
            super(checker, visitor, atypeFactory);
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Tree p) {
            AnnotationMirror kf = type.getAnnotation(KeyFor.class);
            if (kf != null) {
                ModifiersTree mt;
                List<String> maps = AnnotationUtils.getElementValueArray(kf, "value", String.class, false);
                boolean inStatic = false;
                if (p.getKind() == Tree.Kind.VARIABLE && (mt = ((VariableTree)p).getModifiers()).getFlags().contains((Object)Modifier.STATIC)) {
                    inStatic = true;
                }
                for (String map : maps) {
                    if (map.equals("this")) {
                        if (!inStatic) continue;
                        this.checker.report(Result.failure("keyfor.type.invalid", type.getAnnotations(), type.toString()), p);
                        continue;
                    }
                    if (!map.matches("#(\\d+)")) continue;
                }
            }
            if (type.isAnnotatedInHierarchy(((KeyForAnnotatedTypeFactory)this.atypeFactory).KEYFOR)) {
                return super.visitDeclared(type, p);
            }
            return null;
        }
    }
}

