/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.flow;

import java.util.Collection;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.dataflow.util.HashCodeUtils;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.type.visitor.AnnotatedTypeMerger;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;

public abstract class CFAbstractValue<V extends CFAbstractValue<V>>
implements AbstractValue<V> {
    protected final CFAbstractAnalysis<V, ?, ?> analysis;
    protected final TypeHierarchy typeHierarchy;
    protected final AnnotatedTypeMirror type;

    public CFAbstractValue(CFAbstractAnalysis<V, ?, ?> analysis, AnnotatedTypeMirror type) {
        assert (AnnotatedTypes.isValidType(analysis.qualifierHierarchy, type)) : "Encountered invalid type: " + type.toString(true);
        this.analysis = analysis;
        this.type = type;
        this.typeHierarchy = analysis.getTypeHierarchy();
    }

    @Pure
    public AnnotatedTypeMirror getType() {
        return this.type;
    }

    @Override
    public V leastUpperBound(@Nullable V other) {
        if (other == null) {
            CFAbstractValue v = this;
            return (V)v;
        }
        AnnotatedTypeMirror otherType = ((CFAbstractValue)other).getType();
        AnnotatedTypeMirror type = this.getType();
        GenericAnnotatedTypeFactory<V, ?, ?, CFAbstractAnalysis<V, ?, ?>> factory = this.analysis.getTypeFactory();
        ProcessingEnvironment processingEnv = factory.getProcessingEnv();
        AnnotatedTypeMirror lubAnnotatedType = AnnotatedTypes.leastUpperBound(processingEnv, factory, type, otherType);
        return this.analysis.createAbstractValue(lubAnnotatedType);
    }

    private static void copyArrayComponentAnnotations(AnnotatedTypeMirror.AnnotatedArrayType source, AnnotatedTypeMirror.AnnotatedArrayType dest) {
        AnnotatedTypeMirror destComp = dest.getComponentType();
        AnnotatedTypeMirror sourceComp = source.getComponentType();
        destComp.addAnnotations(sourceComp.getAnnotations());
        if (sourceComp instanceof AnnotatedTypeMirror.AnnotatedArrayType) {
            assert (dest instanceof AnnotatedTypeMirror.AnnotatedArrayType);
            CFAbstractValue.copyArrayComponentAnnotations((AnnotatedTypeMirror.AnnotatedArrayType)sourceComp, (AnnotatedTypeMirror.AnnotatedArrayType)destComp);
        }
    }

    private static Collection<AnnotationMirror> getUpperBound(AnnotatedTypeMirror t) {
        AnnotatedTypeMirror upperBound;
        if (t.getKind() == TypeKind.WILDCARD) {
            AnnotatedTypeMirror extendsBound = ((AnnotatedTypeMirror.AnnotatedWildcardType)t).getExtendsBound();
            if (extendsBound != null) {
                return extendsBound.getEffectiveAnnotations();
            }
        } else if (t.getKind() == TypeKind.TYPEVAR && (upperBound = ((AnnotatedTypeMirror.AnnotatedTypeVariable)t).getUpperBound()) != null) {
            return upperBound.getEffectiveAnnotations();
        }
        return t.getEffectiveAnnotations();
    }

    public boolean isSubtypeOf(CFAbstractValue<V> other) {
        if (other == null) {
            return true;
        }
        return this.typeHierarchy.isSubtype(this.type, other.getType());
    }

    public V mostSpecific(@Nullable V other, @Nullable V backup) {
        if (other == null) {
            CFAbstractValue v = this;
            return (V)v;
        }
        TypeMirror underlyingType = InternalUtils.greatestLowerBound(this.analysis.getEnv(), this.getType().getUnderlyingType(), ((CFAbstractValue)other).getType().getUnderlyingType());
        underlyingType = CFAbstractValue.handleTypeVarIntersections(this.getType().getUnderlyingType(), ((CFAbstractValue)other).getType().getUnderlyingType(), underlyingType);
        if (underlyingType.getKind() == TypeKind.ERROR || underlyingType.getKind() == TypeKind.NONE) {
            underlyingType = backup != null ? ((CFAbstractValue)backup).getType().getUnderlyingType() : this.getType().getUnderlyingType();
        }
        AnnotatedTypeMirror result = AnnotatedTypeMirror.createType(underlyingType, this.analysis.getTypeFactory(), false);
        AnnotatedTypeMirror otherType = ((CFAbstractValue)other).getType();
        if (CFAbstractValue.mostSpecific(this.analysis.getTypeFactory(), this.getType(), otherType, backup == null ? null : ((CFAbstractValue)backup).getType(), result)) {
            return this.analysis.createAbstractValue(result);
        }
        return backup;
    }

    private static TypeMirror handleTypeVarIntersections(TypeMirror thisType, TypeMirror other, TypeMirror glbType) {
        TypeMirror typeVar = null;
        if (thisType.getKind() == TypeKind.TYPEVAR) {
            typeVar = thisType;
        } else if (other.getKind() == TypeKind.TYPEVAR) {
            typeVar = other;
        }
        if (typeVar != null && glbType.getKind() == TypeKind.INTERSECTION) {
            for (TypeMirror typeMirror : ((IntersectionType)glbType).getBounds()) {
                if (!typeMirror.equals(typeVar)) continue;
                return typeVar;
            }
        }
        return glbType;
    }

    private static boolean mostSpecific(AnnotatedTypeFactory typeFactory, AnnotatedTypeMirror a, AnnotatedTypeMirror b, AnnotatedTypeMirror backup, AnnotatedTypeMirror result) {
        boolean canContainEmpty = QualifierHierarchy.canHaveEmptyAnnotationSet(a) && QualifierHierarchy.canHaveEmptyAnnotationSet(b) && QualifierHierarchy.canHaveEmptyAnnotationSet(result);
        TypeKind resultKind = result.getKind();
        if (resultKind == TypeKind.TYPEVAR) {
            return CFAbstractValue.mostSpecificTypeVariable(typeFactory, a, b, backup, (AnnotatedTypeMirror.AnnotatedTypeVariable)result);
        }
        QualifierHierarchy qualHierarchy = typeFactory.getQualifierHierarchy();
        for (AnnotationMirror annotationMirror : qualHierarchy.getTopAnnotations()) {
            AnnotationMirror bAnno;
            AnnotationMirror aAnno = canContainEmpty ? a.getAnnotationInHierarchy(annotationMirror) : a.getEffectiveAnnotationInHierarchy(annotationMirror);
            AnnotationMirror annotationMirror2 = bAnno = canContainEmpty ? b.getAnnotationInHierarchy(annotationMirror) : b.getEffectiveAnnotationInHierarchy(annotationMirror);
            if (qualHierarchy.isSubtype(a, b, aAnno, bAnno)) {
                if (aAnno == null) {
                    result.removeAnnotationInHierarchy(annotationMirror);
                    continue;
                }
                result.addAnnotation(aAnno);
                continue;
            }
            if (qualHierarchy.isSubtype(a, b, bAnno, aAnno)) {
                if (bAnno == null) {
                    result.removeAnnotationInHierarchy(annotationMirror);
                    continue;
                }
                result.addAnnotation(bAnno);
                continue;
            }
            if (backup != null) {
                result.addAnnotation(backup.getAnnotationInHierarchy(annotationMirror));
                continue;
            }
            return false;
        }
        if (resultKind == TypeKind.WILDCARD) {
            AnnotatedTypeMirror.AnnotatedWildcardType wResult = (AnnotatedTypeMirror.AnnotatedWildcardType)result;
            Collection<AnnotationMirror> collection = CFAbstractValue.getUpperBound(a);
            Collection<AnnotationMirror> extendsBound2 = CFAbstractValue.getUpperBound(b);
            wResult.addAnnotations(CFAbstractValue.mostSpecific(qualHierarchy, collection, extendsBound2));
        } else {
            AnnotatedTypeMirror.AnnotatedArrayType aLubAnnotatedType;
            if (a.getKind() == TypeKind.ARRAY && b.getKind() == TypeKind.ARRAY) {
                aLubAnnotatedType = (AnnotatedTypeMirror.AnnotatedArrayType)result;
                AnnotatedTypeMirror.AnnotatedArrayType annotatedArrayType = (AnnotatedTypeMirror.AnnotatedArrayType)a;
                AnnotatedTypeMirror.AnnotatedArrayType bb = (AnnotatedTypeMirror.AnnotatedArrayType)b;
                return CFAbstractValue.mostSpecific(typeFactory, annotatedArrayType.getComponentType(), bb.getComponentType(), null, aLubAnnotatedType.getComponentType());
            }
            if (resultKind == TypeKind.ARRAY) {
                aLubAnnotatedType = (AnnotatedTypeMirror.AnnotatedArrayType)result;
                if (a.getKind() == TypeKind.ARRAY) {
                    CFAbstractValue.copyArrayComponentAnnotations((AnnotatedTypeMirror.AnnotatedArrayType)a, aLubAnnotatedType);
                } else {
                    assert (b.getKind() == TypeKind.ARRAY);
                    CFAbstractValue.copyArrayComponentAnnotations((AnnotatedTypeMirror.AnnotatedArrayType)b, aLubAnnotatedType);
                }
            }
        }
        return true;
    }

    private static Set<AnnotationMirror> mostSpecific(QualifierHierarchy qualHierarchy, Collection<AnnotationMirror> a, Collection<AnnotationMirror> b) {
        Set<AnnotationMirror> result = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror annotationMirror : qualHierarchy.getTopAnnotations()) {
            AnnotationMirror aAnno = qualHierarchy.findCorrespondingAnnotation(annotationMirror, a);
            AnnotationMirror bAnno = qualHierarchy.findCorrespondingAnnotation(annotationMirror, b);
            assert (aAnno != null) : "Did not find an annotation for '" + annotationMirror + "' in '" + a + "'.";
            assert (bAnno != null) : "Did not find an annotation for '" + annotationMirror + "' in '" + b + "'.";
            if (qualHierarchy.isSubtype(aAnno, bAnno)) {
                result.add(aAnno);
                continue;
            }
            if (qualHierarchy.isSubtype(bAnno, aAnno)) {
                result.add(bAnno);
                continue;
            }
            assert (false) : "Neither of the two values is more specific: " + a + ", " + b + ".";
        }
        return result;
    }

    public static boolean mostSpecificTypeVariable(AnnotatedTypeFactory typeFactory, AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, AnnotatedTypeMirror backup, AnnotatedTypeMirror.AnnotatedTypeVariable result) {
        AnnotatedTypeMirror fixedType2;
        AnnotatedTypeMirror fixedType1;
        Types types = typeFactory.getProcessingEnv().getTypeUtils();
        TypeHierarchy typeHierarchy = typeFactory.getTypeHierarchy();
        QualifierHierarchy qualifierHierarchy = typeFactory.getQualifierHierarchy();
        AnnotatedTypeMirror.AnnotatedTypeVariable declaredType = (AnnotatedTypeMirror.AnnotatedTypeVariable)typeFactory.getAnnotatedType(result.getUnderlyingType().asElement());
        AnnotatedTypeMerger.merge(declaredType, result);
        if (type1.getKind() == TypeKind.INTERSECTION) {
            fixedType1 = result.deepCopy();
            fixedType1.addAnnotations(AnnotatedTypes.glbOfBounds((AnnotatedTypeMirror.AnnotatedIntersectionType)type1, qualifierHierarchy));
        } else {
            fixedType1 = type1;
        }
        if (type2.getKind() == TypeKind.INTERSECTION) {
            fixedType2 = result.deepCopy();
            fixedType2.addAnnotations(AnnotatedTypes.glbOfBounds((AnnotatedTypeMirror.AnnotatedIntersectionType)type2, qualifierHierarchy));
        } else {
            fixedType2 = type2;
        }
        boolean annotated = true;
        for (AnnotationMirror annotationMirror : qualifierHierarchy.getTopAnnotations()) {
            if (typeHierarchy.isSubtype(fixedType1, fixedType2, annotationMirror)) {
                CFAbstractValue.annotateTypeVarResult(qualifierHierarchy, types, result, fixedType1, annotationMirror);
                continue;
            }
            if (typeHierarchy.isSubtype(fixedType2, fixedType1, annotationMirror)) {
                CFAbstractValue.annotateTypeVarResult(qualifierHierarchy, types, result, fixedType2, annotationMirror);
                continue;
            }
            if (backup != null) {
                CFAbstractValue.annotateTypeVarResult(qualifierHierarchy, types, result, backup, annotationMirror);
                continue;
            }
            annotated = false;
        }
        return annotated;
    }

    private static void annotateTypeVarResult(QualifierHierarchy qualifierHierarchy, Types types, AnnotatedTypeMirror.AnnotatedTypeVariable result, AnnotatedTypeMirror mostSpecific, AnnotationMirror top) {
        AnnotatedTypeMirror source = CFAbstractValue.findSourceAtm(types, qualifierHierarchy, result, mostSpecific, top);
        AnnotationMirror sourcePrimaryAnno = source.getAnnotationInHierarchy(top);
        if (types.isSameType(source.getUnderlyingType(), result.getUnderlyingType()) && sourcePrimaryAnno == null) {
            AnnotatedTypeMirror.AnnotatedTypeVariable resultDecl = (AnnotatedTypeMirror.AnnotatedTypeVariable)source;
            AnnotationMirror declUpperBoundAnno = resultDecl.getUpperBound().getAnnotationInHierarchy(top);
            AnnotationMirror declLowerBoundAnno = resultDecl.getLowerBound().getAnnotationInHierarchy(top);
            if (declUpperBoundAnno != null) {
                result.getUpperBound().addAnnotation(declUpperBoundAnno);
            }
            if (declLowerBoundAnno != null) {
                result.getLowerBound().addAnnotation(declLowerBoundAnno);
            }
        } else {
            result.replaceAnnotation(sourcePrimaryAnno);
        }
    }

    private static AnnotatedTypeMirror findSourceAtm(Types types, QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror.AnnotatedTypeVariable result, AnnotatedTypeMirror toSearch, AnnotationMirror top) {
        AnnotatedTypeMirror source = toSearch;
        block5: while (source.getAnnotationInHierarchy(top) == null && !types.isSameType(result.getUnderlyingType(), source.getUnderlyingType())) {
            switch (source.getKind()) {
                case TYPEVAR: {
                    source = ((AnnotatedTypeMirror.AnnotatedTypeVariable)source).getUpperBound();
                    continue block5;
                }
                case WILDCARD: {
                    source = ((AnnotatedTypeMirror.AnnotatedWildcardType)source).getExtendsBound();
                    continue block5;
                }
                case INTERSECTION: {
                    if ((source = CFAbstractValue.mostSpecificSupertype(qualifierHierarchy, (AnnotatedTypeMirror.AnnotatedIntersectionType)source, top)) != null) continue block5;
                    ErrorReporter.errorAbort("AnnotatedIntersectionType has no annotation in hierarchyon any of its supertypes!\nintersectionType=" + source);
                    continue block5;
                }
            }
            ErrorReporter.errorAbort("Unexpected AnnotatedTypeMirror with no primary annotation!result=" + result + "toSearch=" + toSearch + "top=" + top + "source=" + source);
        }
        return source;
    }

    private static AnnotatedTypeMirror mostSpecificSupertype(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror.AnnotatedIntersectionType isect, AnnotationMirror top) {
        AnnotatedTypeMirror result = null;
        AnnotationMirror anno = null;
        for (AnnotatedTypeMirror annotatedTypeMirror : isect.directSuperTypes()) {
            AnnotationMirror superAnno = annotatedTypeMirror.getAnnotationInHierarchy(top);
            if (superAnno == null || anno != null && !qualifierHierarchy.isSubtype(superAnno, anno)) continue;
            anno = superAnno;
            result = annotatedTypeMirror;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CFAbstractValue)) {
            return false;
        }
        boolean result = this.getType().equals(((CFAbstractValue)obj).getType());
        return result;
    }

    @Pure
    public int hashCode() {
        return HashCodeUtils.hash((Object)this.type);
    }

    @SideEffectFree
    public String toString() {
        return this.getType().toString();
    }
}

