/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type.typeannotator;

import com.sun.tools.javac.code.Type;
import java.util.Set;
import java.util.Stack;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeKind;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.typeannotator.TypeAnnotator;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.TypesUtils;

public class PropagationTypeAnnotator
extends TypeAnnotator {
    private boolean pause = false;
    private Stack<AnnotatedTypeMirror.AnnotatedDeclaredType> parents = new Stack();

    public PropagationTypeAnnotator(AnnotatedTypeFactory typeFactory) {
        super(typeFactory);
    }

    @Override
    public void reset() {
        if (!this.pause) {
            super.reset();
        }
    }

    @Override
    protected Void scan(AnnotatedTypeMirror type, Void aVoid) {
        if (this.pause) {
            return null;
        }
        return (Void)super.scan(type, aVoid);
    }

    @Override
    public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType declaredType, Void aVoid) {
        if (this.pause) {
            return null;
        }
        this.parents.push(declaredType);
        super.visitDeclared(declaredType, aVoid);
        this.parents.pop();
        return null;
    }

    @Override
    public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType wildcardAtm, Void aVoid) {
        if (this.visitedNodes.containsKey(wildcardAtm) || this.pause) {
            return null;
        }
        this.visitedNodes.put(wildcardAtm, null);
        Type.WildcardType wildcard = (Type.WildcardType)wildcardAtm.getUnderlyingType();
        TypeParameterElement typeParamElement = TypesUtils.wildcardToTypeParam(wildcard);
        if (typeParamElement == null) {
            Element element = typeParamElement = this.parents.empty() ? null : this.getTypeParamFromEnclosingClass(wildcardAtm, this.parents.peek());
        }
        if (typeParamElement != null) {
            this.pause = true;
            AnnotatedTypeMirror.AnnotatedTypeVariable typeParam = (AnnotatedTypeMirror.AnnotatedTypeVariable)this.typeFactory.getAnnotatedType(typeParamElement);
            this.pause = false;
            Set<? extends AnnotationMirror> tops = this.typeFactory.getQualifierHierarchy().getTopAnnotations();
            if (wildcard.isUnbound()) {
                this.propagateExtendsBound(wildcardAtm, typeParam, tops);
                this.propagateSuperBound(wildcardAtm, typeParam, tops);
            } else if (wildcard.isExtendsBound()) {
                this.propagateSuperBound(wildcardAtm, typeParam, tops);
            } else {
                this.propagateExtendsBound(wildcardAtm, typeParam, tops);
            }
        }
        this.scan(wildcardAtm.getExtendsBound(), null);
        this.scan(wildcardAtm.getSuperBound(), null);
        return null;
    }

    private void propagateSuperBound(AnnotatedTypeMirror.AnnotatedWildcardType wildcard, AnnotatedTypeMirror.AnnotatedTypeVariable typeParam, Set<? extends AnnotationMirror> tops) {
        this.applyAnnosFromBound(wildcard.getSuperBound(), typeParam.getLowerBound(), tops);
    }

    private void propagateExtendsBound(AnnotatedTypeMirror.AnnotatedWildcardType wildcard, AnnotatedTypeMirror.AnnotatedTypeVariable typeParam, Set<? extends AnnotationMirror> tops) {
        this.applyAnnosFromBound(wildcard.getExtendsBound(), typeParam.getUpperBound(), tops);
    }

    private void applyAnnosFromBound(AnnotatedTypeMirror wildcardBound, AnnotatedTypeMirror typeParamBound, Set<? extends AnnotationMirror> tops) {
        if (wildcardBound.getKind() == TypeKind.TYPEVAR || typeParamBound.getKind() == TypeKind.TYPEVAR) {
            return;
        }
        for (AnnotationMirror annotationMirror : tops) {
            if (wildcardBound.getAnnotationInHierarchy(annotationMirror) != null) continue;
            AnnotationMirror typeParamAnno = typeParamBound.getAnnotationInHierarchy(annotationMirror);
            if (typeParamAnno == null) {
                ErrorReporter.errorAbort("Missing annotation on type parameter\ntop=" + annotationMirror + "\n" + "wildcardBound=" + wildcardBound + "\n" + "typeParamBound=" + typeParamBound + "\n");
            }
            wildcardBound.addAnnotation(typeParamAnno);
        }
    }

    private Element getTypeParamFromEnclosingClass(AnnotatedTypeMirror.AnnotatedWildcardType wildcard, AnnotatedTypeMirror.AnnotatedDeclaredType parent) {
        Integer wildcardIndex = null;
        int currentIndex = 0;
        for (AnnotatedTypeMirror typeArg : parent.getTypeArguments()) {
            if (typeArg == wildcard) {
                wildcardIndex = currentIndex;
                break;
            }
            ++currentIndex;
        }
        if (wildcardIndex != null) {
            TypeElement typeElement = (TypeElement)this.typeFactory.getProcessingEnv().getTypeUtils().asElement(parent.getUnderlyingType());
            return typeElement.getTypeParameters().get(wildcardIndex);
        }
        return null;
    }
}

