/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.poly;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.qualframework.poly.CombiningOperation;

public abstract class PolyQual<Q> {
    public abstract Q getMinimum();

    public abstract Q getMaximum();

    public abstract PolyQual<Q> substitute(Map<String, PolyQual<Q>> var1);

    public abstract Combined<Q> asCombined(CombiningOperation<Q> var1);

    public PolyQual<Q> combineWith(PolyQual<Q> other, CombiningOperation<Q> op) {
        return this.asCombined(op).combineWith(other.asCombined(op));
    }

    public static class Combined<Q>
    extends PolyQual<Q> {
        private final CombiningOperation<Q> op;
        private final HashSet<QualVar<Q>> vars;
        private final Q ground;

        public Combined(CombiningOperation<Q> op, Collection<QualVar<Q>> vars, Q ground) {
            this.op = op;
            this.vars = new HashSet<QualVar<Q>>(vars);
            this.ground = ground;
        }

        public Combined(CombiningOperation<Q> op, QualVar<Q> var, Q ground) {
            this.op = op;
            this.vars = new HashSet();
            this.vars.add(var);
            this.ground = ground;
        }

        public Combined(CombiningOperation<Q> op, QualVar<Q> var) {
            this.op = op;
            this.vars = new HashSet();
            this.vars.add(var);
            this.ground = op.identity();
        }

        public Combined(CombiningOperation<Q> op, Q ground) {
            this.op = op;
            this.vars = new HashSet();
            this.ground = ground;
        }

        public static <Q> PolyQual<Q> from(CombiningOperation<Q> op, Collection<QualVar<Q>> vars, Q ground) {
            Iterator<QualVar<Q>> iterator;
            if (vars.isEmpty()) {
                return new GroundQual<Q>(ground);
            }
            if (vars.size() == 1 && ground.equals(op.identity()) && (iterator = vars.iterator()).hasNext()) {
                QualVar<Q> var = iterator.next();
                return var;
            }
            return new Combined<Q>(op, vars, ground);
        }

        public PolyQual<Q> combineWith(Combined<Q> other) {
            if (this.op != other.op) {
                throw new IllegalArgumentException("can't combine two Combined<Q> using different CombiningOperations");
            }
            HashSet<QualVar<Q>> newVars = new HashSet<QualVar<Q>>(this.vars);
            newVars.addAll(other.vars);
            Q newGround = this.op.combine(this.ground, other.ground);
            return Combined.from(this.op, newVars, newGround);
        }

        public CombiningOperation<Q> getOp() {
            return this.op;
        }

        public Set<QualVar<Q>> getVars() {
            return this.vars;
        }

        public Q getGround() {
            return this.ground;
        }

        @Override
        public Q getMinimum() {
            Q result = this.ground;
            for (QualVar<Q> var : this.vars) {
                result = this.op.combine(result, var.getMinimum());
            }
            return result;
        }

        @Override
        public Q getMaximum() {
            Q result = this.ground;
            for (QualVar<Q> var : this.vars) {
                result = this.op.combine(result, var.getMaximum());
            }
            return result;
        }

        @Override
        public PolyQual<Q> substitute(Map<String, PolyQual<Q>> substs) {
            HashSet<QualVar<Q>> newVars = new HashSet<QualVar<Q>>();
            Q newGround = this.ground;
            for (QualVar<Q> var : this.vars) {
                Combined<Q> substCombined = var.substitute(substs).asCombined(this.op);
                newVars.addAll(substCombined.vars);
                newGround = this.op.combine(newGround, substCombined.ground);
            }
            return Combined.from(this.op, newVars, newGround);
        }

        @Override
        public Combined<Q> asCombined(CombiningOperation<Q> op) {
            if (op != this.op) {
                throw new IllegalArgumentException("can't call Combined.asCombined with different CombiningOperation");
            }
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Combined other = (Combined)o;
            return this.op.equals(other.op) && this.vars.equals(other.vars) && this.ground.equals(other.ground);
        }

        public int hashCode() {
            return this.op.hashCode() * 13 + this.vars.hashCode() * 37 + this.ground.hashCode() * 59;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.op);
            sb.append("(");
            for (QualVar<Q> var : this.vars) {
                sb.append(var);
                sb.append(", ");
            }
            sb.append(this.ground);
            sb.append(")");
            return sb.toString();
        }
    }

    public static final class QualVar<Q>
    extends PolyQual<Q> {
        private final String name;
        private final Q lower;
        private final Q upper;

        public QualVar(String name, Q lower, Q upper) {
            if (name == null) {
                throw new IllegalArgumentException("name must not be null");
            }
            if (lower == null || upper == null) {
                throw new IllegalArgumentException("bounds must not be null");
            }
            this.name = name;
            this.lower = lower;
            this.upper = upper;
        }

        public String getName() {
            return this.name;
        }

        public Q getLowerBound() {
            return this.lower;
        }

        public Q getUpperBound() {
            return this.upper;
        }

        @Override
        public Q getMinimum() {
            return this.lower;
        }

        @Override
        public Q getMaximum() {
            return this.upper;
        }

        @Override
        public PolyQual<Q> substitute(Map<String, PolyQual<Q>> substs) {
            PolyQual<Q> value = substs.get(this.name);
            if (value != null) {
                return value;
            }
            return this;
        }

        @Override
        public Combined<Q> asCombined(CombiningOperation<Q> op) {
            return new Combined<QualVar>((CombiningOperation<QualVar>)op, this);
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            QualVar other = (QualVar)o;
            return this.name.equals(other.name) && this.lower.equals(other.lower) && this.upper.equals(other.upper);
        }

        public int hashCode() {
            return this.name.hashCode() * 13 + this.lower.hashCode() * 37 + this.upper.hashCode() * 59;
        }

        public String toString() {
            return "(" + this.name + " \u2208 [" + this.lower + ".." + this.upper + "])";
        }
    }

    public static final class GroundQual<Q>
    extends PolyQual<Q> {
        private final Q qual;

        public GroundQual(Q qual) {
            if (qual == null) {
                throw new IllegalArgumentException("qual must not be null");
            }
            this.qual = qual;
        }

        public Q getQualifier() {
            return this.qual;
        }

        @Override
        public Q getMinimum() {
            return this.qual;
        }

        @Override
        public Q getMaximum() {
            return this.qual;
        }

        @Override
        public PolyQual<Q> substitute(Map<String, PolyQual<Q>> substs) {
            return this;
        }

        @Override
        public Combined<Q> asCombined(CombiningOperation<Q> op) {
            return new Combined<Q>(op, this.qual);
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            GroundQual other = (GroundQual)o;
            return this.qual.equals(other.qual);
        }

        public int hashCode() {
            return this.qual.hashCode();
        }

        public String toString() {
            return this.qual.toString();
        }
    }
}

