/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.lock;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.lock.LockAnnotatedTypeFactory;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.checkerframework.checker.lock.qual.HoldingOnEntry;
import org.checkerframework.checker.lock.qual.LockHeld;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.cfg.node.ExplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.ImplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

public class LockVisitor
extends BaseTypeVisitor<LockAnnotatedTypeFactory> {
    private final Class<? extends Annotation> checkerGuardedByClass = GuardedBy.class;
    private final Class<? extends Annotation> checkerHoldingClass = Holding.class;
    private final Class<? extends Annotation> checkerHoldingOnEntryClass = HoldingOnEntry.class;
    private final Class<? extends Annotation> checkerLockHeldClass = LockHeld.class;
    private final Class<? extends Annotation> javaxGuardedByClass = javax.annotation.concurrent.GuardedBy.class;
    private final Class<? extends Annotation> jcipGuardedByClass = net.jcip.annotations.GuardedBy.class;

    public LockVisitor(BaseTypeChecker checker) {
        super(checker);
        this.checkForAnnotatedJdk();
    }

    @Override
    public LockAnnotatedTypeFactory createTypeFactory() {
        return new LockAnnotatedTypeFactory(this.checker, true);
    }

    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, @CompilerMessageKey String errorKey, boolean isLocalVariableAssignement) {
        if (valueType.getKind() == TypeKind.NULL) {
            return;
        }
        super.commonAssignmentCheck(varType, valueType, valueTree, errorKey, isLocalVariableAssignement);
    }

    private void reportFailure(@CompilerMessageKey String messageKey, MethodTree overriderTree, AnnotatedTypeMirror.AnnotatedDeclaredType enclosingType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, List<String> overriderLocks, List<String> overriddenLocks) {
        AnnotatedTypeMirror.AnnotatedExecutableType overrider = ((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(overriderTree);
        if (overrider.getTypeVariables().isEmpty() && !overridden.getTypeVariables().isEmpty()) {
            overridden = overridden.getErased();
        }
        String overriderMeth = overrider.toString();
        String overriderTyp = enclosingType.getUnderlyingType().asElement().toString();
        String overriddenMeth = overridden.toString();
        String overriddenTyp = overriddenType.getUnderlyingType().asElement().toString();
        if (overriderLocks == null || overriddenLocks == null) {
            this.checker.report(Result.failure(messageKey, overriderMeth, overriderTyp, overriddenMeth, overriddenTyp), overriderTree);
        } else {
            this.checker.report(Result.failure(messageKey, overriderMeth, overriderTyp, overriddenMeth, overriddenTyp, overriderLocks, overriddenLocks), overriderTree);
        }
    }

    @Override
    protected boolean checkOverride(MethodTree overriderTree, AnnotatedTypeMirror.AnnotatedDeclaredType enclosingType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, Void p) {
        List<String> overriderLocks = this.methodHolding(TreeUtils.elementFromDeclaration(overriderTree));
        List<String> overriddenLocks = this.methodHolding(overridden.getElement());
        List<String> overriderHoldingOnEntryLocks = this.methodHoldingOnEntry(TreeUtils.elementFromDeclaration(overriderTree));
        List<String> overriddenHoldingOnEntryLocks = this.methodHoldingOnEntry(overridden.getElement());
        boolean isValid = true;
        if (!overriddenHoldingOnEntryLocks.isEmpty()) {
            if (!overriderLocks.isEmpty()) {
                isValid = false;
                this.reportFailure("override.holding.invalid.holdingonentry", overriderTree, enclosingType, overridden, overriddenType, null, null);
            } else if (!overriddenHoldingOnEntryLocks.containsAll(overriderHoldingOnEntryLocks)) {
                isValid = false;
                this.reportFailure("override.holding.invalid", overriderTree, enclosingType, overridden, overriddenType, overriderHoldingOnEntryLocks, overriddenHoldingOnEntryLocks);
            }
        } else if (!overriderLocks.isEmpty()) {
            if (!overriddenLocks.containsAll(overriderLocks)) {
                isValid = false;
                this.reportFailure("override.holding.invalid", overriderTree, enclosingType, overridden, overriddenType, overriderLocks, overriddenLocks);
            }
        } else if (!overriddenLocks.containsAll(overriderHoldingOnEntryLocks)) {
            isValid = false;
            this.reportFailure("override.holding.invalid", overriderTree, enclosingType, overridden, overriddenType, overriderHoldingOnEntryLocks, overriddenLocks);
        }
        return super.checkOverride(overriderTree, enclosingType, overridden, overriddenType, p) && isValid;
    }

    protected List<String> methodHolding(ExecutableElement element) {
        String guardedByValue;
        AnnotationMirror holding = ((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(element, this.checkerHoldingClass);
        AnnotationMirror guardedBy = ((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(element, this.jcipGuardedByClass);
        AnnotationMirror guardedByJavax = ((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(element, this.javaxGuardedByClass);
        if (holding == null && guardedBy == null && guardedByJavax == null) {
            return Collections.emptyList();
        }
        ArrayList<String> locks = new ArrayList<String>();
        if (holding != null) {
            List<String> holdingValue = AnnotationUtils.getElementValueArray(holding, "value", String.class, false);
            locks.addAll(holdingValue);
        }
        if (guardedBy != null) {
            guardedByValue = AnnotationUtils.getElementValue(guardedBy, "value", String.class, false);
            locks.add(guardedByValue);
        }
        if (guardedByJavax != null) {
            guardedByValue = AnnotationUtils.getElementValue(guardedByJavax, "value", String.class, false);
            locks.add(guardedByValue);
        }
        return locks;
    }

    protected List<String> methodHoldingOnEntry(ExecutableElement element) {
        AnnotationMirror holdingOnEntry = ((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(element, this.checkerHoldingOnEntryClass);
        if (holdingOnEntry == null) {
            return Collections.emptyList();
        }
        ArrayList<String> locks = new ArrayList<String>();
        List<String> holdingOnEntryValue = AnnotationUtils.getElementValueArray(holdingOnEntry, "value", String.class, false);
        locks.addAll(holdingOnEntryValue);
        return locks;
    }

    @Override
    protected void checkPreconditions(Tree tree, Element invokedElement, boolean methodCall, Set<Pair<String, String>> additionalPreconditions) {
        TypeMirror rt;
        ExecutableElement methodElement;
        MethodTree enclosingMethod;
        if (additionalPreconditions == null) {
            additionalPreconditions = new LinkedHashSet<Pair<String, String>>();
        }
        if ((enclosingMethod = TreeUtils.enclosingMethod(((LockAnnotatedTypeFactory)this.atypeFactory).getPath(tree))) != null && (methodElement = TreeUtils.elementFromDeclaration(enclosingMethod)) != null && (rt = methodElement.getReceiverType()) != null) {
            List<? extends AnnotationMirror> amList = rt.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : amList) {
                MethodAccessNode man;
                List<String> guardedByValue;
                if (!AnnotationUtils.areSameByClass(annotationMirror, this.checkerGuardedByClass) && !AnnotationUtils.areSameByClass(annotationMirror, this.javaxGuardedByClass) && !AnnotationUtils.areSameByClass(annotationMirror, this.jcipGuardedByClass) || (guardedByValue = AnnotationUtils.getElementValueArray(annotationMirror, "value", String.class, false)) == null) continue;
                Node nodeNode = ((LockAnnotatedTypeFactory)this.atypeFactory).getNodeForTree(tree);
                Node receiverNode = null;
                if (nodeNode instanceof FieldAccessNode) {
                    receiverNode = ((FieldAccessNode)nodeNode).getReceiver();
                } else if (nodeNode instanceof MethodInvocationNode && !(man = ((MethodInvocationNode)nodeNode).getTarget()).getMethod().getModifiers().contains((Object)Modifier.STATIC)) {
                    receiverNode = man.getReceiver();
                }
                if (!(receiverNode instanceof ExplicitThisLiteralNode) && !(receiverNode instanceof ImplicitThisLiteralNode)) continue;
                for (String lockExpression : guardedByValue) {
                    if (lockExpression.equals("itself")) {
                        lockExpression = "this";
                    }
                    additionalPreconditions.add(Pair.of(lockExpression, this.checkerLockHeldClass.toString().substring(10)));
                }
            }
        }
        super.checkPreconditions(tree, invokedElement, methodCall, additionalPreconditions);
    }

    @Override
    protected boolean skipContractCheck(Tree tree, FlowExpressions.Receiver expr, FlowExpressionParseUtil.FlowExpressionContext flowExprContext) {
        String fieldName = null;
        try {
            TreePath path;
            FlowExpressions.Receiver fieldExpr;
            Node nodeNode = ((LockAnnotatedTypeFactory)this.atypeFactory).getNodeForTree(tree);
            if (nodeNode instanceof FieldAccessNode && (fieldName = ((FieldAccessNode)nodeNode).getFieldName()) != null && (fieldExpr = FlowExpressionParseUtil.parse(fieldName, flowExprContext, this.getCurrentPath())).equals(expr) && (path = this.getCurrentPath().getParentPath()) != null && (path = path.getParentPath()) != null && path.getLeaf().getKind() == Tree.Kind.SYNCHRONIZED) {
                return true;
            }
        }
        catch (FlowExpressionParseUtil.FlowExpressionParseException flowExpressionParseException) {
            // empty catch block
        }
        return false;
    }
}

