/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type.treeannotator;

import com.sun.source.tree.Tree;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;

public class DebugListTreeAnnotator
extends ListTreeAnnotator {
    private final Set<Tree.Kind> kinds;

    public DebugListTreeAnnotator(TreeAnnotator ... annotators) {
        super(annotators);
        this.kinds = Collections.emptySet();
    }

    public DebugListTreeAnnotator(Tree.Kind[] kinds, TreeAnnotator ... annotators) {
        super(annotators);
        this.kinds = new HashSet<Tree.Kind>(Arrays.asList(kinds));
    }

    @Override
    public Void defaultAction(Tree node, AnnotatedTypeMirror type) {
        if (this.kinds.contains((Object)node.getKind())) {
            System.out.println("DebugListTreeAnnotator input tree: " + node);
            System.out.println("    Initial type: " + type);
            for (TreeAnnotator annotator : this.annotators) {
                System.out.println("    Running annotator: " + annotator.getClass());
                annotator.visit(node, type);
                System.out.println("    Current type: " + type);
            }
        } else {
            super.defaultAction(node, type);
        }
        return null;
    }
}

