/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.visitor.AnnotatedTypeVisitor;
import org.checkerframework.framework.util.DefaultAnnotationFormatter;
import org.checkerframework.framework.util.ExecUtil;
import org.checkerframework.framework.util.PluginUtil;
import org.checkerframework.javacutil.ErrorReporter;

public class TypeVisualizer {
    public static void drawToDot(File dest, AnnotatedTypeMirror type) {
        Drawing drawer = new Drawing("Type", type);
        drawer.draw(dest);
    }

    public static void drawToDot(String dest, AnnotatedTypeMirror type) {
        TypeVisualizer.drawToDot(new File(dest), type);
    }

    public static void drawToPng(File dest, AnnotatedTypeMirror type) {
        try {
            File dotFile = File.createTempFile(dest.getName(), ".dot");
            TypeVisualizer.drawToDot(dotFile, type);
            TypeVisualizer.execDotToPng(dotFile, dest);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public static void drawToPng(String dest, AnnotatedTypeMirror type) {
        TypeVisualizer.drawToPng(new File(dest), type);
    }

    public static void execDotToPng(File dotFile, File pngFile) {
        String[] cmd = new String[]{"dot", "-Tpng", dotFile.getAbsolutePath(), "-o", pngFile.getAbsolutePath()};
        System.out.println("Printing dotFile: " + dotFile + " to loc: " + pngFile);
        System.out.flush();
        ExecUtil.execute(cmd, System.out, System.err);
    }

    public static boolean printTypevarToDotIfMatches(AnnotatedTypeMirror.AnnotatedTypeVariable typeVariable, List<String> typeVarNames, String directory) {
        return TypeVisualizer.printTypevarIfMatches(typeVariable, typeVarNames, directory, false);
    }

    public static boolean printTypevarToPngIfMatches(AnnotatedTypeMirror.AnnotatedTypeVariable typeVariable, List<String> typeVarNames, String directory) {
        return TypeVisualizer.printTypevarIfMatches(typeVariable, typeVarNames, directory, true);
    }

    private static boolean printTypevarIfMatches(AnnotatedTypeMirror.AnnotatedTypeVariable typeVariable, List<String> typeVarNames, String directory, boolean png) {
        String dirPath = directory.endsWith(File.separator) ? directory : directory + File.separator;
        String varName = typeVariable.getUnderlyingType().asElement().toString();
        if (typeVarNames.contains(varName)) {
            if (png) {
                TypeVisualizer.drawToPng(dirPath + varName + ".png", (AnnotatedTypeMirror)typeVariable);
            } else {
                TypeVisualizer.drawToDot(dirPath + varName + ".dot", (AnnotatedTypeMirror)typeVariable);
            }
            return true;
        }
        return false;
    }

    private static class Drawing {
        private final Map<Node, String> nodes = new LinkedHashMap<Node, String>();
        private final List<String> lines = new ArrayList<String>();
        private final String graphName;
        private final AnnotatedTypeMirror type;
        private int nextId = 0;

        public Drawing(String graphName, AnnotatedTypeMirror type) {
            this.graphName = graphName;
            this.type = type;
        }

        public void draw(File file) {
            this.addNodes(this.type);
            this.addConnections();
            this.write(file);
        }

        private void addNodes(AnnotatedTypeMirror type) {
            new NodeDrawer().visit(type);
        }

        private void addConnections() {
            ConnectionDrawer connectionDrawer = new ConnectionDrawer();
            for (Node node : this.nodes.keySet()) {
                connectionDrawer.visit(node.type);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void write(File file) {
            try (BufferedWriter writer = null;){
                writer = new BufferedWriter(new FileWriter(file));
                writer.write("digraph " + this.graphName + "{");
                writer.newLine();
                for (String line : this.lines) {
                    writer.write(line + ";");
                    writer.newLine();
                }
                writer.write("}");
                writer.flush();
            }
            catch (IOException exc) {
                ErrorReporter.errorAbort("Exception visualizing type:\nfile=" + file + "\ntype=" + this.type, exc);
            }
        }

        private class NodeDrawer
        implements AnnotatedTypeVisitor<Void, Void> {
            private final DefaultAnnotationFormatter annoFormatter = new DefaultAnnotationFormatter();

            private void visitAll(List<? extends AnnotatedTypeMirror> types) {
                for (AnnotatedTypeMirror annotatedTypeMirror : types) {
                    this.visit(annotatedTypeMirror);
                }
            }

            @Override
            public Void visit(AnnotatedTypeMirror type) {
                if (type != null) {
                    type.accept(this, null);
                }
                return null;
            }

            @Override
            public Void visit(AnnotatedTypeMirror type, Void aVoid) {
                return this.visit(type);
            }

            @Override
            public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Void aVoid) {
                if (this.checkOrAdd(type)) {
                    this.addLabeledNode(type, this.getAnnoStr(type) + " " + type.getUnderlyingType().asElement().getSimpleName() + (type.getTypeArguments().isEmpty() ? "" : "<...>"), "shape=box");
                    this.visitAll(type.getTypeArguments());
                }
                return null;
            }

            @Override
            public Void visitIntersection(AnnotatedTypeMirror.AnnotatedIntersectionType type, Void aVoid) {
                if (this.checkOrAdd(type)) {
                    this.addLabeledNode(type, this.getAnnoStr(type) + " Intersection", "shape=doublecircle");
                    this.visitAll(type.directSuperTypes());
                }
                return null;
            }

            @Override
            public Void visitUnion(AnnotatedTypeMirror.AnnotatedUnionType type, Void aVoid) {
                if (this.checkOrAdd(type)) {
                    this.addLabeledNode(type, this.getAnnoStr(type) + " Union", "shape=doubleoctagon");
                    this.visitAll(type.getAlternatives());
                }
                return null;
            }

            @Override
            public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, Void aVoid) {
                if (this.checkOrAdd(type)) {
                    this.addLabeledNode(type, this.makeMethodLabel(type), "shape=box,peripheries=2");
                    this.visit(type.getReturnType());
                    this.visitAll(type.getTypeVariables());
                    this.visit(type.getReceiverType());
                    this.visitAll(type.getParameterTypes());
                    this.visitAll(type.getThrownTypes());
                } else {
                    ErrorReporter.errorAbort("Executable types should never be recursive!\ntype=" + type);
                }
                return null;
            }

            @Override
            public Void visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, Void aVoid) {
                if (this.checkOrAdd(type)) {
                    this.addLabeledNode(type, this.getAnnoStr(type) + "[]");
                    this.visit(type.getComponentType());
                }
                return null;
            }

            @Override
            public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, Void aVoid) {
                if (this.checkOrAdd(type)) {
                    this.addLabeledNode(type, this.getAnnoStr(type) + " " + type.getUnderlyingType().asElement().getSimpleName(), "shape=invtrapezium");
                    this.visit(type.getUpperBound());
                    this.visit(type.getLowerBound());
                }
                return null;
            }

            @Override
            public Void visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, Void aVoid) {
                if (this.checkOrAdd(type)) {
                    this.addLabeledNode(type, this.getAnnoStr(type) + " " + (Object)((Object)type.getKind()));
                }
                return null;
            }

            @Override
            public Void visitNoType(AnnotatedTypeMirror.AnnotatedNoType type, Void aVoid) {
                if (this.checkOrAdd(type)) {
                    this.addLabeledNode(type, this.getAnnoStr(type) + " None");
                }
                return null;
            }

            @Override
            public Void visitNull(AnnotatedTypeMirror.AnnotatedNullType type, Void aVoid) {
                if (this.checkOrAdd(type)) {
                    this.addLabeledNode(type, this.getAnnoStr(type) + " NullType");
                }
                return null;
            }

            @Override
            public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, Void aVoid) {
                if (this.checkOrAdd(type)) {
                    this.addLabeledNode(type, this.getAnnoStr(type) + "?", "shape=trapezium");
                    this.visit(type.getExtendsBound());
                    this.visit(type.getSuperBound());
                }
                return null;
            }

            public String getAnnoStr(AnnotatedTypeMirror atm) {
                ArrayList<String> annoNames = new ArrayList<String>();
                for (AnnotationMirror anno : atm.getAnnotations()) {
                    annoNames.add(this.annoFormatter.formatAnnotationMirror(anno).replace("\"", "\\"));
                }
                return PluginUtil.join(" ", annoNames);
            }

            public boolean checkOrAdd(AnnotatedTypeMirror atm) {
                Node node = new Node(atm);
                if (Drawing.this.nodes.containsKey(node)) {
                    return false;
                }
                Drawing.this.nodes.put(node, String.valueOf(Drawing.this.nextId++));
                return true;
            }

            public String makeLabeledNode(AnnotatedTypeMirror type, String label) {
                return this.makeLabeledNode(type, label, null);
            }

            public String makeLabeledNode(AnnotatedTypeMirror type, String label, String attributes) {
                String attr = attributes != null ? ", " + attributes : "";
                return (String)Drawing.this.nodes.get(new Node(type)) + " [label=\"" + label + "\"" + attr + "]";
            }

            public void addLabeledNode(AnnotatedTypeMirror type, String label) {
                Drawing.this.lines.add(this.makeLabeledNode(type, label));
            }

            public void addLabeledNode(AnnotatedTypeMirror type, String label, String attributes) {
                Drawing.this.lines.add(this.makeLabeledNode(type, label, attributes));
            }

            public String makeMethodLabel(AnnotatedTypeMirror.AnnotatedExecutableType methodType) {
                ExecutableElement methodElem = methodType.getElement();
                StringBuilder builder = new StringBuilder();
                builder.append(methodElem.getReturnType().toString());
                builder.append(" <");
                builder.append(PluginUtil.join(", ", methodElem.getTypeParameters()));
                builder.append("> ");
                builder.append(methodElem.getSimpleName().toString());
                builder.append("(");
                builder.append(PluginUtil.join(",", methodElem.getParameters()));
                builder.append(")");
                return builder.toString();
            }
        }

        private class ConnectionDrawer
        implements AnnotatedTypeVisitor<Void, Void> {
            private ConnectionDrawer() {
            }

            @Override
            public Void visit(AnnotatedTypeMirror type) {
                type.accept(this, null);
                return null;
            }

            @Override
            public Void visit(AnnotatedTypeMirror type, Void aVoid) {
                return this.visit(type);
            }

            @Override
            public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Void aVoid) {
                List<AnnotatedTypeMirror> typeArgs = type.getTypeArguments();
                for (int i = 0; i < typeArgs.size(); ++i) {
                    Drawing.this.lines.add(this.connect(type, typeArgs.get(i)) + " " + this.makeTypeArgLabel(i));
                }
                return null;
            }

            @Override
            public Void visitIntersection(AnnotatedTypeMirror.AnnotatedIntersectionType type, Void aVoid) {
                List<AnnotatedTypeMirror.AnnotatedDeclaredType> superTypes = type.directSuperTypes();
                for (int i = 0; i < superTypes.size(); ++i) {
                    Drawing.this.lines.add(this.connect(type, superTypes.get(i)) + " " + this.makeLabel("&"));
                }
                return null;
            }

            @Override
            public Void visitUnion(AnnotatedTypeMirror.AnnotatedUnionType type, Void aVoid) {
                List<AnnotatedTypeMirror.AnnotatedDeclaredType> alternatives = type.getAlternatives();
                for (int i = 0; i < alternatives.size(); ++i) {
                    Drawing.this.lines.add(this.connect(type, alternatives.get(i)) + " " + this.makeLabel("|"));
                }
                return null;
            }

            @Override
            public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, Void aVoid) {
                ExecutableElement methodElem = type.getElement();
                Drawing.this.lines.add(this.connect(type, type.getReturnType()) + " " + this.makeLabel("returns"));
                List<? extends TypeParameterElement> typeVarElems = methodElem.getTypeParameters();
                List<AnnotatedTypeMirror.AnnotatedTypeVariable> typeVars = type.getTypeVariables();
                for (int i = 0; i < typeVars.size(); ++i) {
                    String typeVarName = typeVarElems.get(i).getSimpleName().toString();
                    Drawing.this.lines.add(this.connect(type, typeVars.get(i)) + " " + this.makeMethodTypeArgLabel(i, typeVarName));
                }
                if (type.getReceiverType() != null) {
                    Drawing.this.lines.add(this.connect(type, type.getReceiverType()) + " " + this.makeLabel("receiver"));
                }
                List<? extends VariableElement> paramElems = methodElem.getParameters();
                List<AnnotatedTypeMirror> params = type.getParameterTypes();
                for (int i = 0; i < params.size(); ++i) {
                    String paramName = paramElems.get(i).getSimpleName().toString();
                    Drawing.this.lines.add(this.connect(type, params.get(i)) + " " + this.makeParamLabel(i, paramName));
                }
                List<AnnotatedTypeMirror> thrown = type.getThrownTypes();
                for (int i = 0; i < thrown.size(); ++i) {
                    Drawing.this.lines.add(this.connect(type, thrown.get(i)) + " " + this.makeThrownLabel(i));
                }
                return null;
            }

            @Override
            public Void visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, Void aVoid) {
                Drawing.this.lines.add(this.connect(type, type.getComponentType()));
                return null;
            }

            @Override
            public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, Void aVoid) {
                Drawing.this.lines.add(this.connect(type, type.getUpperBound()) + " " + this.makeLabel("extends"));
                Drawing.this.lines.add(this.connect(type, type.getLowerBound()) + " " + this.makeLabel("super"));
                return null;
            }

            @Override
            public Void visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, Void aVoid) {
                return null;
            }

            @Override
            public Void visitNoType(AnnotatedTypeMirror.AnnotatedNoType type, Void aVoid) {
                return null;
            }

            @Override
            public Void visitNull(AnnotatedTypeMirror.AnnotatedNullType type, Void aVoid) {
                return null;
            }

            @Override
            public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, Void aVoid) {
                Drawing.this.lines.add(this.connect(type, type.getExtendsBound()) + " " + this.makeLabel("extends"));
                Drawing.this.lines.add(this.connect(type, type.getSuperBound()) + " " + this.makeLabel("super"));
                return null;
            }

            private String connect(AnnotatedTypeMirror from, AnnotatedTypeMirror to) {
                return (String)Drawing.this.nodes.get(new Node(from)) + " -> " + (String)Drawing.this.nodes.get(new Node(to));
            }

            private String makeLabel(String text) {
                return "[label=\"" + text + "\"]";
            }

            private String makeTypeArgLabel(int argIndex) {
                return this.makeLabel("<" + argIndex + ">");
            }

            private String makeMethodTypeArgLabel(int argIndex, String paramName) {
                return this.makeLabel("<" + paramName + ">");
            }

            private String makeParamLabel(int index, String paramName) {
                return this.makeLabel(paramName);
            }

            private String makeThrownLabel(int index) {
                return this.makeLabel("throws: " + index);
            }
        }
    }

    private static class Node {
        private final AnnotatedTypeMirror type;

        private Node(AnnotatedTypeMirror type) {
            this.type = type;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof Node) {
                return ((Node)obj).type == this.type;
            }
            return false;
        }
    }
}

